package de.beagtex.gui;

import java.io.File;

import javax.swing.JFileChooser;

import de.beagtex.control.ExampleFileFilter;

/**
 * JFileChooser for opening Graphic-Fils
 * 
 * @author Benjamin Haag
 */
public class MyGraphicsChooser extends JFileChooser {

	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 1L;
	Editor editor;
	File currentDirectory;

	/**
	 * Constructor
	 * 
	 * @param editor:
	 *            the calling editor-object
	 */
	public MyGraphicsChooser(Editor editor) {
		this.editor = editor;
		String[] filters = { "jpg", "gif", "png", "bmp" };
		ExampleFileFilter filter = new ExampleFileFilter(filters);
		setFileFilter(filter);
		setCurrentDirectory(getCurrentDirectory());
		int returnVal = showOpenDialog(getParent());
		// int returnVal = showSaveDialog(getParent());
		if (returnVal == JFileChooser.APPROVE_OPTION) {
			System.out.println("You selected the following File: "
					+ getSelectedFile().getName());
		}

	}

}
