package de.beagtex.listener.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;

import de.beagtex.control.FileWorkMethods;
import de.beagtex.gui.BFrame;
import de.beagtex.gui.Editor;
import de.beagtex.gui.LanguageChoiceWindow;

/**
 * Listener for the language-choice-window
 * 
 * @author Benjamin Haag
 * 
 */
public class LanguageListener implements ActionListener {

	Editor editor;
	BFrame bFrame;
	LanguageChoiceWindow lcw;

	/**
	 * Constructor
	 * 
	 * @param pBFrame :
	 *            the used BFrame
	 * @param pLcw :
	 *            the calling LanguageCoiceWindow
	 */
	public LanguageListener(BFrame pBFrame, LanguageChoiceWindow pLcw) {

		bFrame = pBFrame;
		lcw = pLcw;
		editor = pBFrame.getEdit();
		pBFrame.setLocation(150, 150);
	}

	public void actionPerformed(ActionEvent pE) {

		StringBuffer buffy = new StringBuffer();
		buffy.append(lcw.getLangChooser().getSelectedItem().toString());
		try {
			FileWorkMethods.writeFile(buffy, "data/lang.txt");
		} catch (IOException e) {
			e.printStackTrace();
		}
		bFrame.setLanguage(buffy.toString());
		bFrame.startLangChoice();
		lcw.setVisible(false);
	}

}
