package de.beagtex.listener.control;

import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;

import de.beagtex.gui.Editor;

/**
 * Listener for Undo-Actions 
 * 
 * @author Benjamin Haag
 */
public class MyUndoableEditListener implements UndoableEditListener {


	Editor editor;

	/**
	 * Constructor 
	 * @param pEditor: the calling editor-object
	 */
	public MyUndoableEditListener(Editor pEditor) {

		this.editor = pEditor;

	}


	public void undoableEditHappened(UndoableEditEvent e) {

			editor.getUndoMan().addEdit(e.getEdit());
			editor.undoAction.update();
			editor.redoAction.update();

		}
//	}

}
