package de.beagtex.listener.format;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import de.beagtex.gui.Editor;

/**
 * Listener for bold-formatting
 * 
 * @author Benjamin Haag
 */
public class BoldListener implements ActionListener {


	Editor editor;

	/**
	 * Constructor 
	 * 
	 * @param pEditor:
	 *            the calling editor
	 */
	public BoldListener(Editor pEditor) {
		this.editor = pEditor;
	}

	/**
	 * Inserts command for bold-format
	 */
	public void actionPerformed(ActionEvent arg0) {

		if (editor.getSelectedText() == null) {
			editor.insert("\\textbf{}", editor.getCaretPosition());
			editor.requestFocus();
			editor.setCaretPosition(editor.getCaretPosition() - 1);
		} else {
			editor.insert("\\textbf{", editor.getSelectionStart());
			editor.insert("}", editor.getSelectionEnd());
			editor.requestFocus();
			editor.setCaretPosition(editor.getSelectionEnd());
		}
	}

}
