package de.beagtex.listener.format;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import de.beagtex.gui.Editor;

/**
 * Listener for defining the standard-colors; needed for using the
 * standard-colors
 * 
 * @author Benjamin Haag
 */
public class StandardColordefListener implements ActionListener {

	Editor editor;

	/**
	 * Constructor
	 * 
	 * @param editor:
	 *            the calling editor
	 */
	public StandardColordefListener(Editor editor) {
		this.editor = editor;
	}


	public void actionPerformed(ActionEvent arg0) {

		editor.insert("\r\n" + "\\definecolor{red}{rgb}{1,0,0}" + "\r\n"
				+ "\\definecolor{yellow}{rgb}{1,1,0}" + "\r\n"
				+ "\\definecolor{green}{rgb}{0,1,0}" + "\r\n"
				+ "\\definecolor{blue}{rgb}{0,0,1}" + "\r\n"
				+ "\\definecolor{black}{rgb}{0,0,0}" + "\r\n"
				+ "\\definecolor{white}{rgb}{1,1,1}" + "\r\n", editor
				.getCaretPosition());
		editor.requestFocus();
		editor.setCaretPosition(editor.getCaretPosition());
	}

}
