/*
 * Decompiled with CFR 0.152.
 */
package com.sonoransoft.codequill;

import com.sonoransoft.codequill.BufferMgr;
import com.sonoransoft.codequill.CqOutOfMemoryException;
import com.sonoransoft.codequill.EditDisplay;
import com.sonoransoft.codequill.EditDisplayInt;
import com.sonoransoft.codequill.EditEngine;
import com.sonoransoft.codequill.EditEngineInt;
import com.sonoransoft.codequill.EditSessionInt;
import com.sonoransoft.codequill.InformationBar;
import com.sonoransoft.codequill.Key;
import com.sonoransoft.codequill.Line;
import com.sonoransoft.codequill.LinkedList;
import com.sonoransoft.codequill.MarkedArea;
import com.sonoransoft.codequill.Options;
import com.sonoransoft.codequill.RepeatQueue;
import com.sonoransoft.codequill.SearchMgr;
import com.sonoransoft.codequill.SyntaxMetaMgr;
import com.sonoransoft.codequill.SyntaxMgr;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;

public class EditSession
extends Panel
implements EditEngineInt,
EditDisplayInt,
KeyListener {
    private KeyListener parent = null;
    private EditDisplay editDisplay;
    private InformationBar informationBar;
    private EditEngine editEngine;
    private LinkedList lineList;
    private File file;
    private boolean tabCompression = false;
    private RepeatQueue repeatQueue;
    private Options options;
    static final int WRITE_BUFFER_SIZE = 256;
    static final int EXPAND_BUFFER_SIZE = 256;
    static final char REQUEST_NONE = '\u0000';
    static final char REQUEST_EXIT = '\u0001';
    static final char REQUEST_COMMAND_LINE = '\u0002';
    static final char REQUEST_SEARCH_FORWARD = '\u0003';
    static final char REQUEST_SEARCH_BACK = '\u0004';
    static final int MAX_COLUMN = 512;
    char pendingRequest = '\u0000';
    StringBuffer commandLineText = new StringBuffer();
    EditSessionInt sessionMgr;
    static final char FILE_WRITE_COMPLETE = '\u0000';
    static final char FILE_WRITE_ERROR_OVERWRITE = '\u0001';
    static final char FILE_WRITE_ERROR_READONLY = '\u0002';
    static final char FILE_WRITE_ERROR_DIRECTORY = '\u0003';
    static final char FILE_WRITE_ERROR = '\u0004';
    Scrollbar verticalScrollbar;
    Scrollbar horizontalScrollbar;
    BufferMgr bufferMgr;
    SyntaxMetaMgr syntaxMetaMgr;
    MarkedArea markedArea = new MarkedArea();

    public EditSession(KeyListener keyListener, EditSessionInt editSessionInt, String string, SyntaxMetaMgr syntaxMetaMgr, BufferMgr bufferMgr, Options options, InformationBar informationBar, SearchMgr searchMgr) throws CqOutOfMemoryException {
        this.options = options;
        this.informationBar = informationBar;
        this.sessionMgr = editSessionInt;
        this.bufferMgr = bufferMgr;
        this.syntaxMetaMgr = syntaxMetaMgr;
        this.parent = keyListener;
        this.tabCompression = options.isDefaultTabCompression();
        this.file = new File(string);
        if (this.file.canRead()) {
            try {
                this.lineList = this.getFile(this.file);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.lineList = null;
                throw new CqOutOfMemoryException("Could not open file due to out of memory error");
            }
        } else {
            this.lineList = new LinkedList();
            Line line = new Line("");
            this.lineList.add(line);
        }
        this.repeatQueue = new RepeatQueue();
        this.editEngine = new EditEngine(this, this.lineList, 0, 0, this.repeatQueue, bufferMgr, this.getSyntaxMgr(), informationBar, searchMgr, this.markedArea);
        this.editEngine.setTabInterval(options.getTabInterval());
        this.editEngine.setAutoIndent(options.isAutoIndent());
        this.editEngine.setBackspaceTab(options.isBackspaceTab());
        this.editEngine.setEolIndependentCursor(options.isEolIndependentCursor());
        this.setLayout(new BorderLayout());
        this.verticalScrollbar = new Scrollbar(1);
        this.horizontalScrollbar = new Scrollbar(0);
        this.editDisplay = new EditDisplay(this, this.lineList, this.editEngine, options, this.horizontalScrollbar, this.verticalScrollbar, this.markedArea);
        this.add((Component)this.editDisplay, "Center");
        this.editDisplay.addKeyListener(this);
        this.editDisplay.addKeyListener(keyListener);
        this.editDisplay.setCursorStyle(1);
        this.add((Component)this.verticalScrollbar, "East");
        this.add((Component)this.horizontalScrollbar, "South");
    }

    public EditSession(KeyListener keyListener, EditSessionInt editSessionInt, SyntaxMetaMgr syntaxMetaMgr, BufferMgr bufferMgr, Options options, InformationBar informationBar, SearchMgr searchMgr) {
        this.options = options;
        this.informationBar = informationBar;
        this.sessionMgr = editSessionInt;
        this.bufferMgr = bufferMgr;
        this.syntaxMetaMgr = syntaxMetaMgr;
        this.parent = keyListener;
        this.tabCompression = options.isDefaultTabCompression();
        this.lineList = new LinkedList();
        Line line = new Line("");
        this.lineList.add(line);
        this.repeatQueue = new RepeatQueue();
        this.editEngine = new EditEngine(this, this.lineList, 0, 0, this.repeatQueue, bufferMgr, this.getSyntaxMgr(), informationBar, searchMgr, this.markedArea);
        this.editEngine.setTabInterval(options.getTabInterval());
        this.editEngine.setAutoIndent(options.isAutoIndent());
        this.editEngine.setBackspaceTab(options.isBackspaceTab());
        this.editEngine.setEolIndependentCursor(options.isEolIndependentCursor());
        this.setLayout(new BorderLayout());
        this.verticalScrollbar = new Scrollbar(1);
        this.horizontalScrollbar = new Scrollbar(0);
        this.editDisplay = new EditDisplay(this, this.lineList, this.editEngine, options, this.horizontalScrollbar, this.verticalScrollbar, this.markedArea);
        this.add((Component)this.editDisplay, "Center");
        this.editDisplay.addKeyListener(this);
        this.editDisplay.addKeyListener(keyListener);
        this.editDisplay.setCursorStyle(1);
        this.add((Component)this.verticalScrollbar, "East");
        this.add((Component)this.horizontalScrollbar, "South");
    }

    public void requestFocus() {
        this.informationBar.setLineNumber(this.editEngine.getLineNumber());
        this.informationBar.setColumn(this.editEngine.getColumn());
        this.editDisplay.requestFocus();
    }

    public boolean processCommandLine(String string) {
        boolean bl = this.editEngine.processCommandLine(string);
        return bl;
    }

    public void search() {
        this.editEngine.search();
    }

    private LinkedList getFile(File file) {
        LinkedList linkedList;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            linkedList = this.getData(bufferedReader);
            bufferedReader.close();
        }
        catch (IOException iOException) {
            return null;
        }
        return linkedList;
    }

    public void undo() {
        this.editEngine.undo();
    }

    public void paste(Transferable transferable) {
        if (transferable != null) {
            LinkedList linkedList = this.getPasteData(transferable);
            this.editEngine.paste(linkedList);
        }
    }

    public String getCopyBuffer() {
        LinkedList linkedList = new LinkedList();
        linkedList.add(this.bufferMgr.getBuffer('\u0000'));
        StringWriter stringWriter = new StringWriter();
        BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
        this.putData(bufferedWriter, linkedList, 0, -1, false, false);
        try {
            bufferedWriter.close();
            stringWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    public String getFileArea() {
        try {
            StringWriter stringWriter = new StringWriter();
            BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
            this.putData(bufferedWriter, this.lineList, 0, -1, false, true);
            bufferedWriter.close();
            stringWriter.close();
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public String getMarkedArea(boolean bl, boolean bl2) {
        LinkedList linkedList;
        if (bl) {
            linkedList = this.editEngine.cutMarkedArea();
            this.editDisplay.setWindowUpdate();
            this.editEngineUpdateCursor(this.editEngine.getLineNumber(), this.editEngine.getColumn());
        } else {
            linkedList = this.editEngine.copyMarkedArea();
        }
        if (linkedList == null) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
        this.putData(bufferedWriter, linkedList, 0, -1, false, bl2);
        try {
            bufferedWriter.close();
            stringWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    public int getMarkedAreaStartLine() {
        return this.markedArea.getLogicalStartLine();
    }

    private LinkedList getPasteData(Transferable transferable) {
        LinkedList linkedList = null;
        try {
            StringReader stringReader = new StringReader((String)transferable.getTransferData(DataFlavor.stringFlavor));
            BufferedReader bufferedReader = new BufferedReader(stringReader);
            linkedList = this.getData(bufferedReader);
            bufferedReader.close();
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        return linkedList;
    }

    private LinkedList getData(BufferedReader bufferedReader) {
        char[] cArray = new char[264];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        LinkedList linkedList = new LinkedList();
        try {
            CharSequence charSequence;
            String string = bufferedReader.readLine();
            if (string == null) {
                linkedList.add(new Line(""));
                return linkedList;
            }
            do {
                Line line;
                if (string.indexOf(9) != -1) {
                    n2 = 0;
                    n = 0;
                    String string2 = null;
                    int n4 = string.length();
                    int n5 = 0;
                    while (n4-- > 0) {
                        char c;
                        if ((c = string.charAt(n5++)) == '\t') {
                            this.tabCompression = true;
                            n2 = 8 - n2;
                            while (n2 > 0) {
                                cArray[n++] = 32;
                                --n2;
                            }
                            if (n < 256) continue;
                            string2 = string2 == null ? new String(cArray, 0, n) : string2.concat(new String(cArray, 0, n));
                            n = 0;
                            continue;
                        }
                        if (++n2 >= 8) {
                            n2 = 0;
                            if (n >= 256) {
                                string2 = string2 == null ? new String(cArray, 0, n) : string2.concat(new String(cArray, 0, n));
                                n = 0;
                            }
                        }
                        cArray[n++] = c;
                    }
                    string2 = string2 == null ? new String(cArray, 0, n) : string2.concat(new String(cArray, 0, n));
                    line = new Line();
                    line.setText(string2);
                } else {
                    line = new Line();
                    line.setText(string);
                }
                if (line.textLength() > 512) {
                    ++n3;
                    while (line.textLength() > 512) {
                        charSequence = line.cutCharacter(512);
                        linkedList.add(line);
                        line = new Line((String)charSequence);
                    }
                }
                linkedList.add(line);
            } while ((string = bufferedReader.readLine()) != null);
            if (n3 > 0) {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append(n3);
                ((StringBuffer)charSequence).append(" lines in read file have been split");
                this.sessionMgr.editSessionInformationMessage(((StringBuffer)charSequence).toString());
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return linkedList;
    }

    private boolean writeFile(File file, int n, int n2) {
        try {
            FileWriter fileWriter = new FileWriter(file);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            this.putData(bufferedWriter, this.lineList, n, n2);
            this.editEngine.resetModified();
            bufferedWriter.close();
            fileWriter.close();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private boolean putData(BufferedWriter bufferedWriter, LinkedList linkedList, int n, int n2) {
        boolean bl = this.tabCompression;
        if (this.options.isForceTabCompression()) {
            bl = true;
        } else if (this.options.isForceSpaceExpansion()) {
            bl = false;
        }
        return this.putData(bufferedWriter, linkedList, n, n2, bl, this.options.isStripEolSpaces());
    }

    /*
     * Unable to fully structure code
     */
    private boolean putData(BufferedWriter var1_1, LinkedList var2_2, int var3_3, int var4_4, boolean var5_5, boolean var6_6) {
        var10_7 = new char[256];
        var18_8 = var4_4 == -1 ? -1 : var4_4 - var3_3 + 1;
        try {
            var9_9 = 0;
            var2_2.push();
            var2_2.setTo(var3_3);
            var7_10 = (Line)var2_2.get();
            while (var7_10 != null && var18_8 == -1 || var18_8-- > 0) {
                var13_14 = var7_10.textLength();
                var14_15 = 0;
                ++var9_9;
                var8_11 = var7_10.getText();
                if (var6_6) {
                    while (var13_14 > 0) {
                        if (var8_11.charAt(var13_14 - 1) != ' ') break;
                        --var13_14;
                    }
                }
                while (var13_14 > 0) {
                    block15: {
                        if (var13_14 > 256) {
                            var15_16 = 256;
                            var13_14 -= 256;
                            var8_11 = var7_10.getText();
                        } else {
                            var15_16 = var13_14;
                            var13_14 = 0;
                        }
                        var8_11.getChars(var14_15, var14_15 + var15_16, var10_7, 0);
                        var14_15 += var15_16;
                        if (!var5_5) break block15;
                        var11_12 = 0;
                        var12_13 = 0;
                        var16_17 = 0;
                        var17_18 = 0;
                        while (var11_12 < var15_16) {
                            block16: {
                                if (var17_18++ == 8) {
                                    var17_18 = 1;
                                    if (var16_17 > 1) {
                                        var10_7[var12_13++] = 9;
                                    } else if (var16_17 == 1) {
                                        var10_7[var12_13++] = 32;
                                    }
                                    var16_17 = 0;
                                }
                                if (var10_7[var11_12] != ' ') ** GOTO lbl49
                                ++var16_17;
                                break block16;
lbl-1000:
                                // 1 sources

                                {
                                    --var16_17;
                                    var10_7[var12_13++] = 32;
lbl49:
                                    // 2 sources

                                    ** while (var16_17 > 0)
                                }
lbl50:
                                // 1 sources

                                var10_7[var12_13++] = var10_7[var11_12];
                            }
                            ++var11_12;
                        }
                        if (var16_17 > 0) {
                            var10_7[var12_13++] = 9;
                        }
                        var15_16 = var12_13;
                    }
                    var1_1.write(var10_7, 0, var15_16);
                }
                var1_1.newLine();
                var7_10 = (Line)var2_2.getNext();
            }
            var1_1.close();
        }
        catch (IOException var19_19) {
            return false;
        }
        var2_2.pop();
        return true;
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.isActionKey() || keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 9 || keyEvent.getKeyCode() == 27) {
            Key key = new Key(keyEvent);
            if (keyEvent.getKeyCode() == 9) {
                key.setKeyChar('\t');
            } else if (keyEvent.getKeyCode() == 127) {
                key.setKeyChar('\u007f');
            } else if (keyEvent.getKeyCode() == 27) {
                key.setKeyChar('\u001b');
            }
            if (key.isControl()) {
                if (key.getKeyCode() == 155) {
                    this.copy();
                    return;
                }
                if (key.getKeyCode() == 127) {
                    return;
                }
            } else if (key.isShift()) {
                if (key.getKeyCode() == 127) {
                    this.cut();
                    return;
                }
                if (key.getKeyCode() == 155) {
                    this.paste();
                    return;
                }
            }
            if (this.processKeys(key)) {
                keyEvent.consume();
            }
        }
    }

    private void paste() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        if (transferable == null) {
            this.sessionMgr.editSessionInformationMessage("Clipboard is empty");
        } else {
            this.paste(transferable);
        }
    }

    private void cut() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(this.getMarkedArea(false, false));
        clipboard.setContents(stringSelection, stringSelection);
    }

    private void copy() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(this.getMarkedArea(false, false));
        clipboard.setContents(stringSelection, stringSelection);
    }

    public void keyTyped(KeyEvent keyEvent) {
        Key key = new Key(keyEvent);
        if (keyEvent.getKeyChar() == '\u007f' || keyEvent.getKeyChar() == '\t' || keyEvent.getKeyChar() == '\u001b') {
            keyEvent.consume();
        } else if (this.processKeys(key)) {
            keyEvent.consume();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    private boolean processKeys(Key key) {
        char c = key.getKeyChar();
        int n = this.editEngine.process(key);
        if (n == 2) {
            switch (this.editEngine.request()) {
                case '\u0002': {
                    this.pendingRequest = (char)2;
                    return false;
                }
                case '\u0003': {
                    this.pendingRequest = (char)3;
                    return false;
                }
                case '\u0004': {
                    this.pendingRequest = (char)4;
                    return false;
                }
                case '\u0001': {
                    this.pendingRequest = '\u0001';
                    return false;
                }
            }
            this.pendingRequest = '\u0000';
            return false;
        }
        return true;
    }

    public char request() {
        char c = this.pendingRequest;
        this.pendingRequest = '\u0000';
        return c;
    }

    public char write() {
        if (!this.writeFile(this.file, 0, -1)) {
            return '\u0004';
        }
        return '\u0000';
    }

    public char write(String string, boolean bl) {
        boolean bl2 = false;
        this.file = new File(string);
        if (this.file.exists() && !bl) {
            return '\u0001';
        }
        bl2 = this.writeFile(this.file, 0, -1);
        if (!bl2) {
            return '\u0004';
        }
        this.editEngine.setSyntaxMgr(this.getSyntaxMgr());
        return '\u0000';
    }

    public boolean isModified() {
        return this.editEngine.isModified();
    }

    public boolean isDuplicateFile(String string) {
        String string2;
        if (this.file == null) {
            return false;
        }
        try {
            string2 = this.file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return false;
        }
        return string.compareTo(string2) == 0;
    }

    public String getCanonicalPath() {
        if (this.file == null) {
            return null;
        }
        try {
            return this.file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public char getSeparator() {
        if (this.file == null) {
            return '\u0000';
        }
        return File.separatorChar;
    }

    public String getSimpleName() {
        if (this.file == null) {
            return null;
        }
        if (this.file.getName() == null) {
            return "";
        }
        return this.file.getName();
    }

    public String getName() {
        if (this.file == null) {
            return null;
        }
        if (this.file.getAbsolutePath() == null) {
            return "";
        }
        return this.file.getAbsolutePath();
    }

    public String getFileNameExtension() {
        if (this.file == null) {
            return "";
        }
        int n = this.file.getName().lastIndexOf(46);
        if (n == -1 || n == this.file.getName().length()) {
            return "";
        }
        return this.file.getName().substring(n + 1);
    }

    public String getFileInformation() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Lines: ");
        stringBuffer.append(this.lineList.getSize());
        if (this.editEngine.isModified()) {
            stringBuffer.append(", Modified ");
        } else {
            stringBuffer.append(", Unmodified ");
        }
        if (this.tabCompression) {
            stringBuffer.append(", Tab Compression ");
        }
        if (this.file == null || this.file.getName() == null) {
            stringBuffer.append(", <unnamed>");
        } else {
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public char editEngineWrite() {
        if (this.file == null) {
            return '\u0003';
        }
        if (this.write() != '\u0000') {
            return '\u0001';
        }
        return '\u0000';
    }

    public char editEngineWrite(String string, boolean bl) {
        File file = new File(string);
        if (file.exists() && !bl) {
            return '\u0002';
        }
        if (this.writeFile(file, 0, -1)) {
            this.file = file;
            this.sessionMgr.editSessionSetFileName(string);
            this.editEngine.setSyntaxMgr(this.getSyntaxMgr());
            return '\u0000';
        }
        return '\u0001';
    }

    public char editEngineWrite(int n, int n2) {
        return '\u0001';
    }

    public char editEngineWrite(int n, int n2, String string, boolean bl) {
        File file = new File(string);
        if (file.exists() && !bl) {
            return '\u0002';
        }
        if (this.writeFile(file, n, n2)) {
            this.file = file;
            this.sessionMgr.editSessionSetFileName(string);
            this.editEngine.setSyntaxMgr(this.getSyntaxMgr());
            return '\u0000';
        }
        return '\u0001';
    }

    public char editEngineRead(String string, int n) {
        File file = new File(string);
        if (!file.canRead()) {
            return '\u0005';
        }
        LinkedList linkedList = this.getFile(file);
        this.lineList.push();
        this.lineList.append(linkedList.cut());
        this.lineList.pop();
        return '\u0000';
    }

    public void editEngineQuit() {
        this.sessionMgr.editSessionQuit();
    }

    public void editEngineUpdateWindow() {
        this.editDisplay.setWindowUpdate();
        this.editEngineUpdateCursor(this.editEngine.getLineNumber(), this.editEngine.getColumn());
    }

    public void editEngineUpdateLine(int n) {
        this.editDisplay.setLineUpdate(n);
        this.editEngineUpdateCursor(this.editEngine.getLineNumber(), this.editEngine.getColumn());
    }

    public void editEngineUpdateCursor(int n, int n2) {
        if (this.editEngine.getMode() == 0) {
            this.editDisplay.setCursorStyle(1);
        } else {
            this.editDisplay.setCursorStyle(0);
        }
        this.editDisplay.setCursor(n, n2);
        this.informationBar.setLineNumber(n);
        this.informationBar.setColumn(n2);
        this.editDisplay.repaint();
    }

    public void editEngineSetMarkArea() {
        this.editDisplay.updateMarkedArea();
        this.sessionMgr.editSessionMarkAreaSetEnabled(true);
    }

    public void editEngineResetMarkArea() {
        this.editDisplay.resetMarkArea();
        this.sessionMgr.editSessionMarkAreaSetEnabled(false);
    }

    public void setEnableTabCompression(boolean bl) {
        this.tabCompression = bl;
    }

    public boolean isTabCompression() {
        return this.tabCompression;
    }

    public void updateOptions() {
        this.editEngine.setAutoIndent(this.options.isAutoIndent());
        this.editEngine.setBackspaceTab(this.options.isBackspaceTab());
        this.editEngine.setTabInterval(this.options.getTabInterval());
        this.editEngine.setEolIndependentCursor(this.options.isEolIndependentCursor());
        this.editDisplay.updateOptions();
    }

    public void setSyntaxMetaMgr(SyntaxMetaMgr syntaxMetaMgr) {
        this.syntaxMetaMgr = syntaxMetaMgr;
        this.editEngine.setSyntaxMgr(this.getSyntaxMgr());
    }

    private SyntaxMgr getSyntaxMgr() {
        if (this.file == null) {
            return this.syntaxMetaMgr.getSyntaxMgr();
        }
        return this.syntaxMetaMgr.getSyntaxMgr(this.getFileNameExtension());
    }

    public void editDisplayMarkAreaSetEnabled(boolean bl) {
        this.sessionMgr.editSessionMarkAreaSetEnabled(bl);
    }

    public boolean isMarkAreaEnabled() {
        return this.editDisplay.isMarkAreaValid();
    }

    public void disableCursor() {
        this.editDisplay.disableCursor();
    }

    public void closeSession() {
        this.editDisplay.closeDisplay();
        this.remove(this.editDisplay);
        this.editDisplay = null;
        this.editEngine.closeSession();
        this.editEngine = null;
        this.lineList = null;
    }
}

