/*
 * Decompiled with CFR 0.152.
 */
package com.sonoransoft.codequill;

import com.sonoransoft.codequill.AddExtensionDialog;
import com.sonoransoft.codequill.Box;
import com.sonoransoft.codequill.CqOptionDialog;
import com.sonoransoft.codequill.HelpDialog;
import com.sonoransoft.codequill.Options;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.Vector;

class ExtensionDialog
extends CqOptionDialog {
    Choice extensionChoice = new Choice();
    TextField syntaxFileTextField = new TextField(30);
    Button extensionAddButton = new Button("Add...");
    Button extensionDeleteButton = new Button("Delete");
    Button syntaxFileFindButton = new Button("Find file...");
    Frame parent;
    Options options;
    private Vector extensionList = new Vector();
    private Vector builtInExtensionList = new Vector();

    public ExtensionDialog(Frame frame, Options options, Enumeration enumeration) {
        super(frame, "Extension options", true);
        this.options = options;
        this.parent = frame;
        Panel panel = new Panel(new BorderLayout());
        Panel panel2 = new Panel(new BorderLayout());
        Panel panel3 = new Panel(new FlowLayout(0));
        panel3.add(new Label("Extension:"));
        this.extensionChoice.add("Default extension");
        panel3.add(this.extensionChoice);
        panel2.add("North", panel3);
        Enumeration enumeration2 = options.getSyntaxExtensionList();
        while (enumeration2.hasMoreElements()) {
            this.extensionList.addElement((String)enumeration2.nextElement());
        }
        while (enumeration.hasMoreElements()) {
            this.builtInExtensionList.addElement((String)enumeration.nextElement());
        }
        this.refreshExtensionChoice();
        this.refreshSyntaxFileTextField();
        this.extensionChoice.addItemListener(this);
        this.extensionChoice.addKeyListener(this);
        Panel panel4 = new Panel();
        panel4.add(this.extensionAddButton);
        panel4.add(this.extensionDeleteButton);
        this.extensionDeleteButton.addActionListener(this);
        this.extensionDeleteButton.addKeyListener(this);
        this.extensionAddButton.addActionListener(this);
        this.extensionAddButton.addKeyListener(this);
        panel2.add("South", panel4);
        panel.add("North", panel2);
        Panel panel5 = new Panel(new BorderLayout());
        Panel panel6 = new Panel(new FlowLayout(0));
        panel6.add(new Label("File name:"));
        panel6.add(this.syntaxFileTextField);
        this.syntaxFileTextField.setEditable(false);
        panel5.add("Center", panel6);
        Panel panel7 = new Panel();
        panel7.add(this.syntaxFileFindButton);
        this.syntaxFileFindButton.addActionListener(this);
        this.syntaxFileFindButton.addKeyListener(this);
        panel5.add("South", panel7);
        Box box = new Box((Component)panel5, "Syntax templates");
        panel.add("South", box);
        Box box2 = new Box((Component)panel, "Extension options");
        this.add("Center", box2);
        this.pack();
        this.setResizable(false);
        this.centerDialog();
    }

    public void displayHelp() {
        HelpDialog helpDialog = new HelpDialog(this.parent, "Extension options help", "ExtensionDialogHelp.txt");
        helpDialog.setVisible(true);
        helpDialog.dispose();
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            if (keyEvent.getSource() == this.extensionDeleteButton) {
                this.deleteExtension();
            } else if (keyEvent.getSource() == this.extensionAddButton) {
                this.addExtension();
            } else if (keyEvent.getSource() == this.syntaxFileFindButton) {
                this.findSyntaxFile();
            } else {
                super.keyPressed(keyEvent);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.syntaxFileFindButton) {
            this.findSyntaxFile();
        } else if (actionEvent.getSource() == this.extensionDeleteButton) {
            this.deleteExtension();
        } else if (actionEvent.getSource() == this.extensionAddButton) {
            this.addExtension();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    private void refreshOptions(String string) {
        this.syntaxFileTextField.setText(this.options.getSyntaxFileName(string));
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.extensionChoice) {
            this.refreshSyntaxFileTextField();
        }
    }

    private void deleteExtension() {
        if (this.extensionChoice.getSelectedIndex() > 0) {
            String string = this.extensionChoice.getSelectedItem();
            if (this.extensionList.contains(string)) {
                this.extensionList.removeElement(string);
                this.refreshExtensionChoice();
                this.refreshSyntaxFileTextField();
                this.options.deleteFileNameExtension(string);
                if (this.builtInExtensionList.contains(string)) {
                    this.extensionChoice.select(string);
                    this.refreshSyntaxFileTextField();
                }
            }
        } else {
            this.options.setSyntaxFileName("");
            this.refreshSyntaxFileTextField();
        }
    }

    private void addExtension() {
        String string;
        AddExtensionDialog addExtensionDialog = new AddExtensionDialog(this.parent);
        ((Component)addExtensionDialog).setVisible(true);
        if (addExtensionDialog.isModified() && !(string = addExtensionDialog.getExtension()).equals("")) {
            if (!this.extensionList.contains(string)) {
                this.extensionList.addElement(string);
                this.refreshExtensionChoice();
                this.extensionChoice.select(string);
                this.options.addFileNameExtension(string);
            }
            this.syntaxFileTextField.setText(this.options.getSyntaxFileName(string));
        }
        addExtensionDialog.dispose();
    }

    private void findSyntaxFile() {
        FileDialog fileDialog = new FileDialog(this.parent, "Open syntax file", 0);
        ((Component)fileDialog).setVisible(true);
        String string = fileDialog.getFile();
        String string2 = fileDialog.getDirectory();
        fileDialog.dispose();
        if (string != null && string2 != null && string.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer(string2);
            stringBuffer.append(string);
            if (this.extensionChoice.getSelectedItem().equals("Default extension")) {
                this.options.setSyntaxFileName(stringBuffer.toString());
            } else {
                String string3 = this.extensionChoice.getSelectedItem();
                if (!this.extensionList.contains(string3)) {
                    this.extensionList.addElement(string3);
                    this.options.addFileNameExtension(string3);
                }
                this.options.setSyntaxFileName(string3, stringBuffer.toString());
            }
            this.syntaxFileTextField.setText(stringBuffer.toString());
        }
    }

    public boolean updateOptions() {
        return true;
    }

    private void refreshExtensionChoice() {
        this.extensionChoice.removeAll();
        this.extensionChoice.add("Default extension");
        Enumeration enumeration = this.extensionList.elements();
        while (enumeration.hasMoreElements()) {
            this.extensionChoice.add((String)enumeration.nextElement());
        }
        enumeration = this.builtInExtensionList.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.extensionList.contains(string)) continue;
            this.extensionChoice.add(string);
        }
    }

    private void refreshSyntaxFileTextField() {
        String string;
        String string2 = this.extensionChoice.getSelectedItem();
        if (this.extensionChoice.getSelectedIndex() == 0) {
            string = this.options.getSyntaxFileName();
            if (string == null || string.equals("")) {
                string = "Built In";
            }
        } else {
            string = this.extensionList.contains(string2) ? this.options.getSyntaxFileName(string2) : (this.builtInExtensionList.contains(string2) ? "Built In" : "Built In");
        }
        this.syntaxFileTextField.setText(string);
    }
}

