/*
 * Decompiled with CFR 0.152.
 */
package com.sonoransoft.codequill;

import com.sonoransoft.codequill.Line;
import com.sonoransoft.codequill.LinkedList;
import com.sonoransoft.codequill.ListElement;

public class Syntax {
    private String name;
    private ListElement data;
    private int columnOffset;
    private int lineOffset;
    private int columnWidth;
    private boolean validCursor;

    Syntax(String string) {
        this.name = new String(string);
        this.lineOffset = 0;
        this.columnOffset = 0;
        this.columnWidth = 0;
        this.validCursor = false;
    }

    public boolean isName(String string) {
        return this.name.compareTo(string) == 0;
    }

    public boolean isValidCursor() {
        return this.validCursor;
    }

    public boolean isText() {
        return this.data != null;
    }

    public String getName() {
        return this.name;
    }

    public void putSyntax(ListElement listElement) {
        this.data = listElement;
        LinkedList linkedList = new LinkedList();
        linkedList.add(listElement);
        if (linkedList.first()) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            boolean bl = false;
            boolean bl2 = false;
            do {
                int n2 = 0;
                stringBuffer.setLength(0);
                int n3 = 0;
                String string = ((Line)linkedList.get()).getText();
                int n4 = string.length();
                while (n3 < n4) {
                    char c = string.charAt(n3++);
                    if (!bl) {
                        switch (c) {
                            case '\\': {
                                bl = true;
                                bl2 = true;
                                break;
                            }
                            case '@': {
                                this.columnOffset = n2;
                                this.lineOffset = n;
                                this.validCursor = true;
                                bl2 = true;
                                break;
                            }
                            default: {
                                if (++n2 > this.columnWidth) {
                                    this.columnWidth = n2;
                                    break;
                                } else {
                                    break;
                                }
                            }
                        }
                    } else {
                        bl = false;
                    }
                    if (bl2) {
                        bl2 = false;
                        continue;
                    }
                    stringBuffer.append(c);
                }
                ((Line)linkedList.get()).setText(stringBuffer.toString());
                ++n;
            } while (linkedList.next());
        }
    }

    public ListElement getSyntax() {
        return this.data;
    }

    public int getLine() {
        return this.lineOffset;
    }

    public int getColumn() {
        return this.columnOffset;
    }

    public int getColumnWidth() {
        return this.columnWidth;
    }

    public ListElement getSyntax(int n) {
        LinkedList linkedList = new LinkedList();
        LinkedList linkedList2 = new LinkedList();
        if (this.data == null) {
            return null;
        }
        linkedList.add(this.data);
        if (!linkedList.first()) {
            return null;
        }
        do {
            Line line = new Line();
            if (((Line)linkedList.get()).textLength() > 0) {
                line.fill(' ', n);
                line.append(((Line)linkedList.get()).getText());
            } else {
                line.append("");
            }
            linkedList2.add(line);
        } while (linkedList.next());
        return linkedList2.cut();
    }
}

