/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jheora;

import com.fluendo.jheora.Colorspace;
import com.fluendo.jheora.Comment;
import com.fluendo.jheora.HuffEntry;
import com.fluendo.jheora.Huffman;
import com.fluendo.jheora.Quant;
import com.jcraft.jogg.Buffer;
import com.jcraft.jogg.Packet;

public class Info {
    public int width;
    public int height;
    public int frame_width;
    public int frame_height;
    public int offset_x;
    public int offset_y;
    public int fps_numerator;
    public int fps_denominator;
    public int aspect_numerator;
    public int aspect_denominator;
    public Colorspace colorspace;
    public int target_bitrate;
    public int quality;
    public int quick_p;
    public byte version_major;
    public byte version_minor;
    public byte version_subminor;
    public long keyframe_frequency_force;
    short[][][][] dequant_tables = new short[2][3][64][64];
    int[] AcScaleFactorTable = new int[64];
    short[] DcScaleFactorTable = new short[64];
    int MaxQMatrixIndex;
    short[] qmats;
    HuffEntry[] HuffRoot = new HuffEntry[80];
    byte[] LoopFilterLimitValues = new byte[64];

    private static void _tp_readbuffer(Buffer buffer, byte[] byArray, int n) {
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)buffer.readB(8);
        }
    }

    private static int _tp_readlsbint(Buffer buffer) {
        int n = buffer.readB(8);
        n |= buffer.readB(8) << 8;
        n |= buffer.readB(8) << 16;
        return n |= buffer.readB(8) << 24;
    }

    private int unpackInfo(Buffer buffer) {
        this.version_major = (byte)buffer.readB(8);
        this.version_minor = (byte)buffer.readB(8);
        this.version_subminor = (byte)buffer.readB(8);
        if (this.version_major != 3) {
            return -22;
        }
        if (this.version_minor > 2) {
            return -22;
        }
        this.width = buffer.readB(16) << 4;
        this.height = buffer.readB(16) << 4;
        this.frame_width = buffer.readB(24);
        this.frame_height = buffer.readB(24);
        this.offset_x = buffer.readB(8);
        this.offset_y = buffer.readB(8);
        this.fps_numerator = buffer.readB(32);
        this.fps_denominator = buffer.readB(32);
        this.aspect_numerator = buffer.readB(24);
        this.aspect_denominator = buffer.readB(24);
        this.colorspace = Colorspace.spaces[buffer.readB(8)];
        this.target_bitrate = buffer.readB(24);
        this.quality = buffer.readB(6);
        this.keyframe_frequency_force = 1 << buffer.readB(5);
        if (buffer.readB(5) == -1) {
            return -20;
        }
        return 0;
    }

    static int unpackComment(Comment comment, Buffer buffer) {
        int n = Info._tp_readlsbint(buffer);
        if (n < 0) {
            return -20;
        }
        byte[] byArray = new byte[n];
        Info._tp_readbuffer(buffer, byArray, n);
        comment.vendor = new String(byArray);
        int n2 = Info._tp_readlsbint(buffer);
        if (n2 < 0) {
            comment.clear();
            return -20;
        }
        comment.user_comments = new String[n2];
        for (int i = 0; i < n2; ++i) {
            n = Info._tp_readlsbint(buffer);
            if (n < 0) {
                comment.clear();
                return -20;
            }
            byArray = new byte[n];
            Info._tp_readbuffer(buffer, byArray, n);
            comment.user_comments[i] = new String(byArray);
        }
        return 0;
    }

    private int readFilterTables(Buffer buffer) {
        int n = buffer.readB(3);
        for (int i = 0; i < 64; ++i) {
            int n2 = buffer.readB(n);
            this.LoopFilterLimitValues[i] = (byte)n2;
        }
        if (n < 0) {
            return -20;
        }
        return 0;
    }

    private int unpackTables(Buffer buffer) {
        int n = this.readFilterTables(buffer);
        if (n != 0) {
            return n;
        }
        n = Quant.readQTables(this, buffer);
        if (n != 0) {
            return n;
        }
        n = Huffman.readHuffmanTrees(this.HuffRoot, buffer);
        if (n != 0) {
            return n;
        }
        return n;
    }

    public void clear() {
        this.qmats = null;
        Huffman.clearHuffmanTrees(this.HuffRoot);
    }

    public int decodeHeader(Comment comment, Packet packet) {
        Buffer buffer = new Buffer();
        buffer.readinit(packet.packet_base, packet.packet, packet.bytes);
        byte[] byArray = new byte[6];
        int n = buffer.readB(8);
        if ((n & 0x80) == 0) {
            return -21;
        }
        Info._tp_readbuffer(buffer, byArray, 6);
        if (!"theora".equals(new String(byArray))) {
            return -21;
        }
        switch (n) {
            case 128: {
                if (packet.b_o_s == 0) {
                    return -20;
                }
                if (this.version_major != 0) {
                    return -20;
                }
                long l = this.unpackInfo(buffer);
                return (int)l;
            }
            case 129: {
                if (this.version_major == 0) {
                    return -20;
                }
                long l = Info.unpackComment(comment, buffer);
                return (int)l;
            }
            case 130: {
                if (this.version_major == 0 || comment.vendor == null) {
                    return -20;
                }
                long l = this.unpackTables(buffer);
                return (int)l;
            }
        }
        if (this.version_major == 0 || comment.vendor == null || this.HuffRoot[0] == null) {
            return -20;
        }
        return -25;
    }
}

