/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.plugin;

import com.fluendo.jst.Message;
import com.fluendo.plugin.AudioSink;
import com.fluendo.utils.Debug;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;

public class AudioSinkJ2
extends AudioSink {
    public static final int SEGSIZE = 8192;
    private SourceDataLine line = null;
    private int channels;
    private long samplesWritten;
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;

    protected AudioSink.RingBuffer createRingBuffer() {
        return new AudioSink.RingBuffer();
    }

    protected boolean open(AudioSink.RingBuffer ringBuffer) {
        this.channels = ringBuffer.channels;
        this.line = this.openLine(ringBuffer.channels, ringBuffer.rate);
        if (this.line == null) {
            this.postMessage(Message.newError(this, "Could not open audio device."));
            return false;
        }
        Debug.log(3, "line info: available: " + this.line.available());
        Debug.log(3, "line info: buffer: " + this.line.getBufferSize());
        Debug.log(3, "line info: framePosition: " + this.line.getFramePosition());
        ringBuffer.segSize = 8192;
        ringBuffer.segTotal = this.line.getBufferSize() / ringBuffer.segSize;
        while (ringBuffer.segTotal < 4) {
            ringBuffer.segSize >>= 1;
            ringBuffer.segTotal = this.line.getBufferSize() / ringBuffer.segSize;
        }
        ringBuffer.emptySeg = new byte[ringBuffer.segSize];
        this.samplesWritten = 0L;
        this.line.start();
        return true;
    }

    protected SourceDataLine openLine(int n, int n2) {
        AudioFormat audioFormat = new AudioFormat(n2, 16, n, true, true);
        DataLine.Info info = new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = AudioSinkJ2.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine, audioFormat);
        SourceDataLine sourceDataLine = null;
        try {
            Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
            for (int i = 0; i < infoArray.length; ++i) {
                Debug.log(3, "mixer description: " + infoArray[i].getDescription() + ", vendor: " + infoArray[i].getVendor());
                String string = infoArray[i].getDescription();
                String string2 = infoArray[i].getVendor();
                if (string.indexOf("ALSA") < 0 && string2.indexOf("ALSA") < 0 || string.indexOf("IEC958") >= 0) continue;
                try {
                    Line.Info[] infoArray2 = AudioSystem.getMixer(infoArray[i]).getSourceLineInfo(info);
                    for (int j = 0; j < infoArray2.length; ++j) {
                        Debug.log(3, "Mixer supports line: " + infoArray2[j].toString());
                        AudioFormat[] audioFormatArray = ((DataLine.Info)infoArray2[j]).getFormats();
                        for (int k = 0; k < audioFormatArray.length; ++k) {
                            Debug.log(3, "Format: " + audioFormatArray[k].toString());
                        }
                    }
                    Debug.log(3, "Attempting to get a line from ALSA mixer");
                    sourceDataLine = (SourceDataLine)AudioSystem.getMixer(infoArray[i]).getLine(info);
                    sourceDataLine.open(audioFormat);
                    break;
                }
                catch (Exception exception) {
                    if (sourceDataLine != null) {
                        sourceDataLine.close();
                        sourceDataLine = null;
                    }
                    Debug.log(3, "mixer: " + infoArray[i].getDescription() + " failed: " + exception);
                }
            }
            if (sourceDataLine == null) {
                sourceDataLine = (SourceDataLine)AudioSystem.getLine(info);
                sourceDataLine.open(audioFormat);
            }
        }
        catch (LineUnavailableException lineUnavailableException) {
            Debug.error(lineUnavailableException.toString());
            return null;
        }
        catch (Exception exception) {
            Debug.error(exception.toString());
            return null;
        }
        return sourceDataLine;
    }

    public boolean test() {
        SourceDataLine sourceDataLine = this.openLine(2, 44000);
        if (sourceDataLine == null) {
            return false;
        }
        sourceDataLine.close();
        return true;
    }

    protected boolean close(AudioSink.RingBuffer ringBuffer) {
        this.line.stop();
        this.line.close();
        return true;
    }

    protected int write(byte[] byArray, int n, int n2) {
        int n3;
        block6: {
            int n4;
            n3 = 0;
            if (n < 0 || n >= byArray.length || n + n2 > byArray.length || n2 <= 0) {
                Debug.debug("Invalid audio write offset=" + n + ", length=" + n2 + ", data.length=" + byArray.length);
                return n2;
            }
            while (n2 > (n4 = this.line.available())) {
                if (n4 > 0) {
                    Debug.debug("Doing partial audio write of " + n4 + " bytes");
                    n3 += this.line.write(byArray, n, n4);
                    n += n4;
                    n2 -= n4;
                }
                if (n2 > 0) {
                    try {
                        AudioFormat audioFormat = this.line.getFormat();
                        long l = (long)((float)(this.line.getBufferSize() * 1000) / audioFormat.getSampleRate() / (float)audioFormat.getSampleSizeInBits() * 8.0f / 4.0f);
                        Debug.debug("Sleeping for " + l + "ms");
                        Thread.sleep(l);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                break block6;
            }
            Debug.debug("Doing complete audio write of " + n2 + " bytes");
            n3 += this.line.write(byArray, n, n2);
        }
        this.samplesWritten += (long)(n3 / (2 * this.channels));
        return n3;
    }

    protected long delay() {
        int n = this.line.getFramePosition();
        long l = this.samplesWritten - (long)n;
        return l;
    }

    protected void reset() {
        Debug.log(4, "reset audio: " + this.line);
        this.line.flush();
        this.samplesWritten = this.line.getFramePosition();
        Debug.log(4, "samples written: " + this.samplesWritten);
    }

    public String getFactoryName() {
        return "audiosinkj2";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

