/*
 * Decompiled with CFR 0.152.
 */
package xpages;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import xpages.ImAnim;

public class PNGImage
implements ImAnim {
    Image img = null;

    public static void main(String[] stringArray) {
        int n;
        int n2;
        if (stringArray.length != 4) {
            System.err.println("il faut 4 arguments");
            return;
        }
        File file = new File(stringArray[0]);
        if (!file.exists()) {
            System.err.println("le fichier n'existe pas");
            return;
        }
        File file2 = new File(stringArray[1]);
        try {
            n2 = new Integer(stringArray[2]);
            n = new Integer(stringArray[3]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        PNGImage pNGImage = new PNGImage();
        try {
            pNGImage.open(file);
            pNGImage.rescale(file2, n2, n);
        }
        catch (IOException iOException) {
            System.err.println("IOException : " + iOException.getMessage());
            return;
        }
    }

    public void open(File file) throws IOException {
        this.img = Toolkit.getDefaultToolkit().getImage(file.getPath());
        try {
            while (this.img.getWidth(null) == -1 || this.img.getHeight(null) == -1) {
                Thread.currentThread();
                Thread.sleep(50L);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("InterruptedException: " + interruptedException.getMessage());
        }
    }

    public int getWidth() {
        if (this.img == null) {
            return -1;
        }
        return this.img.getWidth(null);
    }

    public int getHeight() {
        if (this.img == null) {
            return -1;
        }
        return this.img.getHeight(null);
    }

    public int getImageCount() {
        if (this.img == null) {
            return 0;
        }
        return 1;
    }

    public Image getImage(int n) {
        if (n != 0) {
            return null;
        }
        return this.img;
    }

    public void rescale(File file, int n, int n2) throws IOException {
        BufferedImage bufferedImage = this.getScaledBufferedImage(n, n2);
        ImageIO.write((RenderedImage)bufferedImage, "PNG", file);
    }

    public BufferedImage getScaledBufferedImage(int n, int n2) {
        WaitingObserver waitingObserver;
        Image image = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(this.img.getSource(), new AreaAveragingScaleFilter(n, n2)));
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (!graphics2D.drawImage(image, 0, 0, waitingObserver = new WaitingObserver())) {
            waitingObserver.attendre();
            graphics2D.drawImage(image, 0, 0, null);
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    class WaitingObserver
    implements ImageObserver {
        boolean stillwaiting = true;

        WaitingObserver() {
        }

        public void attendre() {
            while (this.stillwaiting) {
                try {
                    Thread.currentThread();
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    System.err.println("InterruptedException: " + interruptedException.getMessage());
                }
            }
        }

        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            if ((n & 0x20) != 0) {
                this.stillwaiting = false;
                return false;
            }
            if ((n & 0x40) != 0) {
                System.err.println("imageUpdate: ERROR");
            }
            if ((n & 0x80) != 0) {
                System.err.println("ABORT");
                this.stillwaiting = false;
                return false;
            }
            return true;
        }
    }
}

