/*
 * Decompiled with CFR 0.152.
 */
package editeurconfig;

import editeurconfig.EditeurFichierConfig;
import editeurconfig.ListeElements;
import editeurconfig.Outils;
import editeurconfig.Strings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ChoixRacine
extends JDialog {
    private Object parentSelectionne = null;
    private Object racineSelectionne = null;
    private Document doc;
    private Element racine;
    private Element langage;
    private ListeElements listeElements;
    private JList listeP;
    private JList listeR;
    private JList listeRestante = new JList();
    private DefaultListModel listeModelParents;
    private DefaultListModel listeModeleRestant;
    private DefaultListModel listeModelRacines;
    private ArrayList<String> elementsRestants = new ArrayList();
    private JButton boutonAjouter;
    private JButton boutonRetirer;

    public ChoixRacine(Document document, Element element, ListeElements listeElements) {
        super((Frame)new JFrame(), Strings.get("titre.ChoixRacines"));
        this.doc = document;
        this.racine = element;
        this.listeElements = listeElements;
        this.langage = Outils.premierEnfantDeNom(element, "LANGAGE");
        listeElements.JListeElementsParents();
        this.listeModelParents = listeElements.getListModelP();
        this.listeR = new JList();
        this.listeR.setSelectionMode(0);
        this.retirerRacinesExistantes();
        if (this.elementsRestants != null) {
            this.listeP = this.listeRestante;
            this.listeModelParents = this.listeModeleRestant;
        } else {
            this.listeP = listeElements.JListeDesElements();
        }
        this.listeP.setSelectionMode(0);
        this.setDefaultCloseOperation(0);
        this.afficher();
    }

    public void afficher() {
        this.creerPanelListes();
        this.listeP.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ChoixRacine.this.parentSelectionne = ChoixRacine.this.listeP.getSelectedValue();
                if (ChoixRacine.this.parentSelectionne != null) {
                    ChoixRacine.this.boutonAjouter.setEnabled(true);
                    ChoixRacine.this.boutonRetirer.setEnabled(false);
                } else {
                    ChoixRacine.this.boutonAjouter.setEnabled(false);
                    ChoixRacine.this.boutonRetirer.setEnabled(false);
                }
            }
        });
        this.listeR.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ChoixRacine.this.racineSelectionne = ChoixRacine.this.listeR.getSelectedValue();
                if (ChoixRacine.this.racineSelectionne != null) {
                    ChoixRacine.this.boutonAjouter.setEnabled(false);
                    ChoixRacine.this.boutonRetirer.setEnabled(true);
                } else {
                    ChoixRacine.this.boutonAjouter.setEnabled(false);
                    ChoixRacine.this.boutonRetirer.setEnabled(false);
                }
            }
        });
        this.creerPanelBoutonsBas();
        this.pack();
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getToolkit().getScreenSize();
        this.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        this.setVisible(true);
    }

    private void creerPanelListes() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new FlowLayout());
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel.add(jPanel2);
        JLabel jLabel = new JLabel(Strings.get("label.ElementsParents"));
        jPanel2.add((Component)jLabel, "North");
        JScrollPane jScrollPane = new JScrollPane(this.listeP);
        jScrollPane.setPreferredSize(new Dimension(200, 300));
        jPanel2.add((Component)jScrollPane, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel.add(jPanel3);
        this.boutonAjouter = new JButton(new AbstractAction(Strings.get("bouton.Ajouter") + " ->"){

            public void actionPerformed(ActionEvent actionEvent) {
                ChoixRacine.this.ajouter();
            }
        });
        this.boutonAjouter.setEnabled(false);
        jPanel3.add(this.boutonAjouter);
        jPanel3.add(Box.createVerticalStrut(10));
        this.boutonRetirer = new JButton(new AbstractAction("<- " + Strings.get("bouton.Retirer")){

            public void actionPerformed(ActionEvent actionEvent) {
                ChoixRacine.this.retirer();
            }
        });
        this.boutonRetirer.setEnabled(false);
        jPanel3.add(this.boutonRetirer);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel.add(jPanel4);
        JLabel jLabel2 = new JLabel(Strings.get("label.Racines"));
        jPanel4.add((Component)jLabel2, "North");
        JScrollPane jScrollPane2 = new JScrollPane(this.listeR);
        jScrollPane2.setPreferredSize(new Dimension(200, 300));
        jPanel4.add((Component)jScrollPane2, "Center");
    }

    private void creerPanelBoutonsBas() {
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "South");
        JButton jButton = new JButton(new AbstractAction(Strings.get("bouton.Fermer")){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ChoixRacine.this.listeModelRacines.getSize() == 0) {
                    JOptionPane.showMessageDialog(ChoixRacine.this, Strings.get("message.AuMoinsUneRacine"), Strings.get("titre.Message"), 0);
                } else {
                    ChoixRacine.this.setVisible(false);
                }
            }
        });
        jPanel.add(jButton);
    }

    private void retirerRacinesExistantes() {
        this.listeModeleRestant = new DefaultListModel();
        Object[] objectArray = this.listeModelParents.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            this.listeModeleRestant.addElement(objectArray[i]);
        }
        Object[] objectArray2 = this.listeModeleRestant.toArray();
        for (int i = 0; i < objectArray2.length; ++i) {
            this.elementsRestants.add(objectArray2[i].toString());
        }
        this.listeRestante.setModel(this.listeModeleRestant);
        this.listeModelRacines = new DefaultListModel();
        for (Node node = this.langage.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !"RACINE".equals(node.getNodeName())) continue;
            String string = ((Element)node).getAttribute("element");
            for (int i = 0; i < this.listeModeleRestant.getSize(); ++i) {
                if (!string.equals(this.listeModeleRestant.get(i).toString())) continue;
                this.listeModeleRestant.removeElement(this.listeModeleRestant.get(i));
                this.listeModelRacines.addElement(string);
            }
        }
        this.trierListe(this.listeModelRacines);
        this.listeR.setModel(this.listeModelRacines);
    }

    private void trierListe(DefaultListModel defaultListModel) {
        Object[] objectArray = defaultListModel.toArray();
        Arrays.sort(objectArray);
        defaultListModel.removeAllElements();
        for (int i = 0; i < objectArray.length; ++i) {
            defaultListModel.addElement(objectArray[i]);
        }
    }

    private void ajouter() {
        if (this.parentSelectionne != null) {
            this.listeModelRacines.addElement(this.parentSelectionne);
            this.enregistrerElementRacine(this.parentSelectionne);
            this.listeModelParents.removeElement(this.parentSelectionne);
            this.trierListe(this.listeModelRacines);
        }
    }

    private void retirer() {
        if (this.racineSelectionne != null) {
            this.listeModelParents.addElement(this.racineSelectionne);
            Element element = Outils.getElementSelectionne(this.langage, "RACINE", this.racineSelectionne.toString(), "element");
            if (element != null) {
                this.langage.removeChild(element);
            }
            this.listeModelRacines.removeElement(this.racineSelectionne);
            this.trierListe(this.listeModelParents);
        }
    }

    private void enregistrerElementRacine(Object object) {
        Element element = Outils.getElementSelectionne(this.langage, "RACINE", object.toString(), "element");
        if (element == null) {
            element = this.doc.createElement("RACINE");
            element.setAttribute("element", object.toString());
            this.langage.appendChild(element);
            EditeurFichierConfig.setModif(true);
        }
    }
}

