/*
 * Decompiled with CFR 0.152.
 */
package editeurconfig;

import editeurconfig.ChoixDuSchema;
import editeurconfig.EditeurFichierConfig;
import editeurconfig.Strings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefinirLaLangue
extends JDialog {
    private EditeurFichierConfig appl;
    private Document doc;
    private Element racine;
    private JList listeLg;
    private DefaultListModel model;
    private JButton bOK;
    private JButton bOKK;

    public DefinirLaLangue(EditeurFichierConfig editeurFichierConfig, Document document, Element element) {
        super((Frame)new JFrame(), Strings.get("titre.DefinirLesLangues"));
        this.appl = editeurFichierConfig;
        this.doc = document;
        this.racine = element;
        this.setDefaultCloseOperation(0);
        this.afficher();
    }

    private void afficher() {
        JPanel jPanel = new JPanel(new FlowLayout());
        JLabel jLabel = new JLabel(Strings.get("label.choixLangues"));
        this.add((Component)jLabel, "North");
        this.model = new DefaultListModel();
        this.listeLg = new JList(this.model);
        this.listeLg.setSelectionMode(2);
        this.add((Component)new JScrollPane(this.listeLg), "Center");
        JButton jButton = new JButton(new AbstractAction(Strings.get("bouton.Ajouter")){

            public void actionPerformed(ActionEvent actionEvent) {
                DefinirLaLangue.this.ajouterLangue();
            }
        });
        jPanel.add(jButton);
        JButton jButton2 = new JButton(new AbstractAction(Strings.get("bouton.Retirer")){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DefinirLaLangue.this.model.getSize() > 0) {
                    Object[] objectArray = DefinirLaLangue.this.listeLg.getSelectedValues();
                    for (int i = objectArray.length - 1; i >= 0; --i) {
                        DefinirLaLangue.this.model.removeElement(objectArray[i]);
                    }
                }
                if (DefinirLaLangue.this.model.isEmpty()) {
                    DefinirLaLangue.this.bOK.setEnabled(false);
                }
            }
        });
        jPanel.add(jButton2);
        JButton jButton3 = new JButton(new AbstractAction(Strings.get("bouton.Annuler")){

            public void actionPerformed(ActionEvent actionEvent) {
                DefinirLaLangue.this.setVisible(false);
                new EditeurFichierConfig();
            }
        });
        jPanel.add(jButton3);
        this.bOK = new JButton(new AbstractAction(Strings.get("bouton.OK")){

            public void actionPerformed(ActionEvent actionEvent) {
                DefinirLaLangue.this.enregistrerElementStrings();
                DefinirLaLangue.this.setVisible(false);
                new ChoixDuSchema(DefinirLaLangue.this.appl, DefinirLaLangue.this.doc, DefinirLaLangue.this.racine);
            }
        });
        jPanel.add(this.bOK);
        this.bOK.setEnabled(false);
        this.add((Component)jPanel, "South");
        this.pack();
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getToolkit().getScreenSize();
        this.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        this.setVisible(true);
    }

    private void ajouterLangue() {
        final JDialog jDialog = new JDialog((Dialog)this, Strings.get("titre.SaisirLaLangue"));
        jDialog.setDefaultCloseOperation(0);
        JPanel jPanel = new JPanel(new FlowLayout());
        final JTextField jTextField = new JTextField(6);
        jPanel.add(jTextField);
        jTextField.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent keyEvent) {
                if (jTextField.getText().length() > 2 || jTextField.getText().length() < 2) {
                    jTextField.setForeground(Color.red);
                    DefinirLaLangue.this.bOKK.setEnabled(false);
                } else {
                    jTextField.setForeground(Color.black);
                    DefinirLaLangue.this.bOKK.setEnabled(true);
                }
            }

            public void keyPressed(KeyEvent keyEvent) {
                if (jTextField.getText().length() > 2 || jTextField.getText().length() < 2) {
                    jTextField.setForeground(Color.red);
                    DefinirLaLangue.this.bOKK.setEnabled(false);
                } else {
                    jTextField.setForeground(Color.black);
                    DefinirLaLangue.this.bOKK.setEnabled(true);
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (jTextField.getText().length() > 2 || jTextField.getText().length() < 2) {
                    jTextField.setForeground(Color.red);
                    DefinirLaLangue.this.bOKK.setEnabled(false);
                } else {
                    jTextField.setForeground(Color.black);
                    DefinirLaLangue.this.bOKK.setEnabled(true);
                }
            }
        });
        JButton jButton = new JButton(new AbstractAction(Strings.get("bouton.Annuler")){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
            }
        });
        jPanel.add(jButton);
        this.bOKK = new JButton(new AbstractAction(Strings.get("bouton.OK")){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!DefinirLaLangue.this.codeLangueValide(jTextField.getText())) {
                    JOptionPane.showMessageDialog(jDialog, Strings.get("message.CodeLangueNonValide"));
                    jTextField.requestFocus();
                    jTextField.selectAll();
                } else if (DefinirLaLangue.this.model.contains(jTextField.getText())) {
                    JOptionPane.showMessageDialog(jDialog, Strings.get("message.LangueExiste"));
                    jTextField.requestFocus();
                    jTextField.selectAll();
                } else {
                    jDialog.setVisible(false);
                    DefinirLaLangue.this.model.addElement(jTextField.getText());
                    if (DefinirLaLangue.this.model.getSize() > 0) {
                        DefinirLaLangue.this.bOK.setEnabled(true);
                    }
                }
            }
        });
        jPanel.add(this.bOKK);
        this.bOKK.setEnabled(false);
        jDialog.add(jPanel);
        jDialog.pack();
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getToolkit().getScreenSize();
        jDialog.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        jDialog.setVisible(true);
    }

    private void enregistrerElementStrings() {
        for (int i = 0; i < this.model.size(); ++i) {
            Element element = this.doc.createElement("STRINGS");
            element.setAttribute("langue", this.model.get(i).toString());
            this.racine.appendChild(element);
        }
    }

    private boolean codeLangueValide(String string) {
        String[] stringArray = Locale.getISOLanguages();
        return Arrays.asList(stringArray).contains(string);
    }
}

