/*
 * Decompiled with CFR 0.152.
 */
package editeurconfig;

import editeurconfig.DefinirLaLangue;
import editeurconfig.FenetreEdition;
import editeurconfig.ListeElements;
import editeurconfig.Outils;
import editeurconfig.Strings;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class EditeurFichierConfig
extends JFrame {
    private Document doc = null;
    private Element racine = null;
    private String encodage = "ISO-8859-1";
    public static boolean modif = false;
    public File fsave = null;
    private ArrayList<String> elementsSchemaSimple = new ArrayList();

    public EditeurFichierConfig() {
        super(Strings.get("titre.EditeurFichierConfig"));
        this.setDefaultCloseOperation(0);
        this.affichageMenuInitial();
        this.setVisible(true);
    }

    public void affichageMenuInitial() {
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.removeAll();
        this.add(jPanel);
        JButton jButton = new JButton(new AbstractAction(Strings.get("bouton.Nouveau")){

            public void actionPerformed(ActionEvent actionEvent) {
                EditeurFichierConfig.this.nouveau();
            }
        });
        jPanel.add(jButton);
        JButton jButton2 = new JButton(new AbstractAction(Strings.get("bouton.Ouvrir")){

            public void actionPerformed(ActionEvent actionEvent) {
                EditeurFichierConfig.this.ouvrir();
            }
        });
        jPanel.add(jButton2);
        JButton jButton3 = new JButton(new AbstractAction(Strings.get("bouton.Quitter")){

            public void actionPerformed(ActionEvent actionEvent) {
                EditeurFichierConfig.quitter();
            }
        });
        jPanel.add(jButton3);
        this.getRootPane().setDefaultButton(jButton);
        this.ajusterTailleFenetre();
    }

    public void ajusterTailleFenetre() {
        this.pack();
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getToolkit().getScreenSize();
        this.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
    }

    private void nouveau() {
        this.creationRacine();
        this.setVisible(false);
        new DefinirLaLangue(this, this.doc, this.racine);
    }

    private void ouvrir() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = file.getName();
                int n = string.lastIndexOf(46);
                return n > 0 && n < string.length() - 1 && string.substring(n + 1).toLowerCase().equals("xml");
            }

            public String getDescription() {
                return Strings.get("texte.FichiersXML");
            }
        });
        if (jFileChooser.showOpenDialog(null) == 0) {
            File file = jFileChooser.getSelectedFile();
            this.ouvrir(file);
        }
    }

    public void ouvrir(File file) {
        block14: {
            URL uRL;
            try {
                uRL = file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                this.erreur(malformedURLException);
                return;
            }
            this.doc = this.lectureDocumentXML(uRL);
            if (this.doc != null) {
                this.setTitle(file.getName());
                this.racine = this.doc.getDocumentElement();
                ListeElements listeElements = null;
                Element element = Outils.premierEnfantDeNom(this.racine, "LANGAGE");
                if (element != null) {
                    Element element2 = Outils.premierEnfantDeNom(element, "FICHIER_SCHEMA");
                    if (element2 != null) {
                        String string = element2.getAttribute("nom");
                        try {
                            URL uRL2 = new URL(uRL, string);
                            URI uRI = null;
                            try {
                                uRI = uRL2.toURI();
                            }
                            catch (URISyntaxException uRISyntaxException) {
                                System.err.println(uRISyntaxException);
                            }
                            File file2 = new File(uRI);
                            if (file2.exists()) {
                                listeElements = new ListeElements(uRL2, null, null);
                                this.setVisible(false);
                                new FenetreEdition(this, file, this.doc, this.racine, listeElements);
                                break block14;
                            }
                            JOptionPane.showMessageDialog(this, Strings.get("message.SchemaInexistant"), Strings.get("titre.Erreur"), 0);
                        }
                        catch (MalformedURLException malformedURLException) {
                            System.err.println("Erreur urlFichier " + malformedURLException);
                        }
                    } else {
                        Element element3 = Outils.premierEnfantDeNom(element, "SCHEMA_SIMPLE");
                        if (element3 != null) {
                            listeElements = new ListeElements(null, null, element3);
                            this.setVisible(false);
                            new FenetreEdition(this, file, this.doc, this.racine, listeElements);
                        } else {
                            JOptionPane.showMessageDialog(this, Strings.get("message.SchemaInexistant"), Strings.get("titre.Erreur"), 0);
                        }
                    }
                } else {
                    JOptionPane.showMessageDialog(this, Strings.get("message.SchemaInexistant"), Strings.get("titre.Erreur"), 0);
                }
            }
        }
    }

    private void creationRacine() {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.doc = documentBuilder.newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.erreur(parserConfigurationException);
            return;
        }
        this.racine = this.doc.createElement("CONFIG_JAXE");
        this.doc.appendChild(this.racine);
    }

    private Document lectureDocumentXML(URL uRL) {
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new ErrorHandler(){

                public void warning(SAXParseException sAXParseException) throws SAXException {
                    String string = "Petite erreur de syntaxe dans le fichier XML:\n";
                    string = string + sAXParseException.getMessage() + " \u00e0 la ligne " + sAXParseException.getLineNumber();
                    EditeurFichierConfig.this.erreur(string);
                }

                public void error(SAXParseException sAXParseException) throws SAXException {
                    throw sAXParseException;
                }

                public void fatalError(SAXParseException sAXParseException) throws SAXException {
                    throw sAXParseException;
                }
            });
            document = documentBuilder.parse(uRL.toExternalForm());
            if (document.getXmlEncoding() != null) {
                this.encodage = document.getXmlEncoding();
            }
        }
        catch (SAXException sAXException) {
            String string = "Erreur de syntaxe dans le fichier XML:\n";
            string = string + sAXException.getMessage();
            if (sAXException instanceof SAXParseException) {
                string = string + " \u00e0 la ligne " + ((SAXParseException)sAXException).getLineNumber();
            }
            this.erreur(string);
            return null;
        }
        catch (IOException iOException) {
            this.erreur("Erreur d'E/S: " + iOException.getMessage());
            return null;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.erreur(parserConfigurationException);
            return null;
        }
        return document;
    }

    private File dialogueEnregistrer() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = file.getName();
                int n = string.lastIndexOf(46);
                return n > 0 && n < string.length() - 1 && string.substring(n + 1).toLowerCase().equals("xml");
            }

            public String getDescription() {
                return Strings.get("texte.FichiersXML");
            }
        });
        jFileChooser.setDialogTitle(Strings.get("titre.EnregistrerFichierXML"));
        jFileChooser.showSaveDialog(this);
        jFileChooser.setVisible(true);
        String string = jFileChooser.getName(jFileChooser.getSelectedFile());
        if (string != null) {
            this.fsave = new File(jFileChooser.getCurrentDirectory().toString(), string);
            if (this.fsave.getName().indexOf(46) == -1) {
                this.fsave = new File(this.fsave.getPath() + "_config.xml");
                if (this.fsave.exists() && JOptionPane.showConfirmDialog(this, Strings.get("message.Remplacerfichierexistant"), "", 0) == 1) {
                    return null;
                }
            }
            if (JOptionPane.showConfirmDialog(this, Strings.get("message.EnregistrerCheminSchema"), "", 0) == 0) {
                this.enregistrerCheminSchema(this.fsave);
            }
            return this.fsave;
        }
        return null;
    }

    public boolean enregistrerFichier(File file) {
        OutputStreamWriter outputStreamWriter;
        FileOutputStream fileOutputStream;
        File file2;
        if (file == null) {
            file2 = this.dialogueEnregistrer();
            if (file2 == null) {
                return false;
            }
        } else {
            file2 = file;
        }
        boolean bl = true;
        try {
            fileOutputStream = new FileOutputStream(file2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.erreur(fileNotFoundException);
            return false;
        }
        try {
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, this.encodage);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.erreur(unsupportedEncodingException);
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
        try {
            DOMSource dOMSource = new DOMSource(this.doc);
            StreamResult streamResult = new StreamResult(outputStreamWriter);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", this.encodage);
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            this.erreur(transformerConfigurationException);
            bl = false;
        }
        catch (TransformerException transformerException) {
            this.erreur(transformerException);
            bl = false;
        }
        try {
            ((Writer)outputStreamWriter).close();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            this.erreur(iOException);
            bl = false;
        }
        return bl;
    }

    public void enregistrerCheminSchema(File file) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = file.getName();
                int n = string.lastIndexOf(46);
                return n > 0 && n < string.length() - 1 && (string.substring(n + 1).toLowerCase().equals("xsd") || string.substring(n + 1).toLowerCase().equals("rng"));
            }

            public String getDescription() {
                return Strings.get("texte.Schemas");
            }
        });
        jFileChooser.setDialogTitle(Strings.get("titre.EnregistrerCheminSchema"));
        jFileChooser.setCurrentDirectory(file.getParentFile());
        jFileChooser.showSaveDialog(this);
        jFileChooser.setVisible(true);
        File file2 = jFileChooser.getSelectedFile();
        if (file2 != null) {
            URI uRI = null;
            URI uRI2 = null;
            try {
                uRI = new URI(file2.toString());
            }
            catch (URISyntaxException uRISyntaxException) {
                System.err.println(uRISyntaxException);
            }
            try {
                uRI2 = new URI(file.getParentFile().toString());
            }
            catch (URISyntaxException uRISyntaxException) {
                System.err.println(uRISyntaxException);
            }
            URI uRI3 = uRI2.relativize(uRI);
            Element element = Outils.premierEnfantDeNom(this.racine, "LANGAGE");
            Element element2 = Outils.premierEnfantDeNom(element, "FICHIER_SCHEMA");
            element2.setAttribute("nom", uRI3.toString());
            this.enregistrerFichier(file);
        }
    }

    public boolean getModif() {
        return modif;
    }

    public static void setModif(boolean bl) {
        if (modif != bl) {
            modif = bl;
        }
    }

    public static void quitter() {
        System.exit(0);
    }

    public void erreur(Exception exception) {
        this.erreur(exception.getClass().getName() + ": " + exception.getMessage());
    }

    public void erreur(String string) {
        JOptionPane.showMessageDialog(this, string, "Erreur", 0);
    }

    public static void main(String[] stringArray) {
        new EditeurFichierConfig();
    }

    public static void convertToString(Document document) {
        for (int i = 0; i < 30; ++i) {
            System.out.println();
        }
        DOMSource dOMSource = new DOMSource(document);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("encoding", "ISO-8859-1");
            transformer.setOutputProperty("indent", "yes");
            try {
                transformer.transform(dOMSource, streamResult);
            }
            catch (TransformerException transformerException) {
                System.err.println(transformerException);
            }
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            System.err.println(transformerConfigurationException);
        }
        System.out.println(stringWriter.toString());
    }
}

