/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jtiger;

import com.fluendo.jkate.Event;
import com.fluendo.jkate.Tracker;
import com.fluendo.jtiger.TigerBitmap;
import com.fluendo.utils.Debug;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;

public class Item {
    private Tracker kin = null;
    private boolean alive = false;
    private Font font = null;
    private int font_size = 0;
    private String text = null;
    private TigerBitmap background_image = null;
    private int width = -1;
    private int height = -1;
    private float region_x;
    private float region_y;
    private float region_w;
    private float region_h;

    public Item(Event event) {
        this.kin = new Tracker(event);
        this.text = null;
        if (event.text != null && event.text.length > 0) {
            try {
                this.text = new String(event.text, "UTF8");
            }
            catch (Exception exception) {
                Debug.warning("Failed to convert text from UTF-8 - text will not display");
                this.text = null;
            }
        }
    }

    protected void createFont(Component component) {
        Dimension dimension = component.getSize();
        this.font_size = dimension.width / 32;
        if (this.font_size < 12) {
            this.font_size = 12;
        }
        this.font = new Font("sansserif", 1, this.font_size);
    }

    protected void updateCachedData(Component component) {
        Dimension dimension = component.getSize();
        if (dimension.width == this.width && dimension.height == this.height) {
            return;
        }
        this.createFont(component);
        this.width = dimension.width;
        this.height = dimension.height;
    }

    public boolean update(Component component, double d) {
        Event event = this.kin.ev;
        if (event == null) {
            return false;
        }
        if (d >= event.end_time) {
            return false;
        }
        this.alive = !(d < event.start_time);
        Dimension dimension = component.getSize();
        return this.kin.update(d - event.start_time, dimension, dimension);
    }

    public void setupRegion(Component component) {
        if (this.kin.has[0]) {
            this.region_x = this.kin.region_x;
            this.region_y = this.kin.region_y;
            this.region_w = this.kin.region_w;
            this.region_h = this.kin.region_h;
        } else {
            Dimension dimension = component.getSize();
            this.region_x = (float)dimension.width * 0.1f;
            this.region_y = (float)dimension.height * 0.8f;
            this.region_w = (float)dimension.width * 0.8f;
            this.region_h = (float)dimension.height * 0.1f;
        }
    }

    public void render(Component component, BufferedImage bufferedImage) {
        Event event = this.kin.ev;
        if (!this.alive) {
            return;
        }
        this.updateCachedData(component);
        this.setupRegion(component);
        this.renderBackground(bufferedImage);
        this.renderText(bufferedImage);
    }

    public void renderBackground(BufferedImage bufferedImage) {
        if (this.kin.ev.bitmap != null) {
            if (this.background_image == null) {
                this.background_image = new TigerBitmap(this.kin.ev.bitmap, this.kin.ev.palette);
            }
            Graphics2D graphics2D = bufferedImage.createGraphics();
            int n = (int)((double)this.region_x + 0.5);
            int n2 = (int)((double)this.region_y + 0.5);
            int n3 = (int)((double)this.region_w + 0.5);
            int n4 = (int)((double)this.region_h + 0.5);
            graphics2D.drawImage(this.background_image.getScaled(n3, n4), n, n2, null);
            graphics2D.dispose();
        }
    }

    public void renderText(BufferedImage bufferedImage) {
        if (this.text == null) {
            return;
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        AttributedString attributedString = new AttributedString(this.text, this.font.getAttributes());
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        int n = attributedCharacterIterator.getEndIndex();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, fontRenderContext);
        float f = 0.0f;
        float f2 = (float)this.font_size * 0.05f;
        float f3 = (float)this.font_size * 0.05f;
        while (lineBreakMeasurer.getPosition() < n) {
            TextLayout textLayout = lineBreakMeasurer.nextLayout(this.region_w);
            float f4 = textLayout.getAdvance();
            graphics2D.setColor(Color.black);
            textLayout.draw(graphics2D, this.region_x + (this.region_w - f4) / 2.0f + f2, this.region_y + (f += textLayout.getAscent()) + f3);
            textLayout.draw(graphics2D, this.region_x + (this.region_w - f4) / 2.0f - f2, this.region_y + f - f3);
            textLayout.draw(graphics2D, this.region_x + (this.region_w - f4) / 2.0f + f2, this.region_y + f - f3);
            textLayout.draw(graphics2D, this.region_x + (this.region_w - f4) / 2.0f - f2, this.region_y + f + f3);
            graphics2D.setColor(Color.white);
            textLayout.draw(graphics2D, this.region_x + (this.region_w - f4) / 2.0f, this.region_y + f);
            f += textLayout.getDescent() + textLayout.getLeading();
        }
        graphics2D.dispose();
    }
}

