/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.invoker;

import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.pipeline.PipelineFacade;
import org.dita.dost.pipeline.PipelineHashIO;
import org.dita.dost.util.StringUtils;

public class ExtensibleAntInvoker
extends Task {
    private static final String KEY_VALUE_PAIR_SEPARATOR = ";";
    private static final String KEY_VALUE_EQUAL_SIGN = "=";
    private DITAOTJavaLogger javaLogger = new DITAOTJavaLogger();
    private PipelineFacade pipeline = new PipelineFacade();
    private PipelineHashIO pipelineInput = new PipelineHashIO();
    private ArrayList<Param> params = new ArrayList();

    public void setBasedir(String s) {
        this.pipelineInput.setAttribute("basedir", s);
    }

    public String getBasedir() {
        return this.pipelineInput.getAttribute("basedir");
    }

    public void setModule(String module) {
        this.pipelineInput.setAttribute("module", module);
    }

    public String getModule() {
        return this.pipelineInput.getAttribute("module");
    }

    public void setMessage(String m) {
        this.pipelineInput.setAttribute("message", m);
    }

    public String getMessage() {
        return this.pipelineInput.getAttribute("message");
    }

    public void setExtparam(String extParam) {
        String keyValueStr = null;
        String attrName = null;
        String attrValue = null;
        StringTokenizer extParamStrTokenizer = new StringTokenizer(extParam, KEY_VALUE_PAIR_SEPARATOR);
        while (extParamStrTokenizer.hasMoreTokens()) {
            keyValueStr = extParamStrTokenizer.nextToken();
            int p = keyValueStr.indexOf(KEY_VALUE_EQUAL_SIGN);
            if (p <= 0) {
                String msg = null;
                Properties params = new Properties();
                params.put("%1", keyValueStr);
                msg = MessageUtils.getMessage("DOTJ006F", params).toString();
                throw new RuntimeException(msg);
            }
            attrName = keyValueStr.substring(0, p).trim();
            attrValue = keyValueStr.substring(p + 1).trim();
            if (StringUtils.isEmptyString(attrName) || StringUtils.isEmptyString(attrValue)) {
                String msg = null;
                Properties params = new Properties();
                params.put("%1", keyValueStr);
                msg = MessageUtils.getMessage("DOTJ006F", params).toString();
                throw new RuntimeException(msg);
            }
            this.pipelineInput.setAttribute(attrName, attrValue);
        }
    }

    public Param createParam() {
        Param p = new Param();
        this.params.add(p);
        return p;
    }

    public void execute() throws BuildException {
        if (this.getModule() == null) {
            throw new BuildException("module attribute must be specified");
        }
        if (this.pipelineInput.getAttribute("basedir") == null) {
            this.pipelineInput.setAttribute("basedir", this.getProject().getBaseDir().getAbsolutePath());
        }
        for (Param p : this.params) {
            if (!p.isValid()) {
                throw new BuildException("Incomplete parameter");
            }
            String ifProperty = p.getIf();
            if (ifProperty != null && !this.getProject().getProperties().containsKey(ifProperty)) continue;
            this.pipelineInput.setAttribute(p.getName(), p.getExpression());
        }
        try {
            this.pipeline.execute(this.getModule(), this.pipelineInput);
        }
        catch (DITAOTException e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }

    public static class Param {
        private String name;
        private String value;
        private String ifproperty;

        public String getName() {
            return this.name;
        }

        public boolean isValid() {
            return this.name != null && this.value != null;
        }

        public void setName(String s) {
            this.name = s;
        }

        public String getExpression() {
            return this.value;
        }

        public void setExpression(String v) {
            this.value = v;
        }

        public String getIf() {
            return this.ifproperty;
        }

        public void setIf(String p) {
            this.ifproperty = p;
        }
    }
}

