/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.log;

import java.io.File;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.DITAOTFileLogger;
import org.dita.dost.log.MessageBean;
import org.dita.dost.log.MessageUtils;

public class LogConfigTask
extends Task {
    private String logDir = null;
    private String logFile = null;

    public void execute() throws BuildException {
        DITAOTFileLogger logger = DITAOTFileLogger.getInstance();
        String oldLogDir = logger.getLogDir();
        this.initMessageFile();
        this.initLogDirectory();
        this.initLogFile();
        if (oldLogDir != null) {
            if (!oldLogDir.equals(this.logDir)) {
                this.logDir = this.getProject().getBaseDir().getAbsolutePath();
            }
            this.logFile = "ditaot_batch.log";
        }
        logger.setLogDir(this.logDir);
        logger.setLogFile(this.logFile);
    }

    private void initMessageFile() {
        String messageFile = this.getProject().getProperty("args.message.file");
        if (!new File(messageFile).exists()) {
            MessageUtils.loadDefaultMessages();
            return;
        }
        if (!new File(messageFile).isAbsolute()) {
            messageFile = new File(this.getProject().getBaseDir(), messageFile).getAbsolutePath();
        }
        MessageUtils.loadMessages(messageFile);
    }

    private void initLogDirectory() throws BuildException {
        Project project = this.getProject();
        File dir = null;
        this.logDir = project.getProperty("args.logdir");
        if (this.logDir == null) {
            this.logDir = project.getProperty("output.dir");
        }
        if (this.logDir == null || "".equals(this.logDir)) {
            MessageBean msgBean = MessageUtils.getMessage("DOTJ015F");
            String msg = msgBean.toString();
            throw new BuildException(msg, (Throwable)new DITAOTException(msgBean, null, msg));
        }
        if (!new File(this.logDir).isAbsolute()) {
            this.logDir = new File(project.getBaseDir(), this.logDir).getAbsolutePath();
        }
        if (!(dir = new File(this.logDir)).exists() && !dir.mkdirs()) {
            Properties params = new Properties();
            String msg = null;
            params.put("%1", this.logDir);
            MessageBean msgBean = MessageUtils.getMessage("DOTJ016F", params);
            msg = msgBean.toString();
            throw new BuildException(msg, (Throwable)new DITAOTException(msgBean, null, msg));
        }
    }

    private void initLogFile() throws BuildException {
        Project project = this.getProject();
        String inputFile = null;
        String rootName = null;
        String transType = null;
        int pos = 0;
        String input = project.getProperty("args.input");
        if (input == null) {
            input = project.getProperty("dita.input");
        }
        if (input == null) {
            MessageBean msgBean = MessageUtils.getMessage("DOTJ017F");
            String msg = msgBean.toString();
            throw new BuildException(msg, (Throwable)new DITAOTException(msgBean, null, msg));
        }
        transType = project.getProperty("transtype");
        if (transType == null) {
            transType = "";
        }
        rootName = (pos = (inputFile = new File(input).getName()).indexOf(46)) == -1 ? inputFile : inputFile.substring(0, pos);
        this.logFile = rootName + "_" + transType + ".log";
    }
}

