/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.module.AbstractPipelineModule;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.pipeline.PipelineHashIO;

public class EscapeUnicodeModule
implements AbstractPipelineModule {
    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        String inputFile = ((PipelineHashIO)input).getAttribute("input");
        String outputFile = ((PipelineHashIO)input).getAttribute("output");
        File file = new File(outputFile);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        FileInputStream fi = null;
        InputStreamReader is = null;
        BufferedReader br = null;
        OutputStreamWriter fw = null;
        try {
            fi = new FileInputStream(new File(inputFile));
            is = new InputStreamReader((InputStream)fi, "UTF-8");
            br = new BufferedReader(is);
            fw = new FileWriter(file);
            String data = null;
            int codePoint = 0;
            while ((data = br.readLine()) != null) {
                for (int i = 0; i < data.length(); ++i) {
                    codePoint = data.codePointAt(i);
                    if (codePoint < 128) {
                        fw.append(data.charAt(i));
                        continue;
                    }
                    fw.append("\\u").append("" + codePoint).append(" ?");
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                fw.flush();
                fw.close();
                br.close();
                is.close();
                fi.close();
            }
            catch (Exception e) {}
        }
        return null;
    }
}

