/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.module.AbstractPipelineModule;
import org.dita.dost.module.Content;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.pipeline.PipelineHashIO;
import org.dita.dost.reader.KeyrefReader;
import org.dita.dost.util.ListUtils;
import org.dita.dost.util.StringUtils;
import org.dita.dost.writer.KeyrefPaser;

public class KeyrefModule
implements AbstractPipelineModule {
    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        String ext;
        String tempDir = ((PipelineHashIO)input).getAttribute("tempDir");
        if (!new File(tempDir).isAbsolute()) {
            tempDir = new File(tempDir).getAbsolutePath();
        }
        String extName = (ext = ((PipelineHashIO)input).getAttribute("ditaext")).startsWith(".") ? ext : "." + ext;
        Properties properties = null;
        try {
            properties = ListUtils.getDitaList();
        }
        catch (Exception e) {
            DITAOTJavaLogger javaLogger = new DITAOTJavaLogger();
            javaLogger.logException(e);
        }
        HashMap<String, String> keymap = new HashMap<String, String>();
        Hashtable maps = new Hashtable();
        String keylist = properties.getProperty("keylist");
        if (!StringUtils.isEmptyString(keylist)) {
            Set<String> keys = StringUtils.restoreSet(keylist);
            for (String key : keys) {
                keymap.put(key.substring(0, key.indexOf("=")), key.substring(key.indexOf("=") + 1, key.lastIndexOf("(")));
                String map = key.substring(key.lastIndexOf("(") + 1, key.lastIndexOf(")"));
                if (maps.containsKey(map)) {
                    ((HashSet)maps.get(map)).add(key.substring(0, key.indexOf("=")));
                    continue;
                }
                HashSet<String> set = new HashSet<String>();
                set.add(key.substring(0, key.indexOf("=")));
                maps.put(map, set);
            }
        }
        KeyrefReader reader = new KeyrefReader();
        reader.setTempDir(tempDir);
        for (String mapFile : maps.keySet()) {
            reader.setKeys((Set)maps.get(mapFile));
            reader.read(mapFile);
        }
        Content content = reader.getContent();
        Set<String> parseList = StringUtils.restoreSet(properties.getProperty("keyreflist"));
        for (String file : parseList) {
            KeyrefPaser parser = new KeyrefPaser();
            parser.setContent(content);
            parser.setTempDir(tempDir);
            parser.setKeyMap(keymap);
            parser.setExtName(extName);
            parser.write(file);
        }
        return null;
    }
}

