/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.imageio.ImageIO;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.log.MessageUtils;

public class ImgUtils {
    private ImgUtils() {
    }

    public static int getWidth(String dirName, String fileName) {
        DITAOTJavaLogger logger = new DITAOTJavaLogger();
        File imgInput = new File(dirName + File.separatorChar + fileName);
        try {
            BufferedImage img = ImageIO.read(imgInput);
            return img.getHeight();
        }
        catch (Exception e) {
            Properties prop = new Properties();
            prop.put("%1", dirName + File.separatorChar + fileName);
            logger.logError(MessageUtils.getMessage("DOTJ021E", prop).toString());
            logger.logException(e);
            return -1;
        }
    }

    public static int getHeight(String dirName, String fileName) {
        DITAOTJavaLogger logger = new DITAOTJavaLogger();
        File imgInput = new File(dirName + File.separatorChar + fileName);
        try {
            BufferedImage img = ImageIO.read(imgInput);
            return img.getWidth();
        }
        catch (Exception e) {
            Properties prop = new Properties();
            prop.put("%1", dirName + File.separatorChar + fileName);
            logger.logError(MessageUtils.getMessage("DOTJ023E", prop).toString());
            logger.logException(e);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBinData(String dirName, String fileName) {
        DITAOTJavaLogger logger = new DITAOTJavaLogger();
        File imgInput = new File(dirName + File.separatorChar + fileName);
        FileInputStream binInput = null;
        try {
            String binStr = null;
            StringBuffer ret = new StringBuffer(16384);
            binInput = new FileInputStream(imgInput);
            int bin = binInput.read();
            while (bin != -1) {
                binStr = Integer.toHexString(bin);
                if (binStr.length() < 2) {
                    ret.append("0");
                }
                ret.append(binStr);
                bin = binInput.read();
            }
            String string = ret.toString();
            return string;
        }
        catch (Exception e) {
            logger.logError(MessageUtils.getMessage("DOTJ023E").toString());
            logger.logException(e);
            String string = null;
            return string;
        }
        finally {
            try {
                binInput.close();
            }
            catch (IOException ioe) {
                logger.logException(ioe);
            }
        }
    }

    public static String getType(String fileName) {
        String name = fileName.toLowerCase();
        DITAOTJavaLogger logger = new DITAOTJavaLogger();
        Properties prop = new Properties();
        if (name.endsWith(".jpg") || name.endsWith(".jpeg")) {
            return "jpegblip";
        }
        if (name.endsWith(".gif") || name.endsWith(".png")) {
            return "pngblip";
        }
        prop.put("%1", fileName);
        logger.logError(MessageUtils.getMessage("DOTJ024W", prop).toString());
        return "other";
    }
}

