/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.resolver.DitaURIResolverFactory;
import org.dita.dost.resolver.URIResolverAdapter;

public class ListUtils {
    private ListUtils() {
    }

    public static Properties getDitaList() throws IOException {
        Properties properties = new Properties();
        try {
            InputStream source = URIResolverAdapter.convertTOInputStream(DitaURIResolverFactory.getURIResolver().resolve("dita.xml.properties", null));
            if (source != null) {
                properties.loadFromXML(source);
            } else {
                source = URIResolverAdapter.convertTOInputStream(DitaURIResolverFactory.getURIResolver().resolve("dita.list", null));
                properties.load(source);
            }
        }
        catch (TransformerException e) {
            DITAOTJavaLogger javaLogger = new DITAOTJavaLogger();
            javaLogger.logException(e);
        }
        return properties;
    }

    public static Properties loadList(String name, String base, boolean isXML) throws IOException {
        Properties properties = new Properties();
        try {
            InputStream source = URIResolverAdapter.convertTOInputStream(DitaURIResolverFactory.getURIResolver().resolve(name, base));
            if (isXML) {
                properties.loadFromXML(source);
            } else {
                properties.load(source);
            }
        }
        catch (TransformerException e) {
            DITAOTJavaLogger javaLogger = new DITAOTJavaLogger();
            javaLogger.logException(e);
        }
        return properties;
    }

    public static void storeList(String name, String base, boolean isXML, Properties properties) throws IOException {
        try {
            InputStream source = URIResolverAdapter.convertTOInputStream(DitaURIResolverFactory.getURIResolver().resolve(name, base));
            if (isXML) {
                properties.storeToXML(new FileOutputStream(name), null);
            } else {
                properties.store(new FileOutputStream(name), null);
            }
        }
        catch (TransformerException e) {
            DITAOTJavaLogger javaLogger = new DITAOTJavaLogger();
            javaLogger.logException(e);
        }
    }
}

