/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.io.File;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.util.CatalogUtils;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.StringUtils;
import org.dita.dost.util.TopicIdParser;
import org.xml.sax.EntityResolver;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class MergeUtils {
    private static MergeUtils instance = null;
    private Hashtable idMap = new Hashtable();
    private int index = 0;
    private Set visitSet = new HashSet(256);
    private DITAOTJavaLogger logger = new DITAOTJavaLogger();

    private MergeUtils() {
    }

    public static MergeUtils getInstance() {
        if (instance == null) {
            instance = new MergeUtils();
        }
        return instance;
    }

    public void reset() {
        this.idMap.clear();
        this.visitSet.clear();
        this.index = 0;
    }

    public boolean findId(String Id) {
        return Id != null && this.idMap.containsKey(FileUtils.removeRedundantNames(Id.trim().replaceAll("\\\\", "/"), "/"));
    }

    public String addId(String Id) {
        String localId = Id;
        if (Id == null) {
            return null;
        }
        localId = Id.trim().replaceAll("\\\\", "/");
        ++this.index;
        this.idMap.put(FileUtils.removeRedundantNames(localId, "/"), "unique_" + Integer.toString(this.index));
        return "unique_" + Integer.toString(this.index);
    }

    public void addId(String Id, String Value) {
        if (Id != null && Value != null) {
            String localId = Id.trim().replaceAll("\\\\", "/");
            String localValue = Value.trim();
            this.idMap.put(FileUtils.removeRedundantNames(localId, "/"), localValue);
        }
    }

    public String getIdValue(String Id) {
        String localId = Id;
        if (Id == null) {
            return null;
        }
        localId = Id.trim().replaceAll("\\\\", "/");
        return (String)this.idMap.get(FileUtils.removeRedundantNames(localId, "/"));
    }

    public boolean isVisited(String path) {
        String localPath = path;
        int idx = path.indexOf("#");
        if (idx != -1) {
            localPath = localPath.substring(0, idx);
        }
        return this.visitSet.contains(FileUtils.removeRedundantNames(localPath.trim().replaceAll("\\\\", "/"), "/"));
    }

    public void visit(String path) {
        String localPath = path;
        int idx = path.indexOf("#");
        if (idx != -1) {
            localPath = localPath.substring(0, idx);
        }
        this.visitSet.add(FileUtils.removeRedundantNames(localPath.trim().replaceAll("\\\\", "/"), "/"));
    }

    public String getFirstTopicId(String path, String dir, boolean useCatalog) {
        String localPath = path;
        String localDir = dir;
        StringBuffer firstTopicId = new StringBuffer();
        if (path == null || dir == null) {
            return null;
        }
        localPath = localPath.trim();
        localDir = localDir.trim();
        TopicIdParser parser = new TopicIdParser(firstTopicId);
        try {
            if (System.getProperty("org.xml.sax.driver") == null) {
                StringUtils.initSaxDriver();
            }
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(parser);
            if (useCatalog) {
                try {
                    Class.forName("org.apache.xml.resolver.tools.CatalogResolver");
                    reader.setEntityResolver((EntityResolver)CatalogUtils.getCatalogResolver());
                }
                catch (ClassNotFoundException e) {
                    this.logger.logException(e);
                }
            }
            reader.parse(localDir + File.separator + localPath);
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
        return firstTopicId.toString();
    }
}

