/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Properties;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.exception.DITAOTXMLErrorHandler;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.Content;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.StringUtils;
import org.dita.dost.writer.AbstractXMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class CoderefResolver
extends AbstractXMLWriter {
    private OutputStreamWriter output = null;
    private XMLReader reader = null;
    private DITAOTJavaLogger logger = new DITAOTJavaLogger();
    private File currentFile = null;
    private HashSet<String> coderefSpec = new HashSet();

    public CoderefResolver() {
        try {
            if (System.getProperty("org.xml.sax.driver") == null) {
                StringUtils.initSaxDriver();
            }
            this.reader = XMLReaderFactory.createXMLReader();
            this.reader.setContentHandler(this);
            this.reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            this.reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    public void setContent(Content content) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String filename) throws DITAOTException {
        String file = null;
        File inputFile = null;
        File outputFile = null;
        FileOutputStream fileOutput = null;
        try {
            Properties prop;
            file = filename;
            if (file == null || !new File(file).exists()) {
                return;
            }
            this.currentFile = inputFile = new File(file);
            outputFile = new File(file + ".temp");
            fileOutput = new FileOutputStream(outputFile);
            this.output = new OutputStreamWriter((OutputStream)fileOutput, "UTF-8");
            this.reader.setErrorHandler(new DITAOTXMLErrorHandler(file));
            this.reader.parse(file);
            this.output.flush();
            this.output.close();
            if (!inputFile.delete()) {
                prop = new Properties();
                prop.put("%1", inputFile.getPath());
                prop.put("%2", outputFile.getPath());
                this.logger.logError(MessageUtils.getMessage("DOTJ009E", prop).toString());
            }
            if (!outputFile.renameTo(inputFile)) {
                prop = new Properties();
                prop.put("%1", inputFile.getPath());
                prop.put("%2", outputFile.getPath());
                this.logger.logError(MessageUtils.getMessage("DOTJ009E", prop).toString());
            }
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
        finally {
            try {
                if (fileOutput != null) {
                    fileOutput.close();
                }
            }
            catch (Exception e) {
                this.logger.logException(e);
            }
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.output.write(StringUtils.escapeXML(ch, start, length));
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        try {
            this.output.write(ch, start, length);
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        try {
            super.processingInstruction(target, data);
            String pi = data != null ? target + " " + data : target;
            this.output.write("<?" + pi + "?" + ">");
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        String classValue = atts.getValue("class");
        String hrefValue = atts.getValue("href");
        try {
            if (classValue != null && classValue.contains(" pr-d/coderef ")) {
                String codeFile;
                this.coderefSpec.add(name);
                if (hrefValue != null && new File(codeFile = FileUtils.normalizeDirectory(this.currentFile.getParentFile().getAbsolutePath(), hrefValue)).exists()) {
                    int len;
                    FileReader codeReader = new FileReader(new File(codeFile));
                    char[] buffer = new char[4096];
                    while ((len = codeReader.read(buffer)) != -1) {
                        this.output.write(StringUtils.escapeXML(buffer, 0, len));
                    }
                    codeReader.close();
                }
            } else {
                this.output.write("<" + name);
                for (int i = 0; i < atts.getLength(); ++i) {
                    this.output.write(" " + atts.getQName(i) + "=" + "\"" + atts.getValue(i) + "\"");
                }
                this.output.write(">");
            }
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        try {
            if (!this.coderefSpec.contains(name)) {
                this.output.write("</" + name + ">");
            }
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }
}

