/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.module.Content;
import org.dita.dost.writer.AbstractWriter;

public class PropertiesWriter
implements AbstractWriter {
    private Properties prop = null;

    public void setContent(Content content) {
        this.prop = (Properties)content.getValue();
    }

    public void write(String filename) throws DITAOTException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(filename);
            this.prop.store(fileOutputStream, null);
            fileOutputStream.flush();
        }
        catch (Exception e) {
            throw new DITAOTException(e);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception e) {
                    throw new DITAOTException(e);
                }
            }
        }
    }

    public void writeToXML(String filename) throws DITAOTException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(filename);
            this.prop.storeToXML(os, null);
        }
        catch (IOException ioe) {
            throw new DITAOTException(ioe);
        }
    }
}

