/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.swing;

import com.swabunga.spell.engine.SpellDictionary;
import com.swabunga.spell.engine.SpellDictionaryHashMap;
import com.swabunga.spell.swing.JTextComponentSpellChecker;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipInputStream;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JTextArea;

public class JSpellApplet
extends JApplet {
    private static final String dictionaryFile = "dict/english.0.zip";
    private SpellDictionary dictionary;
    JTextArea text = null;
    JButton spell = null;

    public void paint(Graphics graphics) {
        super.paint(graphics);
    }

    public void init() {
        super.init();
        try {
            URL uRL = null;
            ZipInputStream zipInputStream = null;
            try {
                uRL = new URL(this.getCodeBase().toExternalForm() + dictionaryFile);
                zipInputStream = new ZipInputStream(uRL.openStream());
            }
            catch (NullPointerException nullPointerException) {
                FileInputStream fileInputStream = new FileInputStream(dictionaryFile);
                zipInputStream = new ZipInputStream(fileInputStream);
            }
            zipInputStream.getNextEntry();
            this.dictionary = new SpellDictionaryHashMap(new BufferedReader(new InputStreamReader(zipInputStream)));
            this.initGUI();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void initGUI() {
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        container.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.text = new JTextArea("The quck brwn dog jmped over the fnce.");
        this.text.setLineWrap(true);
        this.text.setWrapStyleWord(true);
        this.addToFrame(container, this.text, gridBagLayout, gridBagConstraints, 0, 0, 1, 1);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 11;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        this.spell = new JButton("spell check");
        final JTextComponentSpellChecker jTextComponentSpellChecker = new JTextComponentSpellChecker(this.dictionary);
        this.spell.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = new Thread(){

                    public void run() {
                        try {
                            jTextComponentSpellChecker.spellCheck((this).JSpellApplet.this.text);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                };
                thread.start();
            }
        });
        this.addToFrame(container, this.spell, gridBagLayout, gridBagConstraints2, 1, 0, 1, 1);
    }

    private void addToFrame(Container container, Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }
}

