/*
 * Decompiled with CFR 0.152.
 */
package jaxe;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import jaxe.Balise;
import jaxe.JEFactory;
import jaxe.JaxeDocument;
import jaxe.JaxeResourceBundle;
import jaxe.Preferences;
import jaxe.elements.JECData;
import jaxe.elements.JECommentaire;
import jaxe.elements.JEInconnu;
import jaxe.elements.JEStyle;
import jaxe.elements.JESwing;
import jaxe.elements.JETableTexte;
import jaxe.elements.JETexte;
import org.apache.log4j.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JaxeElement {
    private static final Pattern COLOR_PATTERN = Pattern.compile("^.*\\[(x[0-9a-fA-F]{2}|[0-9]{1,3}),(x[0-9a-fA-F]{2}|[0-9]{1,3}),(x[0-9a-fA-F]{2}|[0-9]{1,3})\\]$");
    private static final Logger LOG = Logger.getLogger(JaxeElement.class);
    public static final String kGras = "GRAS";
    public static final String kItalique = "ITALIQUE";
    public static final String kExposant = "EXPOSANT";
    public static final String kCouleur = "PCOULEUR";
    public static final String kCouleurDeFond = "FCOULEUR";
    public static final String kIndice = "INDICE";
    public static final String kSouligne = "SOULIGNE";
    public static final String kBarre = "BARRE";
    public Position debut = null;
    public Position fin = null;
    public Node noeud;
    public Element refElement = null;
    public JaxeDocument doc;
    public ArrayList<Object> jcomps = null;
    public ArrayList<Position> compos = null;
    private boolean effacementAutorise = true;
    private boolean editionAutorisee = true;

    public abstract void init(Position var1, Node var2);

    public void creer(Position position, Node node) {
        this.noeud = node;
        this.doc.dom2JaxeElement.put(node, this);
        if (this.doc.cfg != null) {
            String string;
            HashMap<String, ArrayList<String>> hashMap;
            String string2 = node.getNodeName();
            if (node.getNodeType() == 1) {
                if (this.refElement == null) {
                    hashMap = node.getParentNode();
                    this.refElement = hashMap != null ? this.doc.cfg.getElementRef((Element)node, this.doc.getElementForNode((Node)((Object)hashMap)).refElement) : this.doc.cfg.getElementRef((Element)node, null);
                }
                string = "element";
            } else {
                string = node.getNodeType() == 7 ? "instruction" : (node.getNodeType() == 8 ? "commentaire" : (node.getNodeType() == 4 ? "cdata" : null));
            }
            if (this.refElement != null || node.getNodeType() == 7) {
                hashMap = this.doc.cfg.getParametresNoeud(this.refElement, string, string2);
                ArrayList arrayList = (ArrayList)hashMap.get("effacementAutorise");
                String string3 = arrayList != null && arrayList.size() > 0 ? (String)arrayList.get(0) : null;
                ArrayList arrayList2 = (ArrayList)hashMap.get("editionAutorisee");
                String string4 = arrayList2 != null && arrayList2.size() > 0 ? (String)arrayList2.get(0) : null;
                this.effacementAutorise = !"false".equals(string3);
                this.editionAutorisee = !"false".equals(string4);
            }
        }
        this.init(position, node);
        this.majValidite();
        if (position.getOffset() == 0 && node.getNextSibling() != null) {
            this.majPosSuivant();
        }
    }

    protected void majPosSuivant() {
        JaxeElement jaxeElement = this.doc.getElementForNode(this.noeud.getNextSibling());
        if (jaxeElement != null && jaxeElement.debut != null && jaxeElement.debut.getOffset() == 0) {
            try {
                jaxeElement.debut = this.doc.createPosition(this.fin.getOffset() + 1);
                if (jaxeElement.fin.getOffset() == 0) {
                    jaxeElement.fin = jaxeElement.debut;
                }
            }
            catch (BadLocationException badLocationException) {
                LOG.error((Object)"majPosSuivant - BadLocationException", (Throwable)badLocationException);
            }
            for (int i = 0; i < jaxeElement.compos.size(); ++i) {
                if (jaxeElement.compos.get(i).getOffset() != 0) continue;
                jaxeElement.compos.set(i, jaxeElement.debut);
            }
        }
    }

    public abstract Node nouvelElement(Element var1);

    public boolean testAffichageDialogue() {
        boolean bl;
        ArrayList<Element> arrayList = this.doc.cfg.listeAttributs(this.refElement);
        if (arrayList == null || arrayList.size() == 0) {
            return false;
        }
        Properties properties = Preferences.getPref();
        boolean bl2 = bl = properties != null && "true".equals(properties.getProperty("toujoursAfficherAttributs"));
        if (bl) {
            return true;
        }
        for (Element element : arrayList) {
            if (!this.doc.cfg.attributObligatoire(this.refElement, element)) continue;
            return true;
        }
        return false;
    }

    public void afficherDialogue(JFrame jFrame) {
    }

    public void majAffichage() {
    }

    public void majValidite() {
    }

    public ArrayList<Object> getComponents() {
        if (this.jcomps == null) {
            return new ArrayList<Object>();
        }
        return this.jcomps;
    }

    public ArrayList<Position> getComponentPositions() {
        if (this.compos == null) {
            return new ArrayList<Position>();
        }
        return this.compos;
    }

    public Position insertText(Position position, String string, AttributeSet attributeSet) {
        try {
            int n = position.getOffset();
            this.doc.insertString(position.getOffset(), string, attributeSet);
            if (this.debut == null) {
                this.debut = this.doc.createPosition(n);
            }
            if (position.getOffset() == 0) {
                position = this.doc.createPosition(1);
            }
            this.fin = this.doc.createPosition(position.getOffset() - 1);
        }
        catch (BadLocationException badLocationException) {
            LOG.error((Object)("insertText(Position, String, AttributeSet) - BadLocationException: " + badLocationException.getMessage()), (Throwable)badLocationException);
        }
        return position;
    }

    public Position insertText(Position position, String string) {
        Node node;
        SimpleAttributeSet simpleAttributeSet = null;
        JaxeElement jaxeElement = this.debut == null ? ((node = this.noeud.getParentNode()) != null ? this.doc.getElementForNode(node) : null) : this;
        if (jaxeElement != null) {
            if (jaxeElement.debut.getOffset() == position.getOffset() && !(jaxeElement instanceof JESwing)) {
                jaxeElement = jaxeElement.getParent();
            }
            if (jaxeElement != null) {
                simpleAttributeSet = jaxeElement.attStyle(null);
            }
        }
        return this.insertText(position, string, simpleAttributeSet);
    }

    public Position insertComponent(Position position, JComponent jComponent) {
        int n = position.getOffset();
        Style style = this.doc.addStyle(null, null);
        StyleConstants.setComponent(style, jComponent);
        try {
            this.doc.insertString(position.getOffset(), "*", style, false);
            if (this.jcomps == null) {
                this.jcomps = new ArrayList(2);
            }
            this.jcomps.add(jComponent);
            if (this.compos == null) {
                this.compos = new ArrayList(2);
            }
            this.compos.add(this.doc.createPosition(position.getOffset() - 1));
            if (this.debut == null) {
                this.debut = this.doc.createPosition(n);
            }
            this.fin = this.doc.createPosition(n);
            if (position.getOffset() == 0) {
                position = this.doc.createPosition(1);
            }
        }
        catch (BadLocationException badLocationException) {
            LOG.error((Object)("insertComponent(Position, JComponent) - BadLocationException: " + badLocationException.getMessage()), (Throwable)badLocationException);
        }
        return position;
    }

    public Position insertIcon(Position position, Icon icon) {
        int n = position.getOffset();
        Style style = this.doc.addStyle(null, null);
        StyleConstants.setIcon(style, icon);
        try {
            this.doc.insertString(position.getOffset(), "*", style, false);
            if (this.jcomps == null) {
                this.jcomps = new ArrayList(2);
            }
            this.jcomps.add(icon);
            if (this.compos == null) {
                this.compos = new ArrayList(2);
            }
            this.compos.add(this.doc.createPosition(position.getOffset() - 1));
            if (this.debut == null) {
                this.debut = this.doc.createPosition(n);
            }
            this.fin = this.doc.createPosition(n);
            if (position.getOffset() == 0) {
                position = this.doc.createPosition(1);
            }
        }
        catch (BadLocationException badLocationException) {
            LOG.error((Object)("insertIcon(Position, Icon) - BadLocationException: " + badLocationException.getMessage()), (Throwable)badLocationException);
        }
        return position;
    }

    public JaxeElement elementA(int n) {
        if (this.debut == null || this.fin == null) {
            return null;
        }
        if (this.debut.getOffset() > n || this.fin.getOffset() < n) {
            return null;
        }
        for (Node node = this.noeud.getFirstChild(); node != null; node = node.getNextSibling()) {
            JaxeElement jaxeElement;
            JaxeElement jaxeElement2;
            short s = node.getNodeType();
            if (s != 1 && s != 3 && s != 7 && s != 8 && s != 4 || (jaxeElement2 = this.doc.getElementForNode(node)) == null || (jaxeElement = jaxeElement2.elementA(n)) == null) continue;
            return jaxeElement;
        }
        return this;
    }

    public ArrayList<JaxeElement> elementsDans(int n, int n2) {
        ArrayList<JaxeElement> arrayList = new ArrayList<JaxeElement>();
        if (this.debut == null || this.fin == null) {
            return arrayList;
        }
        if (this.debut.getOffset() > n2 || this.fin.getOffset() < n) {
            return arrayList;
        }
        if (this.debut.getOffset() >= n && (this.fin.getOffset() <= n2 || this instanceof JESwing && this.fin.getOffset() == n2 + 1)) {
            arrayList.add(this);
        } else {
            for (Node node = this.noeud.getFirstChild(); node != null; node = node.getNextSibling()) {
                JaxeElement jaxeElement;
                short s = node.getNodeType();
                if (s != 1 && s != 3 && s != 7 && s != 8 && s != 4 || (jaxeElement = this.doc.getElementForNode(node)) == null) continue;
                arrayList.addAll(jaxeElement.elementsDans(n, n2));
            }
        }
        return arrayList;
    }

    public int nombreXPath() {
        JaxeElement jaxeElement = this.getParent();
        if (jaxeElement == null) {
            return 0;
        }
        int n = 0;
        String string = this.noeud.getNodeName();
        for (Node node = jaxeElement.noeud.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (string.equals(node.getNodeName())) {
                ++n;
            }
            if (node == this.noeud) break;
        }
        return n;
    }

    public String cheminA(int n) {
        if (this.debut == null || this.fin == null) {
            return null;
        }
        if (this.debut.getOffset() > n || this.fin.getOffset() < n) {
            return null;
        }
        switch (this.noeud.getNodeType()) {
            case 3: {
                return "texte";
            }
            case 8: {
                return "commentaire";
            }
            case 4: {
                return "cdata";
            }
            case 7: {
                return "instruction";
            }
        }
        if (this.noeud.getNodeType() != 1) {
            return null;
        }
        Element element = (Element)this.noeud;
        StringBuilder stringBuilder = new StringBuilder(element.getTagName());
        if (this.getParent() != null) {
            stringBuilder.append("[");
            stringBuilder.append(this.nombreXPath());
            stringBuilder.append("]");
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            String string;
            JaxeElement jaxeElement;
            short s = node.getNodeType();
            if (s != 1 && s != 3 && s != 7 && s != 8 && s != 4 || (jaxeElement = this.doc.getElementForNode(node)) == null || (string = jaxeElement.cheminA(n)) == null) continue;
            return stringBuilder.append("/").append(string).toString();
        }
        return stringBuilder.toString();
    }

    public JaxeElement enfantApres(int n) {
        if (this.debut == null || this.fin == null) {
            return null;
        }
        if (this.debut.getOffset() > n || this.fin.getOffset() < n) {
            return null;
        }
        for (Node node = this.noeud.getFirstChild(); node != null; node = node.getNextSibling()) {
            JaxeElement jaxeElement;
            short s = node.getNodeType();
            if (s != 1 && s != 3 && s != 7 && s != 8 && s != 4 || (jaxeElement = this.doc.getElementForNode(node)) == null) continue;
            if (jaxeElement.debut.getOffset() == n) {
                return jaxeElement;
            }
            JaxeElement jaxeElement2 = jaxeElement.elementA(n);
            if (jaxeElement2 == null || node.getNextSibling() == null) continue;
            return this.doc.getElementForNode(node.getNextSibling());
        }
        return null;
    }

    public void effacer() {
        Object object;
        for (Object object2 = this.noeud.getFirstChild(); object2 != null; object2 = object2.getNextSibling()) {
            short s = object2.getNodeType();
            if (s != 1 && s != 3 && s != 7 && s != 8 && s != 4 || (object = this.doc.getElementForNode((Node)object2)) == null) continue;
            ((JaxeElement)object).effacer();
        }
        if (this.jcomps != null) {
            for (Object e : this.jcomps) {
                if (!(e instanceof JComponent) || ((JComponent)e).getParent() == null) continue;
                object = (JComponent)e;
                ((Component)object).getParent().remove((Component)object);
            }
            this.jcomps = null;
        }
        this.compos = null;
    }

    public void mettreAJourDOM() {
        if (this.debut == null || this.fin == null) {
            return;
        }
        try {
            if (this instanceof JECommentaire || this instanceof JECData) {
                String string = this.doc.getText(this.debut.getOffset() + 1, this.fin.getOffset() - this.debut.getOffset() - 1);
                this.noeud.setNodeValue(string);
            } else if (this instanceof JETexte) {
                Object object;
                Node node = this.noeud.getNextSibling();
                if (node != null && (object = this.doc.getElementForNode(node)) != null && ((JaxeElement)object).debut.getOffset() > this.fin.getOffset() + 1) {
                    this.fin = this.doc.createPosition(((JaxeElement)object).debut.getOffset() - 1);
                }
                if ((object = this.doc.getText(this.debut.getOffset(), this.fin.getOffset() - this.debut.getOffset() + 1)) == null || "".equals(object)) {
                    this.getParent().supprimerEnfant(this);
                } else {
                    this.noeud.setNodeValue((String)object);
                }
            } else {
                JaxeElement jaxeElement;
                Object object;
                Object object2;
                int n = this.debut.getOffset();
                int n2 = this instanceof JESwing || this instanceof JEStyle ? n : n + 1;
                for (object2 = this.noeud.getFirstChild(); object2 != null; object2 = object2.getNextSibling()) {
                    object = this.doc.getElementForNode((Node)object2);
                    if (object == null) continue;
                    if (n2 < ((JaxeElement)object).debut.getOffset()) {
                        jaxeElement = null;
                        if (object2.getPreviousSibling() != null) {
                            jaxeElement = this.doc.getElementForNode(object2.getPreviousSibling());
                        }
                        if (jaxeElement != null && (jaxeElement instanceof JEStyle || jaxeElement instanceof JETexte)) {
                            jaxeElement.fin = this.doc.createPosition(((JaxeElement)object).debut.getOffset() - 1);
                        } else if (object instanceof JETexte) {
                            ((JaxeElement)object).debut = this.doc.createPosition(n2);
                        } else {
                            String string = this.doc.getText(n2, ((JaxeElement)object).debut.getOffset() - n2);
                            JETexte jETexte = JETexte.nouveau(this.doc, this.doc.createPosition(n2), this.doc.createPosition(((JaxeElement)object).debut.getOffset() - 1), string);
                            this.noeud.insertBefore(jETexte.noeud, (Node)object2);
                        }
                    }
                    n = ((JaxeElement)object).fin.getOffset();
                    n2 = n + 1;
                }
                if (n2 < this.fin.getOffset() || this instanceof JEStyle && n2 == this.fin.getOffset()) {
                    object2 = null;
                    if (this.noeud.getLastChild() != null) {
                        object2 = this.doc.getElementForNode(this.noeud.getLastChild());
                    }
                    if (object2 instanceof JEStyle || object2 instanceof JETexte) {
                        ((JaxeElement)object2).fin = this instanceof JEStyle ? this.doc.createPosition(this.fin.getOffset()) : this.doc.createPosition(this.fin.getOffset() - 1);
                    } else {
                        object = this.doc.getText(n2, this.fin.getOffset() - n2);
                        jaxeElement = JETexte.nouveau(this.doc, this.doc.createPosition(n2), this.doc.createPosition(this.fin.getOffset() - 1), (String)object);
                        this.noeud.appendChild(((JETexte)jaxeElement).noeud);
                    }
                }
                for (object2 = this.noeud.getFirstChild(); object2 != null; object2 = object2.getNextSibling()) {
                    object = this.doc.getElementForNode((Node)object2);
                    if (object == null) continue;
                    ((JaxeElement)object).mettreAJourDOM();
                }
            }
        }
        catch (BadLocationException badLocationException) {
            LOG.error((Object)("mettreAJourDOM()" + badLocationException.getMessage()), (Throwable)badLocationException);
        }
    }

    public static Element nouvelElementDOM(JaxeDocument jaxeDocument, Element element) {
        Element element2;
        String string = jaxeDocument.cfg.nomElement(element);
        String string2 = jaxeDocument.cfg.espaceElement(element);
        if (string2 == null) {
            element2 = jaxeDocument.DOMdoc.createElementNS(null, string);
        } else {
            String string3 = jaxeDocument.DOMdoc.getDocumentElement() != null ? jaxeDocument.DOMdoc.lookupPrefix(string2) : null;
            if (string3 == null) {
                string3 = jaxeDocument.cfg.prefixeElement(element);
            }
            if (string3 != null) {
                string = string3 + ":" + string;
            }
            element2 = jaxeDocument.DOMdoc.createElementNS(string2, string);
        }
        return element2;
    }

    public static ProcessingInstruction nouvelleInstructionDOM(JaxeDocument jaxeDocument, String string) {
        ProcessingInstruction processingInstruction = jaxeDocument.DOMdoc.createProcessingInstruction(string, "");
        return processingInstruction;
    }

    public static Element nouvelElementDOM(JaxeDocument jaxeDocument, String string, Element element) {
        String string2 = element.getNamespaceURI();
        String string3 = element.getPrefix();
        String string4 = string3 != null ? string3 + ':' + string : string;
        return jaxeDocument.DOMdoc.createElementNS(string2, string4);
    }

    public void inserer(Position position, Node node) {
        this.doc.textPane.debutIgnorerEdition();
        this.insererDOM(position, node);
        this.creer(position, node);
        this.doc.textPane.finIgnorerEdition();
        JaxeElement jaxeElement = this.getParent();
        while (jaxeElement instanceof JESwing && jaxeElement.debut.getOffset() > this.debut.getOffset()) {
            jaxeElement.debut = this.debut;
            jaxeElement = jaxeElement.getParent();
        }
    }

    public void insererDOM(Position position, Node node) {
        JaxeElement.insererDOM(this.doc, position, node);
    }

    public static void insererDOM(JaxeDocument jaxeDocument, Position position, Node node) {
        JaxeElement jaxeElement = jaxeDocument.elementA(position.getOffset());
        if (jaxeElement != null && jaxeElement.debut.getOffset() == position.getOffset() && !(jaxeElement instanceof JESwing)) {
            jaxeElement = jaxeElement.getParent();
        }
        if (jaxeElement instanceof JETexte || jaxeElement instanceof JEStyle) {
            while (jaxeElement.getParent() instanceof JEStyle) {
                jaxeElement = jaxeElement.getParent();
            }
            if (position.getOffset() > jaxeElement.debut.getOffset()) {
                JaxeElement jaxeElement2 = jaxeElement.couper(position);
                Node node2 = jaxeElement.noeud.getParentNode();
                node2.insertBefore(node, jaxeElement2.noeud);
            } else {
                Node node3 = jaxeElement.noeud.getParentNode();
                node3.insertBefore(node, jaxeElement.noeud);
            }
        } else if (jaxeElement != null) {
            JaxeElement jaxeElement3 = jaxeElement.enfantApres(position.getOffset());
            if (jaxeElement3 == null) {
                jaxeElement.noeud.appendChild(node);
            } else {
                jaxeElement.noeud.insertBefore(node, jaxeElement3.noeud);
            }
        } else {
            JaxeElement jaxeElement4 = null;
            for (Node node4 = jaxeDocument.DOMdoc.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
                JaxeElement jaxeElement5;
                short s = node4.getNodeType();
                if (s != 1 && s != 7 && s != 8 || (jaxeElement5 = jaxeDocument.getElementForNode(node4)) == null) continue;
                if (jaxeElement5.debut.getOffset() == position.getOffset()) {
                    jaxeElement4 = jaxeElement5;
                    break;
                }
                if (jaxeElement5.fin.getOffset() < position.getOffset()) continue;
                if (node4.getNextSibling() == null) break;
                jaxeElement4 = jaxeDocument.getElementForNode(node4.getNextSibling());
                break;
            }
            if (jaxeElement4 == null) {
                jaxeDocument.DOMdoc.appendChild(node);
            } else {
                jaxeDocument.DOMdoc.insertBefore(node, jaxeElement4.noeud);
            }
        }
    }

    public void creerEnfants(Position position) {
        Element element = (Element)this.noeud;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            node = this.creerEnfant(position, node);
        }
    }

    public Node creerEnfant(Position position, Node node) {
        Object object;
        int n = position.getOffset();
        if (node.getNodeType() == 1 || node.getNodeType() == 7 || node.getNodeType() == 8 || node.getNodeType() == 4) {
            Object object2;
            object = null;
            String string = null;
            if (node.getNodeType() == 1) {
                if (this.doc.cfg != null) {
                    object2 = node.getParentNode();
                    object = object2 != null ? this.doc.cfg.getElementRef((Element)node, this.doc.getElementForNode((Node)object2).refElement) : this.doc.cfg.getElementRef((Element)node, null);
                }
                if (object != null) {
                    string = this.doc.cfg.typeAffichageElement((Element)object);
                }
            }
            if (node.getNodeType() == 1 && object == null) {
                object2 = new JEInconnu(this.doc);
                ((JaxeElement)object2).creer(position, node);
            } else if (node.getNodeType() == 7 || node.getNodeType() == 8 || node.getNodeType() == 4 || !"style".equals(string) || this.hasText(node) || JaxeElement.hasProcessing(node)) {
                Object object3;
                Object object4;
                if (node.getNodeType() == 7) {
                    object2 = "instruction";
                } else if (node.getNodeType() == 8) {
                    object2 = "commentaire";
                } else if (node.getNodeType() == 4) {
                    object2 = "cdata";
                } else if (string.equals("style") && JaxeElement.hasProcessing(node)) {
                    object4 = node.getPreviousSibling();
                    object3 = node.getParentNode();
                    ProcessingInstruction processingInstruction = JaxeElement.getProcessing(node);
                    node.getParentNode().replaceChild(processingInstruction, node);
                    node = object4 == null ? object3.getFirstChild() : object4.getNextSibling();
                    object = null;
                    object2 = "instruction";
                } else {
                    object2 = "element";
                }
                object3 = this.doc.getElementForNode(node);
                if (object3 != null) {
                    object4 = object3;
                    ((JaxeElement)object4).debut = null;
                    ((JaxeElement)object4).fin = null;
                    ((JaxeElement)object4).jcomps = null;
                    ((JaxeElement)object4).compos = null;
                } else {
                    object4 = JEFactory.createJE(this.doc, (Element)object, node.getNodeName(), (String)object2, node);
                }
                ((JaxeElement)object4).creer(position, node);
            }
        } else if (node.getNodeType() == 3) {
            object = new JETexte(this.doc);
            ((JaxeElement)object).creer(position, node);
        }
        try {
            if (this.debut == null) {
                this.debut = this.doc.createPosition(n);
            }
            if (position.getOffset() == 0) {
                position = this.doc.createPosition(1);
            }
            this.fin = this.doc.createPosition(position.getOffset() - 1);
        }
        catch (BadLocationException badLocationException) {
            LOG.error((Object)("creerEnfant(Position, Node) - BadLocationException: " + badLocationException.getMessage()), (Throwable)badLocationException);
        }
        return node;
    }

    public void setFocus() {
        this.doc.textPane.requestFocus();
    }

    public Position insPosition() {
        try {
            Position position = this.doc.createPosition(this.fin.getOffset() + 1);
            return position;
        }
        catch (BadLocationException badLocationException) {
            LOG.error((Object)("insPosition() - BadLocationException: " + badLocationException.getMessage()), (Throwable)badLocationException);
            return this.debut;
        }
    }

    public boolean hasText(Node node) {
        boolean bl = false;
        Node node2 = node.getFirstChild();
        if (node2 != null) {
            bl = node2.getNodeType() == 3 ? true : this.hasText(node2);
        }
        return bl;
    }

    public static boolean hasProcessing(Node node) {
        boolean bl = false;
        Node node2 = node.getFirstChild();
        if (node2 != null) {
            bl = node2.getNodeType() == 7 ? true : JaxeElement.hasProcessing(node2);
        }
        return bl;
    }

    public static ProcessingInstruction getProcessing(Node node) {
        ProcessingInstruction processingInstruction = null;
        Node node2 = node.getFirstChild();
        if (node2 != null) {
            processingInstruction = node2.getNodeType() == 7 ? (ProcessingInstruction)node2 : JaxeElement.getProcessing(node2);
        }
        return processingInstruction;
    }

    public JaxeElement getParent() {
        Node node = this.noeud.getParentNode();
        if (node == null) {
            return null;
        }
        return this.doc.getElementForNode(node);
    }

    public JaxeElement getFirstChild() {
        Node node = this.noeud.getFirstChild();
        if (node == null) {
            return null;
        }
        return this.doc.getElementForNode(node);
    }

    public JaxeElement getNextSibling() {
        Node node = this.noeud.getNextSibling();
        if (node == null) {
            return null;
        }
        return this.doc.getElementForNode(node);
    }

    public void supprimerEnfant(JaxeElement jaxeElement) {
        this.supprimerEnfantDOM(jaxeElement);
        try {
            int n = jaxeElement.fin.getOffset() - jaxeElement.debut.getOffset() + 1;
            int n2 = jaxeElement.debut.getOffset();
            this.doc.remove(n2, n, false);
        }
        catch (BadLocationException badLocationException) {
            LOG.error((Object)"supprimerEnfant() - BadLocationException", (Throwable)badLocationException);
        }
    }

    public void supprimerEnfantDOM(JaxeElement jaxeElement) {
        try {
            this.noeud.removeChild(jaxeElement.noeud);
        }
        catch (DOMException dOMException) {
            LOG.error((Object)"supprimerEnfantDOM() - DOMException", (Throwable)dOMException);
        }
    }

    public void remplacerEnfant(JaxeElement jaxeElement, JaxeElement jaxeElement2) {
        try {
            this.doc.remove(jaxeElement.debut.getOffset(), jaxeElement.fin.getOffset() - jaxeElement.debut.getOffset() + 1);
        }
        catch (BadLocationException badLocationException) {
            LOG.error((Object)"remplacerEnfant() - BadLocationException", (Throwable)badLocationException);
        }
        jaxeElement2.creer(jaxeElement2.debut, jaxeElement2.noeud);
        this.remplacerEnfantDOM(jaxeElement, jaxeElement2);
    }

    public void remplacerEnfantDOM(JaxeElement jaxeElement, JaxeElement jaxeElement2) {
        Node node = jaxeElement.noeud.getParentNode();
        if (node == null) {
            LOG.error((Object)"remplacerEnfantDOM(JaxeElement, JaxeElement) - remplacerEnfantDOM: parent null !", null);
        }
        try {
            node.replaceChild(jaxeElement2.noeud, jaxeElement.noeud);
        }
        catch (DOMException dOMException) {
            LOG.error((Object)("remplacerEnfantDOM(JaxeElement, JaxeElement) - DOMException: " + dOMException.getMessage()), (Throwable)dOMException);
        }
    }

    public boolean avecIndentation() {
        return false;
    }

    public boolean avecSautsDeLigne() {
        return false;
    }

    public int indentations() {
        JaxeElement jaxeElement;
        JaxeElement jaxeElement2 = this.getParent();
        if (jaxeElement2 != null && (jaxeElement = jaxeElement2.getParent()) != null && (jaxeElement = jaxeElement.getParent()) instanceof JETableTexte) {
            return 0;
        }
        if (jaxeElement2 == null) {
            return 0;
        }
        if (this.avecIndentation()) {
            return jaxeElement2.indentations() + 1;
        }
        return jaxeElement2.indentations();
    }

    public JaxeElement couper(Position position) {
        return null;
    }

    public void fusionner(JaxeElement jaxeElement) {
        if (!(this instanceof JETexte) || !(jaxeElement instanceof JETexte)) {
            return;
        }
        if (this.noeud.getNextSibling() == jaxeElement.noeud) {
            String string = jaxeElement.noeud.getNodeValue();
            this.noeud.setNodeValue(this.noeud.getNodeValue() + string);
            this.fin = jaxeElement.fin;
            jaxeElement.getParent().supprimerEnfantDOM(jaxeElement);
        } else if (jaxeElement.noeud.getNextSibling() == this.noeud) {
            String string = jaxeElement.noeud.getNodeValue();
            this.noeud.setNodeValue(string + this.noeud.getNodeValue());
            this.debut = jaxeElement.debut;
            jaxeElement.getParent().supprimerEnfantDOM(jaxeElement);
        }
    }

    public void regrouperTextes() {
        for (Node node = this.noeud.getFirstChild(); node != null; node = node.getNextSibling()) {
            JaxeElement jaxeElement = this.doc.getElementForNode(node);
            JaxeElement jaxeElement2 = this.doc.getElementForNode(node.getNextSibling());
            while (jaxeElement2 != null && (jaxeElement instanceof JETexte && jaxeElement2 instanceof JETexte || jaxeElement instanceof JEStyle && jaxeElement2 instanceof JEStyle && ((JEStyle)jaxeElement).memeStyle((JEStyle)jaxeElement2))) {
                jaxeElement.fusionner(jaxeElement2);
                jaxeElement2 = jaxeElement.getNextSibling();
            }
        }
    }

    public void setEffacementAutorise(boolean bl) {
        this.effacementAutorise = bl;
    }

    public boolean getEffacementAutorise() {
        return this.effacementAutorise;
    }

    public void setEditionAutorisee(boolean bl) {
        this.editionAutorisee = bl;
    }

    public boolean getEditionAutorisee() {
        return this.editionAutorisee;
    }

    public void selection(boolean bl) {
        Object object;
        Object object2;
        if (this.jcomps != null) {
            object2 = this.jcomps.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                if (!(object instanceof Balise)) continue;
                ((Balise)object).selection(bl);
            }
        }
        for (object2 = this.noeud.getFirstChild(); object2 != null; object2 = object2.getNextSibling()) {
            object = this.doc.getElementForNode((Node)object2);
            if (object == null) continue;
            ((JaxeElement)object).selection(bl);
        }
    }

    public boolean aDesAttributs() {
        if (this.noeud.getNodeType() != 1) {
            return false;
        }
        Element element = (Element)this.noeud;
        if (this.doc.cfg == null) {
            return true;
        }
        if (this.refElement == null) {
            return true;
        }
        ArrayList<Element> arrayList = this.doc.cfg.listeAttributs(this.refElement);
        return arrayList != null && arrayList.size() > 0;
    }

    public Point getPointEnfant(Element element) {
        return null;
    }

    protected static String getString(String string) {
        return JaxeResourceBundle.getRB().getString(string);
    }

    public void changerStyle(String string, int n, int n2) {
        if (string != null) {
            String[] stringArray = string.split(";");
            Style style = this.doc.addStyle(null, null);
            for (String string2 : stringArray) {
                if (string2.indexOf(kExposant) > -1) {
                    StyleConstants.setSuperscript(style, true);
                }
                if (string2.indexOf(kIndice) > -1) {
                    StyleConstants.setSubscript(style, true);
                }
                if (string2.indexOf(kCouleur) > -1) {
                    StyleConstants.setForeground(style, JaxeElement.obtenezCouleur(string2, Color.red));
                }
                if (string2.indexOf(kCouleurDeFond) > -1) {
                    StyleConstants.setBackground(style, JaxeElement.obtenezCouleur(string2, Color.green));
                }
                if (string2.indexOf(kItalique) > -1) {
                    StyleConstants.setItalic(style, true);
                }
                if (string2.indexOf(kGras) > -1) {
                    StyleConstants.setBold(style, true);
                }
                if (string2.indexOf(kSouligne) > -1) {
                    StyleConstants.setUnderline(style, true);
                }
                if (string2.indexOf(kBarre) > -1) {
                    StyleConstants.setStrikeThrough(style, true);
                }
                if (string2.equals("")) continue;
                this.doc.setCharacterAttributes(n, n2, style, false);
            }
        }
    }

    private static Color obtenezCouleur(String string, Color color) {
        Matcher matcher = COLOR_PATTERN.matcher(string);
        if (matcher.matches()) {
            boolean bl = false;
            int[] nArray = new int[3];
            for (int i = 0; i < 3; ++i) {
                String string2 = matcher.group(i + 1);
                try {
                    if (string2.startsWith("x")) {
                        nArray[i] = Integer.parseInt(string2.substring(1), 16);
                        continue;
                    }
                    nArray[i] = Integer.parseInt(string2);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    nArray[i] = 0;
                    bl = true;
                }
            }
            Color color2 = new Color(nArray[0], nArray[1], nArray[2]);
            if (!color2.equals(Color.black) || !bl) {
                color = color2;
            }
        }
        return color;
    }

    public SimpleAttributeSet attStyle(SimpleAttributeSet simpleAttributeSet) {
        Object object;
        SimpleAttributeSet simpleAttributeSet2 = simpleAttributeSet;
        JaxeElement jaxeElement = this.noeud.getNodeType() != 1 ? this.getParent() : this;
        Element element = jaxeElement.refElement;
        if (element == null) {
            return simpleAttributeSet2;
        }
        String string = this.doc.cfg.valeurParametreElement(element, "style", null);
        if (this instanceof JEStyle) {
            string = ((JEStyle)this).ceStyle;
        }
        if (string != null) {
            if (simpleAttributeSet2 == null) {
                simpleAttributeSet2 = new SimpleAttributeSet();
            }
            object = string.split(";");
            for (String string2 : object) {
                if (string2.indexOf(kExposant) > -1) {
                    StyleConstants.setSuperscript(simpleAttributeSet2, true);
                }
                if (string2.indexOf(kIndice) > -1) {
                    StyleConstants.setSubscript(simpleAttributeSet2, true);
                }
                if (string2.indexOf(kCouleur) > -1) {
                    StyleConstants.setForeground(simpleAttributeSet2, JaxeElement.obtenezCouleur(string2, Color.red));
                }
                if (string2.indexOf(kCouleurDeFond) > -1) {
                    StyleConstants.setBackground(simpleAttributeSet2, JaxeElement.obtenezCouleur(string2, Color.green));
                }
                if (string2.indexOf(kItalique) > -1) {
                    StyleConstants.setItalic(simpleAttributeSet2, true);
                }
                if (string2.indexOf(kGras) > -1) {
                    StyleConstants.setBold(simpleAttributeSet2, true);
                }
                if (string2.indexOf(kSouligne) > -1) {
                    StyleConstants.setUnderline(simpleAttributeSet2, true);
                }
                if (string2.indexOf(kBarre) <= -1) continue;
                StyleConstants.setStrikeThrough(simpleAttributeSet2, true);
            }
        }
        if (!(simpleAttributeSet2 != null && simpleAttributeSet2.isDefined(StyleConstants.FontFamily) || (object = this.doc.cfg.valeurParametreElement(element, "police", null)) == null)) {
            if (simpleAttributeSet2 == null) {
                simpleAttributeSet2 = new SimpleAttributeSet();
            }
            StyleConstants.setFontFamily(simpleAttributeSet2, (String)object);
        }
        if (!(simpleAttributeSet2 != null && simpleAttributeSet2.isDefined(StyleConstants.FontSize) || (object = this.doc.cfg.valeurParametreElement(element, "taille", null)) == null)) {
            try {
                int n = Integer.parseInt((String)object);
                if (simpleAttributeSet2 == null) {
                    simpleAttributeSet2 = new SimpleAttributeSet();
                }
                StyleConstants.setFontSize(simpleAttributeSet2, n);
            }
            catch (NumberFormatException numberFormatException) {
                LOG.error((Object)("attStyle(SimpleAttributeSet) - " + numberFormatException.getClass().getName() + ": " + numberFormatException.getMessage()), (Throwable)numberFormatException);
            }
        }
        if ((object = this.getParent()) != null) {
            return ((JaxeElement)object).attStyle(simpleAttributeSet2);
        }
        return simpleAttributeSet2;
    }

    public String toString() {
        String string = "Element: " + this.getClass().getName();
        string = string + "  noeud: ";
        string = this.noeud == null ? string + "null" : string + this.noeud.getNodeName();
        string = string + "  debut: ";
        string = this.debut == null ? string + "null" : string + this.debut.getOffset();
        string = string + "  fin: ";
        string = this.fin == null ? string + "null" : string + this.fin.getOffset();
        return string;
    }
}

