/*
 * Decompiled with CFR 0.152.
 */
package jaxe.equations;

import jaxe.equations.element.MathElement;
import jaxe.equations.element.MathFrac;
import jaxe.equations.element.MathIdentifier;
import jaxe.equations.element.MathNumber;
import jaxe.equations.element.MathOperator;
import jaxe.equations.element.MathOver;
import jaxe.equations.element.MathPhantom;
import jaxe.equations.element.MathRoot;
import jaxe.equations.element.MathRootElement;
import jaxe.equations.element.MathRow;
import jaxe.equations.element.MathSqrt;
import jaxe.equations.element.MathSub;
import jaxe.equations.element.MathSubSup;
import jaxe.equations.element.MathSup;
import jaxe.equations.element.MathTable;
import jaxe.equations.element.MathTableRow;
import jaxe.equations.element.MathText;
import jaxe.equations.element.MathUnder;
import jaxe.equations.element.MathUnderOver;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMMathBuilder {
    private static final Logger LOG = Logger.getLogger(DOMMathBuilder.class);
    private final MathRootElement rootElement;

    public DOMMathBuilder(Document document) {
        Element element = document.getDocumentElement();
        this.rootElement = new MathRootElement();
        NamedNodeMap namedNodeMap = element.getAttributes();
        this.rootElement.setMode(this.getAttribute(namedNodeMap, "mode", "DISPLAY").equals("DISPLAY") ? 1 : 0);
        this.traverse(element, this.rootElement);
    }

    public MathRootElement getMathRootElement() {
        return this.rootElement;
    }

    private String getAttribute(NamedNodeMap namedNodeMap, String string, String string2) {
        Node node = namedNodeMap.getNamedItem(string);
        if (node != null) {
            return node.getNodeValue();
        }
        return string2;
    }

    private int getInteger(NamedNodeMap namedNodeMap, String string, String string2) {
        Node node = namedNodeMap.getNamedItem(string);
        if (node != null) {
            return new Integer(node.getNodeValue());
        }
        return new Integer(string2);
    }

    private boolean getBoolean(NamedNodeMap namedNodeMap, String string, String string2) {
        Node node = namedNodeMap.getNamedItem(string);
        if (node != null) {
            return "true".equals(node.getNodeValue());
        }
        return "true".equals(string2);
    }

    private void traverse(Node node, MathElement mathElement) {
        MathElement mathElement2;
        if (node.getNodeType() != 1) {
            return;
        }
        String string = node.getNodeName();
        int n = -1;
        n = string.indexOf(":");
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (string.equals("mfrac")) {
            mathElement2 = new MathFrac();
            mathElement2.setLineThickness(this.getInteger(namedNodeMap, "linethickness", "1"));
        } else if (string.equals("msup")) {
            mathElement2 = new MathSup();
        } else if (string.equals("msub")) {
            mathElement2 = new MathSub();
        } else if (string.equals("msubsup")) {
            mathElement2 = new MathSubSup();
        } else if (string.equals("munder")) {
            mathElement2 = new MathUnder();
        } else if (string.equals("mover")) {
            mathElement2 = new MathOver();
        } else if (string.equals("munderover")) {
            mathElement2 = new MathUnderOver();
        } else if (string.equals("msqrt")) {
            mathElement2 = new MathSqrt();
        } else if (string.equals("mroot")) {
            mathElement2 = new MathRoot();
        } else if (string.equals("mtable")) {
            mathElement2 = new MathTable();
        } else if (string.equals("mtr")) {
            mathElement2 = new MathTableRow();
        } else if (string.equals("mtd")) {
            mathElement2 = new MathElement();
        } else if (string.equals("mphantom")) {
            mathElement2 = new MathPhantom();
        } else if (string.equals("mo")) {
            mathElement2 = new MathOperator();
            ((MathOperator)mathElement2).setStretchy(this.getBoolean(namedNodeMap, "stretchy", "true"));
        } else {
            mathElement2 = string.equals("mi") ? new MathIdentifier() : (string.equals("mn") ? new MathNumber() : (string.equals("mtext") ? new MathText() : new MathRow()));
        }
        mathElement.addMathElement(mathElement2);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() == 1) {
                this.traverse(nodeList.item(i), mathElement2);
                continue;
            }
            if (nodeList.item(i).getNodeType() != 3) continue;
            mathElement2.addText(nodeList.item(i).getNodeValue());
        }
    }
}

