/*
 * Decompiled with CFR 0.152.
 */
package jaxe.equations;

import java.util.Vector;
import java.util.regex.PatternSyntaxException;
import jaxe.equations.element.MathElement;
import jaxe.equations.element.MathFrac;
import jaxe.equations.element.MathIdentifier;
import jaxe.equations.element.MathNumber;
import jaxe.equations.element.MathOperator;
import jaxe.equations.element.MathOver;
import jaxe.equations.element.MathRoot;
import jaxe.equations.element.MathRootElement;
import jaxe.equations.element.MathRow;
import jaxe.equations.element.MathSqrt;
import jaxe.equations.element.MathSub;
import jaxe.equations.element.MathSubSup;
import jaxe.equations.element.MathSup;
import jaxe.equations.element.MathTable;
import jaxe.equations.element.MathTableData;
import jaxe.equations.element.MathTableRow;
import jaxe.equations.element.MathText;
import jaxe.equations.element.MathUnder;
import jaxe.equations.element.MathUnderOver;
import org.apache.log4j.Logger;

public class StringMathBuilder {
    private static final Logger LOG = Logger.getLogger(StringMathBuilder.class);
    private final MathRootElement rootElement = new MathRootElement();
    private static final String[][] special = new String[][]{{"<==", "\u21d0"}, {"==>", "\u21d2"}, {"<=>", "\u21d4"}, {"!=", "\u2260"}, {"~=", "\u2248"}, {"~", "\u223c"}, {"<=", "\u2264"}, {">=", "\u2265"}, {"<<", "\u226a"}, {">>", "\u226b"}, {"-->", "\u2192"}, {"<->", "\u2194"}, {"->", "\u2192"}, {"<--", "\u2190"}, {"equiv", "\u2261"}, {"forall", "\u2200"}, {"quelquesoit", "\u2200"}, {"exists", "\u2203"}, {"ilexiste", "\u2203"}, {"part", "\u2202"}, {"drond", "\u2202"}, {"nabla", "\u2207"}, {"prop", "\u221d"}, {"times", "\u00d7"}, {"cross", "\u00d7"}, {"croix", "\u00d7"}, {"wedge", "\u2227"}, {"pvec", "\u2227"}, {"plusmn", "\u00b1"}, {"plusoumoins", "\u00b1"}, {"plusminus", "\u00b1"}, {"cap", "\u2229"}, {"cup", "\u222a"}, {"...", "\u2026"}};
    private static final String sops = "_^*/\u2207\u00b1\u2213\u2227-+\u2200\u2203\u2202\u00d7=\u2260\u2248\u223c\u2261<>\u2264\u2265\u226a\u226b\u221d|\u2229\u222a\u2190\u2192\u2194\u21d0\u21d2\u21d4";
    private static final String[][] symboles_id = new String[][]{{"alpha", "\u03b1"}, {"beta", "\u03b2"}, {"gamma", "\u03b3"}, {"delta", "\u03b4"}, {"epsilon", "\u03b5"}, {"zeta", "\u03b6"}, {"eta", "\u03b7"}, {"theta", "\u03b8"}, {"iota", "\u03b9"}, {"kappa", "\u03ba"}, {"lambda", "\u03bb"}, {"mu", "\u03bc"}, {"nu", "\u03bd"}, {"xi", "\u03be"}, {"omicron", "\u03bf"}, {"rho", "\u03c1"}, {"sigma", "\u03c3"}, {"tau", "\u03c4"}, {"upsilon", "\u03c5"}, {"phi", "\u03c6"}, {"chi", "\u03c7"}, {"psi", "\u03c8"}, {"omega", "\u03c9"}, {"Alpha", "\u0391"}, {"Beta", "\u0392"}, {"Gamma", "\u0393"}, {"Delta", "\u0394"}, {"Epsilon", "\u0395"}, {"Zeta", "\u0396"}, {"Eta", "\u0397"}, {"Theta", "\u0398"}, {"Iota", "\u0399"}, {"Kappa", "\u039a"}, {"Lambda", "\u039b"}, {"Mu", "\u039c"}, {"Nu", "\u039d"}, {"Xi", "\u039e"}, {"Omicron", "\u039f"}, {"Pi", "\u03a0"}, {"Rho", "\u03a1"}, {"Sigma", "\u03a3"}, {"Tau", "\u03a4"}, {"Upsilon", "\u03a5"}, {"Phi", "\u03a6"}, {"Chi", "\u03a7"}, {"Psi", "\u03a8"}, {"Omega", "\u03a9"}, {"thetasym", "\u03d1"}, {"upsih", "\u03d2"}, {"piv", "\u03d6"}, {"phiv", "\u03d5"}, {"phi1", "\u03d5"}};
    private static final String[][] symboles_droits = new String[][]{{"pi", "\u03c0"}, {"infin", "\u221e"}, {"infty", "\u221e"}, {"infini", "\u221e"}, {"parallel", "\u2225"}, {"parall\u00e8le", "\u2225"}, {"sun", "\u2609"}, {"soleil", "\u2609"}, {"star", "\u2605"}, {"\u00e9toile", "\u2605"}, {"mercury", "\u263f"}, {"mercure", "\u263f"}, {"venus", "\u2640"}, {"v\u00e9nus", "\u2640"}, {"earth", "\u2295"}, {"terre", "\u2295"}, {"mars", "\u2642"}, {"jupiter", "\u2643"}, {"saturn", "\u2644"}, {"saturne", "\u2644"}, {"uranus", "\u26e2"}, {"neptun", "\u2646"}, {"neptune", "\u2646"}, {"planck", "\u210f"}, {"angstrom", "\u212b"}, {"angstr\u00f6m", "\u212b"}, {"asterisk", "*"}, {"ast\u00e9risque", "*"}, {"ell", "\u2113"}, {"smalll", "\u2113"}, {"petitl", "\u2113"}, {"Ascr", "\ud835\udc9c"}, {"biga", "\ud835\udc9c"}, {"granda", "\ud835\udc9c"}, {"Bscr", "\u212c"}, {"bigb", "\u212c"}, {"grandb", "\u212c"}, {"Cscr", "\ud835\udc9e"}, {"bigc", "\ud835\udc9e"}, {"grandc", "\ud835\udc9e"}, {"Dscr", "\ud835\udc9f"}, {"bigd", "\ud835\udc9f"}, {"grandd", "\ud835\udc9f"}, {"Escr", "\u2130"}, {"bige", "\u2130"}, {"grande", "\u2130"}, {"Fscr", "\u2131"}, {"bigf", "\u2131"}, {"grandf", "\u2131"}, {"Gscr", "\ud835\udca2"}, {"bigg", "\ud835\udca2"}, {"grandg", "\ud835\udca2"}, {"Hscr", "\u210b"}, {"bigh", "\u210b"}, {"grandh", "\u210b"}, {"Iscr", "\u2110"}, {"bigi", "\u2110"}, {"grandi", "\u2110"}, {"Jscr", "\ud835\udca5"}, {"bigj", "\ud835\udca5"}, {"grandj", "\ud835\udca5"}, {"Kscr", "\ud835\udca6"}, {"bigk", "\ud835\udca6"}, {"grandk", "\ud835\udca6"}, {"Lscr", "\u2112"}, {"bigl", "\u2112"}, {"grandl", "\u2112"}, {"Mscr", "\u2133"}, {"bigm", "\u2133"}, {"grandm", "\u2133"}, {"Nscr", "\ud835\udca9"}, {"bign", "\ud835\udca9"}, {"grandn", "\ud835\udca9"}, {"Oscr", "\ud835\udcaa"}, {"bigo", "\ud835\udcaa"}, {"grando", "\ud835\udcaa"}, {"Pscr", "\ud835\udcab"}, {"bigp", "\ud835\udcab"}, {"grandp", "\ud835\udcab"}, {"Qscr", "\ud835\udcac"}, {"bigq", "\ud835\udcac"}, {"grandq", "\ud835\udcac"}, {"Rscr", "\u211b"}, {"bigr", "\u211b"}, {"grandr", "\u211b"}, {"Sscr", "\ud835\udcae"}, {"bigs", "\ud835\udcae"}, {"grands", "\ud835\udcae"}, {"Tscr", "\ud835\udcaf"}, {"bigt", "\ud835\udcaf"}, {"grandt", "\ud835\udcaf"}, {"Uscr", "\ud835\udcb0"}, {"bigu", "\ud835\udcb0"}, {"grandu", "\ud835\udcb0"}, {"Vscr", "\ud835\udcb1"}, {"bigv", "\ud835\udcb1"}, {"grandv", "\ud835\udcb1"}, {"Wscr", "\ud835\udcb2"}, {"bigw", "\ud835\udcb2"}, {"grandw", "\ud835\udcb2"}, {"Xscr", "\ud835\udcb3"}, {"bigx", "\ud835\udcb3"}, {"grandx", "\ud835\udcb3"}, {"Yscr", "\ud835\udcb4"}, {"bigy", "\ud835\udcb4"}, {"grandy", "\ud835\udcb4"}, {"Zscr", "\ud835\udcb5"}, {"bigz", "\ud835\udcb5"}, {"grandz", "\ud835\udcb5"}};
    private static final String[] fctnopar = new String[]{"sin", "cos", "tan", "acos", "asin", "atan"};

    public StringMathBuilder(String string) {
        String string2 = StringMathBuilder.ajParentheses(this.replaceSpecial(string));
        if (!string.equals("")) {
            JEQ jEQ = this.parser(string2);
            MathElement mathElement = jEQ == null ? null : jEQ.versMathML();
            this.rootElement.addMathElement(mathElement);
        }
    }

    public MathRootElement getMathRootElement() {
        return this.rootElement;
    }

    public String replaceSpecial(String string) {
        for (String[] stringArray : special) {
            int n = string.indexOf(stringArray[0]);
            while (n != -1) {
                string = string.substring(0, n) + stringArray[1] + string.substring(n + stringArray[0].length());
                n = string.indexOf(stringArray[0]);
            }
        }
        return string;
    }

    public static String ajParentheses(String string) {
        int n;
        int n2;
        char c;
        int n3;
        int n4 = string.indexOf(59);
        while (n4 != -1) {
            n3 = 0;
            c = '\u0000';
            for (n2 = n4 - 1; n2 >= 0 && n3 >= 0 && ((n = string.charAt(n2)) != 59 || n3 != 0); --n2) {
                if (n == 40) {
                    --n3;
                } else if (n == 41) {
                    ++n3;
                } else if (sops.indexOf(n) != -1) {
                    c = '\u0001';
                }
                if (n3 >= 0 || c == '\u0000') continue;
                string = string.substring(0, n2) + '(' + string.substring(n2, n4) + ')' + string.substring(n4);
                n4 += 2;
            }
            n3 = 0;
            c = '\u0000';
            for (n2 = n4 + 1; n2 < string.length() && n3 >= 0; ++n2) {
                n = string.charAt(n2);
                if (n == 40) {
                    ++n3;
                } else if (n == 41) {
                    --n3;
                } else if (sops.indexOf(n) != -1) {
                    c = '\u0001';
                }
                if ((n3 < 0 || n3 == 0 && n == 59) && c != '\u0000') {
                    string = string.substring(0, n4 + 1) + '(' + string.substring(n4 + 1, n2) + ')' + string.substring(n2);
                }
                if (n == 59 && n3 == 0) break;
            }
            if ((n2 = string.substring(n4 + 1).indexOf(59)) == -1) {
                n4 = n2;
                continue;
            }
            n4 += n2 + 1;
        }
        for (n3 = 0; n3 < sops.length(); ++n3) {
            c = sops.charAt(n3);
            n = n4 = string.indexOf(c);
            int n5 = 32;
            int n6 = 32;
            while (n != -1) {
                int n7;
                boolean bl = false;
                n2 = n4 - 1;
                if (n2 >= 0) {
                    n5 = string.charAt(n2);
                }
                int n8 = 0;
                while (!(n2 < 0 || n8 == 0 && n5 == 40 || n8 == 0 && sops.indexOf(n5) != -1)) {
                    if (n5 == 41) {
                        ++n8;
                    } else if (n5 == 40) {
                        --n8;
                    }
                    if (--n2 < 0) continue;
                    n5 = string.charAt(n2);
                }
                if (n2 < 0 || sops.indexOf(n5) != -1) {
                    bl = true;
                }
                if ((n7 = n4 + 1) >= 0 && n7 <= string.length() - 1) {
                    n6 = string.charAt(n7);
                }
                n8 = 0;
                while (!(n7 >= string.length() || n8 == 0 && n6 == 41 || n8 == 0 && sops.indexOf(n6) != -1)) {
                    if (n6 == 40) {
                        ++n8;
                    } else if (n6 == 41) {
                        --n8;
                    }
                    if (++n7 >= string.length()) continue;
                    n6 = string.charAt(n7);
                }
                if (n7 >= string.length() || sops.indexOf(n6) != -1) {
                    bl = true;
                }
                if (bl) {
                    string = string.substring(0, n2 + 1) + "(" + string.substring(n2 + 1, n7) + ")" + string.substring(n7);
                    ++n4;
                }
                n = string.substring(n4 + 1).indexOf(c);
                n4 = n + n4 + 1;
            }
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public JEQ parser(String string) {
        char c;
        char c2;
        int n;
        if (string == null || "".equals(string)) {
            return null;
        }
        if (string.charAt(0) == '(' && string.charAt(string.length() - 1) == ')') {
            void var2_3;
            boolean c22 = false;
            for (n = 1; n < string.length() - 1; ++n) {
                if (string.charAt(n) == '(') {
                    ++var2_3;
                } else if (string.charAt(n) == ')') {
                    --var2_3;
                }
                if (var2_3 == -1) break;
            }
            if (var2_3 != -1) {
                string = string.substring(1, string.length() - 1);
            }
        }
        int n2 = -1;
        n = 0;
        for (c2 = '\u0000'; c2 < string.length(); ++c2) {
            if (n == 0 && sops.indexOf(string.charAt(c2)) != -1) {
                c = c2;
                break;
            }
            if (string.charAt(c2) == '(') {
                ++n;
                continue;
            }
            if (string.charAt(c2) != ')') continue;
            --n;
        }
        if (c == '\uffffffff') {
            try {
                c2 = (char)(string.matches("\\s?([0-9]+([\\.,][0-9]+)?|[\\.,][0-9]+)(E[+-]?[0-9]+)?\\s?") ? 1 : 0);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                c2 = '\u0000';
            }
            if (c2 != '\u0000') {
                return new JEQNombre(string);
            }
            int n3 = string.indexOf(40);
            if (n3 != -1 && string.charAt(string.length() - 1) == ')') {
                char c3;
                int n4;
                int n5 = -1;
                n = 0;
                for (int i = 0; i < string.length(); ++i) {
                    char c4 = string.charAt(i);
                    if (c4 == '(' && n == 0 && i != n3) {
                        n5 = i;
                        break;
                    }
                    if (c4 == '(') {
                        ++n;
                        continue;
                    }
                    if (c4 != ')') continue;
                    --n;
                }
                Object var7_14 = null;
                JEQ jEQ = null;
                if (n5 == -1) {
                    jEQ = new JEQVariable(string.substring(0, n3));
                    string = string.substring(n3 + 1, string.length() - 1);
                } else {
                    jEQ = this.parser(string.substring(0, n5));
                    string = string.substring(n5 + 1, string.length() - 1);
                }
                Vector<JEQ> vector = new Vector<JEQ>();
                int n6 = -1;
                n = 0;
                for (n4 = 0; n4 < string.length(); ++n4) {
                    c3 = string.charAt(n4);
                    if (c3 == ';' && n == 0) {
                        n6 = n4;
                        break;
                    }
                    if (c3 == '(') {
                        ++n;
                        continue;
                    }
                    if (c3 != ')') continue;
                    --n;
                }
                if (n6 == -1) {
                    vector.add(this.parser(string.trim()));
                } else {
                    while (n6 != -1) {
                        vector.add(this.parser(string.substring(0, n6).trim()));
                        string = string.substring(n6 + 1);
                        n6 = -1;
                        n = 0;
                        for (n4 = 0; n4 < string.length(); ++n4) {
                            c3 = string.charAt(n4);
                            if (c3 == ';' && n == 0) {
                                n6 = n4;
                                break;
                            }
                            if (c3 == '(') {
                                ++n;
                                continue;
                            }
                            if (c3 != ')') continue;
                            --n;
                        }
                        if (n6 != -1) continue;
                        vector.add(this.parser(string.trim()));
                    }
                }
                return new JEQFonction(jEQ, vector);
            }
            return new JEQVariable(string);
        }
        c2 = string.charAt(c);
        String string2 = string.substring(0, c).trim();
        JEQ jEQ = string2.equals("") ? null : this.parser(string2);
        String string3 = string.substring(c + 1).trim();
        JEQ jEQ2 = string3.equals("") ? null : this.parser(string3);
        return new JEQOperation(c2, jEQ, jEQ2);
    }

    private static MathElement elemOrQuestion(JEQ jEQ) {
        if (jEQ != null) {
            return jEQ.versMathML();
        }
        MathText mathText = new MathText();
        mathText.addText("?");
        return mathText;
    }

    class JEQVariable
    implements JEQ {
        String nom;
        boolean unites;

        public JEQVariable(String string) {
            this.nom = string.trim();
            this.unites = false;
        }

        public void setUnites() {
            this.unites = true;
        }

        public MathElement versMathML() {
            if ("hat".equals(this.nom) || "chapeau".equals(this.nom)) {
                MathOperator mathOperator = new MathOperator();
                mathOperator.setStretchy(true);
                mathOperator.addText("^");
                return mathOperator;
            }
            if ("bar".equals(this.nom) || "barre".equals(this.nom)) {
                MathOperator mathOperator = new MathOperator();
                mathOperator.setStretchy(true);
                mathOperator.addText("\u00af");
                return mathOperator;
            }
            String string = this.nom;
            boolean bl = this.unites;
            for (String[] stringArray : symboles_id) {
                if (!stringArray[0].equals(string)) continue;
                string = stringArray[1];
                break;
            }
            for (String[] stringArray : symboles_droits) {
                if (!stringArray[0].equals(string)) continue;
                string = stringArray[1];
                bl = true;
                break;
            }
            if (string.indexOf(44) != -1 || string.indexOf(46) != -1 || string.indexOf(40) != -1 || string.indexOf(41) != -1) {
                string = "?";
            }
            if (string.indexOf(32) != -1) {
                string = string.replace(" ", "?");
            }
            if (string.indexOf(160) != -1) {
                string = string.replace("\u00a0", "?");
            }
            if (string.matches("[0-9]+[a-zA-Z]+")) {
                string = "?";
            }
            MathText mathText = bl ? new MathText() : new MathIdentifier();
            mathText.addText(string);
            return mathText;
        }
    }

    class JEQNombre
    implements JEQ {
        String valeur;

        public JEQNombre(String string) {
            this.valeur = string;
        }

        public void setUnites() {
        }

        public MathElement versMathML() {
            MathNumber mathNumber = new MathNumber();
            mathNumber.addText(this.valeur);
            return mathNumber;
        }
    }

    class JEQOperation
    implements JEQ {
        char op;
        JEQ p1;
        JEQ p2;
        boolean unites;

        public JEQOperation(char c, JEQ jEQ, JEQ jEQ2) {
            this.op = c;
            this.p1 = jEQ;
            this.p2 = jEQ2;
            this.unites = false;
        }

        public void setUnites() {
            this.unites = true;
            if (this.p1 != null) {
                this.p1.setUnites();
            }
            if (this.p2 != null) {
                this.p2.setUnites();
            }
        }

        public MathElement versMathML() {
            MathElement mathElement;
            if (this.op == '/') {
                MathFrac mathFrac = new MathFrac();
                mathFrac.addMathElement(StringMathBuilder.elemOrQuestion(this.p1));
                mathFrac.addMathElement(StringMathBuilder.elemOrQuestion(this.p2));
                return mathFrac;
            }
            if (this.op == '^') {
                char c;
                Object object;
                MathSup mathSup = new MathSup();
                boolean bl = this.p1 instanceof JEQFonction ? ("sqrt".equals(object = ((JEQFonction)this.p1).getNomFct()) || "racine".equals(object) ? false : ("abs".equals(object) ? false : ("matrice".equals(object) ? false : !"dtemps".equals(object) && !"timed".equals(object)))) : (this.p1 instanceof JEQOperation ? (c = ((JEQOperation)this.p1).op) != '_' : false);
                object = bl ? this.ajPar(this.p1.versMathML()) : StringMathBuilder.elemOrQuestion(this.p1);
                mathSup.addMathElement((MathElement)object);
                mathSup.addMathElement(StringMathBuilder.elemOrQuestion(this.p2));
                return mathSup;
            }
            if (this.op == '_') {
                MathSub mathSub = new MathSub();
                mathSub.addMathElement(StringMathBuilder.elemOrQuestion(this.p1));
                mathSub.addMathElement(StringMathBuilder.elemOrQuestion(this.p2));
                return mathSub;
            }
            if (this.op == '*') {
                Object object;
                String string;
                MathRow mathRow = new MathRow();
                MathElement mathElement2 = StringMathBuilder.elemOrQuestion(this.p1);
                if (this.p1 instanceof JEQOperation && "+-".indexOf(((JEQOperation)this.p1).op) != -1) {
                    mathElement2 = this.ajPar(mathElement2);
                }
                mathRow.addMathElement(mathElement2);
                JEQ jEQ = this.p1;
                if (this.p1 != null) {
                    while (jEQ instanceof JEQOperation && ((JEQOperation)jEQ).p2 != null) {
                        jEQ = ((JEQOperation)jEQ).p2;
                    }
                }
                boolean bl = jEQ instanceof JEQNombre;
                JEQ jEQ2 = this.p2;
                if (this.p2 != null) {
                    while (jEQ2 instanceof JEQOperation && ((JEQOperation)jEQ2).p1 != null) {
                        jEQ2 = ((JEQOperation)jEQ2).p1;
                    }
                }
                boolean bl2 = jEQ2 instanceof JEQNombre;
                boolean bl3 = false;
                if (this.p1 instanceof JEQFonction && ("pscalaire".equals(string = ((JEQFonction)this.p1).getNomFct()) || "scalarp".equals(string))) {
                    bl3 = true;
                }
                boolean bl4 = false;
                if (this.p2 instanceof JEQFonction && ("pscalaire".equals(object = ((JEQFonction)this.p2).getNomFct()) || "scalarp".equals(object))) {
                    bl4 = true;
                }
                if (bl && bl2 || bl3 && bl4) {
                    object = new MathOperator();
                    ((MathElement)object).addText("\u00d7");
                    mathRow.addMathElement((MathElement)object);
                } else if (this.unites) {
                    object = new MathOperator();
                    ((MathElement)object).addText(".");
                    mathRow.addMathElement((MathElement)object);
                }
                object = StringMathBuilder.elemOrQuestion(this.p2);
                if (this.p2 instanceof JEQOperation && "+-".indexOf(((JEQOperation)this.p2).op) != -1) {
                    object = this.ajPar((MathElement)object);
                }
                mathRow.addMathElement((MathElement)object);
                return mathRow;
            }
            if (this.op == '-') {
                MathRow mathRow = new MathRow();
                if (this.p1 != null) {
                    mathRow.addMathElement(this.p1.versMathML());
                }
                MathOperator mathOperator = new MathOperator();
                mathOperator.addText("-");
                mathRow.addMathElement(mathOperator);
                if (this.p2 != null) {
                    MathElement mathElement3 = this.p2.versMathML();
                    if (this.p2 instanceof JEQOperation && "+-".indexOf(((JEQOperation)this.p2).op) != -1) {
                        mathElement3 = this.ajPar(mathElement3);
                    }
                    mathRow.addMathElement(mathElement3);
                }
                return mathRow;
            }
            if (this.op == '+') {
                MathRow mathRow = new MathRow();
                if (this.p1 != null) {
                    mathRow.addMathElement(this.p1.versMathML());
                }
                MathOperator mathOperator = new MathOperator();
                mathOperator.addText("+");
                mathRow.addMathElement(mathOperator);
                if (this.p2 != null) {
                    MathElement mathElement4 = this.p2.versMathML();
                    if (mathElement4 instanceof MathRow && mathElement4.getMathElementCount() > 0) {
                        MathElement mathElement5 = mathElement4;
                        while (mathElement5 instanceof MathRow && mathElement5.getMathElementCount() > 0) {
                            mathElement5 = mathElement5.getMathElement(0);
                        }
                        if ("-".equals(mathElement5.getText())) {
                            mathElement4 = this.ajPar(mathElement4);
                        }
                    }
                    mathRow.addMathElement(mathElement4);
                }
                return mathRow;
            }
            MathRow mathRow = new MathRow();
            if (this.p1 != null) {
                mathElement = this.p1.versMathML();
                if (this.op == '\u2227' && this.p1 instanceof JEQOperation && "+-".indexOf(((JEQOperation)this.p1).op) != -1) {
                    mathElement = this.ajPar(mathElement);
                }
                mathRow.addMathElement(mathElement);
            }
            mathElement = new MathOperator();
            mathElement.addText(Character.toString(this.op));
            if ("=\u2260\u2248\u223c\u2261\u2264\u2265\u226a\u226b\u221d".indexOf(this.op) != -1) {
                ((MathOperator)mathElement).setLspace(0.5);
                ((MathOperator)mathElement).setRspace(0.5);
            }
            mathRow.addMathElement(mathElement);
            if (this.p2 != null) {
                MathElement mathElement6 = this.p2.versMathML();
                if (this.op == '\u2227' && this.p2 instanceof JEQOperation && "+-".indexOf(((JEQOperation)this.p2).op) != -1) {
                    mathElement6 = this.ajPar(mathElement6);
                }
                mathRow.addMathElement(mathElement6);
            }
            return mathRow;
        }

        private MathElement ajPar(MathElement mathElement) {
            MathRow mathRow = new MathRow();
            MathOperator mathOperator = new MathOperator();
            mathOperator.addText("(");
            mathRow.addMathElement(mathOperator);
            mathRow.addMathElement(mathElement);
            mathOperator = new MathOperator();
            mathOperator.addText(")");
            mathRow.addMathElement(mathOperator);
            return mathRow;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class JEQFonction
    implements JEQ {
        JEQ nom;
        Vector<JEQ> vp;
        boolean unites;

        public JEQFonction(JEQ jEQ, Vector<JEQ> vector) {
            this.nom = jEQ;
            if (jEQ instanceof JEQVariable && ((JEQVariable)jEQ).nom.matches("[0-9]+")) {
                ((JEQVariable)jEQ).nom = ((JEQVariable)jEQ).nom + "?";
            }
            this.vp = vector;
            boolean bl = this.unites = "unit\u00e9".equals(this.getNomFct()) || "unit".equals(this.getNomFct());
            if (this.unites) {
                this.setUnites();
            }
        }

        @Override
        public void setUnites() {
            this.unites = true;
            for (JEQ jEQ : this.vp) {
                if (jEQ == null) continue;
                jEQ.setUnites();
            }
        }

        public String getNomFct() {
            if (this.nom instanceof JEQVariable) {
                return ((JEQVariable)this.nom).nom;
            }
            return null;
        }

        @Override
        public MathElement versMathML() {
            MathElement mathElement;
            JEQ jEQ = this.vp.size() > 0 ? this.vp.get(0) : null;
            JEQ jEQ2 = this.vp.size() > 1 ? this.vp.get(1) : null;
            JEQ jEQ3 = this.vp.size() > 2 ? this.vp.get(2) : null;
            JEQ jEQ4 = this.vp.size() > 3 ? this.vp.get(3) : null;
            Object string = this.getNomFct();
            if ("sqrt".equals(string) || "racine".equals(string) && (jEQ == null || jEQ2 == null)) {
                mathElement = new MathSqrt();
                mathElement.addMathElement(StringMathBuilder.elemOrQuestion(jEQ));
            } else if ("racine".equals(string) || "root".equals(string)) {
                mathElement = new MathRoot();
                mathElement.addMathElement(StringMathBuilder.elemOrQuestion(jEQ));
                mathElement.addMathElement(StringMathBuilder.elemOrQuestion(jEQ2));
            } else if ("exp".equals(string)) {
                mathElement = new MathSup();
                MathIdentifier mathIdentifier = new MathIdentifier();
                mathIdentifier.addText("e");
                mathElement.addMathElement(mathIdentifier);
                mathElement.addMathElement(StringMathBuilder.elemOrQuestion(jEQ));
            } else if ("abs".equals(string)) {
                mathElement = new MathRow();
                MathOperator mathOperator = new MathOperator();
                mathOperator.addText("|");
                mathElement.addMathElement(mathOperator);
                mathElement.addMathElement(StringMathBuilder.elemOrQuestion(jEQ));
                mathOperator = new MathOperator();
                mathOperator.addText("|");
                mathElement.addMathElement(mathOperator);
            } else if ("norm".equals(string) || "norme".equals(string)) {
                mathElement = new MathRow();
                MathOperator mathOperator = new MathOperator();
                mathOperator.addText("\u2016");
                mathElement.addMathElement(mathOperator);
                mathElement.addMathElement(StringMathBuilder.elemOrQuestion(jEQ));
                mathOperator = new MathOperator();
                mathOperator.addText("\u2016");
                mathElement.addMathElement(mathOperator);
            } else if ("fact".equals(string) || "factorielle".equals(string) || "factorial".equals(string)) {
                MathOperator mathOperator;
                mathElement = new MathRow();
                if (!(jEQ instanceof JEQVariable) && !(jEQ instanceof JEQNombre)) {
                    mathOperator = new MathOperator();
                    mathOperator.addText("(");
                    mathElement.addMathElement(mathOperator);
                }
                mathElement.addMathElement(jEQ.versMathML());
                if (!(jEQ instanceof JEQVariable) && !(jEQ instanceof JEQNombre)) {
                    mathOperator = new MathOperator();
                    mathOperator.addText(")");
                    mathElement.addMathElement(mathOperator);
                }
                mathOperator = new MathOperator();
                mathOperator.addText("!");
                mathElement.addMathElement(mathOperator);
            } else if ("int".equals(string) || "int\u00e9grale".equals(string)) {
                MathElement mathElement2;
                mathElement = new MathRow();
                MathOperator mathOperator = new MathOperator();
                mathOperator.addText("\u222b");
                mathOperator.setStretchy(true);
                if (jEQ3 != null && jEQ4 != null) {
                    mathElement2 = new MathUnderOver();
                    ((MathUnderOver)mathElement2).addMathElement(mathOperator);
                    ((MathUnderOver)mathElement2).addMathElement(StringMathBuilder.elemOrQuestion(jEQ3));
                    ((MathUnderOver)mathElement2).addMathElement(StringMathBuilder.elemOrQuestion(jEQ4));
                    mathElement.addMathElement(mathElement2);
                } else if (jEQ3 != null) {
                    mathElement2 = new MathUnder();
                    ((MathUnder)mathElement2).addMathElement(mathOperator);
                    ((MathUnder)mathElement2).addMathElement(StringMathBuilder.elemOrQuestion(jEQ3));
                    mathElement.addMathElement(mathElement2);
                } else if (jEQ4 != null) {
                    mathElement2 = new MathOver();
                    ((MathOver)mathElement2).addMathElement(mathOperator);
                    ((MathOver)mathElement2).addMathElement(StringMathBuilder.elemOrQuestion(jEQ4));
                    mathElement.addMathElement(mathElement2);
                } else {
                    mathElement.addMathElement(mathOperator);
                }
                mathElement2 = new MathRow();
                mathElement2.addMathElement(StringMathBuilder.elemOrQuestion(jEQ));
                if (jEQ2 != null) {
                    mathOperator = new MathOperator();
                    mathOperator.addText("d");
                    mathElement2.addMathElement(mathOperator);
                    mathElement2.addMathElement(jEQ2.versMathML());
                }
                mathElement.addMathElement(mathElement2);
            } else if ("prod".equals(string) || "sum".equals(string) || "produit".equals(string) || "somme".equals(string)) {
                mathElement = new MathRow();
                MathUnderOver mathUnderOver = new MathUnderOver();
                MathOperator mathOperator = new MathOperator();
                if ("prod".equals(string) || "produit".equals(string)) {
                    mathOperator.addText("\u220f");
                } else if ("sum".equals(string) || "somme".equals(string)) {
                    mathOperator.addText("\u2211");
                }
                mathOperator.setStretchy(true);
                mathUnderOver.addMathElement(mathOperator);
                mathUnderOver.addMathElement(StringMathBuilder.elemOrQuestion(jEQ2));
                mathUnderOver.addMathElement(StringMathBuilder.elemOrQuestion(jEQ3));
                mathElement.addMathElement(mathUnderOver);
                MathRow mathRow = new MathRow();
                mathRow.addMathElement(StringMathBuilder.elemOrQuestion(jEQ));
                mathElement.addMathElement(mathRow);
            } else if ("over".equals(string) || "dessus".equals(string)) {
                MathOver mathOver = new MathOver();
                mathOver.addMathElement(StringMathBuilder.elemOrQuestion(jEQ));
                mathOver.addMathElement(StringMathBuilder.elemOrQuestion(jEQ2));
                mathElement = mathOver;
            } else if ("subsup".equals(string)) {
                MathSubSup mathSubSup = new MathSubSup();
                mathSubSup.addMathElement(StringMathBuilder.elemOrQuestion(jEQ));
                mathSubSup.addMathElement(StringMathBuilder.elemOrQuestion(jEQ2));
                mathSubSup.addMathElement(StringMathBuilder.elemOrQuestion(jEQ3));
                mathElement = mathSubSup;
            } else if ("accent".equals(string)) {
                MathOver mathOver = new MathOver();
                mathOver.setAccent(true);
                mathOver.addMathElement(StringMathBuilder.elemOrQuestion(jEQ));
                if (jEQ2 instanceof JEQOperation && ((JEQOperation)jEQ2).op == '\u223c') {
                    MathOperator mathOperator = new MathOperator();
                    mathOperator.setStretchy(true);
                    mathOperator.addText("\u223c");
                    mathOver.addMathElement(mathOperator);
                } else {
                    mathOver.addMathElement(StringMathBuilder.elemOrQuestion(jEQ2));
                }
                mathElement = mathOver;
            } else if ("matrix".equals(string) || "matrice".equals(string)) {
                mathElement = new MathRow();
                MathOperator mathOperator = new MathOperator();
                mathOperator.addText("(");
                mathElement.addMathElement(mathOperator);
                MathTable mathTable = new MathTable();
                for (JEQ jEQ5 : this.vp) {
                    mathTable.addMathElement(StringMathBuilder.elemOrQuestion(jEQ5));
                }
                mathElement.addMathElement(mathTable);
                mathOperator = new MathOperator();
                mathOperator.addText(")");
                mathElement.addMathElement(mathOperator);
            } else if ("system".equals(string) || "syst\u00e8me".equals(string)) {
                mathElement = new MathRow();
                MathOperator mathOperator = new MathOperator();
                mathOperator.addText("{");
                mathElement.addMathElement(mathOperator);
                MathTable mathTable = new MathTable();
                for (JEQ jEQ6 : this.vp) {
                    MathRow mathRow = new MathRow();
                    MathTableData mathTableData = new MathTableData();
                    mathTableData.setColumnAlign("left");
                    mathTableData.addMathElement(StringMathBuilder.elemOrQuestion(jEQ6));
                    mathRow.addMathElement(mathTableData);
                    mathTable.addMathElement(mathRow);
                }
                mathElement.addMathElement(mathTable);
            } else if ("line".equals(string) || "ligne".equals(string)) {
                mathElement = new MathTableRow();
                for (JEQ jEQ7 : this.vp) {
                    MathTableData mathTableData = new MathTableData();
                    mathTableData.addMathElement(StringMathBuilder.elemOrQuestion(jEQ7));
                    mathElement.addMathElement(mathTableData);
                }
            } else if ("slash".equals(string)) {
                mathElement = new MathRow();
                mathElement.addMathElement(StringMathBuilder.elemOrQuestion(jEQ));
                MathOperator mathOperator = new MathOperator();
                mathOperator.addText("/");
                mathElement.addMathElement(mathOperator);
                mathElement.addMathElement(StringMathBuilder.elemOrQuestion(jEQ2));
            } else if ("frac".equals(string) || "fraction".equals(string)) {
                MathFrac mathFrac = new MathFrac();
                mathFrac.addMathElement(StringMathBuilder.elemOrQuestion(jEQ));
                mathFrac.addMathElement(StringMathBuilder.elemOrQuestion(jEQ2));
                mathElement = mathFrac;
            } else {
                if ("pscalaire".equals(string) || "scalarp".equals(string)) {
                    MathRow mathRow = new MathRow();
                    mathRow.addMathElement(StringMathBuilder.elemOrQuestion(jEQ));
                    MathOperator mathOperator = new MathOperator();
                    mathOperator.addText(".");
                    mathRow.addMathElement(mathOperator);
                    mathRow.addMathElement(StringMathBuilder.elemOrQuestion(jEQ2));
                    return mathRow;
                }
                if ("dtemps".equals(string) || "timed".equals(string)) {
                    MathOver mathOver = new MathOver();
                    mathOver.setAccent(true);
                    mathOver.addMathElement(StringMathBuilder.elemOrQuestion(jEQ));
                    MathOperator mathOperator = new MathOperator();
                    if (jEQ2 instanceof JEQNombre) {
                        try {
                            int n = Integer.parseInt(((JEQNombre)jEQ2).valeur);
                            String string2 = "";
                            for (int i = 0; i < n; ++i) {
                                string2 = string2 + '.';
                            }
                            mathOperator.addText(string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            mathOperator.addText("?");
                        }
                    } else {
                        mathOperator.addText("?");
                    }
                    mathOver.addMathElement(mathOperator);
                    mathElement = mathOver;
                } else {
                    if ("unit\u00e9".equals(string) || "unit".equals(string)) {
                        MathRow mathRow = new MathRow();
                        mathRow.addMathElement(StringMathBuilder.elemOrQuestion(jEQ));
                        MathOperator mathOperator = new MathOperator();
                        mathOperator.addText(" ");
                        mathRow.addMathElement(mathOperator);
                        mathRow.addMathElement(StringMathBuilder.elemOrQuestion(jEQ2));
                        return mathRow;
                    }
                    if ("moyenne".equals(string) || "mean".equals(string)) {
                        mathElement = new MathRow();
                        MathOperator mathOperator = new MathOperator();
                        mathOperator.addText("\u2329");
                        mathElement.addMathElement(mathOperator);
                        mathElement.addMathElement(StringMathBuilder.elemOrQuestion(jEQ));
                        mathOperator = new MathOperator();
                        mathOperator.addText("\u232a");
                        mathElement.addMathElement(mathOperator);
                    } else if ("vecteur".equals(string) || "vector".equals(string)) {
                        MathElement mathElement3 = StringMathBuilder.elemOrQuestion(jEQ);
                        if (mathElement3 instanceof MathIdentifier) {
                            ((MathIdentifier)mathElement3).setMathvariant("bold");
                            mathElement = mathElement3;
                        } else if (mathElement3 instanceof MathSub && mathElement3.getMathElement(0) instanceof MathIdentifier) {
                            ((MathIdentifier)mathElement3.getMathElement(0)).setMathvariant("bold");
                            mathElement = mathElement3;
                        } else {
                            MathOver mathOver = new MathOver();
                            mathOver.setAccent(true);
                            mathOver.addMathElement(StringMathBuilder.elemOrQuestion(jEQ));
                            MathOperator mathOperator = new MathOperator();
                            mathOperator.setStretchy(true);
                            mathOperator.addText("\u2192");
                            mathOver.addMathElement(mathOperator);
                            mathElement = mathOver;
                        }
                    } else {
                        MathElement mathElement4;
                        mathElement = new MathRow();
                        boolean bl = true;
                        if (this.nom instanceof JEQVariable) {
                            mathElement4 = new MathText();
                            for (String[] object : symboles_id) {
                                if (!object[0].equals(string)) continue;
                                string = object[1];
                                break;
                            }
                            for (String[] stringArray : symboles_droits) {
                                if (!((String)stringArray[0]).equals(string)) continue;
                                string = stringArray[1];
                                break;
                            }
                            mathElement4.addText((String)string);
                            if (jEQ2 == null && jEQ instanceof JEQVariable) {
                                for (String string2 : fctnopar) {
                                    if (!string2.equals(string)) continue;
                                    bl = false;
                                    break;
                                }
                            }
                            mathElement.addMathElement(mathElement4);
                        } else {
                            mathElement.addMathElement(this.nom.versMathML());
                        }
                        if (bl) {
                            mathElement4 = new MathOperator();
                            mathElement4.addText("(");
                            mathElement.addMathElement(mathElement4);
                        }
                        mathElement.addMathElement(StringMathBuilder.elemOrQuestion(jEQ));
                        for (int i = 1; i < this.vp.size(); ++i) {
                            MathOperator mathOperator = new MathOperator();
                            mathOperator.addText(";");
                            mathElement.addMathElement(mathOperator);
                            mathElement.addMathElement(this.vp.get(i).versMathML());
                        }
                        if (bl) {
                            MathOperator mathOperator = new MathOperator();
                            mathOperator.addText(")");
                            mathElement.addMathElement(mathOperator);
                        } else {
                            MathText mathText = new MathText();
                            mathText.addText("\u00a0");
                            mathElement.addMathElement(mathText);
                        }
                    }
                }
            }
            return mathElement;
        }
    }

    static interface JEQ {
        public MathElement versMathML();

        public void setUnites();
    }
}

