<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:output doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd" encoding="ISO-8859-1" indent="yes" method="xml"/>

<xsl:template match="TUTORIAL">
<html>
<head>
<title><xsl:value-of select="TITLE"/></title>

<style type="text/css">
body { margin-left: 6%; margin-right: 6%; font-size: 100%; background: rgb(255,255,235) }
h1 { text-align: center; font-size: 125%; font-family: Textile, Arial Black, sans-serif; font-weight: normal; margin-bottom: 2em }
h2 { font-size: 110%; margin-left: -3%; font-style: italic; font-family: serif }
h3 { font-size: 100%; font-weight: bold; font-family: serif }
hr { margin-left: -3% }
div.section { border: none; background: rgb(235,235,255); padding-left: 2em; padding-right: 2em;
padding-top: 0.5em; padding-bottom: 0.5em; margin-bottom: 2em }
p { text-indent: 1em; text-align: justify }
div.image { text-align: center; }
tt { color: rgb(150,50,50) }
</style>
<meta content="text/html;charset=ISO-8859-1" http-equiv="Content-type"/>
</head>

<body>
<xsl:if test="TITLE">
<h1><xsl:value-of select="TITLE"/></h1>
</xsl:if>
<xsl:apply-templates/>
</body>
</html>
</xsl:template>

<xsl:template match="TITLE">
</xsl:template>

<xsl:template match="SECTION">
<div class="section">
<xsl:if test="TITLE">
<h2><xsl:value-of select="TITLE"/></h2>
</xsl:if>
<xsl:apply-templates/>
</div>
</xsl:template>

<xsl:template match="PARAGRAPH">
<xsl:if test="TITLE">
<h3><xsl:value-of select="TITLE"/></h3>
</xsl:if>
<p><xsl:apply-templates/></p>
</xsl:template>

<xsl:template match="LIST">
<ul>
<xsl:apply-templates/>
</ul>
</xsl:template>

<xsl:template match="LI">
<li><xsl:apply-templates/></li>
</xsl:template>

<xsl:template match="IMAGE">
<div class="image">
<img alt="{@file}" src="{@file}"/>
</div>
</xsl:template>

<xsl:template match="CODE">
<tt><xsl:apply-templates/></tt>
</xsl:template>

<xsl:template match="EMPHASIS">
<em><xsl:apply-templates/></em>
</xsl:template>

<xsl:template match="LINK">
<a href="{@href}"><xsl:apply-templates/></a>
</xsl:template>

</xsl:stylesheet>
