/*
Jaxe - Editeur XML en Java

Copyright (C) 2005 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformment aux dispositions de la Licence Publique Gnrale GNU, telle que publie par la Free Software Foundation ; version 2 de la licence, ou encore ( votre choix) toute version ultrieure.

Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de dtail, voir la Licence Publique Gnrale GNU .

Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme temps que ce programme ; si ce n'est pas le cas, crivez  la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

package pluginsjaxe;

import javax.swing.JOptionPane;
import javax.swing.text.BadLocationException;

import org.w3c.dom.*;

import jaxe.JaxeDocument;
import jaxe.Fonction;


/**
 * Function displaying a dialog with statistics on the document.
 * Attributes are ignored.
 * compilation:
 * javac -encoding ISO-8859-1 -classpath .:Jaxe.jar pluginsjaxe/StatisticsFunction.java
 */
public class StatisticsFunction implements Fonction {

    int nbmots, nbcar;

    public boolean appliquer(JaxeDocument doc, int start, int end) {
        nbmots = 0;
        nbcar = 0;
        String infosel;
        try {
            if (start == end) {
                infosel = "All the document";
                calculer(doc.getText(0, doc.getLength()));
            } else {
                infosel = "Selection";
                calculer(doc.getText(start, end - start));
            }
            
            JOptionPane.showMessageDialog(doc.jframe,
                infosel + " :\n" +
                " word count : " + nbmots + "\n" +
                " character count (including spaces) : " + nbcar,
                "Statistics", JOptionPane.INFORMATION_MESSAGE);
            return(true);
        } catch (BadLocationException ex) {
            // an exception can be thrown by doc.getText
            ex.printStackTrace();
            return(false);
        }
    }
    
    private void calculer(String s) {
        char c;
        int ind1 = -1; // index last space
        for (int i=0; i<s.length(); i++) {
            c = s.charAt(i);
            if (" \n'\",;:.!?()*".indexOf(c) != -1) {
                if (i - ind1 > 1)
                    nbmots++;
                ind1 = i;
            }
            if (c != '*') // the * character corresponds to a tag, we don't count it
                nbcar++;
        }
        if (s.length() - ind1 > 1)
            nbmots++;
    }
}
