/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.swing.ImageIcon;
import org.enhydra.jawe.ActionBase;
import org.enhydra.jawe.JaWEAction;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEConstants;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.PFFilter;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.SearchResult;
import org.enhydra.jawe.WaitScreen;
import org.enhydra.jawe.base.controller.JaWEController;
import org.enhydra.jawe.base.xpdlvalidator.ValidationError;
import org.enhydra.jawe.misc.PFLocale;
import org.enhydra.jxpdl.XMLCollection;
import org.enhydra.jxpdl.XMLComplexElement;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLUtil;
import org.enhydra.jxpdl.elements.Activity;
import org.enhydra.jxpdl.elements.ActivitySet;
import org.enhydra.jxpdl.elements.Application;
import org.enhydra.jxpdl.elements.DataField;
import org.enhydra.jxpdl.elements.ExtendedAttribute;
import org.enhydra.jxpdl.elements.ExtendedAttributes;
import org.enhydra.jxpdl.elements.FormalParameter;
import org.enhydra.jxpdl.elements.Package;
import org.enhydra.jxpdl.elements.Participant;
import org.enhydra.jxpdl.elements.TypeDeclaration;
import org.enhydra.jxpdl.elements.WorkflowProcess;
import org.enhydra.jxpdl.utilities.SequencedHashMap;

public class Utils {
    public static final String LANG_PROP_PREFIX = "JaWE";
    protected static SequencedHashMap actImgResources = null;
    protected static List actImgResourceNames = null;

    public static Properties getProperties(String string, Properties properties) throws Exception {
        Properties properties2 = properties;
        if (string == null || string.equals("")) {
            return properties2;
        }
        File file = new File(string);
        if (file != null) {
            if (!file.isAbsolute()) {
                file = file.getAbsoluteFile();
            }
            if (!file.exists()) {
                file = null;
            }
        }
        if (file == null) {
            string = System.getProperty("JaWE_CURRENT_CONFIG_HOME") + "/" + string;
            file = new File(string);
            if (file == null) {
                return properties2;
            }
            if (!file.isAbsolute()) {
                file = file.getAbsoluteFile();
            }
        }
        if (file.exists()) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                properties2.load(fileInputStream);
                fileInputStream.close();
            }
            catch (Exception exception) {
                throw new Exception("Something went wrong while reading configuration from file " + file + "!!!", exception);
            }
        } else {
            throw new Exception("Component needs to be configured properly - configuration file " + file + " does not exist!!!");
        }
        return properties2;
    }

    public static boolean checkFileExistence(String string) {
        if (string == null || string.equals("")) {
            return false;
        }
        File file = new File(string);
        if (file != null) {
            if (!file.isAbsolute()) {
                file = file.getAbsoluteFile();
            }
            if (!file.exists()) {
                file = null;
            }
        }
        if (file == null) {
            string = System.getProperty("JaWE_CURRENT_CONFIG_HOME") + "/" + string;
            file = new File(string);
            if (file == null) {
                return false;
            }
            if (!file.isAbsolute()) {
                file = file.getAbsoluteFile();
            }
        }
        return file.exists();
    }

    public static boolean checkResourceExistence(String string, String string2) {
        return Utils.class.getClassLoader().getResource(string + string2) != null;
    }

    public static Map getProperties(Properties properties, String string) {
        SequencedHashMap sequencedHashMap = new SequencedHashMap();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (!((String)entry.getKey()).startsWith(string)) continue;
            sequencedHashMap.put(entry.getKey(), entry.getValue());
        }
        return sequencedHashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyPropertyFile(String string, String string2, boolean bl) throws Exception {
        boolean bl2;
        String string3 = System.getProperty("JaWE_CURRENT_CONFIG_HOME");
        if (string3 == null) {
            return true;
        }
        String string4 = string3 + "/" + string2;
        if (!bl && (bl2 = Utils.checkFileExistence(string4))) {
            return false;
        }
        System.out.println("Copying property file " + string2 + " to " + string4);
        InputStream inputStream = null;
        URL uRL = Utils.class.getClassLoader().getResource(string + string2);
        BufferedReader bufferedReader = null;
        Writer writer = null;
        try {
            URLConnection uRLConnection = uRL.openConnection();
            inputStream = uRLConnection.getInputStream();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuffer stringBuffer = new StringBuffer();
            String string5 = null;
            while ((string5 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string5);
                stringBuffer.append(System.getProperty("line.separator"));
            }
            writer = new BufferedWriter(new FileWriter(string4));
            writer.write(stringBuffer.toString());
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
        return true;
    }

    public static void manageProperties(Properties properties, String string, String string2) throws Exception {
        block6: {
            try {
                if (!Utils.copyPropertyFile(string, string2, false)) {
                    Properties properties2 = new Properties();
                    FileInputStream fileInputStream = null;
                    try {
                        fileInputStream = new FileInputStream(System.getProperty("JaWE_CURRENT_CONFIG_HOME") + "/" + string2);
                        properties2.load(fileInputStream);
                        fileInputStream.close();
                        Utils.adjustProperties(properties, properties2);
                        break block6;
                    }
                    catch (Exception exception) {
                        throw new Error("Something went wrong while reading external component properties !!!", exception);
                    }
                }
                URL uRL = JaWEManager.class.getClassLoader().getResource(string + string2);
                if (uRL == null) {
                    return;
                }
                URLConnection uRLConnection = uRL.openConnection();
                InputStream inputStream = uRLConnection.getInputStream();
                properties.load(inputStream);
            }
            catch (Exception exception) {
                throw new Exception("Something went wrong while reading component's properties !!!", exception);
            }
        }
    }

    public static void adjustProperties(Properties properties, Properties properties2) {
        for (Map.Entry<Object, Object> entry : properties2.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            properties.setProperty(string, string2);
        }
    }

    public static String getUnqualifiedClassName(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(".");
        if (n >= 0) {
            string = string.substring(n + 1, string.length());
        }
        return string;
    }

    public static Color getColor(String string) {
        Color color = null;
        int n = string.indexOf(".");
        if (string.indexOf("Color") != -1 && n != -1) {
            try {
                ClassLoader classLoader = JaWEManager.class.getClassLoader();
                Class<?> clazz = classLoader.loadClass("java.awt." + string.substring(0, n));
                Field field = clazz.getField(string.substring(n + 1));
                color = (Color)field.get(null);
                color = new Color(color.getRed(), color.getGreen(), color.getBlue());
            }
            catch (Exception exception) {}
        } else {
            int n2;
            int n3;
            int n4;
            try {
                int n5 = string.indexOf("R=");
                if (n5 == -1) {
                    n5 = string.indexOf("r=");
                }
                int n6 = string.indexOf(",", n5 + 2);
                int n7 = string.indexOf("G=");
                if (n7 == -1) {
                    n7 = string.indexOf("g=");
                }
                int n8 = string.indexOf(",", n7 + 2);
                int n9 = string.indexOf("B=");
                if (n9 == -1) {
                    n9 = string.indexOf("b=");
                }
                if (n5 != -1 && n6 != -1 && n7 != -1 && n8 != -1 && n9 != -1 && n6 < n7 && n8 < n9) {
                    n4 = Integer.valueOf(string.substring(n5 + 2, n6).trim());
                    if (n4 < 0) {
                        n4 = 0;
                    }
                    if (n4 > 255) {
                        n4 = 255;
                    }
                    if ((n3 = Integer.valueOf(string.substring(n7 + 2, n8).trim()).intValue()) < 0) {
                        n3 = 0;
                    }
                    if (n3 > 255) {
                        n3 = 255;
                    }
                    if ((n2 = Integer.valueOf(string.substring(n9 + 2).trim()).intValue()) < 0) {
                        n2 = 0;
                    }
                    if (n2 > 255) {
                        n2 = 255;
                    }
                    color = new Color(n4, n3, n2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (color == null) {
                try {
                    String[] stringArray = XMLUtil.tokenize((String)string, (String)",");
                    n4 = Integer.valueOf(stringArray[0]);
                    n3 = Integer.valueOf(stringArray[1]);
                    n2 = Integer.valueOf(stringArray[2]);
                    color = new Color(n4, n3, n2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (color == null) {
                try {
                    String string2 = string.substring(1, 3);
                    String string3 = string.substring(4, 6);
                    String string4 = string.substring(5, 7);
                    n4 = Integer.parseInt(string2, 16);
                    n3 = Integer.parseInt(string3, 16);
                    n2 = Integer.parseInt(string4, 16);
                    color = new Color(n4, n3, n2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return color;
    }

    public static String getColorString(Color color) {
        if (color == null) {
            return "128,128,128";
        }
        return String.valueOf(color.getRed()) + "," + String.valueOf(color.getGreen()) + "," + String.valueOf(color.getBlue());
    }

    public static void flipCoordinates(Point point) {
        int n = point.x;
        point.x = point.y;
        point.y = n;
    }

    public static void printStrings(String[] stringArray) {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println("String no " + i + " = " + stringArray[i]);
            }
        } else {
            System.out.println("Passed string array is null !!!");
        }
    }

    public static void center(Window window, int n, int n2) {
        window.pack();
        Dimension dimension = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds().getSize();
        Dimension dimension2 = window.getPreferredSize();
        if (dimension2.width > dimension.width - n) {
            dimension2.width = dimension.width - n;
        }
        if (dimension2.height > dimension.height - n2) {
            dimension2.height = dimension.height - n2;
        }
        window.setSize(dimension2);
        window.setLocation(dimension.width / 2 - dimension2.width / 2, dimension.height / 2 - dimension2.height / 2);
    }

    public static List findPropertyFiles() {
        Object object;
        String string;
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>();
        URL uRL = Utils.class.getClassLoader().getResource("org/enhydra/jawe/language");
        File file = null;
        if (uRL != null) {
            try {
                file = new File(uRL.toURI());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (file != null && file.exists() && file.isDirectory()) {
            arrayList.addAll(Arrays.asList(file.list(new PFFilter())));
        } else {
            object2 = null;
            try {
                String string2 = "org/enhydra/jawe/language/JaWE.properties";
                uRL = Utils.class.getClassLoader().getResource(string2);
                string = uRL.getPath().substring(0, uRL.getPath().length() - string2.length() - 2);
                string = URLDecoder.decode(string, "UTF-8");
                string = string.substring(5);
                object2 = new JarFile(string, false);
                Enumeration<JarEntry> enumeration = ((JarFile)object2).entries();
                while (enumeration.hasMoreElements()) {
                    try {
                        ZipEntry zipEntry = enumeration.nextElement();
                        object = zipEntry.getName();
                        if (((String)object).indexOf(LANG_PROP_PREFIX) == -1 || !((String)object).endsWith(".properties")) continue;
                        arrayList.add((String)object);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (arrayList.size() == 0) {
            uRL = Utils.class.getClassLoader().getResource("org/enhydra/jawe/language/JaWE.properties");
            if (uRL != null) {
                arrayList.add("JaWE.properties");
            }
            if ((uRL = Utils.class.getClassLoader().getResource("org/enhydra/jawe/language/JaWE_de.properties")) != null) {
                arrayList.add("JaWE_de.properties");
            }
            if ((uRL = Utils.class.getClassLoader().getResource("org/enhydra/jawe/language/JaWE_fr.properties")) != null) {
                arrayList.add("JaWE_fr.properties");
            }
            if ((uRL = Utils.class.getClassLoader().getResource("org/enhydra/jawe/language/JaWE_sh.properties")) != null) {
                arrayList.add("JaWE_sh.properties");
            }
            if ((uRL = Utils.class.getClassLoader().getResource("org/enhydra/jawe/language/JaWE_es.properties")) != null) {
                arrayList.add("JaWE_es.properties");
            }
            if ((uRL = Utils.class.getClassLoader().getResource("org/enhydra/jawe/language/JaWE_pt.properties")) != null) {
                arrayList.add("JaWE_pt.properties");
            }
        }
        object2 = new ArrayList<PFLocale>();
        if (arrayList.size() > 0) {
            object2.add(new PFLocale());
            for (int i = 0; i < arrayList.size(); ++i) {
                int n;
                boolean bl;
                string = (String)arrayList.get(i);
                boolean bl2 = bl = !string.substring(n = string.indexOf(LANG_PROP_PREFIX) + LANG_PROP_PREFIX.length(), n + 1).equals("_");
                if (bl || (object = PFLocale.createPFLocale(string.substring(n + 1, string.length() - ".properties".length()))) == null) continue;
                object2.add(object);
            }
        }
        return object2;
    }

    public static void copyFile(String string, String string2) {
        try {
            FileChannel fileChannel = new FileInputStream(string).getChannel();
            FileChannel fileChannel2 = new FileOutputStream(string2).getChannel();
            fileChannel2.transferFrom(fileChannel, 0L, fileChannel.size());
            fileChannel.close();
            fileChannel2.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void showEAS(ExtendedAttributes extendedAttributes) {
        System.err.println("ExtendedAttributes, el = " + extendedAttributes + ", there are " + extendedAttributes.size() + " eas");
        Iterator iterator = extendedAttributes.toElements().iterator();
        while (iterator.hasNext()) {
            System.err.println();
            Utils.showEA((ExtendedAttribute)iterator.next());
        }
    }

    public static void showEA(ExtendedAttribute extendedAttribute) {
        System.err.println("ExtendedAttribute, el = " + extendedAttribute);
        System.err.println("ExtendedAttribute.name), el = " + extendedAttribute.get("Name"));
        System.err.println("ExtendedAttribute.value), el = " + extendedAttribute.get("Value"));
        System.err.println();
    }

    public static String getActivityStringType(int n) {
        String string = "";
        switch (n) {
            case 1: {
                string = "ACTIVITY_NO";
                break;
            }
            case 2: {
                string = "ACTIVITY_TASK_APPLICATION";
                break;
            }
            case 12: {
                string = "ACTIVITY_TASK_SCRIPT";
                break;
            }
            case 4: {
                string = "ACTIVITY_BLOCK";
                break;
            }
            case 0: {
                string = "ACTIVITY_ROUTE";
                break;
            }
            case 3: {
                string = "ACTIVITY_SUBFLOW";
            }
        }
        return string;
    }

    public static String getArtifactStringType(String string) {
        String string2 = "";
        if (string.equals("Annotation")) {
            string2 = "ARTIFACT_ANNOTATION";
        } else if (string.equals("DataObject")) {
            string2 = "ARTIFACT_DATA_OBJECT";
        }
        return string2;
    }

    public static List sortValidationErrorList(List list) {
        ArrayList arrayList = new ArrayList();
        Map map = JaWEManager.getInstance().getXPDLValidator().getExtPkgValidationErrors();
        for (List object : map.values()) {
            list.removeAll(object);
        }
        arrayList.addAll(Utils.sortValidationErrorList(list, JaWEManager.getInstance().getJaWEController().getMainPackage()));
        for (Map.Entry entry : map.entrySet()) {
            Package package_ = (Package)entry.getKey();
            List list2 = (List)entry.getValue();
            arrayList.addAll(Utils.sortValidationErrorList(list2, package_));
        }
        return arrayList;
    }

    public static List sortValidationErrorList(List list, Package package_) {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(Utils.findErrorList(list, Package.class, "SCHEMA"));
        arrayList.addAll(Utils.findErrorList(list, package_, "LOGIC"));
        arrayList.addAll(Utils.findErrorListParent(list, package_));
        arrayList.addAll(Utils.findErrorListParent(list, package_.getTypeDeclarations()));
        arrayList.addAll(Utils.findErrorListParent(list, package_.getApplications()));
        arrayList.addAll(Utils.findErrorListParent(list, package_.getParticipants()));
        arrayList.addAll(Utils.findErrorListParent(list, package_.getDataFields()));
        for (Application application : package_.getApplications().toElements()) {
            arrayList.addAll(Utils.findErrorListParent(list, application.getApplicationTypes().getFormalParameters()));
        }
        for (Application application : package_.getWorkflowProcesses().toElements()) {
            arrayList.addAll(Utils.findErrorList(list, application));
        }
        for (Application application : package_.getWorkflowProcesses().toElements()) {
            for (ActivitySet activitySet : application.getActivitySets().toElements()) {
                arrayList.addAll(Utils.findErrorList(list, activitySet));
            }
        }
        for (Application application : package_.getWorkflowProcesses().toElements()) {
            arrayList.addAll(Utils.findErrorListParent(list, application.getApplications()));
            arrayList.addAll(Utils.findErrorListParent(list, application.getParticipants()));
            arrayList.addAll(Utils.findErrorListParent(list, application.getDataFields()));
            arrayList.addAll(Utils.findErrorListParent(list, application.getFormalParameters()));
            for (ActivitySet activitySet : application.getApplications().toElements()) {
                arrayList.addAll(Utils.findErrorListParent(list, activitySet.getApplicationTypes().getFormalParameters()));
            }
            for (ActivitySet activitySet : application.getActivitySets().toElements()) {
                for (Activity activity : activitySet.getActivities().toElements()) {
                    arrayList.addAll(Utils.findErrorList(list, activity));
                }
                for (Activity activity : activitySet.getTransitions().toElements()) {
                    arrayList.addAll(Utils.findErrorList(list, activity));
                }
            }
            for (ActivitySet activitySet : application.getActivities().toElements()) {
                arrayList.addAll(Utils.findErrorList(list, activitySet));
            }
            for (ActivitySet activitySet : application.getTransitions().toElements()) {
                arrayList.addAll(Utils.findErrorList(list, activitySet));
            }
        }
        list.removeAll(arrayList);
        arrayList.addAll(list);
        return arrayList;
    }

    public static List findErrorList(List list, Object object, String string) {
        ArrayList<ValidationError> arrayList = new ArrayList<ValidationError>();
        for (int i = 0; i < list.size(); ++i) {
            ValidationError validationError = (ValidationError)list.get(i);
            if (!validationError.getSubType().equals(string) || validationError.getElement() != object) continue;
            arrayList.add(validationError);
        }
        return arrayList;
    }

    public static List findErrorList(List list, Object object) {
        ArrayList<ValidationError> arrayList = new ArrayList<ValidationError>();
        for (int i = 0; i < list.size(); ++i) {
            ValidationError validationError = (ValidationError)list.get(i);
            if (validationError.getElement() != object) continue;
            arrayList.add(validationError);
        }
        return arrayList;
    }

    public static List findErrorList(List list, Class clazz) {
        ArrayList<ValidationError> arrayList = new ArrayList<ValidationError>();
        for (int i = 0; i < list.size(); ++i) {
            ValidationError validationError = (ValidationError)list.get(i);
            if (validationError.getElement().getClass() != clazz) continue;
            arrayList.add(validationError);
        }
        return arrayList;
    }

    public static List findErrorList(List list, Class clazz, String string) {
        ArrayList<ValidationError> arrayList = new ArrayList<ValidationError>();
        for (int i = 0; i < list.size(); ++i) {
            ValidationError validationError = (ValidationError)list.get(i);
            if (!validationError.getSubType().equals(string) || validationError.getElement().getClass() != clazz) continue;
            arrayList.add(validationError);
        }
        return arrayList;
    }

    public static List findErrorListParent(List list, Object object) {
        ArrayList<ValidationError> arrayList = new ArrayList<ValidationError>();
        for (int i = 0; i < list.size(); ++i) {
            ValidationError validationError = (ValidationError)list.get(i);
            if (validationError.getElement().getParent() != object) continue;
            arrayList.add(validationError);
        }
        return arrayList;
    }

    public static int countErrors(List list) {
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            ValidationError validationError = (ValidationError)list.get(i);
            if (!validationError.getType().equalsIgnoreCase("ERROR")) continue;
            ++n;
        }
        return n;
    }

    public static boolean showExternalDocument(String string) {
        if (!new File(string).canRead()) {
            return false;
        }
        String string2 = System.getProperty("path.to.start");
        if (null != string2) {
            if (!new File(string2).canRead()) {
                return false;
            }
            if (System.getProperty("path.separator").equals(";")) {
                string = "\"" + string + "\"";
            }
        } else if (System.getProperty("path.separator").equals(":")) {
            string2 = "kfmclient exec";
        } else {
            string2 = "cmd /c start";
            string = "\"" + string + "\"" + " \"" + string + "\"";
        }
        try {
            Runtime.getRuntime().exec(string2 + " " + string);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
        return true;
    }

    public static XMLElement getLocation(XMLElement xMLElement) {
        Activity activity = XMLUtil.getActivity((XMLElement)xMLElement);
        if (activity == null) {
            activity = XMLUtil.getTransition((XMLElement)xMLElement);
        }
        if (activity == null) {
            activity = XMLUtil.getArtifact((XMLElement)xMLElement);
        }
        if (activity == null) {
            activity = XMLUtil.getAssociation((XMLElement)xMLElement);
        }
        if (activity == null) {
            activity = XMLUtil.getParentElement(TypeDeclaration.class, (XMLElement)xMLElement);
        }
        if (activity == null) {
            activity = XMLUtil.getParentElement(FormalParameter.class, (XMLElement)xMLElement);
        }
        if (activity == null) {
            activity = XMLUtil.getParentElement(Application.class, (XMLElement)xMLElement);
        }
        if (activity == null) {
            activity = XMLUtil.getParentElement(Participant.class, (XMLElement)xMLElement);
        }
        if (activity == null) {
            activity = XMLUtil.getParentElement(DataField.class, (XMLElement)xMLElement);
        }
        ActivitySet activitySet = XMLUtil.getActivitySet((XMLElement)xMLElement);
        if (activity == null) {
            activity = activitySet;
        }
        WorkflowProcess workflowProcess = XMLUtil.getWorkflowProcess((XMLElement)xMLElement);
        if (activity == null) {
            activity = workflowProcess;
        }
        Package package_ = XMLUtil.getPackage((XMLElement)xMLElement);
        if (activity == null) {
            activity = package_;
        }
        return activity;
    }

    public static String getLocString(XMLElement xMLElement, XMLElement xMLElement2) {
        ActivitySet activitySet = XMLUtil.getActivitySet((XMLElement)xMLElement2);
        WorkflowProcess workflowProcess = XMLUtil.getWorkflowProcess((XMLElement)xMLElement2);
        Package package_ = XMLUtil.getPackage((XMLElement)xMLElement2);
        String string = ResourceManager.getLanguageDependentString("PackageKey") + " '" + package_.getId() + "'";
        if (workflowProcess != null) {
            string = string + ", " + ResourceManager.getLanguageDependentString("WorkflowProcessKey") + " '" + workflowProcess.getId() + "'";
        }
        if (activitySet != null) {
            string = string + ", " + ResourceManager.getLanguageDependentString("ActivitySetKey") + " '" + activitySet.getId() + "'";
        }
        if (xMLElement != activitySet && xMLElement != workflowProcess && xMLElement != package_) {
            string = string + ", " + ResourceManager.getLanguageDependentString(xMLElement.toName() + "Key") + " '" + ((XMLComplexElement)xMLElement).get("Id").toValue() + "'";
        }
        if (xMLElement2 != xMLElement && xMLElement2 != activitySet && xMLElement2 != workflowProcess && xMLElement2 != package_) {
            XMLElement xMLElement3 = xMLElement2.getParent();
            if (xMLElement3 != xMLElement && !(xMLElement3 instanceof XMLCollection)) {
                string = string + ", " + ResourceManager.getLanguageDependentString(xMLElement3.toName() + "Key");
            }
            string = string + " -> " + ResourceManager.getLanguageDependentString(xMLElement2.toName() + "Key");
        }
        return string;
    }

    public static List makeSearchResultList(List list) {
        ArrayList<SearchResult> arrayList = new ArrayList<SearchResult>();
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(new SearchResult((XMLElement)list.get(i)));
        }
        return arrayList;
    }

    public static Map loadActions(Properties properties, JaWEComponent jaWEComponent) {
        return Utils.loadActions(properties, jaWEComponent, new HashMap());
    }

    public static Map loadActions(Properties properties, JaWEComponent jaWEComponent, Map map) {
        HashMap<String, JaWEAction> hashMap = new HashMap<String, JaWEAction>();
        HashSet hashSet = new HashSet();
        List list = ResourceManager.getResourceStrings(properties, "Action.Name.", false);
        List list2 = ResourceManager.getResourceStrings(properties, "Action.Class.", false);
        List list3 = ResourceManager.getResourceStrings(properties, "Action.Image.", false);
        hashSet.addAll(list);
        hashSet.addAll(list2);
        hashSet.addAll(list3);
        for (String string : hashSet) {
            try {
                Object object;
                Object object2;
                JaWEAction jaWEAction = map.containsKey(string) ? (JaWEAction)map.get(string) : new JaWEAction();
                try {
                    object2 = ResourceManager.getResourceString(properties, "Action.Class." + string);
                    object = Class.forName((String)object2).getConstructor(JaWEComponent.class);
                    ActionBase actionBase = (ActionBase)((Constructor)object).newInstance(jaWEComponent);
                    jaWEAction.setAction(actionBase);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    object2 = ResourceManager.getResource(properties, "Action.Image." + string);
                    object = null;
                    if (object2 != null) {
                        object = new ImageIcon((URL)object2);
                    }
                    jaWEAction.setIcon((ImageIcon)object);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    object2 = ResourceManager.getResourceString(properties, "Action.Name." + string);
                    jaWEAction.setLangDepName((String)object2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (jaWEAction.getAction() != null) {
                    hashMap.put(string, jaWEAction);
                    JaWEManager.getInstance().getLoggingManager().info("Created " + jaWEComponent.getName() + " action for class " + string);
                    continue;
                }
                JaWEManager.getInstance().getLoggingManager().info("Missing action for " + string);
            }
            catch (Throwable throwable) {
                JaWEManager.getInstance().getLoggingManager().error("Can't create " + jaWEComponent.getName() + " action for class " + string);
            }
        }
        return hashMap;
    }

    public static Map loadAllMenusAndToolbars(Properties properties) {
        Map map = new HashMap();
        map = Utils.loadSubMenus(properties);
        map.putAll(Utils.loadPopups(properties));
        map.putAll(Utils.loadToolbars(properties));
        return map;
    }

    public static Map loadSubMenus(Properties properties) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        List list = ResourceManager.getResourceStrings(properties, "SubMenu.Name.", false);
        for (int i = 0; i < list.size(); ++i) {
            String string = ResourceManager.getResourceString(properties, "SubMenu.ActionOrder." + list.get(i));
            String string2 = ResourceManager.getResourceString(properties, "SubMenu.Name." + list.get(i));
            hashMap.put(list.get(i) + "Menu", string);
            hashMap.put(list.get(i) + "LangName", string2);
        }
        return hashMap;
    }

    public static Map loadToolbars(Properties properties) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        List list = ResourceManager.getResourceStrings(properties, "Toolbar.ActionOrder.", false);
        for (int i = 0; i < list.size(); ++i) {
            String string = ResourceManager.getResourceString(properties, "Toolbar.ActionOrder." + list.get(i));
            hashMap.put(list.get(i) + "Toolbar", string);
        }
        return hashMap;
    }

    public static Map loadPopups(Properties properties) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        List list = ResourceManager.getResourceStrings(properties, "PopupMenu.ActionOrder.", false);
        for (int i = 0; i < list.size(); ++i) {
            String string = ResourceManager.getResourceString(properties, "PopupMenu.ActionOrder." + list.get(i));
            hashMap.put(list.get(i) + "Menu", string);
        }
        return hashMap;
    }

    public static List getActivityIconNamesList() {
        if (actImgResources == null) {
            Utils.getActivityIconsMap();
        }
        return new ArrayList(actImgResourceNames);
    }

    public static SequencedHashMap getOriginalActivityIconsMap() {
        if (actImgResources == null) {
            Utils.getActivityIconsMap();
        }
        return actImgResources;
    }

    public static SequencedHashMap getActivityIconsMap() {
        if (actImgResources == null) {
            String string;
            int n;
            HashMap hashMap = new HashMap();
            String string2 = System.getProperty("java.class.path");
            String[] stringArray = XMLUtil.tokenize((String)string2, (String)File.pathSeparator);
            String string3 = System.getProperty("java.ext.dirs");
            String[] stringArray2 = XMLUtil.tokenize((String)string3, (String)File.pathSeparator);
            for (n = 0; n < stringArray.length; ++n) {
                string = stringArray[n];
                if (string.indexOf("activityicons") < 0) continue;
                hashMap.putAll(Utils.getResourcesForPath(string, "org/enhydra/jawe/activityicons"));
            }
            for (n = 0; n < stringArray2.length; ++n) {
                File[] fileArray;
                string = stringArray2[n];
                File file = new File(string);
                if (!file.exists() || !file.isDirectory() || (fileArray = file.listFiles()) == null) continue;
                for (int i = 0; i < fileArray.length; ++i) {
                    if (!fileArray[i].isFile() || fileArray[i].getName().indexOf("activityicons") < 0) continue;
                    hashMap.putAll(Utils.getResourcesForPath(fileArray[i].getAbsolutePath(), "org/enhydra/jawe/activityicons"));
                }
            }
            actImgResources = new SequencedHashMap();
            actImgResourceNames = new ArrayList(hashMap.keySet());
            Collections.sort(actImgResourceNames);
            for (n = 0; n < actImgResourceNames.size(); ++n) {
                string = actImgResourceNames.get(n);
                actImgResources.put((Object)string, hashMap.get(string));
            }
        }
        return new SequencedHashMap((Map)actImgResources);
    }

    public static Map getResourcesForPath(String string, String string2) {
        HashMap<String, ImageIcon> hashMap;
        block13: {
            block12: {
                hashMap = new HashMap<String, ImageIcon>();
                if (!string.endsWith(".jar")) break block12;
                JarFile jarFile = null;
                try {
                    jarFile = new JarFile(string, false);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    return hashMap;
                }
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    try {
                        String string3;
                        ZipEntry zipEntry = enumeration.nextElement();
                        String string4 = string3 = zipEntry.getName();
                        if (string4.startsWith("/")) {
                            string4 = string4.substring(1);
                        }
                        if (!string3.startsWith(string2)) continue;
                        ImageIcon imageIcon = null;
                        try {
                            imageIcon = new ImageIcon(Utils.class.getClassLoader().getResource(string3));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (imageIcon == null) continue;
                        if ((string4 = string4.substring(string2.length())).startsWith("/")) {
                            string4 = string4.substring(1);
                        }
                        if (string4.length() <= 0) continue;
                        hashMap.put(string4, imageIcon);
                    }
                    catch (Throwable throwable) {}
                }
                break block13;
            }
            File file = new File(string + "/" + string2);
            if (!file.exists() || !file.isDirectory()) break block13;
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isFile()) continue;
                String string5 = fileArray[i].getName();
                ImageIcon imageIcon = null;
                try {
                    imageIcon = new ImageIcon(Utils.class.getClassLoader().getResource(string2 + "/" + string5));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (imageIcon == null) continue;
                hashMap.put(string5, imageIcon);
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean reconfigure(String string) {
        JaWEController jaWEController = JaWEManager.getInstance().getJaWEController();
        String string2 = JaWEConstants.JAWE_CONF_HOME + "/defaultconfig";
        File file = new File(string2);
        if (!file.exists()) {
            return false;
        }
        File file2 = new File(JaWEConstants.JAWE_CONF_HOME + "/temp");
        WaitScreen waitScreen = new WaitScreen(null);
        try {
            file2.createNewFile();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
            String string3 = null;
            boolean bl = false;
            while ((string3 = bufferedReader.readLine()) != null) {
                if (!bl && (string3.startsWith("#JaWE_CURRENT_CONFIG_HOME") || string3.startsWith("JaWE_CURRENT_CONFIG_HOME"))) {
                    string3 = "JaWE_CURRENT_CONFIG_HOME = " + string;
                    bl = true;
                }
                bufferedWriter.write(string3 + "\n");
            }
            bufferedReader.close();
            bufferedWriter.close();
            file.delete();
            file2.renameTo(file);
            System.setProperty("JaWE_CURRENT_CONFIG_HOME", JaWEConstants.JAWE_CONF_HOME + "/" + string);
            String string4 = jaWEController.getPackageFilename(jaWEController.getMainPackageId());
            jaWEController.tryToClosePackage(jaWEController.getMainPackageId(), true);
            waitScreen.show(null, "", jaWEController.getSettings().getLanguageDependentString("ReconfiguringKey"));
            JaWEManager.getInstance().restart(string4);
            waitScreen.setVisible(false);
            boolean bl2 = true;
            return bl2;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            waitScreen.setVisible(false);
        }
    }

    public static String getCallerMethodName(int n) {
        Throwable throwable = new Throwable();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        if (stackTraceElementArray.length >= (n += 2) + 1) {
            return stackTraceElementArray[n].getMethodName();
        }
        return "";
    }
}

