/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.enhydra.jawe.ChoiceButton;
import org.enhydra.jawe.ChoiceButtonListener;
import org.enhydra.jawe.CombinedIcon;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jxpdl.XMLComplexElement;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.utilities.SequencedHashMap;

public class XMLElementChoiceButton
extends ChoiceButton
implements ActionListener {
    private static int MODE_NONE = 0;
    private static int MODE_LONG_LIST = 1;
    private static int MODE_SHORT_LIST = 2;
    private static int MIN_LIST_SIZE = 30;
    protected ChoiceButtonListener parent;
    protected int lastMode = MODE_NONE;
    protected SequencedHashMap choiceMap = new SequencedHashMap();
    protected JPopupMenu popup = new JPopupMenu();
    protected JTextField filterField = new JTextField();
    protected FilteredListModel filterModel = new FilteredListModel();
    protected JList longList;
    protected Class choiceType;
    protected String[] filterDatas;
    protected ImageIcon defIcon = null;
    protected boolean alwaysUseDefaultIcon = true;
    protected static Icon select;

    public XMLElementChoiceButton(Class clazz, ChoiceButtonListener choiceButtonListener, ImageIcon imageIcon, boolean bl) {
        this(clazz, choiceButtonListener, imageIcon, bl, null);
    }

    public XMLElementChoiceButton(Class clazz, ChoiceButtonListener choiceButtonListener, ImageIcon imageIcon, boolean bl, String[] stringArray) {
        this.parent = choiceButtonListener;
        this.choiceType = clazz;
        this.filterDatas = stringArray;
        this.defIcon = imageIcon;
        this.alwaysUseDefaultIcon = bl;
        this.setIcon(imageIcon);
        this.addActionListener(this);
        this.setBorderPainted(false);
        this.setMargin(new Insets(1, 2, 1, 2));
        this.setSize(new Dimension(10, 8));
        this.setAlignmentY(0.5f);
        this.longList = new JList(this.filterModel){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                int n = this.locationToIndex(mouseEvent.getPoint());
                Object e = this.getModel().getElementAt(n);
                return XMLElementChoiceButton.this.getElementTooltipText((XMLElement)((Map.Entry)e).getValue());
            }
        };
        this.filterModel.setFilteredList(this.choiceMap.entrySet().toArray());
        this.filterField.getDocument().addDocumentListener(this.filterModel);
        this.filterField.addActionListener(this.filterModel);
        this.longList.setCellRenderer(new ChoiceButtonCellRenderer());
        this.longList.setVisibleRowCount(MIN_LIST_SIZE);
        this.longList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.getSource() == XMLElementChoiceButton.this.longList && (n = XMLElementChoiceButton.this.longList.locationToIndex(mouseEvent.getPoint())) >= 0) {
                    XMLElementChoiceButton.this.setSelectedItem(((Map.Entry)XMLElementChoiceButton.this.filterModel.getElementAt(n)).getValue());
                }
            }
        });
        this.longList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                Object e = XMLElementChoiceButton.this.longList.getSelectedValue();
                if (keyEvent.getKeyCode() == 10 && e != null) {
                    XMLElementChoiceButton.this.setSelectedItem(((Map.Entry)e).getValue());
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this) {
            this.refresh();
            if (this.choiceMap.size() > 0) {
                this.popup.show(this.getParent(), this.getX(), this.getY() + this.getHeight());
                this.filterField.grabFocus();
            }
        } else {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            int n = this.popup.getComponentIndex(jMenuItem);
            Object object = this.choiceMap.getValue(n);
            this.setSelectedItem(object);
        }
    }

    private void setSelectedItem(Object object) {
        this.parent.selectionChanged(this, object);
        this.choiceMap.clear();
        this.popup.setVisible(false);
        this.setObjectIcon(object);
    }

    public void setObjectIcon(Object object) {
        if (object instanceof XMLElement && !this.alwaysUseDefaultIcon) {
            ImageIcon imageIcon = JaWEManager.getInstance().getJaWEController().getTypeResolver().getJaWEType((XMLElement)object).getIcon();
            if (imageIcon == null) {
                imageIcon = this.defIcon;
            } else if (select != null) {
                imageIcon = new CombinedIcon(imageIcon, select, 1);
            }
            this.setIcon(imageIcon);
        }
    }

    protected void refresh() {
        Object object;
        Object object2;
        this.choiceMap.clear();
        List list = this.parent.getChoices(this);
        if (list != null) {
            for (XMLElement xMLElement : list) {
                object2 = " " + JaWEManager.getInstance().getDisplayNameGenerator().getDisplayName(xMLElement) + " ";
                if (this.choiceMap.containsKey(object2) && xMLElement instanceof XMLComplexElement) {
                    XMLElement xMLElement2 = ((XMLComplexElement)xMLElement).get("Id");
                    object2 = (String)object2 + "[" + ResourceManager.getLanguageDependentString("IdKey") + "=" + xMLElement2.toValue() + "] ";
                }
                this.choiceMap.put(object2, (Object)xMLElement);
            }
        }
        if (this.choiceMap.size() >= MIN_LIST_SIZE) {
            this.filterModel.setFilteredList(this.choiceMap.entrySet().toArray());
            if (this.lastMode != MODE_LONG_LIST) {
                this.popup.removeAll();
                this.filterField.setText("");
                object = new JScrollPane(this.longList);
                this.popup.add(this.filterField);
                this.popup.add((Component)object);
            }
            this.lastMode = MODE_LONG_LIST;
        } else if (this.choiceMap.size() > 0) {
            this.popup.removeAll();
            object = new String[this.choiceMap.size()];
            this.choiceMap.keySet().toArray((T[])object);
            for (int i = 0; i < this.choiceMap.size(); ++i) {
                object2 = new JMenuItem(object[i]);
                ((JComponent)object2).setToolTipText(this.getElementTooltipText((XMLElement)this.choiceMap.get((Object)object[i])));
                this.popup.add((JMenuItem)object2);
                ((AbstractButton)object2).addActionListener(this);
            }
            this.lastMode = MODE_SHORT_LIST;
        }
    }

    @Override
    public Class getChoiceType() {
        return this.choiceType;
    }

    private String getElementTooltipText(XMLElement xMLElement) {
        return JaWEManager.getInstance().getTooltipGenerator().getTooltip(xMLElement);
    }

    static {
        try {
            select = new ImageIcon(XMLElementChoiceButton.class.getClassLoader().getResource("org/enhydra/jawe/images/select_icon_small.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class FilteredListModel
    extends AbstractListModel
    implements DocumentListener,
    ActionListener {
        private ArrayList fullList = new ArrayList();
        private ArrayList filteredList = new ArrayList();
        private ArrayList rejectedList = new ArrayList();
        private String key;

        private FilteredListModel() {
        }

        public void setFilteredList(Object[] objectArray) {
            this.fullList.clear();
            this.filteredList.clear();
            for (int i = 0; i < objectArray.length; ++i) {
                this.fullList.add((Map.Entry)objectArray[i]);
            }
            this.filteredList.addAll(this.fullList);
            if (this.key != null) {
                this.filter(this.key);
            }
        }

        public int getFilterSize() {
            return this.filteredList.size();
        }

        @Override
        public int getSize() {
            return this.fullList.size();
        }

        @Override
        public Object getElementAt(int n) {
            if (n >= 0) {
                if (n < this.filteredList.size()) {
                    return this.filteredList.get(n);
                }
                if (n < this.fullList.size()) {
                    return this.rejectedList.get(n - this.filteredList.size());
                }
            }
            return null;
        }

        private boolean match(String string, XMLElement xMLElement) {
            String string2;
            if (XMLElementChoiceButton.this.filterDatas != null && XMLElementChoiceButton.this.filterDatas.length > 0 && xMLElement instanceof XMLComplexElement) {
                string2 = (XMLComplexElement)xMLElement;
                for (int i = 0; i < XMLElementChoiceButton.this.filterDatas.length; ++i) {
                    String string3;
                    XMLElement xMLElement2 = string2.get(XMLElementChoiceButton.this.filterDatas[i].toString());
                    if (xMLElement2 == null || (string3 = xMLElement2.toValue()) == null || string3.toLowerCase().indexOf(string) < 0) continue;
                    return true;
                }
            }
            return (string2 = xMLElement.toValue()) != null && string2.toLowerCase().indexOf(string) >= 0;
        }

        private boolean splitAndMatch(String string, XMLElement xMLElement) {
            string = string.toLowerCase().trim();
            String[] stringArray = string.split("\\s");
            for (int i = 0; i < stringArray.length; ++i) {
                if (this.match(stringArray[i], xMLElement)) continue;
                return false;
            }
            return string.length() > 0;
        }

        public void filter(String string) {
            this.key = string;
            this.filteredList.clear();
            this.rejectedList.clear();
            for (Map.Entry entry : this.fullList) {
                XMLElement xMLElement = (XMLElement)entry.getValue();
                if (this.splitAndMatch(string, xMLElement)) {
                    this.filteredList.add(entry);
                    continue;
                }
                this.rejectedList.add(entry);
            }
            this.fireContentsChanged(this, 0, this.getSize());
        }

        private void updateFilter(Document document) {
            try {
                String string = document.getText(0, document.getLength());
                this.filter(string);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.updateFilter(documentEvent.getDocument());
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateFilter(documentEvent.getDocument());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.filteredList.size() == 1) {
                XMLElementChoiceButton.this.longList.setSelectedIndex(0);
            }
        }
    }

    private class ChoiceButtonCellRenderer
    extends JLabel
    implements ListCellRenderer {
        Font bold;
        Font normal;

        public ChoiceButtonCellRenderer() {
            Font font = this.getFont();
            this.bold = font.deriveFont(font.getStyle() | 1);
            this.normal = font.deriveFont(font.getStyle() & 0xFFFFFFFE);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = ((Map.Entry)object).getKey().toString();
            this.setText(string);
            this.setOpaque(true);
            if (bl) {
                this.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.BLACK));
            } else if (n == XMLElementChoiceButton.this.filterModel.getFilterSize() && n > 0) {
                this.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.red));
            } else {
                this.setBorder(null);
            }
            if (n >= XMLElementChoiceButton.this.filterModel.getFilterSize() || XMLElementChoiceButton.this.filterModel.getFilterSize() == XMLElementChoiceButton.this.filterModel.getSize()) {
                if (bl) {
                    this.setBackground(jList.getForeground());
                    this.setForeground(jList.getBackground());
                } else {
                    this.setBackground(jList.getBackground());
                    this.setForeground(jList.getForeground());
                }
            } else if (bl) {
                this.setBackground(jList.getSelectionForeground());
                this.setForeground(jList.getSelectionBackground());
            } else {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            }
            if (bl) {
                this.setFont(this.bold);
            } else {
                this.setFont(this.normal);
            }
            return this;
        }
    }
}

