/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.base.controller;

import java.awt.Window;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.nio.channels.FileLock;
import java.nio.channels.NonWritableChannelException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.enhydra.jawe.BuildInfo;
import org.enhydra.jawe.ChoiceButton;
import org.enhydra.jawe.ChoiceButtonListener;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEComponentSettings;
import org.enhydra.jawe.JaWEComponentView;
import org.enhydra.jawe.JaWEConstants;
import org.enhydra.jawe.JaWEEAHandler;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.JaWEXMLUtil;
import org.enhydra.jawe.UndoHistoryManager;
import org.enhydra.jawe.Utils;
import org.enhydra.jawe.WaitScreen;
import org.enhydra.jawe.XPDLElementChangeInfo;
import org.enhydra.jawe.XPDLListenerAndObservable;
import org.enhydra.jawe.base.controller.ControllerSettings;
import org.enhydra.jawe.base.controller.JaWEActions;
import org.enhydra.jawe.base.controller.JaWEEdit;
import org.enhydra.jawe.base.controller.JaWEFrame;
import org.enhydra.jawe.base.controller.JaWESelectionManager;
import org.enhydra.jawe.base.controller.JaWEType;
import org.enhydra.jawe.base.controller.JaWETypeChoiceButton;
import org.enhydra.jawe.base.controller.JaWETypeResolver;
import org.enhydra.jawe.base.controller.JaWETypes;
import org.enhydra.jawe.base.xpdlhandler.XPDLHandler;
import org.enhydra.jawe.base.xpdlobjectfactory.XPDLObjectFactory;
import org.enhydra.jawe.base.xpdlvalidator.ValidationError;
import org.enhydra.jxpdl.Path;
import org.enhydra.jxpdl.StandardPackageValidator;
import org.enhydra.jxpdl.XMLAttribute;
import org.enhydra.jxpdl.XMLCollection;
import org.enhydra.jxpdl.XMLCollectionElement;
import org.enhydra.jxpdl.XMLComplexElement;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLElementChangeInfo;
import org.enhydra.jxpdl.XMLInterface;
import org.enhydra.jxpdl.XMLUtil;
import org.enhydra.jxpdl.XMLValidationError;
import org.enhydra.jxpdl.elements.Activities;
import org.enhydra.jxpdl.elements.Activity;
import org.enhydra.jxpdl.elements.ActivitySet;
import org.enhydra.jxpdl.elements.ActivitySets;
import org.enhydra.jxpdl.elements.ActivityTypes;
import org.enhydra.jxpdl.elements.Application;
import org.enhydra.jxpdl.elements.Applications;
import org.enhydra.jxpdl.elements.Artifact;
import org.enhydra.jxpdl.elements.Artifacts;
import org.enhydra.jxpdl.elements.Associations;
import org.enhydra.jxpdl.elements.ConnectorGraphicsInfo;
import org.enhydra.jxpdl.elements.ConnectorGraphicsInfos;
import org.enhydra.jxpdl.elements.DataField;
import org.enhydra.jxpdl.elements.DataFields;
import org.enhydra.jxpdl.elements.EnumerationValue;
import org.enhydra.jxpdl.elements.ExtendedAttribute;
import org.enhydra.jxpdl.elements.ExtendedAttributes;
import org.enhydra.jxpdl.elements.ExternalPackage;
import org.enhydra.jxpdl.elements.ExternalPackages;
import org.enhydra.jxpdl.elements.FormalParameter;
import org.enhydra.jxpdl.elements.FormalParameters;
import org.enhydra.jxpdl.elements.ImplementationTypes;
import org.enhydra.jxpdl.elements.Join;
import org.enhydra.jxpdl.elements.Lane;
import org.enhydra.jxpdl.elements.Lanes;
import org.enhydra.jxpdl.elements.Member;
import org.enhydra.jxpdl.elements.Namespace;
import org.enhydra.jxpdl.elements.Namespaces;
import org.enhydra.jxpdl.elements.NestedLane;
import org.enhydra.jxpdl.elements.NestedLanes;
import org.enhydra.jxpdl.elements.NodeGraphicsInfo;
import org.enhydra.jxpdl.elements.NodeGraphicsInfos;
import org.enhydra.jxpdl.elements.Package;
import org.enhydra.jxpdl.elements.Participant;
import org.enhydra.jxpdl.elements.Participants;
import org.enhydra.jxpdl.elements.Performers;
import org.enhydra.jxpdl.elements.Pool;
import org.enhydra.jxpdl.elements.Pools;
import org.enhydra.jxpdl.elements.Responsible;
import org.enhydra.jxpdl.elements.Responsibles;
import org.enhydra.jxpdl.elements.Split;
import org.enhydra.jxpdl.elements.TaskTypes;
import org.enhydra.jxpdl.elements.Transition;
import org.enhydra.jxpdl.elements.TransitionRef;
import org.enhydra.jxpdl.elements.TransitionRefs;
import org.enhydra.jxpdl.elements.TransitionRestriction;
import org.enhydra.jxpdl.elements.TransitionRestrictions;
import org.enhydra.jxpdl.elements.Transitions;
import org.enhydra.jxpdl.elements.TypeDeclaration;
import org.enhydra.jxpdl.elements.TypeDeclarations;
import org.enhydra.jxpdl.elements.WorkflowProcess;
import org.enhydra.jxpdl.elements.WorkflowProcesses;
import org.enhydra.jxpdl.utilities.SequencedHashMap;
import org.w3c.dom.Document;

public class JaWEController
extends Observable
implements Observer,
JaWEComponent,
ChoiceButtonListener {
    protected ControllerSettings settings;
    protected boolean undoableChangeInProgress = false;
    protected boolean updateInProgress = false;
    protected boolean updateSpecialInProgress = false;
    protected JaWEEdit edit = new JaWEEdit();
    protected JaWETypes jtypes;
    protected JaWETypeResolver jtypeResolver;
    protected List xpdlInfoList = new ArrayList();
    protected List xpdlListenerObservables = new ArrayList();
    protected JaWESelectionManager selectionMng;
    protected JaWEActions defaultJaWEActions;
    protected UndoHistoryManager undoHistoryManager;
    protected JaWEFrame frame;
    protected boolean jaweFrameShown = false;
    protected XPDLElementChangeInfo undoSelectionEvent = null;
    protected String currentConfig = null;
    protected Map configInfo;
    protected String appTitle;

    public JaWEController(ControllerSettings controllerSettings) {
        this.settings = controllerSettings;
        this.settings.init(this);
        this.appTitle = this.getSettings().getLanguageDependentString("DialogTitle");
        this.jtypes = new JaWETypes();
        this.jtypes.setPropertyMgr(controllerSettings.getPropertyMgr());
        this.jtypes.init(this);
    }

    @Override
    public void addObserver(Observer observer) {
        super.addObserver(observer);
        if (observer instanceof Observable) {
            ((Observable)((Object)observer)).addObserver(this);
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (this.updateInProgress) {
            JaWEManager.getInstance().getLoggingManager().warn("JaWEController -> this is nested event dispatch, because another one is in progress!");
            Thread.dumpStack();
            return;
        }
        if (!(object instanceof XMLElementChangeInfo) || ((XMLElementChangeInfo)object).getChangedElement() == null) {
            JaWEManager.getInstance().getLoggingManager().error("JaWEController -> Invalid arg " + object + " or element");
            Thread.dumpStack();
            return;
        }
        XPDLElementChangeInfo xPDLElementChangeInfo = !(object instanceof XPDLElementChangeInfo) ? new XPDLElementChangeInfo(this, (XMLElementChangeInfo)object) : (XPDLElementChangeInfo)((Object)object);
        if (object instanceof XPDLElementChangeInfo && xPDLElementChangeInfo.getSource() == this) {
            JaWEManager.getInstance().getLoggingManager().error("JaWEController -> Aborting update because JaWEController is a source!");
            Thread.dumpStack();
            return;
        }
        int n = xPDLElementChangeInfo.getAction();
        XMLElement xMLElement = xPDLElementChangeInfo.getChangedElement();
        if (xMLElement != null && xMLElement.getParent() instanceof Package && (n == 1 && xMLElement instanceof XMLAttribute && xMLElement.toName().equals("Id") || xMLElement.toName().equals("Name"))) {
            if (xMLElement.toName().equals("Id")) {
                this.changePackageId((Package)xMLElement.getParent(), (String)xPDLElementChangeInfo.getOldValue(), (String)xPDLElementChangeInfo.getNewValue());
            }
            this.updateTitle();
        }
        if (this.isUndoOrRedoInProgress()) {
            JaWEManager.getInstance().getLoggingManager().debug("JaWEController -> event " + (Object)((Object)xPDLElementChangeInfo) + " won't be taken into account while processing undo/redo actions!");
            return;
        }
        if (this.undoableChangeInProgress) {
            if (n != 3 && n != 5 && n != 1 && n != 7) {
                JaWEManager.getInstance().getLoggingManager().error("JaWEController -> event " + (Object)((Object)xPDLElementChangeInfo) + " won't be taken into account while processing undoable change action!");
                return;
            }
            this.xpdlInfoList.add(xPDLElementChangeInfo);
            return;
        }
        if (this.updateSpecialInProgress) {
            JaWEManager.getInstance().getLoggingManager().warn("JaWEController -> this is nested event dispatch, because another special update is in progress!");
            Thread.dumpStack();
            return;
        }
        this.updateInProgress = true;
        JaWEManager.getInstance().getLoggingManager().info("JaWEController -> normal update for event " + object + " started ...");
        if (n == 8) {
            JaWEManager.getInstance().getLoggingManager().error("JaWEController -> SELECTION event not sent from JaWEController! ");
            Thread.dumpStack();
            return;
        }
        this.clearHistory();
        this.setChanged();
        this.notifyObservers((Object)xPDLElementChangeInfo);
        JaWEManager.getInstance().getLoggingManager().info("JaWEController -> normal update ended");
        this.updateTitle();
        this.adjustActions();
        this.updateInProgress = false;
        if (this.settings.isDesingTimeValidationEnabled() && this.getMainPackage() != null && (n == 3 || n == 5 || n == 1 || n == 7)) {
            this.checkValidity(this.getMainPackage(), true, false, true);
        }
        this.handleEvent(xPDLElementChangeInfo);
    }

    @Override
    public JaWEComponentSettings getSettings() {
        return this.settings;
    }

    @Override
    public JaWEComponentView getView() {
        return this.getJaWEFrame();
    }

    @Override
    public String getName() {
        return "TogWE";
    }

    @Override
    public String getComponentType() {
        return "MAIN";
    }

    @Override
    public void setComponentType(String string) {
    }

    @Override
    public boolean adjustXPDL(Package package_) {
        boolean bl = JaWEManager.getInstance().getXPDLUtils().correctSplitsAndJoins(package_);
        if (JaWEManager.getInstance().getXPDLHandler().getXPDLRepositoryHandler().isXPDLPrefixEnabled()) {
            String string;
            Object object;
            ArrayList arrayList = package_.getNamespaces().toElements();
            boolean bl2 = false;
            for (int i = 0; i < arrayList.size(); ++i) {
                object = (Namespace)arrayList.get(i);
                string = object.getName();
                if (!string.equals("xpdl")) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                Namespaces namespaces = package_.getNamespaces();
                object = JaWEManager.getInstance().getXPDLObjectFactory();
                string = ((XPDLObjectFactory)object).createXPDLObject(namespaces, "", false);
                string.setName("xpdl");
                string.setLocation("http://www.wfmc.org/2008/XPDL2.1");
                namespaces.add((XMLElement)string);
                ((XPDLObjectFactory)object).adjustXPDLObject((XMLElement)package_, null);
                bl = true;
            }
        }
        for (JaWEComponent jaWEComponent : JaWEManager.getInstance().getComponentManager().getComponents()) {
            if (jaWEComponent == this) continue;
            bl = jaWEComponent.adjustXPDL(package_) || bl;
        }
        if (!JaWEEAHandler.getJaWEConfig(package_).equals(this.getCurrentConfig())) {
            JaWEEAHandler.setJaWEConfig(package_, this.getCurrentConfig());
            bl = true;
        }
        String string = BuildInfo.getVersion() + "-" + BuildInfo.getRelease() + "-" + BuildInfo.getBuildNo();
        if (!JaWEEAHandler.getEditingToolVersion(package_).equals(string)) {
            JaWEEAHandler.setEditingToolVersion(package_, string);
            bl = true;
        }
        if (!JaWEEAHandler.getEditingTool(package_).equals(JaWEManager.getInstance().getName())) {
            JaWEEAHandler.setEditingTool(package_, JaWEManager.getInstance().getName());
            bl = true;
        }
        if (JaWEEAHandler.removeOldPackageEAs(package_)) {
            bl = true;
        }
        if (JaWEEAHandler.adjustExternalPackageEAs(package_)) {
            bl = true;
        }
        return bl;
    }

    public boolean checkValidity(Package package_, boolean bl, boolean bl2, boolean bl3) {
        StandardPackageValidator standardPackageValidator = JaWEManager.getInstance().getXPDLValidator();
        standardPackageValidator.init((XMLInterface)JaWEManager.getInstance().getXPDLHandler(), XMLUtil.getPackage((XMLElement)package_), !bl2, this.settings.getEncoding(), JaWEManager.getInstance().getStartingLocale());
        List list = this.checkValidity((XMLElement)package_, bl);
        XPDLElementChangeInfo xPDLElementChangeInfo = this.createInfo((XMLElement)package_, list, 10);
        xPDLElementChangeInfo.setNewValue(new Boolean(bl2));
        xPDLElementChangeInfo.setOldValue(new Boolean(bl3));
        this.sendEvent(xPDLElementChangeInfo);
        return list == null || list.size() == 0;
    }

    @Override
    public List checkValidity(XMLElement xMLElement, boolean bl) {
        Object object;
        int n;
        StandardPackageValidator standardPackageValidator = JaWEManager.getInstance().getXPDLValidator();
        if (xMLElement == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        standardPackageValidator.validateElement(xMLElement, arrayList, bl);
        List<ValidationError> list = new ArrayList<ValidationError>();
        for (n = 0; n < arrayList.size(); ++n) {
            object = new ValidationError((XMLValidationError)arrayList.get(n));
            list.add((ValidationError)object);
        }
        arrayList.clear();
        n = list.size() == 0 ? 1 : 0;
        object = new ArrayList();
        if (n != 0 || bl) {
            for (JaWEComponent jaWEComponent : JaWEManager.getInstance().getComponentManager().getComponents()) {
                if (jaWEComponent == this) continue;
                List list2 = jaWEComponent.checkValidity(xMLElement, bl);
                int n2 = n = (list2 == null || list2.size() == 0) && n != 0 ? 1 : 0;
                if (list2 != null) {
                    object.addAll(list2);
                }
                if (n != 0 || bl) continue;
                break;
            }
        }
        list.addAll((Collection<ValidationError>)object);
        list = Utils.sortValidationErrorList(list, XMLUtil.getPackage((XMLElement)xMLElement));
        return list;
    }

    @Override
    public boolean canCreateElement(XMLCollection xMLCollection) {
        return this.canCreateElement(xMLCollection, true);
    }

    @Override
    public boolean canInsertElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return this.canInsertElement(xMLCollection, xMLElement, true);
    }

    @Override
    public boolean canModifyElement(XMLElement xMLElement) {
        return this.canModifyElement(xMLElement, true);
    }

    @Override
    public boolean canRemoveElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return this.canRemoveElement(xMLCollection, xMLElement, true);
    }

    @Override
    public boolean canDuplicateElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return this.canDuplicateElement(xMLCollection, xMLElement, true);
    }

    @Override
    public boolean canRepositionElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return this.canRepositionElement(xMLCollection, xMLElement, true);
    }

    @Override
    public void selectionChanged(ChoiceButton choiceButton, Object object) {
        if (choiceButton instanceof JaWETypeChoiceButton && ((JaWETypeChoiceButton)choiceButton).getXPDLChoiceType() != null && choiceButton.getChoiceType().equals(JaWEType.class)) {
            Class clazz;
            JaWEType jaWEType = (JaWEType)object;
            String string = null;
            if (jaWEType != null) {
                string = jaWEType.getTypeId();
            }
            if ((clazz = ((JaWETypeChoiceButton)choiceButton).getXPDLChoiceType()) == Package.class) {
                if (this.tryToClosePackage(this.getMainPackageId(), false)) {
                    this.newPackage(string);
                }
            } else {
                Package package_;
                this.startUndouableChange();
                ArrayList<Activity> arrayList = new ArrayList<Activity>();
                Activity activity = null;
                if (clazz == Activities.class || clazz == Activity.class) {
                    ActivitySet activitySet = this.selectionMng.getWorkingActivitySet();
                    WorkflowProcess workflowProcess = this.selectionMng.getWorkingProcess();
                    if (activitySet != null && !activitySet.isReadOnly()) {
                        activity = JaWEManager.getInstance().getXPDLObjectFactory().createXPDLObject(activitySet.getActivities(), string, true);
                    } else if (workflowProcess != null && !workflowProcess.isReadOnly()) {
                        activity = JaWEManager.getInstance().getXPDLObjectFactory().createXPDLObject(workflowProcess.getActivities(), string, true);
                    }
                } else if (clazz == ActivitySet.class || clazz == ActivitySets.class) {
                    WorkflowProcess workflowProcess = this.selectionMng.getWorkingProcess();
                    if (workflowProcess != null && !workflowProcess.isReadOnly()) {
                        activity = JaWEManager.getInstance().getXPDLObjectFactory().createXPDLObject(workflowProcess.getActivitySets(), string, true);
                    }
                } else if (clazz == Application.class || clazz == Applications.class) {
                    Package package_2 = this.selectionMng.getWorkingPKG();
                    if (package_2 != null && !package_2.isReadOnly()) {
                        activity = JaWEManager.getInstance().getXPDLObjectFactory().createXPDLObject(package_2.getApplications(), string, true);
                    }
                } else if (clazz == DataField.class || clazz == DataFields.class) {
                    Package package_3 = this.selectionMng.getWorkingPKG();
                    if (package_3 != null && !package_3.isReadOnly()) {
                        activity = JaWEManager.getInstance().getXPDLObjectFactory().createXPDLObject(package_3.getDataFields(), string, true);
                    }
                } else if (clazz == ExtendedAttribute.class || clazz == ExtendedAttributes.class) {
                    Package package_4 = this.selectionMng.getWorkingPKG();
                    if (package_4 != null && !package_4.isReadOnly()) {
                        activity = JaWEManager.getInstance().getXPDLObjectFactory().createXPDLObject(package_4.getExtendedAttributes(), string, true);
                    }
                } else if (clazz == FormalParameter.class || clazz == FormalParameters.class) {
                    WorkflowProcess workflowProcess = this.selectionMng.getWorkingProcess();
                    if (workflowProcess != null && !workflowProcess.isReadOnly()) {
                        activity = JaWEManager.getInstance().getXPDLObjectFactory().createXPDLObject(workflowProcess.getFormalParameters(), string, true);
                    }
                } else if (clazz == Namespace.class || clazz == Namespaces.class) {
                    Package package_5 = this.selectionMng.getWorkingPKG();
                    if (package_5 != null && !package_5.isReadOnly()) {
                        activity = JaWEManager.getInstance().getXPDLObjectFactory().createXPDLObject(package_5.getNamespaces(), string, true);
                    }
                } else if (clazz == Participant.class || clazz == Participants.class) {
                    Package package_6 = this.selectionMng.getWorkingPKG();
                    if (package_6 != null && !package_6.isReadOnly()) {
                        activity = JaWEManager.getInstance().getXPDLObjectFactory().createXPDLObject(package_6.getParticipants(), string, true);
                    }
                } else if (clazz == Responsible.class || clazz == Responsibles.class) {
                    Package package_7 = this.selectionMng.getWorkingPKG();
                    if (package_7 != null && !package_7.isReadOnly()) {
                        activity = JaWEManager.getInstance().getXPDLObjectFactory().createXPDLObject(package_7.getRedefinableHeader().getResponsibles(), string, true);
                    }
                } else if (clazz == Transition.class || clazz == Transitions.class) {
                    ActivitySet activitySet = this.selectionMng.getWorkingActivitySet();
                    WorkflowProcess workflowProcess = this.selectionMng.getWorkingProcess();
                    if (activitySet != null && !activitySet.isReadOnly()) {
                        activity = JaWEManager.getInstance().getXPDLObjectFactory().createXPDLObject(activitySet.getTransitions(), string, true);
                    } else if (workflowProcess != null && !workflowProcess.isReadOnly()) {
                        activity = JaWEManager.getInstance().getXPDLObjectFactory().createXPDLObject(workflowProcess.getTransitions(), string, true);
                    }
                } else if (clazz == TypeDeclaration.class || clazz == TypeDeclarations.class) {
                    Package package_8 = this.selectionMng.getWorkingPKG();
                    if (package_8 != null && !package_8.isReadOnly()) {
                        activity = JaWEManager.getInstance().getXPDLObjectFactory().createXPDLObject(package_8.getTypeDeclarations(), string, true);
                    }
                } else if (!(clazz != WorkflowProcess.class && clazz != WorkflowProcesses.class || (package_ = this.selectionMng.getWorkingPKG()) == null || package_.isReadOnly())) {
                    activity = JaWEManager.getInstance().getXPDLObjectFactory().createXPDLObject(package_.getWorkflowProcesses(), string, true);
                }
                if (activity != null) {
                    arrayList.add(activity);
                }
                this.endUndouableChange(arrayList);
            }
        } else {
            this.selectionMng.setSelection((XMLElement)object, true);
            this.updateTitle();
            this.adjustActions();
        }
    }

    @Override
    public Object getSelectedObject(ChoiceButton choiceButton) {
        return null;
    }

    @Override
    public List getChoices(ChoiceButton choiceButton) {
        ArrayList arrayList = new ArrayList();
        if (choiceButton instanceof JaWETypeChoiceButton) {
            Class clazz = ((JaWETypeChoiceButton)choiceButton).getXPDLChoiceType();
            Class clazz2 = ((JaWETypeChoiceButton)choiceButton).getXPDLChoiceTypeParentForEA();
            arrayList.addAll(this.jtypes.getTypes(clazz, clazz2));
        }
        return arrayList;
    }

    public void init() {
        String string;
        this.selectionMng = new JaWESelectionManager(this);
        try {
            string = this.getControllerSettings().undoHistoryManagerClass();
            if (string != null && !string.equals("")) {
                this.undoHistoryManager = (UndoHistoryManager)Class.forName(string).newInstance();
                this.undoHistoryManager.init(this.getControllerSettings().undoHistorySize());
            }
        }
        catch (Exception exception) {
            System.err.println("Failed to instantiate undo history manager!");
        }
        try {
            string = this.settings.getResolverTypeClassName();
            Constructor<?> constructor = Class.forName(string).getConstructor(JaWEController.class);
            this.jtypeResolver = (JaWETypeResolver)constructor.newInstance(this);
            JaWEManager.getInstance().getLoggingManager().info("JaWEController -> Working with '" + string + "' as type resolver");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            JaWEManager.getInstance().getLoggingManager().info("JaweManager -> Problems while instantiating type resolver! Using default!");
            this.jtypeResolver = new JaWETypeResolver(this);
        }
        this.defaultJaWEActions = new JaWEActions(this);
        this.defaultJaWEActions.init();
        this.settings.adjustActions();
        if (this.settings.useJaWEFrame()) {
            this.createJaWEFrame();
        }
        this.updateTitle();
        this.clearAll();
    }

    public void registerJaWEComponent(JaWEComponent jaWEComponent) {
        if (this.getJaWEFrame() != null) {
            JComponent jComponent = jaWEComponent.getView().getDisplay();
            String string = jaWEComponent.getName();
            String string2 = jaWEComponent.getComponentType();
            if (string2.equals("MAIN")) {
                this.getJaWEFrame().addMainComponent(string, jComponent);
            } else if (string2.equals("SPECIAL")) {
                this.getJaWEFrame().addToSpecialComponents(string, jComponent);
            } else if (string2.equals("TREE")) {
                this.getJaWEFrame().addToTreeComponents(string, jComponent);
            } else if (string2.equals("OTHER")) {
                this.getJaWEFrame().addToOtherComponents(string, jComponent);
            } else if (string2.equals("UPPER_STATUS")) {
                this.getJaWEFrame().addUpperStatusComponent(string, jComponent);
            } else if (string2.equals("LOWER_STATUS")) {
                this.getJaWEFrame().addLowerStatusComponent(string, jComponent);
            }
        }
    }

    public void removeJaWEComonent(JaWEComponent jaWEComponent) {
        if (this.getJaWEFrame() != null) {
            String string = jaWEComponent.getComponentType();
            JComponent jComponent = jaWEComponent.getView().getDisplay();
            if (string.equals("MAIN")) {
                this.getJaWEFrame().removeMainComponent(jComponent);
            } else if (string.equals("SPECIAL")) {
                this.getJaWEFrame().removeSpecialComponent(jComponent);
            } else if (string.equals("TREE")) {
                this.getJaWEFrame().removeTreeComponent(jComponent);
            } else if (string.equals("OTHER")) {
                this.getJaWEFrame().removeOtherComponent(jComponent);
            } else if (string.equals("UPPER_STATUS")) {
                this.getJaWEFrame().removeUpperStatusComponent(jComponent);
            } else if (string.equals("LOWER_STATUS")) {
                this.getJaWEFrame().removeLowerStatusComponent(jComponent);
            }
        }
    }

    public void changeJaWEComponentType(JaWEComponent jaWEComponent, String string) {
        if (this.getJaWEFrame() != null) {
            this.removeJaWEComonent(jaWEComponent);
            jaWEComponent.setComponentType(string);
            this.registerJaWEComponent(jaWEComponent);
        }
    }

    protected void createJaWEFrame() {
        this.frame = new JaWEFrame(this);
        this.frame.configure();
    }

    public void showJaWEFrame() {
        if (this.frame != null) {
            this.frame.setVisible(true);
            this.jaweFrameShown = true;
        }
    }

    public boolean isPackageModified(String string) {
        if (string == null) {
            string = this.getMainPackageId();
        }
        for (XPDLListenerAndObservable xPDLListenerAndObservable : this.xpdlListenerObservables) {
            if (xPDLListenerAndObservable.getPackage() == null || xPDLListenerAndObservable.getPackage().isReadOnly() || !xPDLListenerAndObservable.getPackage().getId().equals(string)) continue;
            return xPDLListenerAndObservable.isModified();
        }
        return false;
    }

    public Package getMainPackage() {
        return JaWEManager.getInstance().getXPDLHandler().getPackageById(this.getMainPackageId());
    }

    public String getMainPackageId() {
        XPDLHandler xPDLHandler = JaWEManager.getInstance().getXPDLHandler();
        String string = xPDLHandler.getMainPackageId();
        if (string == null && xPDLHandler.getAllPackageIds().size() > 0) {
            for (Package package_ : xPDLHandler.getAllPackages()) {
                if (package_.isTransient() || package_.isReadOnly()) continue;
                string = package_.getId();
                break;
            }
        }
        return string;
    }

    public String getPackageFilename(String string) {
        XPDLHandler xPDLHandler = JaWEManager.getInstance().getXPDLHandler();
        if (string == null) {
            string = this.getMainPackageId();
        }
        Package package_ = xPDLHandler.getPackageById(string);
        return xPDLHandler.getAbsoluteFilePath(package_);
    }

    public void changePackageFileName(Package package_, String string) {
        XPDLHandler xPDLHandler = JaWEManager.getInstance().getXPDLHandler();
        xPDLHandler.registerPackageFilename(string, package_);
    }

    public void newPackage(String string) {
        this.clearAll();
        XPDLHandler xPDLHandler = JaWEManager.getInstance().getXPDLHandler();
        JaWEManager.getInstance().getLoggingManager().info("JaWEController -> creating new XPDL, type=" + string);
        Package package_ = JaWEManager.getInstance().getXPDLObjectFactory().createPackage(string);
        xPDLHandler.registerPackage(package_);
        this.adjustXPDL(package_);
        this.createNewXPDLListenerObservable(package_, true, true);
        this.setChanged();
        this.notifyObservers((Object)this.createInfo((XMLElement)package_, 3));
        this.selectionMng.setSelection((XMLElement)package_, true);
        JaWEManager.getInstance().getLoggingManager().info("JaWEController -> new package with Id " + package_.getId() + " is created");
        this.updateTitle();
        this.adjustActions();
    }

    public Package openPackageFromFile(String string) {
        JaWEManager.getInstance().getLoggingManager().info("JaWEController -> opening package from file " + string);
        return this.openPackage(string, null);
    }

    public Package openPackageFromStream(byte[] byArray) {
        JaWEManager.getInstance().getLoggingManager().info("JaWEController -> opening package from stream ");
        return this.openPackage(null, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package openPackage(String string, byte[] byArray) {
        WaitScreen waitScreen = new WaitScreen((Window)this.frame);
        XPDLHandler xPDLHandler = null;
        try {
            Object object;
            Package package_ = null;
            this.clearAll();
            XPDLHandler xPDLHandler2 = JaWEManager.getInstance().getXPDLHandler();
            if (this.jaweFrameShown && string != null && byArray == null) {
                waitScreen.show(null, "", this.settings.getLanguageDependentString("OpeningFile"));
            }
            xPDLHandler = JaWEManager.getInstance().createXPDLHandler(xPDLHandler2.getXPDLRepositoryHandler());
            try {
                package_ = string != null ? xPDLHandler.openPackage(string, true) : xPDLHandler.openPackageFromStream(byArray, true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.clearAll();
                xPDLHandler.closeAllPackages();
                waitScreen.setVisible(false);
                this.message(this.settings.getLanguageDependentString("ErrorCannotOpenXPDL\n" + exception.getMessage()), 1);
            }
            if (package_ != null) {
                object = new HashSet(xPDLHandler2.getAllPackageIds());
                boolean bl = true;
                if (object.contains(package_.getId())) {
                    bl = false;
                }
                if (bl) {
                    Object object22;
                    xPDLHandler2.synchronizePackages((XMLInterface)xPDLHandler);
                    boolean bl2 = false;
                    for (Object object22 : xPDLHandler2.getAllPackages()) {
                        XPDLListenerAndObservable xPDLListenerAndObservable;
                        boolean bl3 = this.adjustXPDL((Package)object22);
                        if (object22 == package_) {
                            xPDLListenerAndObservable = this.createNewXPDLListenerObservable(package_, true, false);
                            if (bl3) {
                                bl2 = true;
                            }
                        } else {
                            xPDLListenerAndObservable = this.createNewXPDLListenerObservable((Package)object22, false, false);
                            object22.setReadOnly(true);
                        }
                        xPDLListenerAndObservable.setModified(bl3);
                    }
                    object22 = new ArrayList();
                    object22.add(package_);
                    for (Package package_2 : xPDLHandler2.getAllPackages()) {
                        if (package_2 == package_) continue;
                        object22.add(package_2);
                    }
                    this.setChanged();
                    this.notifyObservers((Object)this.createInfo((XMLElement)package_, (List)object22, 3));
                    if (package_.getWorkflowProcesses().size() > 0) {
                        this.selectionMng.setSelection(package_.getWorkflowProcesses().get(0), true);
                    } else {
                        this.selectionMng.setSelection((XMLElement)package_, true);
                    }
                    JaWEManager.getInstance().getLoggingManager().info("JaWEController -> opened package " + package_.getId());
                    if (this.settings.isInitialXPDLValidationEnabled()) {
                        this.checkValidity(package_, true, true, true);
                    }
                    if (bl2 && this.jaweFrameShown && bl2) {
                        waitScreen.setVisible(false);
                        this.message(this.settings.getLanguageDependentString("InformationTogWEHasAutomaticallyAdjustedSomeXPDLParts"), 1);
                    }
                } else {
                    this.message(this.settings.getLanguageDependentString("InformationPackageCannotBeOpened"), 1);
                }
            } else {
                Object object3;
                this.clearAll();
                object = xPDLHandler2.getParsingErrorMessages();
                String string2 = null;
                if (object != null && object.size() > 0 && (object3 = (Set)object.values().toArray()[0]) != null && object3.size() > 0) {
                    string2 = (String)object3.toArray()[0];
                }
                for (Package package_3 : xPDLHandler2.getAllPackages()) {
                    if (package_3.isTransient()) continue;
                    xPDLHandler2.closePackageVersion(package_3.getId(), package_3.getInternalVersion());
                }
                waitScreen.setVisible(false);
                this.message(this.settings.getLanguageDependentString("ErrorCannotOpenXPDL") + (string2 != null ? "\n" + string2 : ""), 1);
            }
            this.updateTitle();
            this.adjustActions();
            object = package_;
            return object;
        }
        finally {
            waitScreen.setVisible(false);
        }
    }

    public void addExternalPackage() {
        block12: {
            Package package_ = this.getMainPackage();
            XPDLHandler xPDLHandler = JaWEManager.getInstance().getXPDLHandler();
            this.getSelectionManager().setSelection((XMLElement)package_.getExternalPackages(), false);
            String string = "";
            String string2 = this.settings.getLanguageDependentString("DialogChooseFile");
            string = JaWEXMLUtil.dialog(this.getJaWEFrame(), string2, 0, 0, null);
            XPDLHandler xPDLHandler2 = null;
            if (string != null && string.length() > 0) {
                try {
                    Collection collection;
                    xPDLHandler2 = JaWEManager.getInstance().createXPDLHandler(xPDLHandler.getXPDLRepositoryHandler());
                    Package package_2 = xPDLHandler2.openPackage(string, true);
                    HashSet hashSet = new HashSet(package_.getExternalPackageIds());
                    boolean bl = true;
                    if (hashSet.contains(package_2.getId())) {
                        bl = false;
                    }
                    if (bl) {
                        bl = this.checkInsertion(xPDLHandler, xPDLHandler2, package_.getId());
                    }
                    if (bl && !(collection = XMLUtil.getAllExternalPackageIds((XMLInterface)xPDLHandler, (Package)package_, new HashSet())).contains(package_2.getId()) && xPDLHandler.getPackageById(package_2.getId()) != null) {
                        bl = false;
                    }
                    if (bl) {
                        Package package_3;
                        Object object3;
                        Object object22;
                        collection = new HashSet(xPDLHandler2.getAllPackageIds());
                        HashSet hashSet2 = new HashSet(package_.getExternalPackageIds());
                        HashSet hashSet3 = new HashSet(hashSet2);
                        List list = XMLUtil.getAllExternalPackageIds((XMLInterface)xPDLHandler, (Package)package_, new HashSet());
                        ArrayList arrayList = new ArrayList(xPDLHandler.getAllPackageIds());
                        arrayList.removeAll(list);
                        hashSet3.addAll(arrayList);
                        for (Object object22 : hashSet2) {
                            object3 = xPDLHandler.getPackageById((String)object22);
                            hashSet3.addAll(XMLUtil.getAllExternalPackageIds((XMLInterface)xPDLHandler, (Package)object3, new HashSet()));
                        }
                        collection.removeAll(hashSet3);
                        object22 = new HashSet();
                        for (Object object3 : collection) {
                            package_3 = xPDLHandler2.getPackageById((String)object3);
                            object22.add(package_3);
                        }
                        xPDLHandler.synchronizePackages((XMLInterface)xPDLHandler2);
                        object3 = xPDLHandler.getPackageById(package_2.getId());
                        package_3 = null;
                        ExternalPackages externalPackages = package_.getExternalPackages();
                        File file = new File(xPDLHandler.getAbsoluteFilePath(package_));
                        String string3 = file.getParent();
                        Path path = new Path(string3);
                        String string4 = xPDLHandler.getAbsoluteFilePath((Package)object3);
                        String string5 = Path.getRelativePath((Path)new Path(string4), (Path)path);
                        package_3 = JaWEManager.getInstance().getXPDLObjectFactory().createXPDLObject(externalPackages, "", false);
                        package_3.setHref(string5);
                        package_3.setId(object3.getId());
                        package_.addExternalPackageMapping(string5, object3.getId());
                        externalPackages.add((XMLElement)package_3);
                        Iterator iterator = object22.iterator();
                        while (iterator.hasNext()) {
                            Package package_4 = (Package)iterator.next();
                            boolean bl2 = this.adjustXPDL(package_4);
                            XPDLListenerAndObservable xPDLListenerAndObservable = this.createNewXPDLListenerObservable(package_4, false, false);
                            package_4.setReadOnly(true);
                            xPDLListenerAndObservable.setModified(bl2);
                        }
                        this.setChanged();
                        this.notifyObservers((Object)this.createInfo((XMLElement)package_, new ArrayList(object22), 3));
                        if (package_3 != null) {
                            this.getSelectionManager().setSelection((XMLElement)package_3, true);
                        }
                    } else {
                        this.message(this.settings.getLanguageDependentString("InformationExternalPackageCannotBeInserted"), 1);
                        xPDLHandler2.closeAllPackages();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.message(this.settings.getLanguageDependentString("InformationExternalPackageCannotBeInserted"), 1);
                    if (xPDLHandler2 == null) break block12;
                    xPDLHandler2.closeAllPackages();
                }
            }
        }
    }

    public void removeExternalPackage() {
        Object object;
        Iterator iterator;
        Package package_;
        Object object322;
        Package package_2 = this.getMainPackage();
        XPDLHandler xPDLHandler = JaWEManager.getInstance().getXPDLHandler();
        Package package_3 = (Package)this.getSelectionManager().getSelectedElement();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(package_3.getId());
        hashSet.addAll(XMLUtil.getAllExternalPackageIds((XMLInterface)xPDLHandler, (Package)package_3, new HashSet()));
        HashSet hashSet2 = new HashSet(package_2.getExternalPackageIds());
        hashSet2.remove(package_3.getId());
        HashSet hashSet3 = new HashSet(hashSet2);
        for (Object object322 : hashSet2) {
            Package object22 = xPDLHandler.getPackageById((String)object322);
            hashSet3.addAll(XMLUtil.getAllExternalPackageIds((XMLInterface)xPDLHandler, (Package)object22, new HashSet()));
        }
        hashSet.removeAll(hashSet3);
        object322 = new HashSet();
        for (String string : hashSet) {
            package_ = xPDLHandler.getPackageById(string);
            if (package_ == package_2 || package_.isTransient()) continue;
            object322.add(package_);
        }
        ExternalPackages externalPackages = package_2.getExternalPackages();
        package_ = package_2.getExternalPackage(package_3.getId());
        if (object322.size() > 0) {
            int n;
            boolean package_5 = false;
            iterator = object322.iterator();
            while (iterator.hasNext()) {
                object = (Package)iterator.next();
                List list = JaWEManager.getInstance().getXPDLUtils().getReferences((XMLComplexElement)package_2, (XMLComplexElement)object);
                if (list.size() <= 0) continue;
                package_5 = true;
                break;
            }
            if (package_5 && (n = JOptionPane.showConfirmDialog(this.getJaWEFrame(), this.settings.getLanguageDependentString("MessageReferencedDoYouReallyWantToDeleteSelectedItem"), this.settings.getLanguageDependentString("DeletingKey"), 0)) != 0) {
                return;
            }
        }
        try {
            if (package_ != null) {
                package_2.removeExternalPackageMapping(package_.getHref());
            }
            if (object322.size() > 0) {
                iterator = object322.iterator();
                while (iterator.hasNext()) {
                    Package exception = (Package)iterator.next();
                    object = this.getXPDLListenerObservable(exception);
                    ((XPDLListenerAndObservable)object).unregisterFromXPDL();
                    this.xpdlListenerObservables.remove(object);
                    xPDLHandler.closePackageVersion(exception.getId(), exception.getInternalVersion());
                }
                this.setChanged();
                this.notifyObservers((Object)this.createInfo((XMLElement)package_2, new ArrayList(object322), 5));
            }
            if (package_ != null) {
                externalPackages.remove((XMLElement)package_);
                ArrayList<Package> arrayList = new ArrayList<Package>();
                arrayList.add(package_);
                this.setChanged();
                this.notifyObservers((Object)this.createInfo((XMLElement)externalPackages, arrayList, 5));
            }
            this.getSelectionManager().setSelection((XMLElement)externalPackages, true);
            if (object322.size() > 0 && this.settings.isDesingTimeValidationEnabled()) {
                iterator = object322.iterator();
                while (iterator.hasNext()) {
                    Package package_4 = (Package)iterator.next();
                    JaWEManager.getInstance().getXPDLValidator().clearCache(package_4);
                }
                this.checkValidity(package_2, true, true, true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.message(this.settings.getLanguageDependentString("ErrorCannotRemoveExternalPackage"), 1);
        }
    }

    public void addTransientPackage() {
        boolean bl;
        this.getSelectionManager().setSelection((XMLElement)null, true);
        String string = "";
        String string2 = this.settings.getLanguageDependentString("DialogChooseFile");
        string = JaWEXMLUtil.dialog(this.getJaWEFrame(), string2, 0, 0, null);
        if (string != null && string.length() > 0 && !(bl = this.addTransientPackage(string))) {
            this.message(this.settings.getLanguageDependentString("InformationTransientPackageCannotBeInserted"), 1);
        }
    }

    public boolean addTransientPackage(String string) {
        block6: {
            XPDLHandler xPDLHandler = JaWEManager.getInstance().getXPDLHandler();
            XPDLHandler xPDLHandler2 = null;
            if (string != null && string.length() > 0) {
                try {
                    Package package_;
                    xPDLHandler2 = JaWEManager.getInstance().createXPDLHandler(xPDLHandler.getXPDLRepositoryHandler());
                    Package package_2 = xPDLHandler2.openPackage(string, false);
                    HashSet hashSet = new HashSet(xPDLHandler.getAllPackageIds());
                    boolean bl = true;
                    if (hashSet.contains(package_2.getId())) {
                        bl = false;
                    }
                    if (bl && (package_ = this.getMainPackage()) != null) {
                        bl = this.checkInsertion(xPDLHandler, xPDLHandler2, package_.getId());
                    }
                    if (bl) {
                        xPDLHandler.synchronizePackages((XMLInterface)xPDLHandler2);
                        package_ = xPDLHandler.getPackageById(package_2.getId());
                        this.adjustXPDL(package_);
                        XPDLListenerAndObservable xPDLListenerAndObservable = this.createNewXPDLListenerObservable(package_, false, false);
                        package_.setReadOnly(true);
                        xPDLListenerAndObservable.setModified(false);
                        ArrayList<Package> arrayList = new ArrayList<Package>();
                        arrayList.add(package_);
                        this.setChanged();
                        this.notifyObservers((Object)this.createInfo((XMLElement)package_, new ArrayList(arrayList), 3));
                        return true;
                    }
                    xPDLHandler2.closeAllPackages();
                    return false;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (xPDLHandler2 == null) break block6;
                    xPDLHandler2.closeAllPackages();
                }
            }
        }
        return false;
    }

    public void removeTransientPackage() {
        XPDLHandler xPDLHandler = JaWEManager.getInstance().getXPDLHandler();
        Package package_ = XMLUtil.getPackage((XMLElement)this.getSelectionManager().getSelectedElement());
        try {
            XPDLListenerAndObservable xPDLListenerAndObservable = this.getXPDLListenerObservable(package_);
            xPDLListenerAndObservable.unregisterFromXPDL();
            this.xpdlListenerObservables.remove(xPDLListenerAndObservable);
            xPDLHandler.closePackageVersion(package_.getId(), package_.getInternalVersion());
            this.setChanged();
            ArrayList<Package> arrayList = new ArrayList<Package>();
            arrayList.add(package_);
            this.notifyObservers((Object)this.createInfo((XMLElement)package_, arrayList, 5));
            this.getSelectionManager().setSelection((XMLElement)this.getMainPackage(), true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.message(this.settings.getLanguageDependentString("ErrorCannotRemoveTransientPackage"), 1);
        }
    }

    protected boolean checkInsertion(XPDLHandler xPDLHandler, XPDLHandler xPDLHandler2, String string) {
        boolean bl = true;
        Collection collection = xPDLHandler2.getAllPackages();
        for (Package package_ : collection) {
            if (package_.getId().equals(string)) {
                bl = false;
                break;
            }
            String string2 = xPDLHandler2.getAbsoluteFilePath(package_);
            Package package_2 = xPDLHandler.getPackageByFilename(string2);
            if (package_2 == null || package_2.getId().equals(package_.getId())) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public void closePackage(String string, boolean bl) {
        this.clearAll();
        XPDLHandler xPDLHandler = JaWEManager.getInstance().getXPDLHandler();
        Package package_ = this.getMainPackage();
        if (string == null && package_ != null) {
            string = package_.getId();
        }
        JaWEManager.getInstance().getLoggingManager().info("JaWEController -> closing package " + string);
        if (package_ != null && package_.getId().equals(string)) {
            String string2 = JaWEManager.getInstance().getXPDLHandler().getAbsoluteFilePath(package_);
            ArrayList arrayList = new ArrayList(xPDLHandler.getAllPackages());
            ArrayList<Package> arrayList2 = new ArrayList<Package>();
            for (int i = 0; i < arrayList.size(); ++i) {
                Package package_2 = (Package)arrayList.get(i);
                if (!package_2.isTransient() || bl) {
                    xPDLHandler.closePackageVersion(package_2.getId(), package_2.getInternalVersion());
                    continue;
                }
                arrayList2.add(package_2);
            }
            arrayList.removeAll(arrayList2);
            this.setChanged();
            XPDLElementChangeInfo xPDLElementChangeInfo = this.createInfo((XMLElement)package_, arrayList, 5);
            xPDLElementChangeInfo.setOldValue(string2);
            this.notifyObservers((Object)xPDLElementChangeInfo);
            this.clearXPDLListenerObservables(bl);
        }
        JaWEManager.getInstance().getLoggingManager().info("JaWEController -> package " + string + " closed");
        this.updateTitle();
        if (this.getJaWEFrame() != null) {
            this.getJaWEFrame().repaint();
        }
        this.adjustActions();
        System.gc();
    }

    public boolean isSaveEnabled(boolean bl) {
        if (this.getMainPackageId() != null) {
            if (bl) {
                return true;
            }
            return this.isPackageModified(this.getMainPackageId());
        }
        return false;
    }

    public void savePackage(String string, String string2) {
        XPDLHandler xPDLHandler = JaWEManager.getInstance().getXPDLHandler();
        Package package_ = xPDLHandler.getPackageById(string);
        String string3 = xPDLHandler.getAbsoluteFilePath(package_);
        try {
            OutputStream outputStream;
            Object object;
            Object object2;
            Object object3;
            boolean bl;
            if (string2 == null) {
                return;
            }
            boolean bl2 = bl = !string2.equals(string3);
            if (string3 != null && bl) {
                boolean bl3 = JaWEManager.getInstance().getXPDLUtils().doesCrossreferenceExist(package_);
                int n = 0;
                if (bl3) {
                    n = JOptionPane.showConfirmDialog(this.getJaWEFrame(), this.settings.getLanguageDependentString("MessageCrossReferenceExistDoYouWantToProceed"), this.getAppTitle(), 0);
                }
                if (n == 0) {
                    this.updateExternalPackagesRelativePaths(package_, string2);
                } else {
                    return;
                }
            }
            Document document = null;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
            RandomAccessFile randomAccessFile = xPDLHandler.getRaf(package_);
            if (bl) {
                try {
                    object3 = new File(string2);
                    object2 = new RandomAccessFile((File)object3, "rw");
                    object = ((RandomAccessFile)object2).getChannel().tryLock();
                    ((FileLock)object).release();
                    ((RandomAccessFile)object2).close();
                }
                catch (IOException iOException) {
                }
                catch (NullPointerException nullPointerException) {
                    throw new Exception();
                }
                outputStream = new FileOutputStream(string2);
            } else {
                outputStream = new ByteArrayOutputStream();
            }
            JaWEManager.getInstance().getXPDLHandler().getXPDLRepositoryHandler().toXML(document, package_);
            object3 = TransformerFactory.newInstance();
            object2 = ((TransformerFactory)object3).newTransformer();
            ((Transformer)object2).setOutputProperty("indent", "yes");
            ((Transformer)object2).setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            ((Transformer)object2).setOutputProperty("encoding", this.settings.getEncoding());
            object = new DOMSource(document);
            StreamResult streamResult = new StreamResult(outputStream);
            ((Transformer)object2).transform((Source)object, streamResult);
            if (!bl && randomAccessFile != null && outputStream instanceof ByteArrayOutputStream && randomAccessFile != null) {
                randomAccessFile.seek(0L);
                randomAccessFile.getChannel().truncate(0L);
                randomAccessFile.write(((ByteArrayOutputStream)outputStream).toByteArray());
            }
            outputStream.close();
            XPDLListenerAndObservable xPDLListenerAndObservable = this.getXPDLListenerObservable(package_);
            if (xPDLListenerAndObservable != null) {
                xPDLListenerAndObservable.setModified(false);
            }
            if (bl) {
                xPDLHandler.registerPackageFilename(string2, package_);
            }
            try {
                System.setProperty("user.dir", xPDLHandler.getParentDirectory(package_));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (NonWritableChannelException nonWritableChannelException) {
            nonWritableChannelException.printStackTrace();
            this.message(this.settings.getLanguageDependentString("ErrorCannotSaveReadOnlyFile"), 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.message(this.settings.getLanguageDependentString("ErrorCannotSaveDocument"), 0);
        }
        this.updateTitle();
        this.adjustActions();
    }

    public boolean tryToClosePackage(String string, boolean bl) {
        if (string == null) {
            string = this.getMainPackageId();
        }
        if (string == null) {
            return true;
        }
        int n = 1;
        boolean bl2 = this.isPackageModified(string);
        String string2 = this.getPackageFilename(string);
        if (bl2 || string2 == null) {
            n = JOptionPane.showConfirmDialog(this.getJaWEFrame(), this.settings.getLanguageDependentString("DialogSaveChanges"), this.getAppTitle(), 1);
        }
        if (n == 0) {
            String string3 = this.settings.getLanguageDependentString("SaveLabel");
            if (string2 == null) {
                string3 = this.settings.getLanguageDependentString("SaveAsLabel");
            }
            if (string2 == null) {
                string2 = this.saveDialog(string3, 0, string);
            }
            this.savePackage(string, string2);
            if (this.isPackageModified(string)) {
                n = 2;
            }
        }
        if (n == 2) {
            return false;
        }
        this.closePackage(string, bl);
        return true;
    }

    protected XPDLListenerAndObservable createNewXPDLListenerObservable(Package package_, boolean bl, boolean bl2) {
        XPDLListenerAndObservable xPDLListenerAndObservable = new XPDLListenerAndObservable(package_, bl);
        xPDLListenerAndObservable.setModified(bl2);
        this.xpdlListenerObservables.add(xPDLListenerAndObservable);
        xPDLListenerAndObservable.addObserver(this);
        return xPDLListenerAndObservable;
    }

    protected XPDLListenerAndObservable getXPDLListenerObservable(Package package_) {
        for (XPDLListenerAndObservable xPDLListenerAndObservable : this.xpdlListenerObservables) {
            if (xPDLListenerAndObservable.getPackage() != package_) continue;
            return xPDLListenerAndObservable;
        }
        return null;
    }

    protected XPDLListenerAndObservable getWorkingXPDLListenerObservable() {
        for (XPDLListenerAndObservable xPDLListenerAndObservable : this.xpdlListenerObservables) {
            if (xPDLListenerAndObservable.getPackage() != this.selectionMng.getWorkingPKG()) continue;
            return xPDLListenerAndObservable;
        }
        return null;
    }

    protected void changePackageId(Package package_, String string, String string2) {
        XPDLHandler xPDLHandler = JaWEManager.getInstance().getXPDLHandler();
        xPDLHandler.changePackageId(package_, string, string2);
    }

    protected void updateExternalPackagesRelativePaths(Package package_, String string) {
        XPDLHandler xPDLHandler = JaWEManager.getInstance().getXPDLHandler();
        File file = new File(string);
        String string2 = file.getParent();
        Path path = new Path(string2);
        for (ExternalPackage externalPackage : package_.getExternalPackages().toElements()) {
            String string3 = externalPackage.getHref();
            try {
                Package package_2 = xPDLHandler.getExternalPackageByRelativeFilePath(string3, package_);
                String string4 = xPDLHandler.getAbsoluteFilePath(package_2);
                String string5 = Path.getRelativePath((Path)new Path(string4), (Path)path);
                externalPackage.setHref(XMLUtil.replaceBackslashesWithSlashes((String)string5));
            }
            catch (Exception exception) {
                System.err.println("Failed to update old external package's relative path " + string3 + " for main package " + package_.getId() + " with a new filename " + string);
            }
        }
    }

    public XPDLElementChangeInfo createInfo(XMLElement xMLElement, int n) {
        XPDLElementChangeInfo xPDLElementChangeInfo = new XPDLElementChangeInfo();
        xPDLElementChangeInfo.setChangedElement(xMLElement);
        xPDLElementChangeInfo.setAction(n);
        xPDLElementChangeInfo.setSource(this);
        return xPDLElementChangeInfo;
    }

    public XPDLElementChangeInfo createInfo(XMLElement xMLElement, List list, int n) {
        XPDLElementChangeInfo xPDLElementChangeInfo = new XPDLElementChangeInfo();
        xPDLElementChangeInfo.setChangedElement(xMLElement);
        xPDLElementChangeInfo.setChangedSubElements(list);
        xPDLElementChangeInfo.setAction(n);
        xPDLElementChangeInfo.setSource(this);
        return xPDLElementChangeInfo;
    }

    public boolean canCreateElement(XMLCollection xMLCollection, boolean bl) {
        SequencedHashMap sequencedHashMap;
        if (bl && xMLCollection.isReadOnly()) {
            return false;
        }
        if (xMLCollection instanceof TransitionRestrictions || xMLCollection instanceof TransitionRefs || xMLCollection instanceof ExternalPackages || xMLCollection instanceof Pools || xMLCollection instanceof Lanes || xMLCollection instanceof NestedLanes || xMLCollection instanceof Performers || xMLCollection instanceof NodeGraphicsInfos || xMLCollection instanceof ConnectorGraphicsInfos || xMLCollection instanceof Artifacts || xMLCollection instanceof Associations) {
            return false;
        }
        if (xMLCollection instanceof Responsibles && (sequencedHashMap = JaWEManager.getInstance().getXPDLUtils().getPossibleResponsibles((Responsibles)xMLCollection, null)).size() == 0) {
            return false;
        }
        for (JaWEComponent jaWEComponent : JaWEManager.getInstance().getComponentManager().getComponents()) {
            boolean bl2;
            if (jaWEComponent == this || (bl2 = jaWEComponent.canCreateElement(xMLCollection))) continue;
            return false;
        }
        return true;
    }

    public boolean canInsertElement(XMLCollection xMLCollection, XMLElement xMLElement, boolean bl) {
        if (bl && xMLCollection.isReadOnly()) {
            return false;
        }
        if (xMLCollection instanceof TransitionRestrictions || xMLCollection instanceof TransitionRefs || xMLCollection instanceof ExternalPackages || xMLCollection instanceof Pools || xMLCollection instanceof Lanes || xMLCollection instanceof NestedLanes || xMLCollection instanceof Performers || xMLCollection instanceof NodeGraphicsInfos || xMLCollection instanceof ConnectorGraphicsInfos || xMLCollection instanceof Artifacts || xMLCollection instanceof Associations) {
            return false;
        }
        if (xMLCollection instanceof ExtendedAttributes && xMLCollection.getParent() instanceof ExternalPackage && xMLElement != null && ((ExtendedAttribute)xMLElement).getName().equals("EXTERNAL_PACKAGE_ID")) {
            return false;
        }
        for (JaWEComponent jaWEComponent : JaWEManager.getInstance().getComponentManager().getComponents()) {
            boolean bl2;
            if (jaWEComponent == this || (bl2 = jaWEComponent.canInsertElement(xMLCollection, xMLElement))) continue;
            return false;
        }
        return true;
    }

    public boolean canModifyElement(XMLElement xMLElement, boolean bl) {
        if (bl && xMLElement.isReadOnly()) {
            return false;
        }
        if (XMLUtil.getParentElement(TransitionRef.class, (XMLElement)xMLElement) != null || XMLUtil.getParentElement(NestedLane.class, (XMLElement)xMLElement) != null || XMLUtil.getParentElement(NodeGraphicsInfo.class, (XMLElement)xMLElement) != null || XMLUtil.getParentElement(ConnectorGraphicsInfo.class, (XMLElement)xMLElement) != null) {
            return false;
        }
        if (XMLUtil.getParentElement(ExternalPackage.class, (XMLElement)xMLElement) != null) {
            if (xMLElement.toName().equals("href")) {
                return false;
            }
            ExtendedAttribute extendedAttribute = (ExtendedAttribute)XMLUtil.getParentElement(ExtendedAttribute.class, (XMLElement)xMLElement);
            if (extendedAttribute != null && extendedAttribute.getName().equals("EXTERNAL_PACKAGE_ID")) {
                return false;
            }
        } else if (XMLUtil.getParentElement(Pool.class, (XMLElement)xMLElement) != null && xMLElement.toName().equals("Process")) {
            return false;
        }
        if ((xMLElement.getParent() instanceof Split || xMLElement.getParent() instanceof Join) && xMLElement.toName().equals("Type")) {
            return false;
        }
        for (JaWEComponent jaWEComponent : JaWEManager.getInstance().getComponentManager().getComponents()) {
            boolean bl2;
            if (jaWEComponent == this || (bl2 = jaWEComponent.canModifyElement(xMLElement))) continue;
            return false;
        }
        return true;
    }

    public boolean canRemoveElement(XMLCollection xMLCollection, XMLElement xMLElement, boolean bl) {
        if (bl && xMLCollection.isReadOnly()) {
            return false;
        }
        if (xMLCollection instanceof TransitionRestrictions || xMLCollection instanceof TransitionRefs || xMLCollection instanceof Pools || xMLCollection instanceof Lanes || xMLCollection instanceof NestedLanes || xMLCollection instanceof Performers || xMLCollection instanceof NodeGraphicsInfos || xMLCollection instanceof ConnectorGraphicsInfos) {
            return false;
        }
        if (xMLCollection instanceof ExternalPackages) {
            if (xMLElement != null) {
                String string = ((ExternalPackage)xMLElement).getHref();
                Object object = XMLUtil.getPackage((XMLElement)xMLCollection);
                String string2 = object.getExternalPackageId(string);
                if (string2 != null) {
                    return false;
                }
            }
        } else if (xMLCollection instanceof ExtendedAttributes && xMLCollection.getParent() instanceof ExternalPackage && xMLElement != null && ((ExtendedAttribute)xMLElement).getName().equals("EXTERNAL_PACKAGE_ID")) {
            return false;
        }
        for (Object object : JaWEManager.getInstance().getComponentManager().getComponents()) {
            boolean bl2;
            if (object == this || (bl2 = object.canRemoveElement(xMLCollection, xMLElement))) continue;
            return false;
        }
        return true;
    }

    public boolean canDuplicateElement(XMLCollection xMLCollection, XMLElement xMLElement, boolean bl) {
        if (bl && xMLCollection.isReadOnly()) {
            return false;
        }
        if (xMLElement instanceof TransitionRestriction || xMLElement instanceof TransitionRef || xMLElement instanceof Member || xMLElement instanceof EnumerationValue || xMLElement instanceof ExternalPackage || xMLElement instanceof Responsible || xMLElement instanceof Transition || xMLElement instanceof Lane || xMLElement instanceof Pool || xMLCollection instanceof NestedLanes || xMLCollection instanceof Performers || xMLCollection instanceof NodeGraphicsInfos || xMLCollection instanceof ConnectorGraphicsInfos) {
            return false;
        }
        if (xMLCollection instanceof ExtendedAttributes && xMLCollection.getParent() instanceof ExternalPackage && xMLElement != null && ((ExtendedAttribute)xMLElement).getName().equals("EXTERNAL_PACKAGE_ID")) {
            return false;
        }
        for (JaWEComponent jaWEComponent : JaWEManager.getInstance().getComponentManager().getComponents()) {
            boolean bl2;
            if (jaWEComponent == this || (bl2 = jaWEComponent.canDuplicateElement(xMLCollection, xMLElement))) continue;
            return false;
        }
        return true;
    }

    public boolean canRepositionElement(XMLCollection xMLCollection, XMLElement xMLElement, boolean bl) {
        if (bl && xMLCollection.isReadOnly()) {
            return false;
        }
        if (xMLCollection instanceof ExtendedAttributes && xMLCollection.getParent() instanceof ExternalPackage && xMLElement != null && ((ExtendedAttribute)xMLElement).getName().equals("EXTERNAL_PACKAGE_ID")) {
            return false;
        }
        for (JaWEComponent jaWEComponent : JaWEManager.getInstance().getComponentManager().getComponents()) {
            boolean bl2;
            if (jaWEComponent == this || (bl2 = jaWEComponent.canRepositionElement(xMLCollection, xMLElement))) continue;
            return false;
        }
        return true;
    }

    public void startUndouableChange() {
        Package package_ = this.getMainPackage();
        this.xpdlInfoList.clear();
        this.undoableChangeInProgress = true;
        this.undoSelectionEvent = this.getCurrentSelectionEvent();
        XPDLElementChangeInfo xPDLElementChangeInfo = this.createInfo((XMLElement)package_, 13);
        xPDLElementChangeInfo.setChangedSubElements(this.xpdlInfoList);
        this.setChanged();
        this.notifyObservers((Object)xPDLElementChangeInfo);
    }

    public void endUndouableChange(List arrayList) {
        XPDLElementChangeInfo xPDLElementChangeInfo2;
        Package package_ = this.getMainPackage();
        ArrayList arrayList2 = new ArrayList(this.xpdlInfoList);
        for (XPDLElementChangeInfo xPDLElementChangeInfo2 : arrayList2) {
            this.handleEvent(xPDLElementChangeInfo2);
        }
        xPDLElementChangeInfo2 = this.createInfo((XMLElement)package_, 14);
        xPDLElementChangeInfo2.setChangedSubElements(this.xpdlInfoList);
        this.setChanged();
        this.notifyObservers((Object)xPDLElementChangeInfo2);
        xPDLElementChangeInfo2 = this.createInfo((XMLElement)package_, 15);
        if (arrayList != null && arrayList.size() > 0) {
            if (!this.selectionMng.checkSelection(arrayList)) {
                XMLElement xMLElement = (XMLElement)arrayList.get(0);
                arrayList.clear();
                arrayList.add(xMLElement);
            }
        } else {
            arrayList = new ArrayList<Object>();
            arrayList.add(package_);
        }
        xPDLElementChangeInfo2.setChangedSubElements(this.xpdlInfoList);
        this.updateInProgress = true;
        this.setChanged();
        this.notifyObservers((Object)xPDLElementChangeInfo2);
        this.updateInProgress = false;
        if (this.undoHistoryManager != null) {
            this.undoHistoryManager.registerEvents(this.xpdlInfoList, this.undoSelectionEvent);
        }
        this.getSettings().adjustActions();
        JaWEManager.getInstance().getLoggingManager().debug("All events after undoable change:\n" + this.xpdlInfoList);
        this.xpdlInfoList.clear();
        this.undoableChangeInProgress = false;
        this.selectionMng.setSelection(arrayList, true);
        if (this.settings.isDesingTimeValidationEnabled()) {
            this.checkValidity(package_, true, false, true);
        }
    }

    public boolean isUndoableChangeInProgress() {
        return this.undoableChangeInProgress;
    }

    public boolean isUndoOrRedoInProgress() {
        if (this.undoHistoryManager != null) {
            return this.undoHistoryManager.isUndoOrRedoInProgress();
        }
        return false;
    }

    public void handleEvent(XPDLElementChangeInfo xPDLElementChangeInfo) {
        Object object;
        XMLElement xMLElement = xPDLElementChangeInfo.getChangedElement();
        JaWEManager.getInstance().getLoggingManager().debug("INFO: handleEvenet(): " + (Object)((Object)xPDLElementChangeInfo));
        int n = xPDLElementChangeInfo.getAction();
        if (n != 8) {
            if (xMLElement instanceof WorkflowProcesses) {
                if (n == 5 && xPDLElementChangeInfo.getChangedSubElements() != null) {
                    this.updateSpecialInProgress = true;
                    JaWEManager.getInstance().getXPDLUtils().removeArtifactAndAssociationsForProcessesOrActivitySets(xPDLElementChangeInfo.getChangedSubElements());
                    JaWEManager.getInstance().getXPDLUtils().removePoolsForProcesses(xPDLElementChangeInfo.getChangedSubElements());
                    this.selectionMng.removeFromSelection(xPDLElementChangeInfo.getChangedSubElements());
                    this.updateSpecialInProgress = false;
                    for (Object object2 : xPDLElementChangeInfo.getChangedSubElements()) {
                        if (object2 != this.selectionMng.getWorkingProcess()) continue;
                        this.selectionMng.setSelection(object2.getParent().getParent(), true);
                        break;
                    }
                }
            } else if (xMLElement instanceof ActivitySets && n == 5 && xPDLElementChangeInfo.getChangedSubElements() != null) {
                this.updateSpecialInProgress = true;
                JaWEManager.getInstance().getXPDLUtils().removeArtifactAndAssociationsForProcessesOrActivitySets(xPDLElementChangeInfo.getChangedSubElements());
                JaWEManager.getInstance().getXPDLUtils().removePoolsForActivitySets(xPDLElementChangeInfo.getChangedSubElements());
                this.selectionMng.removeFromSelection(xPDLElementChangeInfo.getChangedSubElements());
                this.updateSpecialInProgress = false;
                for (Object object2 : xPDLElementChangeInfo.getChangedSubElements()) {
                    if (object2 != this.selectionMng.getWorkingActivitySet()) continue;
                    this.selectionMng.setSelection(object2.getParent().getParent(), true);
                    break;
                }
            }
        }
        if (n == 3 && (xMLElement instanceof WorkflowProcesses || xMLElement instanceof ActivitySets)) {
            this.updateSpecialInProgress = true;
            if (xMLElement instanceof WorkflowProcesses) {
                JaWEManager.getInstance().getXPDLUtils().createPoolsForProcesses(xPDLElementChangeInfo.getChangedSubElements());
            } else {
                JaWEManager.getInstance().getXPDLUtils().createPoolsForActivitySets(xPDLElementChangeInfo.getChangedSubElements());
            }
            this.selectionMng.removeFromSelection(xPDLElementChangeInfo.getChangedSubElements());
            this.updateSpecialInProgress = false;
            if (xPDLElementChangeInfo.getChangedSubElements() != null) {
                this.selectionMng.setSelection(xPDLElementChangeInfo.getChangedSubElements(), true);
            }
        }
        this.updateTitle();
        this.adjustActions();
        if (n == 5 || n == 3) {
            JaWEManager.getInstance().getLoggingManager().info("JaWEController -> performing appropriate actions on inserting/removing");
            if (xMLElement instanceof Lanes && n == 5) {
                this.updateSpecialInProgress = true;
                JaWEManager.getInstance().getXPDLUtils().removeNestedLanesForLanes(xPDLElementChangeInfo.getChangedSubElements());
                this.selectionMng.removeFromSelection(xPDLElementChangeInfo.getChangedSubElements());
                this.updateSpecialInProgress = false;
            } else if (xMLElement instanceof Activities && n == 5) {
                this.updateSpecialInProgress = true;
                JaWEManager.getInstance().getXPDLUtils().removeTransitionsAndAssociationsForActivities(xPDLElementChangeInfo.getChangedSubElements());
                this.selectionMng.removeFromSelection(xPDLElementChangeInfo.getChangedSubElements());
                this.updateSpecialInProgress = false;
            } else if (xMLElement instanceof Artifacts && n == 5) {
                this.updateSpecialInProgress = true;
                JaWEManager.getInstance().getXPDLUtils().removeAssociationsForArtifacts(xPDLElementChangeInfo.getChangedSubElements());
                this.selectionMng.removeFromSelection(xPDLElementChangeInfo.getChangedSubElements());
                this.updateSpecialInProgress = false;
            } else if (xMLElement instanceof Transitions) {
                object = (Activities)((XMLCollectionElement)xMLElement.getParent()).get("Activities");
                this.updateSpecialInProgress = true;
                JaWEManager.getInstance().getXPDLUtils().correctSplitsAndJoins(object.toElements());
                this.updateSpecialInProgress = false;
                if (n == 5) {
                    this.selectionMng.removeFromSelection(xPDLElementChangeInfo.getChangedSubElements());
                }
            }
            JaWEManager.getInstance().getLoggingManager().info("JaWEController -> finished performing appropriate actions on inserting/removing");
        } else if (n == 1) {
            Lane lane;
            Object object3;
            Object object4;
            Object object2;
            object = xMLElement.getParent();
            if (xMLElement.toName().equals("Name") && (object instanceof Participant || object instanceof WorkflowProcess)) {
                this.updateSpecialInProgress = true;
                if (object instanceof Participant) {
                    object2 = JaWEManager.getInstance().getXPDLUtils().getParticipantReferences((XMLComplexElement)object.getParent().getParent(), ((Participant)object).getId());
                    object4 = object2.iterator();
                    while (object4.hasNext()) {
                        object3 = (XMLElement)object4.next();
                        lane = XMLUtil.getLane((XMLElement)object3);
                        if (lane == null) continue;
                        lane.setName(xMLElement.toValue());
                    }
                } else {
                    object2 = JaWEManager.getInstance().getXPDLUtils().getWorkflowProcessReferences((Package)object.getParent().getParent(), ((WorkflowProcess)object).getId());
                    object4 = object2.iterator();
                    while (object4.hasNext()) {
                        object3 = (XMLElement)object4.next();
                        if (!(object3 instanceof Pool)) continue;
                        ((Pool)object3).setName(xMLElement.toValue());
                    }
                }
                this.updateSpecialInProgress = false;
            }
            if (xMLElement.toName().equals("Id") && (object instanceof WorkflowProcess || object instanceof ActivitySet || object instanceof Application || object instanceof Artifact || object instanceof Participant || object instanceof DataField || object instanceof FormalParameter || object instanceof Activity || object instanceof Transition || object instanceof TypeDeclaration || object instanceof Lane) || (xMLElement.toName().equals("From") || xMLElement.toName().equals("To")) && object instanceof Transition || (object instanceof Split || object instanceof Join) && xMLElement instanceof XMLAttribute) {
                if (object instanceof Activity || object instanceof Transition || object instanceof Split || object instanceof Join) {
                    object2 = XMLUtil.getActivitySetOrWorkflowProcess((XMLElement)object);
                    if (object instanceof Activity) {
                        this.updateSpecialInProgress = true;
                        JaWEManager.getInstance().getXPDLUtils().updateActivityReferences(JaWEManager.getInstance().getXPDLUtils().getActivityReferences((XMLCollectionElement)object2, (String)xPDLElementChangeInfo.getOldValue()), (String)xPDLElementChangeInfo.getOldValue(), (String)xPDLElementChangeInfo.getNewValue());
                        this.updateSpecialInProgress = false;
                    } else if (object instanceof Transition) {
                        if (xMLElement.toName().equals("Id")) {
                            this.updateSpecialInProgress = true;
                            JaWEManager.getInstance().getXPDLUtils().updateActivityOnTransitionIdChange((Activities)object2.get("Activities"), ((Transition)object).getFrom(), (String)xPDLElementChangeInfo.getOldValue(), (String)xPDLElementChangeInfo.getNewValue());
                            this.updateSpecialInProgress = false;
                        } else if (xMLElement.toName().equals("From")) {
                            this.updateSpecialInProgress = true;
                            JaWEManager.getInstance().getXPDLUtils().updateActivitiesOnTransitionFromChange((Activities)object2.get("Activities"), ((Transition)object).getId(), (String)xPDLElementChangeInfo.getOldValue(), (String)xPDLElementChangeInfo.getNewValue());
                            this.updateSpecialInProgress = false;
                        } else {
                            this.updateSpecialInProgress = true;
                            JaWEManager.getInstance().getXPDLUtils().updateActivitiesOnTransitionToChange((Activities)object2.get("Activities"), ((Transition)object).getId(), (String)xPDLElementChangeInfo.getOldValue(), (String)xPDLElementChangeInfo.getNewValue());
                            this.updateSpecialInProgress = false;
                        }
                    } else if (object instanceof Split || object instanceof Join) {
                        this.updateSpecialInProgress = true;
                        object4 = XMLUtil.getActivity((XMLElement)object);
                        JaWEManager.getInstance().getXPDLUtils().correctSplitAndJoin((Activity)object4);
                        this.updateSpecialInProgress = false;
                    }
                } else if (object instanceof Artifact) {
                    this.updateSpecialInProgress = true;
                    JaWEManager.getInstance().getXPDLUtils().updateArtifactReferences(JaWEManager.getInstance().getXPDLUtils().getArtifactReferences(XMLUtil.getPackage((XMLElement)object), (String)xPDLElementChangeInfo.getOldValue()), (String)xPDLElementChangeInfo.getOldValue(), (String)xPDLElementChangeInfo.getNewValue());
                    this.updateSpecialInProgress = false;
                } else if (object instanceof TypeDeclaration) {
                    this.updateSpecialInProgress = true;
                    JaWEManager.getInstance().getXPDLUtils().updateTypeDeclarationReferences(JaWEManager.getInstance().getXPDLUtils().getTypeDeclarationReferences(XMLUtil.getPackage((XMLElement)object), (String)xPDLElementChangeInfo.getOldValue()), (String)xPDLElementChangeInfo.getNewValue());
                    this.updateSpecialInProgress = false;
                } else if (object instanceof WorkflowProcess) {
                    this.updateSpecialInProgress = true;
                    JaWEManager.getInstance().getXPDLUtils().updateWorkflowProcessReferences(JaWEManager.getInstance().getXPDLUtils().getWorkflowProcessReferences(XMLUtil.getPackage((XMLElement)object), (String)xPDLElementChangeInfo.getOldValue()), (String)xPDLElementChangeInfo.getNewValue());
                    this.updateSpecialInProgress = false;
                } else if (object instanceof ActivitySet) {
                    this.updateSpecialInProgress = true;
                    JaWEManager.getInstance().getXPDLUtils().updateActivitySetReferences(JaWEManager.getInstance().getXPDLUtils().getActivitySetReferences(XMLUtil.getWorkflowProcess((XMLElement)object), (String)xPDLElementChangeInfo.getOldValue()), (String)xPDLElementChangeInfo.getNewValue());
                    this.updateSpecialInProgress = false;
                } else if (object instanceof Application) {
                    this.updateSpecialInProgress = true;
                    JaWEManager.getInstance().getXPDLUtils().updateApplicationReferences(JaWEManager.getInstance().getXPDLUtils().getApplicationReferences((XMLComplexElement)object.getParent().getParent(), (String)xPDLElementChangeInfo.getOldValue()), (String)xPDLElementChangeInfo.getNewValue());
                    this.updateSpecialInProgress = false;
                } else if (object instanceof Participant) {
                    this.updateSpecialInProgress = true;
                    JaWEManager.getInstance().getXPDLUtils().updateParticipantReferences(JaWEManager.getInstance().getXPDLUtils().getParticipantReferences((XMLComplexElement)object.getParent().getParent(), (String)xPDLElementChangeInfo.getOldValue()), (String)xPDLElementChangeInfo.getNewValue());
                    this.updateSpecialInProgress = false;
                } else if (object instanceof DataField || object instanceof FormalParameter && object.getParent().getParent() instanceof WorkflowProcess) {
                    this.updateSpecialInProgress = true;
                    object2 = (XMLComplexElement)object.getParent().getParent();
                    object4 = null;
                    object4 = object instanceof DataField ? JaWEManager.getInstance().getXPDLUtils().getDataFieldReferences((XMLComplexElement)object2, (String)xPDLElementChangeInfo.getOldValue()) : JaWEManager.getInstance().getXPDLUtils().getFormalParameterReferences((WorkflowProcess)object2, (String)xPDLElementChangeInfo.getOldValue());
                    JaWEManager.getInstance().getXPDLUtils().updateVariableReferences((List)object4, (String)xPDLElementChangeInfo.getOldValue(), (String)xPDLElementChangeInfo.getNewValue());
                    this.updateSpecialInProgress = false;
                } else if (object instanceof Lane) {
                    this.updateSpecialInProgress = true;
                    JaWEManager.getInstance().getXPDLUtils().updateLaneReferences(JaWEManager.getInstance().getXPDLUtils().getLaneReferences(XMLUtil.getPackage((XMLElement)object), (String)xPDLElementChangeInfo.getOldValue()), (String)xPDLElementChangeInfo.getNewValue());
                    this.updateSpecialInProgress = false;
                }
            }
            if (xMLElement instanceof ActivityTypes || xMLElement instanceof ImplementationTypes || xMLElement instanceof TaskTypes) {
                System.out.println("OV=" + xPDLElementChangeInfo.getOldValue() + ",NV=" + xPDLElementChangeInfo.getNewValue() + ",CSUB=" + xPDLElementChangeInfo.getChangedSubElements());
                object2 = XMLUtil.getActivity((XMLElement)xMLElement);
                object4 = object2.getFirstPerformerObj();
                if (object2.getActivityType() == 1 || object2.getActivityType() == 2) {
                    if (object4 == null) {
                        Lane lane2;
                        object4 = object2.createFirstPerformerObj();
                        object3 = JaWEManager.getInstance().getXPDLUtils().getLaneId((XMLCollectionElement)object2);
                        if (object3 != null && (lane = JaWEManager.getInstance().getXPDLUtils().getPoolForProcessOrActivitySet((XMLCollectionElement)object2.getParent().getParent())) != null && (lane2 = lane.getLanes().getLane((String)object3)) != null && lane2.getPerformers().size() > 0) {
                            object4.setValue(lane2.getPerformers().get(0).toValue());
                        }
                    }
                } else if (object4 != null) {
                    ((Performers)object4.getParent()).remove((XMLElement)object4);
                }
            }
        }
    }

    protected void clearHistory() {
        if (this.undoHistoryManager != null) {
            this.undoHistoryManager.cleanHistory();
            this.adjustActions();
        }
        this.undoSelectionEvent = null;
        System.gc();
    }

    protected void clearAll() {
        this.xpdlInfoList.clear();
        this.clearHistory();
        this.selectionMng.clear();
        this.edit.clear();
        this.undoSelectionEvent = null;
        StandardPackageValidator standardPackageValidator = JaWEManager.getInstance().getXPDLValidator();
        if (standardPackageValidator != null) {
            standardPackageValidator.clearCache();
        }
        if (JaWEManager.getInstance().getXPDLElementEditor() != null && JaWEManager.getInstance().getXPDLElementEditor().getWindow() != null) {
            JaWEManager.getInstance().getXPDLElementEditor().close();
        }
        XPDLElementChangeInfo xPDLElementChangeInfo = this.createInfo(null, new ArrayList(), 10);
        xPDLElementChangeInfo.setNewValue(new Boolean(false));
        this.sendEvent(xPDLElementChangeInfo);
        xPDLElementChangeInfo = this.createInfo(null, new ArrayList(), 9);
        this.sendEvent(xPDLElementChangeInfo);
        if (JaWEManager.getInstance().getTableEditor() != null) {
            JaWEManager.getInstance().getTableEditor().close();
        }
        System.gc();
    }

    protected void clearXPDLListenerObservables(boolean bl) {
        ArrayList<XPDLListenerAndObservable> arrayList = new ArrayList<XPDLListenerAndObservable>();
        for (int i = 0; i < this.xpdlListenerObservables.size(); ++i) {
            XPDLListenerAndObservable xPDLListenerAndObservable = (XPDLListenerAndObservable)this.xpdlListenerObservables.get(i);
            if (bl || !xPDLListenerAndObservable.getPackage().isTransient()) {
                xPDLListenerAndObservable.unregisterFromXPDL();
                continue;
            }
            arrayList.add(xPDLListenerAndObservable);
        }
        this.xpdlListenerObservables.retainAll(arrayList);
        System.gc();
    }

    public void undo() {
        if (this.undoHistoryManager != null) {
            this.undoHistoryManager.undo();
            if (this.settings.isDesingTimeValidationEnabled()) {
                this.checkValidity(this.getMainPackage(), true, false, true);
            }
            this.getSettings().adjustActions();
        }
    }

    public void redo() {
        if (this.undoHistoryManager != null) {
            this.undoHistoryManager.redo();
            if (this.settings.isDesingTimeValidationEnabled()) {
                this.checkValidity(this.getMainPackage(), true, false, true);
            }
            this.getSettings().adjustActions();
        }
    }

    public void sendEvent(XPDLElementChangeInfo xPDLElementChangeInfo) {
        this.setChanged();
        JaWEManager.getInstance().getLoggingManager().debug("Controller sending event: " + (Object)((Object)xPDLElementChangeInfo));
        this.notifyObservers((Object)xPDLElementChangeInfo);
        this.updateTitle();
        this.adjustActions();
    }

    public XPDLElementChangeInfo getCurrentSelectionEvent() {
        List list = this.selectionMng.getSelectedElements();
        Package package_ = this.getMainPackage();
        if (list != null && list.size() > 0) {
            package_ = (XMLElement)list.get(0);
            if (list.size() == 1) {
                list.clear();
            } else {
                package_ = package_.getParent();
            }
        }
        XPDLElementChangeInfo xPDLElementChangeInfo = this.createInfo((XMLElement)package_, list, 8);
        return xPDLElementChangeInfo;
    }

    public boolean confirmDelete(List list, XMLElement xMLElement) {
        int n;
        Package package_ = this.getMainPackage();
        WorkflowProcess workflowProcess = XMLUtil.getWorkflowProcess((XMLElement)xMLElement);
        if (workflowProcess != null && workflowProcess != xMLElement) {
            package_ = workflowProcess;
        }
        String string = this.getControllerSettings().doNotAskOnDeletionOfReferencedElementTypes();
        Set set = JaWEController.refElsNotToAskOnDeletion(string);
        ArrayList arrayList = new ArrayList();
        if (this.getControllerSettings().shouldAskOnDeletionOfReferencedElements()) {
            for (n = 0; n < list.size(); ++n) {
                XMLElement xMLElement2 = (XMLElement)list.get(n);
                if (xMLElement2 instanceof Activity) {
                    if (set.contains(xMLElement2.toName())) continue;
                    arrayList.addAll(JaWEManager.getInstance().getXPDLUtils().getReferences((Activity)xMLElement2));
                    continue;
                }
                if (xMLElement2 instanceof Transition) {
                    if (set.contains(xMLElement2.toName())) continue;
                    arrayList.addAll(JaWEManager.getInstance().getXPDLUtils().getReferences((Transition)xMLElement2));
                    continue;
                }
                if (!(xMLElement2 instanceof XMLComplexElement) || set.contains(xMLElement2.toName())) continue;
                arrayList.addAll(JaWEManager.getInstance().getXPDLUtils().getReferences((XMLComplexElement)package_, (XMLComplexElement)xMLElement2));
            }
        }
        n = 0;
        if (this.getControllerSettings().shoudAskOnDeletion() || this.getControllerSettings().shouldAskOnDeletionOfReferencedElements()) {
            if (arrayList.size() == 0) {
                if (this.getControllerSettings().shoudAskOnDeletion()) {
                    n = JOptionPane.showConfirmDialog(this.getJaWEFrame(), this.getSettings().getLanguageDependentString("MessageDoYouReallyWantToRemoveSelectedItem"), this.getSettings().getLanguageDependentString("DeletingKey"), 0);
                }
            } else if (this.getControllerSettings().shouldAskOnDeletionOfReferencedElements()) {
                n = JOptionPane.showConfirmDialog(this.getJaWEFrame(), this.getSettings().getLanguageDependentString("MessageReferencedDoYouReallyWantToDeleteSelectedItem"), this.getSettings().getLanguageDependentString("DeletingKey"), 0);
            }
        }
        return n == 0;
    }

    protected static Set refElsNotToAskOnDeletion(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        String[] stringArray = XMLUtil.tokenize((String)string, (String)" ");
        if (stringArray.length > 0) {
            hashSet.addAll(Arrays.asList(stringArray));
        }
        return hashSet;
    }

    public JaWEEdit getEdit() {
        return this.edit;
    }

    public JaWESelectionManager getSelectionManager() {
        return this.selectionMng;
    }

    public JaWEActions getJaWEActions() {
        return this.defaultJaWEActions;
    }

    public JaWEFrame getJaWEFrame() {
        return this.frame;
    }

    public void adjustActions() {
        this.settings.adjustActions();
        this.defaultJaWEActions.enableDisableActions();
    }

    protected void updateTitle() {
        Object object;
        String string = "";
        if (this.getMainPackage() != null && (object = this.getXPDLListenerObservable(this.getMainPackage())) != null && ((XPDLListenerAndObservable)object).isModified()) {
            string = "*";
        }
        string = string + JaWEManager.getInstance().getName() + " " + BuildInfo.getVersion() + "-" + BuildInfo.getRelease();
        object = this.getCurrentConfigName();
        if (object == null) {
            object = "Default";
        }
        string = string + " (" + (String)object + " " + this.getSettings().getLanguageDependentString("ConfigurationKey") + ")";
        if (this.getMainPackage() != null) {
            string = string + " - ";
            XPDLHandler xPDLHandler = JaWEManager.getInstance().getXPDLHandler();
            String string2 = xPDLHandler.getAbsoluteFilePath(this.getMainPackage());
            string = string2 == null || string2.equals("") ? string + this.getSettings().getLanguageDependentString("NotSavedKey") : string + string2;
        }
        if (this.getJaWEFrame() != null) {
            this.getJaWEFrame().setTitle(string);
        }
    }

    public JaWETypes getJaWETypes() {
        return this.jtypes;
    }

    public JaWETypeResolver getTypeResolver() {
        return this.jtypeResolver;
    }

    public ControllerSettings getControllerSettings() {
        return this.settings;
    }

    @Override
    public void setUpdateInProgress(boolean bl) {
        this.updateInProgress = bl;
    }

    @Override
    public boolean isUpdateInProgress() {
        return this.updateInProgress;
    }

    public UndoHistoryManager getUndoHistoryManager() {
        return this.undoHistoryManager;
    }

    public String getCurrentConfig() {
        if (this.currentConfig == null) {
            this.fillConfigInfo();
            this.currentConfig = "default";
            String string = System.getProperty("JaWE_CURRENT_CONFIG_HOME");
            if (string != null) {
                int n;
                int n2 = string.lastIndexOf("/");
                int n3 = Math.max(n2, n = string.lastIndexOf("\\"));
                if (n3 >= 0) {
                    string = string.substring(n3 + 1);
                }
                this.currentConfig = string;
            }
        }
        return this.currentConfig;
    }

    public String getCurrentConfigName() {
        String string = JaWEManager.getInstance().getJaWEController().getCurrentConfig();
        return (String)this.configInfo.get(string);
    }

    public String getConfigId(String string) {
        if (this.configInfo != null) {
            return this.getConfigId(this.configInfo, string);
        }
        return string;
    }

    protected String getConfigId(Map map, String string) {
        for (Map.Entry entry : map.entrySet()) {
            if (!entry.getValue().equals(string)) continue;
            return (String)entry.getKey();
        }
        return string;
    }

    public Map getConfigInfo() {
        if (this.configInfo == null) {
            this.fillConfigInfo();
        }
        return Collections.unmodifiableMap(this.configInfo);
    }

    protected void fillConfigInfo() {
        Serializable serializable;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (JaWEConstants.JAWE_CONF_HOME != null && ((File)(serializable = new File(JaWEConstants.JAWE_CONF_HOME))).exists()) {
            File[] fileArray = ((File)serializable).listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isDirectory()) continue;
                hashMap.put(fileArray[i].getName(), this.readConfigName(fileArray[i].getName()));
            }
        }
        serializable = new ArrayList(hashMap.values());
        Collections.sort(serializable);
        this.configInfo = new SequencedHashMap();
        for (int i = 0; i < serializable.size(); ++i) {
            String string = (String)serializable.get(i);
            this.configInfo.put(this.getConfigId(hashMap, string), string);
        }
    }

    protected String readConfigName(String string) {
        String string2 = JaWEConstants.JAWE_CONF_HOME + "/" + string + "/jaweconfigname";
        File file = new File(string2);
        if (file.exists()) {
            Properties properties = new Properties();
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(string2);
                properties.load(fileInputStream);
                String string3 = properties.getProperty("JaWE_CONFIG_NAME", string);
                return string3;
            }
            catch (Exception exception) {
                throw new Error("Something went wrong while reading external component properties !!!", exception);
            }
            finally {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return string;
    }

    public String openDialog(String string, String string2) {
        return JaWEXMLUtil.dialog(this.getJaWEFrame(), string, 0, 0, string2);
    }

    public String saveDialog(String string, int n, String string2) {
        return JaWEXMLUtil.dialog(this.getJaWEFrame(), string, 1, n, string2);
    }

    public void message(String string, int n) {
        JOptionPane.showMessageDialog(this.getJaWEFrame(), string, this.getAppTitle(), n);
    }

    public String getAppTitle() {
        return this.appTitle;
    }
}

