/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.base.label;

import java.lang.reflect.Method;
import org.enhydra.jawe.Settings;
import org.enhydra.jawe.base.label.LabelGenerator;
import org.enhydra.jawe.base.label.LabelGeneratorSettings;
import org.enhydra.jxpdl.XMLAttribute;
import org.enhydra.jxpdl.XMLCollection;
import org.enhydra.jxpdl.XMLCollectionElement;
import org.enhydra.jxpdl.XMLComplexChoice;
import org.enhydra.jxpdl.XMLComplexElement;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLEmptyChoiceElement;
import org.enhydra.jxpdl.XMLSimpleElement;
import org.enhydra.jxpdl.elements.BasicType;
import org.enhydra.jxpdl.elements.DataTypes;
import org.enhydra.jxpdl.elements.Join;
import org.enhydra.jxpdl.elements.Split;

public class StandardLabelGenerator
implements LabelGenerator {
    protected LabelGeneratorSettings settings;

    public StandardLabelGenerator() {
        this.settings = new LabelGeneratorSettings();
        this.settings.init(null);
    }

    public StandardLabelGenerator(LabelGeneratorSettings labelGeneratorSettings) {
        this.settings = labelGeneratorSettings;
        this.settings.init(null);
    }

    public String getLabel(DataTypes dataTypes) {
        return this.settings.getLanguageDependentString("TypeKey");
    }

    public String getLabel(Join join) {
        return this.settings.getLanguageDependentString("JoinTypeKey");
    }

    public String getLabel(Split split) {
        return this.settings.getLanguageDependentString("SplitTypeKey");
    }

    public String getLabel(XMLEmptyChoiceElement xMLEmptyChoiceElement) {
        return "";
    }

    public String getLabel(XMLComplexChoice xMLComplexChoice) {
        return this.settings.getLanguageDependentString(xMLComplexChoice.toName() + "Key");
    }

    public String getLabel(XMLCollection xMLCollection) {
        return this.generateStandardLabel((XMLElement)xMLCollection);
    }

    public String getLabel(XMLCollectionElement xMLCollectionElement) {
        return this.generateStandardLabel((XMLElement)xMLCollectionElement);
    }

    public String getLabel(XMLComplexElement xMLComplexElement) {
        return this.generateStandardLabel((XMLElement)xMLComplexElement);
    }

    public String getLabel(XMLSimpleElement xMLSimpleElement) {
        return this.generateStandardLabel((XMLElement)xMLSimpleElement);
    }

    public String getLabel(XMLAttribute xMLAttribute) {
        if (xMLAttribute.getParent() instanceof Join || xMLAttribute.getParent() instanceof Split) {
            return this.getLabel(xMLAttribute.getParent());
        }
        if (xMLAttribute.getParent() instanceof BasicType) {
            return this.settings.getLanguageDependentString("SubTypeKey");
        }
        return this.generateStandardLabel((XMLElement)xMLAttribute);
    }

    @Override
    public String getLabel(XMLElement xMLElement) {
        try {
            Method method;
            Class<Object> clazz;
            block8: {
                clazz = xMLElement.getClass();
                method = null;
                try {
                    method = this.getClass().getMethod("getLabel", clazz);
                }
                catch (Exception exception) {
                    if (clazz == XMLSimpleElement.class || clazz == XMLAttribute.class || clazz == XMLComplexChoice.class || clazz == XMLComplexElement.class || clazz == XMLCollectionElement.class || clazz == XMLCollection.class) break block8;
                    if (XMLComplexChoice.class.isAssignableFrom(clazz)) {
                        clazz = XMLComplexChoice.class;
                    }
                    if (XMLAttribute.class.isAssignableFrom(clazz)) {
                        clazz = XMLAttribute.class;
                    }
                    if (XMLSimpleElement.class.isAssignableFrom(clazz)) {
                        clazz = XMLSimpleElement.class;
                    }
                    if (XMLComplexElement.class.isAssignableFrom(clazz)) {
                        clazz = XMLComplexElement.class;
                    }
                    if (!XMLCollection.class.isAssignableFrom(clazz)) break block8;
                    clazz = XMLCollection.class;
                }
            }
            method = this.getClass().getMethod("getLabel", clazz);
            return (String)method.invoke((Object)this, xMLElement);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return this.generateStandardLabel(xMLElement);
        }
    }

    public String generateStandardLabel(XMLElement xMLElement) {
        return this.settings.getLanguageDependentString(xMLElement.toName() + "Key");
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }
}

