/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.base.panel.panels.tablesorting;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.base.controller.JaWEController;
import org.enhydra.jawe.base.panel.InlinePanel;
import org.enhydra.jawe.base.panel.panels.XMLTablePanel;
import org.enhydra.jawe.base.panel.panels.tablesorting.SortingTableModel;
import org.enhydra.jxpdl.XMLCollection;
import org.enhydra.jxpdl.XMLElement;

public class SortingTable
extends JTable {
    protected int sortedColIndex = -1;
    protected boolean ascending = true;
    protected InlinePanel ipc;
    XMLTablePanel owner;

    public SortingTable(XMLTablePanel xMLTablePanel, Vector vector, Vector vector2) {
        super(new SortingTableModel((XMLCollection)xMLTablePanel.getOwner(), vector, vector2));
        this.owner = xMLTablePanel;
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.setDefaultRenderer(new SHRenderer());
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SortingTable.this.performSorting(mouseEvent);
            }
        };
        jTableHeader.addMouseListener(mouseAdapter);
    }

    public SortingTable(XMLTablePanel xMLTablePanel, Vector vector, Vector vector2, InlinePanel inlinePanel) {
        this(xMLTablePanel, vector, vector2);
        this.ipc = inlinePanel;
    }

    public int getSortedColumnIndex() {
        return this.sortedColIndex;
    }

    public boolean isSortedColumnAscending() {
        return this.ascending;
    }

    public synchronized void performSorting(MouseEvent mouseEvent) {
        if (this.owner.getOwner().isReadOnly() && ((XMLCollection)this.owner.getOwner()).getParent().isReadOnly()) {
            return;
        }
        if (mouseEvent == null && this.sortedColIndex == -1) {
            return;
        }
        if (this.ipc != null) {
            this.ipc.getJaWEComponent().setUpdateInProgress(true);
        }
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = this.sortedColIndex;
        if (mouseEvent != null) {
            n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
        }
        int n2 = tableColumnModel.getColumn(n).getModelIndex();
        SortingTableModel sortingTableModel = (SortingTableModel)this.getModel();
        Object object = null;
        int n3 = this.getSelectedRow();
        if (n3 >= 0) {
            object = sortingTableModel.getValueAt(n3, 0);
        }
        if (this.sortedColIndex == n && mouseEvent != null) {
            this.ascending = !this.ascending;
        }
        this.sortedColIndex = n;
        sortingTableModel.sortByColumn(n2, this.ascending);
        ArrayList<XMLCollection> arrayList = new ArrayList<XMLCollection>();
        JaWEController jaWEController = null;
        if (this.ipc != null) {
            jaWEController = JaWEManager.getInstance().getJaWEController();
            jaWEController.startUndouableChange();
        }
        XMLCollection xMLCollection = (XMLCollection)this.owner.getOwner();
        for (int i = 0; i < sortingTableModel.getRowCount(); ++i) {
            XMLElement xMLElement = (XMLElement)sortingTableModel.getValueAt(i, 0);
            if (!xMLCollection.contains(xMLElement)) continue;
            xMLCollection.reposition(xMLElement, i);
        }
        if (this.ipc != null) {
            arrayList.add(xMLCollection);
            jaWEController.endUndouableChange(arrayList);
        }
        if (object != null) {
            try {
                this.owner.setSelectedElement(object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.update(this.getGraphics());
        this.getTableHeader().update(this.getTableHeader().getGraphics());
        if (this.ipc != null) {
            this.ipc.getJaWEComponent().setUpdateInProgress(false);
        }
    }

    static class SHRenderer
    extends DefaultTableCellRenderer {
        static Icon NONSORTED = null;
        static Icon ASCENDING = null;
        static Icon DESCENDING = null;

        public SHRenderer() {
            this.setHorizontalTextPosition(2);
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2;
            int n3 = -1;
            boolean bl3 = true;
            SortingTable sortingTable = (SortingTable)jTable;
            n3 = sortingTable.getSortedColumnIndex();
            bl3 = sortingTable.isSortedColumnAscending();
            if (jTable != null && (object2 = jTable.getTableHeader()) != null) {
                this.setForeground(((Component)object2).getForeground());
                this.setBackground(((Component)object2).getBackground());
                this.setFont(((Component)object2).getFont());
            }
            object2 = null;
            object2 = bl3 ? ASCENDING : DESCENDING;
            if (n2 == n3) {
                this.setIcon((Icon)object2);
            } else {
                this.setIcon(NONSORTED);
            }
            if (object == null) {
                this.setText("");
            } else {
                this.setText(object.toString());
            }
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this;
        }

        static {
            URL uRL = SortingTable.class.getClassLoader().getResource("org/enhydra/jawe/images/arrowup.gif");
            if (uRL != null) {
                ASCENDING = new ImageIcon(uRL);
            }
            if ((uRL = SortingTable.class.getClassLoader().getResource("org/enhydra/jawe/images/arrowdown.gif")) != null) {
                DESCENDING = new ImageIcon(uRL);
            }
        }
    }
}

