/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.graph;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.enhydra.jawe.Utils;
import org.enhydra.jawe.components.graph.DefaultGraphEventActivityRenderer;
import org.enhydra.jawe.components.graph.GraphActivityInterface;
import org.enhydra.jawe.components.graph.GraphActivityRendererInterface;
import org.enhydra.jawe.components.graph.GraphActivityViewInterface;
import org.enhydra.jawe.components.graph.GraphUtilities;
import org.enhydra.jawe.components.graph.MultiLinedRenderer;
import org.enhydra.jxpdl.elements.Activity;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.VertexView;

public class DefaultGraphActivityView
extends VertexView
implements GraphActivityViewInterface {
    protected static Map renderers = new HashMap();
    protected static List mthlst = Arrays.asList("intersection", "getPerimeterPoint", "getCenterPoint", "getLocation", "paintPort", "getCBounds");

    public DefaultGraphActivityView(Object object) {
        super(object);
    }

    public CellViewRenderer getRenderer() {
        String string = ((GraphActivityInterface)super.getCell()).getType();
        GraphActivityRendererInterface graphActivityRendererInterface = (GraphActivityRendererInterface)renderers.get(string);
        if (graphActivityRendererInterface == null) {
            graphActivityRendererInterface = this.createRenderer((Activity)((GraphActivityInterface)super.getCell()).getUserObject());
            renderers.put(string, graphActivityRendererInterface);
        }
        return graphActivityRendererInterface;
    }

    public Rectangle2D getBounds() {
        String string = Utils.getCallerMethodName(0);
        if (mthlst.contains(string)) {
            return this.bounds;
        }
        Dimension dimension = ((GraphActivityRendererInterface)this.getRenderer()).getLabelDimension(this);
        int n = dimension.getWidth() > this.bounds.getWidth() ? (int)(dimension.getWidth() - this.bounds.getWidth()) / 2 : 0;
        Rectangle rectangle = new Rectangle((int)(this.bounds.getX() - (double)n), (int)(this.bounds.getY() + this.bounds.getHeight()), (int)dimension.getWidth(), (int)dimension.getHeight());
        if (rectangle != null) {
            Rectangle2D.union(this.bounds, rectangle, rectangle);
        }
        return rectangle;
    }

    @Override
    public Rectangle getOriginalBounds() {
        return this.bounds.getBounds();
    }

    @Override
    public void setOriginalBounds(Rectangle rectangle) {
        this.bounds = rectangle;
    }

    protected GraphActivityRendererInterface createRenderer(Activity activity) {
        return GraphUtilities.getGraphController().getGraphObjectRendererFactory().createActivityRenderer(activity);
    }

    public Point2D getPerimeterPoint(EdgeView edgeView, Point2D point2D, Point2D point2D2) {
        CellViewRenderer cellViewRenderer = this.getRenderer();
        if (cellViewRenderer instanceof DefaultGraphEventActivityRenderer) {
            return ((DefaultGraphEventActivityRenderer)this.getRenderer()).getPerimeterPoint(this, point2D2);
        }
        return ((MultiLinedRenderer)this.getRenderer()).getPerimeterPoint(this, point2D2);
    }
}

