/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.graph;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.enhydra.jawe.Utils;
import org.enhydra.jawe.components.graph.GraphArtifactInterface;
import org.enhydra.jawe.components.graph.GraphArtifactRendererInterface;
import org.enhydra.jawe.components.graph.GraphArtifactViewInterface;
import org.enhydra.jawe.components.graph.GraphUtilities;
import org.enhydra.jawe.components.graph.MultiLinedRenderer;
import org.enhydra.jxpdl.elements.Artifact;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.VertexView;

public class DefaultGraphArtifactView
extends VertexView
implements GraphArtifactViewInterface {
    protected static Map renderers = new HashMap();
    protected static List mthlst = Arrays.asList("intersection", "getPerimeterPoint", "getCenterPoint", "paintPort", "getCBounds");

    public DefaultGraphArtifactView(Object object) {
        super(object);
    }

    public CellViewRenderer getRenderer() {
        String string = ((GraphArtifactInterface)super.getCell()).getType();
        GraphArtifactRendererInterface graphArtifactRendererInterface = (GraphArtifactRendererInterface)renderers.get(string);
        if (graphArtifactRendererInterface == null) {
            graphArtifactRendererInterface = this.createRenderer((Artifact)((GraphArtifactInterface)super.getCell()).getUserObject());
            renderers.put(string, graphArtifactRendererInterface);
        }
        return graphArtifactRendererInterface;
    }

    public Rectangle2D getBounds() {
        GraphArtifactInterface graphArtifactInterface = (GraphArtifactInterface)this.getCell();
        Artifact artifact = (Artifact)graphArtifactInterface.getUserObject();
        String string = Utils.getCallerMethodName(0);
        if (artifact.getArtifactType().equals("Annotation") || mthlst.contains(string)) {
            return this.bounds;
        }
        Dimension dimension = ((GraphArtifactRendererInterface)this.getRenderer()).getLabelDimension(this);
        int n = dimension.getWidth() > this.bounds.getWidth() ? (int)(dimension.getWidth() - this.bounds.getWidth()) / 2 : 0;
        Rectangle rectangle = new Rectangle((int)(this.bounds.getX() - (double)n), (int)(this.bounds.getY() + this.bounds.getHeight()), (int)dimension.getWidth(), (int)dimension.getHeight());
        if (rectangle != null) {
            Rectangle2D.union(this.bounds, rectangle, rectangle);
        }
        return rectangle;
    }

    @Override
    public Rectangle getOriginalBounds() {
        return this.bounds.getBounds();
    }

    @Override
    public void setOriginalBounds(Rectangle rectangle) {
        this.bounds = rectangle;
    }

    protected GraphArtifactRendererInterface createRenderer(Artifact artifact) {
        return GraphUtilities.getGraphController().getGraphObjectRendererFactory().createArtifactRenderer(artifact);
    }

    public Point2D getPerimeterPoint(EdgeView edgeView, Point2D point2D, Point2D point2D2) {
        return ((MultiLinedRenderer)this.getRenderer()).getPerimeterPoint(this, point2D2);
    }
}

