/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.graph.actions;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.enhydra.jawe.ActionBase;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.base.controller.JaWEController;
import org.enhydra.jawe.components.graph.Graph;
import org.enhydra.jawe.components.graph.GraphController;
import org.enhydra.jawe.components.graph.GraphUtilities;
import org.enhydra.jawe.components.graph.JaWEGraphModel;
import org.enhydra.jxpdl.XMLCollectionElement;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLUtil;
import org.enhydra.jxpdl.elements.Activity;
import org.enhydra.jxpdl.elements.ActivitySet;
import org.enhydra.jxpdl.elements.Package;
import org.enhydra.jxpdl.elements.Transition;
import org.enhydra.jxpdl.elements.WorkflowProcess;
import org.enhydra.jxpdl.utilities.SequencedHashMap;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.GraphModel;

public class SimpleGraphLayout
extends ActionBase {
    public SimpleGraphLayout(JaWEComponent jaWEComponent) {
        super(jaWEComponent);
    }

    @Override
    public void enableDisableAction() {
        JaWEController jaWEController = JaWEManager.getInstance().getJaWEController();
        GraphController graphController = (GraphController)this.jawecomponent;
        if (graphController.getSelectedGraph() != null && XMLUtil.getPackage((XMLElement)graphController.getSelectedGraph().getXPDLObject()) == jaWEController.getMainPackage()) {
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        GraphController graphController = (GraphController)this.jawecomponent;
        Graph graph = graphController.getSelectedGraph();
        if (graph == null) {
            return;
        }
        graphController.setUpdateInProgress(true);
        JaWEManager.getInstance().getJaWEController().startUndouableChange();
        SimpleGraphLayout.layoutGraph(graphController, graph);
        graph.clearSelection();
        ArrayList<XMLCollectionElement> arrayList = new ArrayList<XMLCollectionElement>();
        arrayList.add(graph.getXPDLObject());
        JaWEManager.getInstance().getJaWEController().endUndouableChange(arrayList);
        graphController.setUpdateInProgress(false);
    }

    public static void layoutAllGraphs() {
        Graph graph = null;
        GraphController graphController = GraphUtilities.getGraphController();
        graphController.setUpdateInProgress(true);
        JaWEManager.getInstance().getJaWEController().startUndouableChange();
        Iterator iterator = JaWEManager.getInstance().getXPDLHandler().getAllPackages().iterator();
        while (iterator.hasNext()) {
            for (WorkflowProcess workflowProcess : ((Package)iterator.next()).getWorkflowProcesses().toElements()) {
                if (graph == null) {
                    graph = graphController.getGraph((XMLCollectionElement)workflowProcess);
                }
                SimpleGraphLayout.layoutGraph(graphController, graphController.getGraph((XMLCollectionElement)workflowProcess));
                for (ActivitySet activitySet : workflowProcess.getActivitySets().toElements()) {
                    SimpleGraphLayout.layoutGraph(graphController, graphController.getGraph((XMLCollectionElement)activitySet));
                }
            }
        }
        ArrayList<XMLCollectionElement> arrayList = new ArrayList<XMLCollectionElement>();
        arrayList.add(graph.getXPDLObject());
        JaWEManager.getInstance().getJaWEController().endUndouableChange(arrayList);
        graphController.setUpdateInProgress(false);
    }

    public static void layoutGraph(GraphController graphController, Graph graph) {
        boolean bl = GraphUtilities.getGraphOrientation(graph.getXPDLObject()).equals("HORIZONTAL");
        Object[] objectArray = JaWEGraphModel.getAll((GraphModel)graph.getModel());
        graph.getModel().remove(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            Transition transition;
            if (!(objectArray[i] instanceof DefaultGraphCell) || !(((DefaultGraphCell)objectArray[i]).getUserObject() instanceof Transition) || (transition = (Transition)((DefaultGraphCell)objectArray[i]).getUserObject()).getTo().equals(transition.getFrom())) continue;
            GraphUtilities.setBreakpoints((XMLCollectionElement)transition, new ArrayList());
        }
        SimpleGraphLayout.sortItOut(graph.getXPDLObject(), bl);
        graph.getGraphManager().createWorkflowGraph(graph.getXPDLObject());
    }

    protected static void sortItOut(XMLCollectionElement xMLCollectionElement, boolean bl) {
        Object object;
        ArrayList arrayList = new ArrayList(XMLUtil.getStartingActivities((XMLCollectionElement)xMLCollectionElement));
        ArrayList<Activity> arrayList2 = new ArrayList<Activity>();
        HashMap<String, Point> hashMap = new HashMap<String, Point>();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        HashMap hashMap4 = new HashMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            Activity activity = (Activity)arrayList.get(i);
            object = SimpleGraphLayout.getYPos(hashMap, hashMap2, hashMap3, hashMap4, activity, null, bl);
            GraphUtilities.setOffsetPoint((XMLCollectionElement)activity, (Point)object, null);
            arrayList2.add(activity);
        }
        SequencedHashMap sequencedHashMap = new SequencedHashMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            sequencedHashMap.put(arrayList.get(i), null);
        }
        while (sequencedHashMap.size() > 0) {
            Point point;
            Activity activity = (Activity)sequencedHashMap.keySet().toArray()[0];
            object = SimpleGraphLayout.insertActivity(hashMap, hashMap3, activity, (Activity)sequencedHashMap.get((Object)activity), arrayList2, bl);
            sequencedHashMap.remove((Object)activity);
            if (object.size() == 0) {
                String string = GraphUtilities.getParticipantId(activity);
                point = (Point)hashMap.get(string);
                Point point2 = null;
                point2 = bl ? new Point(point.x + (int)(1.5 * (double)GraphUtilities.getGraphController().getGraphSettings().getActivityWidth()), point.y) : new Point(point.x, point.y + (int)(1.5 * (double)GraphUtilities.getGraphController().getGraphSettings().getActivityHeight()));
                hashMap.put(string, point2);
                continue;
            }
            for (int i = 0; i < object.size(); ++i) {
                point = object.get(i);
                if (sequencedHashMap.containsKey((Object)point)) continue;
                sequencedHashMap.put((Object)point, (Object)activity);
            }
        }
    }

    protected static List insertActivity(Map map, Map map2, Activity activity, Activity activity2, List list, boolean bl) {
        ArrayList<Activity> arrayList = new ArrayList<Activity>();
        if (list.contains(activity) && activity2 != null) {
            return arrayList;
        }
        List list2 = XMLUtil.getOrderedOutgoingTransitions((Activity)activity, (Set)XMLUtil.getOutgoingTransitions((Activity)activity));
        for (int i = 0; i < list2.size(); ++i) {
            Transition transition = (Transition)list2.get(i);
            Activity activity3 = XMLUtil.getWorkflowProcess((XMLElement)activity).getActivity(transition.getTo());
            if (list.contains(activity3)) continue;
            arrayList.add(activity3);
        }
        if (activity2 != null) {
            Point point = SimpleGraphLayout.getXPos(map, map2, activity, activity2, bl);
            GraphUtilities.setOffsetPoint((XMLCollectionElement)activity, point, null);
            list.add(activity);
        }
        return arrayList;
    }

    protected static Point getYPos(Map map, Map map2, Map map3, Map map4, Activity activity, Activity activity2, boolean bl) {
        Point point;
        int n = GraphUtilities.getGraphController().getGraphSettings().getActivityWidth();
        int n2 = GraphUtilities.getGraphController().getGraphSettings().getActivityHeight();
        int n3 = GraphUtilities.getGraphController().getGraphSettings().getLaneNameWidth();
        n3 = bl ? (int)((double)n3 + (double)n * 1.5) : (int)((double)n3 + (double)n2 * 1.5);
        int n4 = 15;
        Point point2 = null;
        String string = GraphUtilities.getParticipantId(activity);
        Point point3 = (Point)map2.get(string);
        Point point4 = point = activity2 != null ? GraphUtilities.getOffsetPoint(activity2) : null;
        if (point3 == null) {
            point3 = point;
            if (point3 == null) {
                point2 = bl ? new Point(n3, n4) : new Point(n4, n3);
            }
            map.put(string, point2);
            map3.put(string, activity);
        } else if (point != null) {
            point3 = bl ? new Point(point3.x, Math.max(point3.y, point.y)) : new Point(Math.max(point3.x, point.x), point3.y);
        }
        if (point2 == null) {
            point2 = bl ? new Point(point3.x, point3.y + (int)(1.5 * (double)n2)) : new Point(point3.x + (int)(1.5 * (double)n), point3.y);
        }
        map2.put(string, point2);
        map4.put(string, activity);
        return point2;
    }

    protected static Point getXPos(Map map, Map map2, Activity activity, Activity activity2, boolean bl) {
        int n = GraphUtilities.getGraphController().getGraphSettings().getActivityWidth();
        int n2 = GraphUtilities.getGraphController().getGraphSettings().getActivityHeight();
        int n3 = 15;
        Point point = null;
        String string = GraphUtilities.getParticipantId(activity);
        Point point2 = (Point)map.get(string);
        Point point3 = GraphUtilities.getOffsetPoint(activity2);
        boolean bl2 = true;
        if (point2 == null) {
            point2 = point3;
            point2 = bl ? new Point(point3.x, n3) : new Point(n3, point3.y);
        } else {
            point2 = bl ? new Point(Math.max(point2.x, point3.x), point2.y) : new Point(point2.x, Math.max(point2.y, point3.y));
        }
        Activity activity3 = (Activity)map2.get(string);
        if (activity3 != null) {
            Set set = XMLUtil.getIncomingTransitions((Activity)activity3);
            for (Transition transition : set) {
                if (!transition.getFrom().equals(activity2.getId())) continue;
                bl2 = false;
                break;
            }
        }
        if (bl) {
            if (bl2) {
                point = new Point(point2.x + (int)(1.5 * (double)n), point2.y);
            } else {
                point = GraphUtilities.getOffsetPoint(activity3);
                point.y += (int)(1.5 * (double)n2);
            }
        } else if (bl2) {
            point = new Point(point2.x, point2.y + (int)(1.5 * (double)n2));
        } else {
            point = GraphUtilities.getOffsetPoint(activity3);
            point.x += (int)(1.5 * (double)n);
        }
        if (bl2) {
            map.put(string, point);
        }
        map2.put(string, activity);
        return point;
    }
}

