/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.xpdlview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelListener;
import java.io.ByteArrayOutputStream;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEComponentView;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.base.controller.JaWEController;
import org.enhydra.jawe.components.xpdlview.MouseWheelHandler;
import org.enhydra.jawe.components.xpdlview.XPDLViewController;
import org.enhydra.jawe.components.xpdlview.XPDLViewSettings;
import org.enhydra.jxpdl.XMLAttribute;
import org.enhydra.jxpdl.XMLCollection;
import org.enhydra.jxpdl.XMLComplexChoice;
import org.enhydra.jxpdl.XMLComplexElement;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLSimpleElement;
import org.enhydra.jxpdl.elements.Package;
import org.jedit.syntax.JEditTextArea;
import org.jedit.syntax.SyntaxDocument;
import org.jedit.syntax.SyntaxStyle;
import org.jedit.syntax.TextAreaPainter;
import org.jedit.syntax.TokenMarker;
import org.jedit.syntax.XMLTokenMarker;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XPDLViewControllerPanel
extends JPanel
implements JaWEComponentView {
    protected XPDLViewController controller;
    protected JEditTextArea xpdlPreviewTA;
    protected JComboBox searchCB = new JComboBox();
    protected Component searchPanel;
    protected XMLElement elementToShow;

    public XPDLViewControllerPanel(XPDLViewController xPDLViewController) {
        this.controller = xPDLViewController;
    }

    @Override
    public void configure() {
    }

    @Override
    public void init() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        this.add(this.createCenterComponent(), "Center");
        this.searchPanel = this.createSearchPanel();
        this.add(this.searchPanel, "North");
    }

    @Override
    public JaWEComponent getJaWEComponent() {
        return this.controller;
    }

    @Override
    public JComponent getDisplay() {
        return this;
    }

    public void setSelectedElement(XMLElement xMLElement) {
        this.elementToShow = xMLElement;
        this.refreshView();
    }

    public XMLElement getSelectedElement() {
        return this.elementToShow;
    }

    protected Component createCenterComponent() {
        this.xpdlPreviewTA = new JEditTextArea();
        this.xpdlPreviewTA.setEditable(false);
        this.xpdlPreviewTA.setMinimumSize(new Dimension(100, 100));
        this.xpdlPreviewTA.setElectricScroll(3);
        this.xpdlPreviewTA.addMouseWheelListener((MouseWheelListener)new MouseWheelHandler(this.xpdlPreviewTA));
        Color color = ((XPDLViewSettings)this.controller.getSettings()).getBackgroundColor();
        if (this.controller.getXPDLViewSettings().showHighlight()) {
            SyntaxDocument syntaxDocument = new SyntaxDocument();
            syntaxDocument.putProperty((Object)"tabSize", (Object)new Integer(4));
            this.xpdlPreviewTA.setDocument(syntaxDocument);
            this.xpdlPreviewTA.setTokenMarker((TokenMarker)new XMLTokenMarker());
            TextAreaPainter textAreaPainter = this.xpdlPreviewTA.getPainter();
            SyntaxStyle[] syntaxStyleArray = textAreaPainter.getStyles();
            syntaxStyleArray[6] = new SyntaxStyle(new Color(0, 102, 153), false, true);
            syntaxStyleArray[7] = new SyntaxStyle(new Color(0, 153, 102), false, true);
            syntaxStyleArray[8] = new SyntaxStyle(new Color(0, 153, 255), false, true);
            syntaxStyleArray[3] = new SyntaxStyle(new Color(255, 0, 204), false, false);
            syntaxStyleArray[4] = new SyntaxStyle(new Color(204, 0, 204), false, false);
            textAreaPainter.setStyles(syntaxStyleArray);
            textAreaPainter.setEOLMarkersPainted(false);
            textAreaPainter.setBracketHighlightEnabled(true);
            textAreaPainter.setBackground(color);
        }
        this.xpdlPreviewTA.setBackground(color);
        return this.xpdlPreviewTA;
    }

    protected Component createSearchPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        Border border = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        jPanel.setBorder(border);
        JLabel jLabel = new JLabel(this.controller.getSettings().getLanguageDependentString("SearchForKey") + ": ");
        jLabel.setAlignmentX(0.0f);
        jLabel.setAlignmentY(1.0f);
        jLabel.setHorizontalAlignment(4);
        this.searchCB.setEditable(true);
        this.searchCB.setAlignmentX(0.0f);
        this.searchCB.setAlignmentY(1.0f);
        Dimension dimension = new Dimension(200, 20);
        this.searchCB.setMinimumSize(new Dimension(dimension));
        this.searchCB.setMaximumSize(new Dimension(dimension));
        this.searchCB.setPreferredSize(new Dimension(dimension));
        Color color = ((XPDLViewSettings)this.controller.getSettings()).getBackgroundColor();
        this.searchCB.setBackground(color);
        this.searchCB.getEditor().getEditorComponent().setBackground(color);
        JButton jButton = new JButton("");
        jButton.setIcon(this.controller.getXPDLViewSettings().getFindNextIcon());
        jButton.setToolTipText(this.controller.getSettings().getLanguageDependentString("FindNextStringOccuranceKey"));
        jButton.setVerticalTextPosition(0);
        jButton.setAlignmentX(0.0f);
        jButton.setAlignmentY(1.0f);
        jButton.setPreferredSize(new Dimension(20, 20));
        jPanel.add(jLabel);
        jPanel.add(this.searchCB);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                XPDLViewControllerPanel.this.findString();
            }
        });
        return jPanel;
    }

    public void refreshView() {
        try {
            String string = "";
            this.xpdlPreviewTA.setText(string);
            Document document = null;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            if (this.elementToShow != null) {
                if (!(this.elementToShow instanceof XMLAttribute)) {
                    Object object;
                    Object object2;
                    if (this.elementToShow instanceof Package) {
                        JaWEManager.getInstance().getXPDLHandler().getXPDLRepositoryHandler().toXML(document, (Package)this.elementToShow);
                    } else {
                        object2 = document.createElement(this.elementToShow.toName());
                        if (this.elementToShow instanceof XMLComplexElement) {
                            JaWEManager.getInstance().getXPDLHandler().getXPDLRepositoryHandler().toXML((Node)object2, (XMLComplexElement)this.elementToShow);
                        } else if (this.elementToShow instanceof XMLCollection) {
                            JaWEManager.getInstance().getXPDLHandler().getXPDLRepositoryHandler().toXML((Node)object2, (XMLCollection)this.elementToShow);
                        } else if (this.elementToShow instanceof XMLComplexChoice) {
                            JaWEManager.getInstance().getXPDLHandler().getXPDLRepositoryHandler().toXML((Node)object2, (XMLComplexChoice)this.elementToShow);
                        } else if (this.elementToShow instanceof XMLSimpleElement) {
                            JaWEManager.getInstance().getXPDLHandler().getXPDLRepositoryHandler().toXML((Node)object2, (XMLSimpleElement)this.elementToShow);
                        }
                        object = object2.getFirstChild();
                        if (object == null) {
                            object = object2;
                        }
                        document.appendChild((Node)object);
                    }
                    object2 = TransformerFactory.newInstance();
                    object = ((TransformerFactory)object2).newTransformer();
                    ((Transformer)object).setOutputProperty("indent", "yes");
                    ((Transformer)object).setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                    ((Transformer)object).setOutputProperty("encoding", JaWEManager.getInstance().getJaWEController().getControllerSettings().getEncoding());
                    if (!(this.elementToShow instanceof Package)) {
                        ((Transformer)object).setOutputProperty("omit-xml-declaration", "yes");
                    }
                    DOMSource dOMSource = new DOMSource(document);
                    StreamResult streamResult = new StreamResult(byteArrayOutputStream);
                    ((Transformer)object).transform(dOMSource, streamResult);
                    string = byteArrayOutputStream.toString(JaWEManager.getInstance().getJaWEController().getControllerSettings().getEncoding());
                    byteArrayOutputStream.close();
                } else {
                    string = this.elementToShow.toName() + "=" + "\"" + this.elementToShow.toValue() + "\"";
                }
            }
            this.xpdlPreviewTA.setText(string);
            this.xpdlPreviewTA.setCaretPosition(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void findString() {
        if (this.searchCB.getSelectedItem() == null) {
            return;
        }
        String string = this.searchCB.getSelectedItem().toString();
        this.addItemToCombo(string);
        String string2 = this.xpdlPreviewTA.getText();
        try {
            int n;
            for (int i = n = this.xpdlPreviewTA.getCaretPosition(); i <= string2.length() - string.length(); ++i) {
                if (!string2.substring(i, i + string.length()).equalsIgnoreCase(string)) continue;
                this.xpdlPreviewTA.setCaretPosition(i);
                this.xpdlPreviewTA.select(i, i + string.length());
                n = i + string.length();
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        JaWEController jaWEController = JaWEManager.getInstance().getJaWEController();
        JOptionPane.showMessageDialog(jaWEController.getJaWEFrame(), this.controller.getSettings().getLanguageDependentString("MessageJaWEHasFinishedSearchingXPDL"), jaWEController.getAppTitle(), 1);
        this.xpdlPreviewTA.setCaretPosition(0);
    }

    private void addItemToCombo(String string) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        for (int i = 0; i < this.searchCB.getItemCount(); ++i) {
            if (!this.searchCB.getItemAt(i).toString().equals(string)) continue;
            return;
        }
        this.searchCB.addItem(string);
    }

    public void changeLanguage() {
        JLabel jLabel = (JLabel)((JPanel)this.searchPanel).getComponent(0);
        JButton jButton = (JButton)((JPanel)this.searchPanel).getComponent(3);
        jLabel.setText(this.controller.getSettings().getLanguageDependentString("SearchForKey") + ": ");
        jButton.setToolTipText(this.controller.getSettings().getLanguageDependentString("FindNextStringOccuranceKey"));
    }
}

