/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.extpkgrelations;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.enhydra.jawe.BarFactory;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEComponentView;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.XPDLElementChangeInfo;
import org.enhydra.jawe.components.XPDLTreeCellRenderer;
import org.enhydra.jawe.components.XPDLTreeNode;
import org.enhydra.jawe.components.XPDLTreeUtil;
import org.enhydra.jawe.components.extpkgrelations.ExtPkgRelations;
import org.enhydra.jawe.components.extpkgrelations.ExtPkgRelationsTreeModel;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLUtil;
import org.enhydra.jxpdl.elements.ExternalPackages;
import org.enhydra.jxpdl.elements.Package;

public class ExtPkgRelationsPanel
extends JPanel
implements JaWEComponentView {
    protected ExtPkgRelationsTreeModel treeModel;
    protected JTree tree;
    protected JToolBar toolbar;
    protected JLabel epInfo = new JLabel();
    protected JPanel innerPanel = new JPanel();
    protected JScrollPane scrollPane;
    protected ExtPkgRelations controller;
    protected XPDLTreeCellRenderer renderer;

    public ExtPkgRelationsPanel(ExtPkgRelations extPkgRelations) {
        this.controller = extPkgRelations;
    }

    public void configure() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        this.toolbar = BarFactory.createToolbar((String)"defaultToolbar", (JaWEComponent)this.controller);
        this.toolbar.setFloatable(false);
        if (this.toolbar.getComponentCount() > 0) {
            this.add((Component)this.toolbar, "North");
        }
        this.innerPanel.setLayout(new BorderLayout());
        this.innerPanel.add((Component)this.epInfo, "North");
        this.add((Component)this.innerPanel, "Center");
        this.init();
    }

    public void init() {
        this.treeModel = new ExtPkgRelationsTreeModel(this.controller);
        this.tree = new JTree((TreeModel)((Object)this.treeModel)){

            @Override
            public void scrollRectToVisible(Rectangle rectangle) {
                rectangle.x = ExtPkgRelationsPanel.this.scrollPane.getHorizontalScrollBar().getValue();
                super.scrollRectToVisible(rectangle);
            }
        };
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.renderer = new XPDLTreeCellRenderer((JaWEComponent)this.controller);
        Color color = this.controller.getExtSettings().getBackgroundColor();
        this.renderer.setBackgroundNonSelectionColor(color);
        this.tree.setBackground(color);
        this.tree.setCellRenderer((TreeCellRenderer)this.renderer);
        this.scrollPane = new JScrollPane();
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setViewportView(this.tree);
        JViewport jViewport = this.scrollPane.getViewport();
        jViewport.setScrollMode(1);
        this.scrollPane.setBackground(Color.lightGray);
        this.innerPanel.add((Component)this.scrollPane, "Center");
    }

    public TreeModel getTreeModel() {
        return this.treeModel;
    }

    public JTree getTree() {
        return this.tree;
    }

    public JaWEComponent getJaWEComponent() {
        return this.controller;
    }

    public JComponent getDisplay() {
        return this;
    }

    public void refreshExtPkgPanel(XPDLElementChangeInfo xPDLElementChangeInfo) {
        Object object;
        Package package_;
        int n = xPDLElementChangeInfo.getAction();
        if (n == 10) {
            this.renderer.setValidationErrors(xPDLElementChangeInfo.getChangedSubElements());
            this.tree.repaint();
        }
        if (n != 8 && n != 5 && n != 3) {
            return;
        }
        Set set = this.renderer.getErrors();
        Set set2 = this.renderer.getWarnings();
        XMLElement xMLElement = xPDLElementChangeInfo.getChangedElement();
        this.tree.clearSelection();
        if (xMLElement == null || n != 8 && (xMLElement instanceof Package || xMLElement instanceof ExternalPackages)) {
            this.reinitialize();
            if (n != 3) {
                return;
            }
        }
        if ((package_ = XMLUtil.getPackage((XMLElement)xMLElement)) != null && !package_.isTransient() && !this.treeModel.getRootNode().isLeaf() && (object = (XPDLTreeNode)this.treeModel.getRootNode().getFirstChild()) != null && object.getXPDLElement() == package_ && n == 8) {
            return;
        }
        this.reinitialize();
        this.renderer.setErrors(set);
        this.renderer.setWarnings(set2);
        if (package_ != null && !package_.isTransient()) {
            this.treeModel.insertNode((XMLElement)package_);
            XPDLTreeUtil.expandOrCollapsToLevel((JTree)this.tree, (TreePath)new TreePath(this.treeModel.getRootNode()), (int)2, (boolean)true);
        }
        object = " ";
        if (package_ != null) {
            object = (String)object + JaWEManager.getInstance().getLabelGenerator().getLabel((XMLElement)package_) + ", Id='" + package_.getId() + "'";
        }
        this.epInfo.setText((String)object);
    }

    public boolean hasRelations() {
        return !this.treeModel.getRootNode().isLeaf();
    }

    protected void reinitialize() {
        this.innerPanel.remove(this.scrollPane);
        this.treeModel.clearTree();
        this.tree.getSelectionModel().clearSelection();
        this.tree.setCellRenderer(null);
        this.epInfo.setText("");
        this.init();
    }
}

