/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.wfxml;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.base.panel.panels.XMLGroupPanel;
import org.enhydra.jawe.base.panel.panels.XMLMultiLineTextPanel;
import org.enhydra.jawe.base.panel.panels.XMLPanel;
import org.enhydra.jawe.base.panel.panels.XMLTextPanel;
import org.enhydra.jawe.components.wfxml.DefInfo;
import org.enhydra.jxpdl.XMLElement;

public class DefInfoEditor
extends JDialog {
    public static final int STATUS_OK = 0;
    public static final int STATUS_CANCEL = 1;
    protected XMLPanel panelToEdit;
    protected JButton buttonOK;
    protected JButton buttonCancel;
    protected int status = 0;
    protected DefInfo di;
    protected WindowListener wl = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            DefInfoEditor.this.status = 1;
            DefInfoEditor.this.dispose();
        }
    };
    protected ActionListener cl = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DefInfoEditor.this.status = 1;
            DefInfoEditor.this.dispose();
        }
    };
    protected ActionListener okl = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (DefInfoEditor.this.panelToEdit.getOwner().isReadOnly()) {
                DefInfoEditor.this.status = 1;
                DefInfoEditor.this.dispose();
            } else if (DefInfoEditor.this.canApplyChanges()) {
                DefInfoEditor.this.applyChanges();
                DefInfoEditor.this.status = 0;
                DefInfoEditor.this.dispose();
                if (DefInfoEditor.this.getParent() != null) {
                    DefInfoEditor.this.getParent().repaint();
                }
            }
        }
    };

    public DefInfoEditor(DefInfo defInfo) {
        super((Frame)JaWEManager.getInstance().getJaWEController().getJaWEFrame(), true);
        this.di = defInfo;
        this.panelToEdit = this.getDefInfoPanel();
        this.initDialog();
    }

    public boolean canApplyChanges() {
        return this.panelToEdit.validateEntry();
    }

    public void applyChanges() {
        this.panelToEdit.setElements();
    }

    @Override
    public void requestFocus() {
        try {
            this.panelToEdit.requestFocus();
        }
        catch (Exception exception) {
            super.requestFocus();
        }
    }

    public int getStatus() {
        return this.status;
    }

    protected void initDialog() {
        try {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.setAlignmentX(0.0f);
            jPanel.setAlignmentY(0.0f);
            this.buttonOK = new JButton(ResourceManager.getLanguageDependentString((String)"OKKey"));
            this.buttonCancel = new JButton(ResourceManager.getLanguageDependentString((String)"CancelKey"));
            jPanel.add(Box.createHorizontalGlue());
            jPanel.add(this.buttonOK);
            jPanel.add(Box.createHorizontalStrut(4));
            jPanel.add(this.buttonCancel);
            jPanel.add(Box.createHorizontalStrut(4));
            Container container = this.getContentPane();
            container.setLayout(new BoxLayout(container, 1));
            container.add((Component)this.panelToEdit);
            container.add(Box.createVerticalStrut(5));
            container.add(jPanel);
            this.buttonOK.addActionListener(this.okl);
            this.buttonCancel.addActionListener(this.cl);
            this.addWindowListener(this.wl);
            this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0, false), "Cancel");
            this.getRootPane().getActionMap().put("Cancel", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DefInfoEditor.this.cl.actionPerformed(actionEvent);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setDefaultCloseOperation(0);
        this.setResizable(true);
        this.setLocationRelativeTo(this.getParent());
        this.buttonOK.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.pack();
        this.setVisible(true);
    }

    protected XMLGroupPanel getDefInfoPanel() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new XMLMultiLineTextPanel(null, this.di.get("DefinitionKey"), true, XMLMultiLineTextPanel.SIZE_MEDIUM, false, true));
        arrayList.add(new XMLTextPanel(null, this.di.get("Name"), false, false, true));
        arrayList.add(new XMLMultiLineTextPanel(null, this.di.get("Description"), true, XMLMultiLineTextPanel.SIZE_LARGE, true, true));
        arrayList.add(new XMLTextPanel(null, this.di.get("Version"), false, false, true));
        arrayList.add(new XMLTextPanel(null, this.di.get("Status"), false, false, true));
        XMLGroupPanel xMLGroupPanel = new XMLGroupPanel(null, (XMLElement)this.di, arrayList, "", true, false, true);
        return xMLGroupPanel;
    }
}

