/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.wfxml;

import java.awt.Window;
import java.net.Authenticator;
import java.net.URL;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEComponentSettings;
import org.enhydra.jawe.JaWEComponentView;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.XPDLElementChangeInfo;
import org.enhydra.jawe.components.wfxml.DefInfos;
import org.enhydra.jawe.components.wfxml.WfXMLAuthenticator;
import org.enhydra.jawe.components.wfxml.WfXMLConnector;
import org.enhydra.jawe.components.wfxml.WfXMLPanel;
import org.enhydra.jawe.components.wfxml.WfXMLSettings;
import org.enhydra.jxpdl.XMLCollection;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.elements.Package;

public class WfXML
implements JaWEComponent,
Observer {
    protected String type = "OTHER";
    protected WfXMLPanel panel;
    protected boolean updateInProgress = false;
    protected DefInfos defInfos = new DefInfos();
    protected WfXMLSettings settings;

    public WfXML(JaWEComponentSettings jaWEComponentSettings) throws Exception {
        Authenticator.setDefault(new WfXMLAuthenticator((Window)JaWEManager.getInstance().getJaWEController().getJaWEFrame()));
        this.settings = (WfXMLSettings)jaWEComponentSettings;
        this.settings.init(this);
        this.init();
        JaWEManager.getInstance().getJaWEController().addObserver((Observer)this);
    }

    @Override
    public void update(Observable observable, Object object) {
        if (!(object instanceof XPDLElementChangeInfo)) {
            return;
        }
        XPDLElementChangeInfo xPDLElementChangeInfo = (XPDLElementChangeInfo)object;
        int n = xPDLElementChangeInfo.getAction();
        if (n != 1 && n != 3 && n != 5 && n != 8) {
            return;
        }
        long l = System.currentTimeMillis();
        JaWEManager.getInstance().getLoggingManager().info("WfXML -> update for event " + xPDLElementChangeInfo + " started ...");
        this.settings.adjustActions();
        JaWEManager.getInstance().getLoggingManager().info("WfXML -> update ended...");
        long l2 = System.currentTimeMillis();
        double d = (double)(l2 - l) / 1000.0;
        JaWEManager.getInstance().getLoggingManager().debug("THE UPDATE OF WfXML COMPONENT LASTED FOR " + d + " SECONDS!");
    }

    public JaWEComponentSettings getSettings() {
        return this.settings;
    }

    public WfXMLSettings getWfXMLSettings() {
        return this.settings;
    }

    public boolean hasEntries() {
        return this.defInfos.size() > 0;
    }

    public boolean hasConnection() {
        return this.panel.hasConnection();
    }

    public boolean hasConnectionsInHistory() {
        String string = this.panel.getSelectedConnection();
        return string != null && string.trim().length() > 0;
    }

    public void clearConnectionHistory() {
        this.panel.getComboPanel().cleanup();
    }

    public DefInfos getDefInfos() {
        return this.defInfos;
    }

    public void listDefinitions(String string) throws Exception {
        this.getDefInfos().clear();
        List list = WfXMLConnector.wfxmlListDefinitions(new URL(string), this.getDefInfos());
        this.getDefInfos().addAll(list);
    }

    protected void init() {
        this.panel = new WfXMLPanel(this);
        this.panel.configure();
        this.settings.adjustActions();
    }

    public JaWEComponentView getView() {
        return this.panel;
    }

    public JComponent getDisplay() {
        return this.panel.getDisplay();
    }

    public String getComponentType() {
        return this.type;
    }

    public void setComponentType(String string) {
        this.type = string;
    }

    public String getName() {
        return "WfXML";
    }

    public boolean adjustXPDL(Package package_) {
        return false;
    }

    public List checkValidity(XMLElement xMLElement, boolean bl) {
        return null;
    }

    public boolean canCreateElement(XMLCollection xMLCollection) {
        return true;
    }

    public boolean canInsertElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    public boolean canModifyElement(XMLElement xMLElement) {
        return true;
    }

    public boolean canRemoveElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    public boolean canDuplicateElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    public boolean canRepositionElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    public void setUpdateInProgress(boolean bl) {
    }

    public boolean isUpdateInProgress() {
        return false;
    }
}

