/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.wfxml;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.enhydra.jawe.BarFactory;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEComponentView;
import org.enhydra.jawe.components.wfxml.DefInfo;
import org.enhydra.jawe.components.wfxml.DefInfos;
import org.enhydra.jawe.components.wfxml.WfXML;
import org.enhydra.jawe.components.wfxml.WfXMLComboPanel;
import org.enhydra.jawe.components.wfxml.WfXMLTablePanel;
import org.enhydra.jawe.components.wfxml.actions.ListDefinitions;

public class WfXMLPanel
extends JPanel
implements JaWEComponentView {
    protected JToolBar toolbar;
    protected JPanel innerPanel = new JPanel();
    protected WfXMLTablePanel tablePanel;
    protected JScrollPane scrollPane;
    protected WfXMLComboPanel cboPanel;
    protected DefInfos defInfos = new DefInfos();
    protected WfXML controller;
    protected ListDefinitions ld;

    public WfXMLPanel(WfXML wfXML) {
        this.controller = wfXML;
    }

    public void configure() {
        this.ld = new ListDefinitions(this.controller);
        this.init();
    }

    public void init() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        this.toolbar = BarFactory.createToolbar((String)"defaultToolbar", (JaWEComponent)this.controller);
        this.toolbar.setFloatable(false);
        if (this.toolbar.getComponentCount() > 0) {
            this.add((Component)this.toolbar, "North");
        }
        this.cboPanel = new WfXMLComboPanel(this.controller, (ActionListener)((Object)this.ld));
        this.tablePanel = new WfXMLTablePanel(this.controller);
        this.innerPanel.setLayout(new BorderLayout());
        this.innerPanel.add((Component)((Object)this.cboPanel), "North");
        this.innerPanel.add((Component)((Object)this.tablePanel), "Center");
        this.add((Component)this.innerPanel, "Center");
    }

    protected boolean hasConnection() {
        return !this.cboPanel.getSelectedItem().equals("");
    }

    public WfXMLComboPanel getComboPanel() {
        return this.cboPanel;
    }

    public void cleanTable() {
        this.tablePanel.cleanup();
    }

    public DefInfo getSelectedDefInfo() {
        return this.tablePanel.getSelectedElement();
    }

    public String getSelectedConnection() {
        String string = this.cboPanel.getSelectedItem();
        string = string.replaceAll("&", "&amp;");
        return string;
    }

    public JaWEComponent getJaWEComponent() {
        return this.controller;
    }

    public JComponent getDisplay() {
        return this;
    }
}

