/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.transpkgpool;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.enhydra.jawe.BarFactory;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEComponentView;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.XPDLElementChangeInfo;
import org.enhydra.jawe.components.XPDLTreeCellRenderer;
import org.enhydra.jawe.components.XPDLTreeNode;
import org.enhydra.jawe.components.transpkgpool.TransientPkgPool;
import org.enhydra.jawe.components.transpkgpool.TransientPkgPoolTreeModel;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLUtil;
import org.enhydra.jxpdl.elements.Package;

public class TransientPkgPoolPanel
extends JPanel
implements JaWEComponentView {
    protected TransientPkgPoolTreeModel treeModel;
    protected JTree tree;
    protected JToolBar toolbar;
    protected JScrollPane scrollPane;
    protected TransientPkgPool controller;
    protected int xClick;
    protected int yClick;
    protected MouseListener mouseListener;
    protected XPDLTreeCellRenderer renderer;

    public TransientPkgPoolPanel(TransientPkgPool transientPkgPool) {
        this.controller = transientPkgPool;
    }

    public void configure() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        this.toolbar = BarFactory.createToolbar((String)"defaultToolbar", (JaWEComponent)this.controller);
        this.toolbar.setFloatable(false);
        if (this.toolbar.getComponentCount() > 0) {
            this.add((Component)this.toolbar, "North");
        }
        this.init();
    }

    public void init() {
        this.controller.getSettings().adjustActions();
        this.treeModel = new TransientPkgPoolTreeModel(this.controller);
        this.tree = new JTree((TreeModel)((Object)this.treeModel)){

            @Override
            public void scrollRectToVisible(Rectangle rectangle) {
                rectangle.x = TransientPkgPoolPanel.this.scrollPane.getHorizontalScrollBar().getValue();
                super.scrollRectToVisible(rectangle);
            }
        };
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.renderer = new XPDLTreeCellRenderer((JaWEComponent)this.controller);
        Color color = this.controller.getExtSettings().getBackgroundColor();
        this.renderer.setBackgroundNonSelectionColor(color);
        this.tree.setBackground(color);
        this.tree.setCellRenderer((TreeCellRenderer)this.renderer);
        this.tree.addTreeSelectionListener(this.controller);
        this.mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                TransientPkgPoolPanel.this.xClick = mouseEvent.getX();
                TransientPkgPoolPanel.this.yClick = mouseEvent.getY();
                TreePath treePath = TransientPkgPoolPanel.this.tree.getPathForLocation(TransientPkgPoolPanel.this.xClick, TransientPkgPoolPanel.this.yClick);
                if (treePath != null) {
                    Object object;
                    TransientPkgPoolPanel.this.tree.setAnchorSelectionPath(treePath);
                    if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                        if (!TransientPkgPoolPanel.this.tree.isPathSelected(treePath)) {
                            TransientPkgPoolPanel.this.tree.setSelectionPath(treePath);
                        }
                        object = BarFactory.createPopupMenu((String)"default", (JaWEComponent)TransientPkgPoolPanel.this.controller);
                        ((JPopupMenu)object).show(TransientPkgPoolPanel.this.tree, mouseEvent.getX(), mouseEvent.getY());
                    }
                    object = (XPDLTreeNode)treePath.getLastPathComponent();
                    if (mouseEvent.getClickCount() > 1 && !SwingUtilities.isRightMouseButton(mouseEvent) && TransientPkgPoolPanel.this.tree.getModel().isLeaf(object)) {
                        JaWEManager.getInstance().getJaWEController().getJaWEActions().getAction("EditProperties").actionPerformed(null);
                    }
                } else {
                    TreePath treePath2 = TransientPkgPoolPanel.this.tree.getClosestPathForLocation(TransientPkgPoolPanel.this.xClick, TransientPkgPoolPanel.this.yClick);
                    Rectangle rectangle = TransientPkgPoolPanel.this.tree.getPathBounds(treePath2);
                    if (rectangle == null || rectangle.y >= TransientPkgPoolPanel.this.yClick || rectangle.y + rectangle.height <= TransientPkgPoolPanel.this.yClick) {
                        JaWEManager.getInstance().getJaWEController().getSelectionManager().setSelection((XMLElement)null, false);
                        TransientPkgPoolPanel.this.tree.clearSelection();
                    }
                }
                TransientPkgPoolPanel.this.tree.getParent().requestFocus();
            }
        };
        this.tree.addMouseListener(this.mouseListener);
        this.scrollPane = new JScrollPane();
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setViewportView(this.tree);
        JViewport jViewport = this.scrollPane.getViewport();
        jViewport.setScrollMode(1);
        this.scrollPane.setBackground(Color.lightGray);
        this.add((Component)this.scrollPane, "Center");
    }

    public TreeModel getTreeModel() {
        return this.treeModel;
    }

    public JTree getTree() {
        return this.tree;
    }

    public JaWEComponent getJaWEComponent() {
        return this.controller;
    }

    public JComponent getDisplay() {
        return this;
    }

    public Point getMouseClickLocation() {
        return new Point(this.xClick, this.yClick);
    }

    public void refreshTransientPkgPanel(XPDLElementChangeInfo xPDLElementChangeInfo) {
        Object object;
        int n = xPDLElementChangeInfo.getAction();
        XMLElement xMLElement = xPDLElementChangeInfo.getChangedElement();
        List list = xPDLElementChangeInfo.getChangedSubElements();
        this.tree.removeTreeSelectionListener(this.controller);
        if (n == 8) {
            this.tree.clearSelection();
        }
        if (n == 10) {
            this.renderer.setValidationErrors(xPDLElementChangeInfo.getChangedSubElements());
            this.tree.repaint();
        }
        if (xMLElement instanceof Package) {
            if (n == 3) {
                if (list != null && list.size() > 0) {
                    for (Package package_ : list) {
                        if (!package_.isTransient()) continue;
                        this.treeModel.insertNode((XMLElement)package_);
                    }
                } else {
                    object = (Package)xMLElement;
                    if (object.isTransient()) {
                        this.treeModel.insertNode((XMLElement)object);
                    }
                }
                this.controller.getSettings().adjustActions();
            } else if (n == 5) {
                if (list != null && list.size() > 0) {
                    for (Package package_ : list) {
                        if (!package_.isTransient()) continue;
                        this.treeModel.removeNode((XMLElement)package_);
                    }
                } else {
                    object = (Package)xMLElement;
                    if (object.isTransient()) {
                        this.treeModel.removeNode(xMLElement);
                    }
                }
                if (this.treeModel.getRootNode().getChildCount() == 0) {
                    this.reinitialize();
                    return;
                }
                this.controller.getSettings().adjustActions();
            }
        }
        if (n == 8) {
            if (xMLElement != null) {
                object = new ArrayList();
                if (list != null) {
                    object.addAll(list);
                }
                if (object.size() == 0) {
                    object.add(xMLElement);
                }
                for (int i = 0; i < object.size(); ++i) {
                    Package package_ = XMLUtil.getPackage((XMLElement)((XMLElement)object.get(i)));
                    if (package_ == null || !package_.isTransient()) continue;
                    XPDLTreeNode xPDLTreeNode = this.treeModel.findNode((XMLElement)package_);
                    TreePath treePath = null;
                    if (xPDLTreeNode != null) {
                        treePath = new TreePath(xPDLTreeNode.getPath());
                        this.tree.addSelectionPath(treePath);
                    }
                    if (treePath == null) continue;
                    this.tree.scrollPathToVisible(treePath);
                    break;
                }
            }
            this.controller.getSettings().adjustActions();
        }
        this.tree.addTreeSelectionListener(this.controller);
    }

    protected void reinitialize() {
        this.remove(this.scrollPane);
        this.treeModel.clearTree();
        this.tree.getSelectionModel().clearSelection();
        this.tree.removeMouseListener(this.mouseListener);
        this.tree.removeTreeSelectionListener(this.controller);
        this.tree.setCellRenderer(null);
        this.init();
    }

    public void setCurrentSelection() {
        List list = JaWEManager.getInstance().getJaWEController().getSelectionManager().getSelectedElements();
        for (int i = 0; i < list.size(); ++i) {
            XMLElement xMLElement = (XMLElement)list.get(i);
            if (!(xMLElement instanceof Package)) continue;
            XPDLTreeNode xPDLTreeNode = this.treeModel.findNode(xMLElement);
            TreePath treePath = null;
            if (xPDLTreeNode != null) {
                treePath = new TreePath(xPDLTreeNode.getPath());
                this.tree.addSelectionPath(treePath);
            }
            if (treePath == null) continue;
            this.tree.scrollPathToVisible(treePath);
        }
    }
}

