/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.shark;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.enhydra.jawe.XPDLUtils;
import org.enhydra.jxpdl.XMLCollectionElement;
import org.enhydra.jxpdl.XMLComplexElement;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLUtil;
import org.enhydra.jxpdl.elements.Activities;
import org.enhydra.jxpdl.elements.Activity;
import org.enhydra.jxpdl.elements.ActivitySet;
import org.enhydra.jxpdl.elements.DataField;
import org.enhydra.jxpdl.elements.ExtendedAttribute;
import org.enhydra.jxpdl.elements.FormalParameter;
import org.enhydra.jxpdl.elements.Package;
import org.enhydra.jxpdl.elements.Transition;
import org.enhydra.jxpdl.elements.WorkflowProcess;

public class SharkXPDLUtils
extends XPDLUtils {
    public List getDataFieldReferences(XMLComplexElement xMLComplexElement, String string) {
        if (string.equals("")) {
            return new ArrayList();
        }
        if (xMLComplexElement instanceof Package) {
            return this.getDataFieldReferences((Package)xMLComplexElement, string);
        }
        return this.getDataFieldReferences((WorkflowProcess)xMLComplexElement, string);
    }

    public List getReferences(Package package_, DataField dataField) {
        return this.getDataFieldReferences(package_, dataField.getId());
    }

    public List getDataFieldReferences(Package package_, String string) {
        ArrayList arrayList = new ArrayList();
        if (string.equals("")) {
            return arrayList;
        }
        for (WorkflowProcess workflowProcess : package_.getWorkflowProcesses().toElements()) {
            if (workflowProcess.getDataField(string) != null) continue;
            arrayList.addAll(this.getDataFieldReferences(workflowProcess, string));
        }
        return arrayList;
    }

    public List getReferences(WorkflowProcess workflowProcess, DataField dataField) {
        if (XMLUtil.getWorkflowProcess((XMLElement)dataField) == null && (workflowProcess.getDataField(dataField.getId()) != null || workflowProcess.getFormalParameter(dataField.getId()) != null)) {
            return new ArrayList();
        }
        return this.getDataFieldReferences(workflowProcess, dataField.getId());
    }

    public List getDataFieldReferences(WorkflowProcess workflowProcess, String string) {
        ArrayList arrayList = new ArrayList();
        if (string.equals("")) {
            return arrayList;
        }
        arrayList.addAll(this.getVariableReferences((XMLCollectionElement)workflowProcess, string));
        for (ActivitySet activitySet : workflowProcess.getActivitySets().toElements()) {
            arrayList.addAll(this.getVariableReferences((XMLCollectionElement)activitySet, string));
        }
        return arrayList;
    }

    public List getReferences(WorkflowProcess workflowProcess, FormalParameter formalParameter) {
        ArrayList arrayList = new ArrayList();
        if (!(formalParameter.getParent().getParent() instanceof WorkflowProcess)) {
            return arrayList;
        }
        return this.getFormalParameterReferences(workflowProcess, formalParameter.getId());
    }

    public List getFormalParameterReferences(WorkflowProcess workflowProcess, String string) {
        ArrayList arrayList = new ArrayList();
        if (string.equals("")) {
            return arrayList;
        }
        if (workflowProcess.getDataField(string) != null) {
            return arrayList;
        }
        arrayList.addAll(this.getVariableReferences((XMLCollectionElement)workflowProcess, string));
        for (ActivitySet activitySet : workflowProcess.getActivitySets().toElements()) {
            arrayList.addAll(this.getVariableReferences((XMLCollectionElement)activitySet, string));
        }
        return arrayList;
    }

    protected List getVariableReferences(XMLCollectionElement xMLCollectionElement, String string) {
        List list = XMLUtil.getVariableReferences((XMLCollectionElement)xMLCollectionElement, (String)string);
        Map map = XMLUtil.getWorkflowProcess((XMLElement)xMLCollectionElement).getAllVariables();
        for (Activity activity : ((Activities)xMLCollectionElement.get("Activities")).toElements()) {
            int n = activity.getActivityType();
            if (n != 2 && n != 1) continue;
            ArrayList arrayList = activity.getExtendedAttributes().toElements();
            for (int i = 0; i < arrayList.size(); ++i) {
                ExtendedAttribute extendedAttribute = (ExtendedAttribute)arrayList.get(i);
                if (!extendedAttribute.getName().equals("VariableToProcess_UPDATE") && !extendedAttribute.getName().equals("VariableToProcess_VIEW") || XMLUtil.getUsingPositions((String)extendedAttribute.getVValue(), (String)string, (Map)map).size() <= 0) continue;
                list.add(extendedAttribute.get("Value"));
            }
        }
        return list;
    }

    public Set getAllExtendedAttributeNames(Collection collection) {
        HashSet<String> hashSet = new HashSet<String>();
        for (ExtendedAttribute extendedAttribute : collection) {
            String string = extendedAttribute.getName();
            XMLElement xMLElement = extendedAttribute.getParent().getParent();
            if (xMLElement instanceof XMLComplexElement && string.equals("JaWE_TYPE") || xMLElement instanceof Package && (string.equals("EDITING_TOOL") || string.equals("EDITING_TOOL_VERSION") || string.equals("JaWE_CONFIGURATION") || string.equals("EXTERNAL_PACKAGE_ID") || string.equals("ALLOW_UNDEFINED_VARIABLES") || string.equals("DYNAMIC_VARIABLE_HANDLING") || string.equals("CHOOSE_NEXT_PERFORMER") || string.equals("MAX_ASSIGNMENTS") || string.equals("WORKLOAD_FACTOR") || string.equals("USE_PROCESS_CONTEXT_ONLY") || string.equals("CREATE_ASSIGNMENTS") || string.equals("TRANSIENT") || string.equals("DELETE_FINISHED") || string.equals("CHECK_FOR_FIRST_ACTIVITY") || string.equals("CHECK_FOR_CONTINUATION") || string.equals("REDIRECT_AFTER_PROCESS_END")) || xMLElement instanceof WorkflowProcess && (string.equals("JaWE_GRAPH_WORKFLOW_PARTICIPANT_ORIENTATION") || string.equals("JaWE_GRAPH_BLOCK_PARTICIPANT_ORIENTATION") || string.equals("JaWE_GRAPH_WORKFLOW_PARTICIPANT_ORDER") || string.equals("JaWE_GRAPH_BLOCK_PARTICIPANT_ORDER") || string.equals("JaWE_GRAPH_START_OF_WORKFLOW") || string.equals("JaWE_GRAPH_END_OF_WORKFLOW") || string.equals("JaWE_GRAPH_START_OF_BLOCK") || string.equals("JaWE_GRAPH_END_OF_BLOCK") || string.equals("ALLOW_UNDEFINED_VARIABLES") || string.equals("DYNAMIC_VARIABLE_HANDLING") || string.equals("CHOOSE_NEXT_PERFORMER") || string.equals("MAX_ASSIGNMENTS") || string.equals("WORKLOAD_FACTOR") || string.equals("USE_PROCESS_CONTEXT_ONLY") || string.equals("CREATE_ASSIGNMENTS") || string.equals("TRANSIENT") || string.equals("DELETE_FINISHED") || string.equals("CHECK_FOR_FIRST_ACTIVITY") || string.equals("CHECK_FOR_CONTINUATION") || string.equals("REDIRECT_AFTER_PROCESS_END")) || xMLElement instanceof Activity && (string.equals("JaWE_GRAPH_OFFSET") || string.equals("JaWE_GRAPH_PARTICIPANT_ID") || string.equals("MAX_ASSIGNMENTS") || string.equals("WORKLOAD_FACTOR") || string.equals("VariableToProcess_UPDATE") || string.equals("VariableToProcess_VIEW") || string.equals("XFORMS_FILE")) || xMLElement instanceof Transition && (string.equals("JaWE_GRAPH_BREAK_POINTS") || string.equals("JaWE_GRAPH_TRANSITION_STYLE")) || xMLElement instanceof DataField && (string.equals("TRANSIENT") || string.equals("MIN_LENGTH") || string.equals("IS_MANDATORY"))) continue;
            hashSet.add(string);
        }
        return hashSet;
    }
}

