/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.ChangedCharSetException;
import com.sun.java.help.search.DefaultIndexerKit;
import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Stack;
import javax.help.search.ConfigFile;
import javax.help.search.IndexBuilder;
import javax.help.search.IndexerKit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;

public class HTMLIndexerKit
extends DefaultIndexerKit {
    private static HTMLEditorKit.Parser defaultParser = null;
    private static HTMLParserCallback defaultCallback = null;
    private static char[] NEWLINE = new char[1];
    private boolean debugFlag = false;

    public Object clone() {
        return new HTMLIndexerKit();
    }

    public String getContentType() {
        return "text/html";
    }

    public void parse(Reader reader, String string, boolean bl, IndexBuilder indexBuilder, ConfigFile configFile) throws IOException {
        this.builder = indexBuilder;
        this.config = configFile;
        this.file = string;
        this.documentStarted = false;
        HTMLEditorKit.Parser parser = this.getParser();
        if (parser == null) {
            throw new IOException("Can't load parser");
        }
        if (defaultCallback == null) {
            defaultCallback = this.getParserCallback(this);
        }
        defaultCallback.initialize();
        try {
            parser.parse(reader, defaultCallback, bl);
        }
        catch (javax.swing.text.ChangedCharSetException changedCharSetException) {
            throw new ChangedCharSetException(changedCharSetException.getCharSetSpec(), changedCharSetException.keyEqualsCharSet());
        }
        try {
            defaultCallback.flush();
        }
        catch (BadLocationException badLocationException) {
            throw new IOException("Can't flush parser");
        }
        try {
            this.storeTitle(defaultCallback.getTitle());
            this.endStoreDocument();
        }
        catch (Exception exception) {
            throw new IOException("Can't store title");
        }
        this.builder = null;
        this.config = null;
    }

    protected HTMLEditorKit.Parser getParser() {
        if (defaultParser == null) {
            try {
                Class<?> clazz = Class.forName("javax.swing.text.html.parser.ParserDelegator");
                defaultParser = (HTMLEditorKit.Parser)clazz.newInstance();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return defaultParser;
    }

    public HTMLParserCallback getParserCallback(IndexerKit indexerKit) {
        return new HTMLParserCallback(indexerKit);
    }

    private void debug(String string) {
        if (this.debugFlag) {
            System.err.println("HTMLIndexerKit: " + string);
        }
    }

    static {
        HTMLIndexerKit.NEWLINE[0] = 10;
    }

    public class HTMLParserCallback
    extends HTMLEditorKit.ParserCallback {
        private IndexerKit kit;
        private String title;
        private String header;
        private boolean firstHeader;
        private int currentPos;
        private boolean receivedEndHTML;
        private boolean insertAfterImplied;
        private boolean inParagraph;
        private boolean impliedP;
        private boolean inPre;
        private boolean inTextArea;
        private boolean inTitle;
        private boolean lastWasNewline;
        private boolean emptyAnchor;
        private boolean inBody;
        private boolean foundInsertTag;
        private boolean inHead;
        private boolean inStyle;
        private boolean inOption;
        private boolean inFirstHeader;
        private boolean startTagType;
        private boolean preservesUnknownTags;
        Hashtable tagMap;
        int inBlock;
        Stack tagStack;
        String defaultLang;
        String lastLang;

        public HTMLParserCallback(IndexerKit indexerKit) {
            this.kit = indexerKit;
            this.tagMap = new Hashtable(57);
            TagAction tagAction = new TagAction();
            BlockAction blockAction = new BlockAction();
            ParagraphAction paragraphAction = new ParagraphAction();
            CharacterAction characterAction = new CharacterAction();
            SpecialAction specialAction = new SpecialAction();
            FormAction formAction = new FormAction();
            HiddenAction hiddenAction = new HiddenAction();
            ConvertAction convertAction = new ConvertAction();
            this.tagMap.put(HTML.Tag.A, new AnchorAction());
            this.tagMap.put(HTML.Tag.ADDRESS, characterAction);
            this.tagMap.put(HTML.Tag.APPLET, hiddenAction);
            this.tagMap.put(HTML.Tag.AREA, new AreaAction());
            this.tagMap.put(HTML.Tag.B, characterAction);
            this.tagMap.put(HTML.Tag.BASE, new BaseAction());
            this.tagMap.put(HTML.Tag.BASEFONT, characterAction);
            this.tagMap.put(HTML.Tag.BIG, characterAction);
            this.tagMap.put(HTML.Tag.BLOCKQUOTE, blockAction);
            this.tagMap.put(HTML.Tag.BODY, blockAction);
            this.tagMap.put(HTML.Tag.BR, specialAction);
            this.tagMap.put(HTML.Tag.CAPTION, blockAction);
            this.tagMap.put(HTML.Tag.CENTER, blockAction);
            this.tagMap.put(HTML.Tag.CITE, characterAction);
            this.tagMap.put(HTML.Tag.CODE, characterAction);
            this.tagMap.put(HTML.Tag.DD, blockAction);
            this.tagMap.put(HTML.Tag.DFN, characterAction);
            this.tagMap.put(HTML.Tag.DIR, blockAction);
            this.tagMap.put(HTML.Tag.DIV, blockAction);
            this.tagMap.put(HTML.Tag.DL, blockAction);
            this.tagMap.put(HTML.Tag.DT, paragraphAction);
            this.tagMap.put(HTML.Tag.EM, characterAction);
            this.tagMap.put(HTML.Tag.FONT, convertAction);
            this.tagMap.put(HTML.Tag.FORM, new FormTagAction());
            this.tagMap.put(HTML.Tag.FRAME, specialAction);
            this.tagMap.put(HTML.Tag.FRAMESET, blockAction);
            this.tagMap.put(HTML.Tag.H1, paragraphAction);
            this.tagMap.put(HTML.Tag.H2, paragraphAction);
            this.tagMap.put(HTML.Tag.H3, paragraphAction);
            this.tagMap.put(HTML.Tag.H4, paragraphAction);
            this.tagMap.put(HTML.Tag.H5, paragraphAction);
            this.tagMap.put(HTML.Tag.H6, paragraphAction);
            this.tagMap.put(HTML.Tag.HEAD, new HeadAction());
            this.tagMap.put(HTML.Tag.HR, specialAction);
            this.tagMap.put(HTML.Tag.HTML, blockAction);
            this.tagMap.put(HTML.Tag.I, convertAction);
            this.tagMap.put(HTML.Tag.IMG, specialAction);
            this.tagMap.put(HTML.Tag.INPUT, formAction);
            this.tagMap.put(HTML.Tag.ISINDEX, new IsindexAction());
            this.tagMap.put(HTML.Tag.KBD, characterAction);
            this.tagMap.put(HTML.Tag.LI, blockAction);
            this.tagMap.put(HTML.Tag.LINK, new LinkAction());
            this.tagMap.put(HTML.Tag.MAP, new MapAction());
            this.tagMap.put(HTML.Tag.MENU, blockAction);
            this.tagMap.put(HTML.Tag.META, new MetaAction());
            HTML.Tag tag = HTML.getTag("NOBR");
            if (tag != null) {
                this.tagMap.put(tag, characterAction);
            }
            this.tagMap.put(HTML.Tag.NOFRAMES, blockAction);
            this.tagMap.put(HTML.Tag.OBJECT, specialAction);
            this.tagMap.put(HTML.Tag.OL, blockAction);
            this.tagMap.put(HTML.Tag.OPTION, formAction);
            this.tagMap.put(HTML.Tag.P, paragraphAction);
            this.tagMap.put(HTML.Tag.PARAM, new ObjectAction());
            this.tagMap.put(HTML.Tag.PRE, new PreAction());
            this.tagMap.put(HTML.Tag.SAMP, characterAction);
            this.tagMap.put(HTML.Tag.SCRIPT, hiddenAction);
            this.tagMap.put(HTML.Tag.SELECT, formAction);
            this.tagMap.put(HTML.Tag.SMALL, characterAction);
            this.tagMap.put(HTML.Tag.STRIKE, convertAction);
            this.tagMap.put(HTML.Tag.S, characterAction);
            this.tagMap.put(HTML.Tag.STRONG, characterAction);
            this.tagMap.put(HTML.Tag.STYLE, new StyleAction());
            this.tagMap.put(HTML.Tag.SUB, convertAction);
            this.tagMap.put(HTML.Tag.SUP, convertAction);
            this.tagMap.put(HTML.Tag.TABLE, blockAction);
            this.tagMap.put(HTML.Tag.TD, blockAction);
            this.tagMap.put(HTML.Tag.TEXTAREA, formAction);
            this.tagMap.put(HTML.Tag.TH, blockAction);
            this.tagMap.put(HTML.Tag.TITLE, new TitleAction());
            this.tagMap.put(HTML.Tag.TR, blockAction);
            this.tagMap.put(HTML.Tag.TT, characterAction);
            this.tagMap.put(HTML.Tag.U, convertAction);
            this.tagMap.put(HTML.Tag.UL, blockAction);
            this.tagMap.put(HTML.Tag.VAR, characterAction);
        }

        public void initialize() {
            this.title = null;
            this.header = null;
            this.firstHeader = true;
            this.currentPos = 0;
            this.receivedEndHTML = false;
            this.insertAfterImplied = false;
            this.inParagraph = false;
            this.impliedP = false;
            this.inPre = false;
            this.inTitle = false;
            this.inOption = false;
            this.inFirstHeader = false;
            this.startTagType = false;
            this.emptyAnchor = false;
            this.inBlock = 0;
            this.tagStack = new Stack();
            this.lastLang = this.defaultLang = this.kit.getLocale().toString();
            this.inTextArea = false;
            this.lastWasNewline = false;
            this.inBody = false;
            this.foundInsertTag = true;
            this.preservesUnknownTags = true;
            this.inHead = false;
            this.inStyle = false;
        }

        public String getTitle() {
            if (this.title == null || this.title.length() < 1) {
                this.title = this.header;
                if (this.title == null || this.title.length() < 1) {
                    this.title = "No Title";
                }
            }
            return this.title;
        }

        public void flush() throws BadLocationException {
        }

        public void handleText(char[] cArray, int n) {
            if (this.receivedEndHTML) {
                return;
            }
            if (!this.inTextArea) {
                if (this.inPre) {
                    this.preContent(cArray);
                } else if (this.inTitle) {
                    this.titleContent(new String(cArray));
                } else if (!this.inOption && !this.inStyle && this.inBlock > 0) {
                    if (this.inFirstHeader) {
                        this.headerContent(new String(cArray));
                    }
                    if (!this.foundInsertTag && this.insertAfterImplied) {
                        this.foundInsertTag(false);
                        this.foundInsertTag = true;
                        this.impliedP = true;
                        this.inParagraph = true;
                    }
                    if (cArray.length >= 1) {
                        this.addContent(cArray, 0, cArray.length);
                    }
                }
            }
        }

        public void handleStartTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
            TagAction tagAction;
            if (this.receivedEndHTML) {
                return;
            }
            if (!this.inBody && tag == HTML.Tag.BODY) {
                this.inBody = true;
            }
            if ((tagAction = (TagAction)this.tagMap.get(tag)) != null) {
                tagAction.start(tag, mutableAttributeSet);
            }
        }

        public void handleComment(char[] cArray, int n) {
            if (this.receivedEndHTML) {
                return;
            }
            if (!this.inStyle && this.preservesUnknownTags) {
                if (this.inBlock == 0) {
                    return;
                }
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                simpleAttributeSet.addAttribute(HTML.Attribute.COMMENT, new String(cArray));
                this.addSpecialElement(HTML.Tag.COMMENT, simpleAttributeSet);
                HTMLIndexerKit.this.debug("comment added currentPos=" + this.currentPos);
            }
        }

        public void handleEndTag(HTML.Tag tag, int n) {
            TagAction tagAction;
            if (this.receivedEndHTML) {
                return;
            }
            if (tag == HTML.Tag.HTML) {
                this.receivedEndHTML = true;
            }
            if (tag == HTML.Tag.BODY) {
                this.inBody = false;
            }
            if ((tagAction = (TagAction)this.tagMap.get(tag)) != null) {
                tagAction.end(tag);
            }
        }

        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
            if (this.receivedEndHTML) {
                return;
            }
            TagAction tagAction = (TagAction)this.tagMap.get(tag);
            if (tagAction != null) {
                tagAction.start(tag, mutableAttributeSet);
                tagAction.end(tag);
            } else if (this.preservesUnknownTags) {
                this.addSpecialElement(tag, mutableAttributeSet);
            }
        }

        protected void registerTag(HTML.Tag tag, TagAction tagAction) {
            this.tagMap.put(tag, tagAction);
        }

        protected void titleContent(String string) {
            if (this.title == null) {
                this.title = new String(string);
            } else {
                this.title.concat(string);
            }
        }

        protected void headerContent(String string) {
            if (this.header == null) {
                this.header = new String(string);
            } else {
                this.header.concat(string);
            }
        }

        protected void preContent(char[] cArray) {
            int n = 0;
            int n2 = 0;
            while (n2 < cArray.length) {
                if (cArray[n2] == '\n') {
                    HTMLIndexerKit.this.debug("preContent currentPos=" + this.currentPos);
                    this.addContent(cArray, n, n2 - n + 1);
                    this.blockClose(HTML.Tag.IMPLIED);
                    SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                    simpleAttributeSet.addAttribute(CSS.Attribute.WHITE_SPACE, "pre");
                    this.blockOpen(HTML.Tag.IMPLIED, simpleAttributeSet);
                    n = n2 + 1;
                }
                ++n2;
            }
            if (n < cArray.length) {
                HTMLIndexerKit.this.debug("preContent currentPos=" + this.currentPos);
                this.addContent(cArray, n, cArray.length - n);
            }
        }

        protected void blockOpen(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
            HTMLIndexerKit.this.debug("blockOpen");
            if (this.impliedP) {
                this.blockClose(HTML.Tag.IMPLIED);
            }
            ++this.inBlock;
            if (!this.canInsertTag(tag, mutableAttributeSet, true)) {
                return;
            }
            this.startTagType = true;
            this.lastWasNewline = false;
        }

        protected void blockClose(HTML.Tag tag) {
            HTMLIndexerKit.this.debug("blockClose");
            --this.inBlock;
            if (!this.foundInsertTag) {
                return;
            }
            if (!this.lastWasNewline) {
                HTMLIndexerKit.this.debug("blockClose adding NEWLINE currentPos=" + this.currentPos);
                this.addContent(NEWLINE, 0, 1, false);
                this.lastWasNewline = true;
            }
            if (this.impliedP) {
                this.impliedP = false;
                this.inParagraph = false;
                if (tag != HTML.Tag.IMPLIED) {
                    this.blockClose(HTML.Tag.IMPLIED);
                }
            }
            if (this.startTagType) {
                char[] cArray = new char[]{' '};
                HTMLIndexerKit.this.debug("blockclose open/close nocontent currentPos=" + this.currentPos);
                this.addContent(cArray, 0, 1);
            }
            this.startTagType = false;
        }

        protected void addContent(char[] cArray, int n, int n2) {
            this.addContent(cArray, n, n2, true);
        }

        protected void addContent(char[] cArray, int n, int n2, boolean bl) {
            HTMLIndexerKit.this.debug("addContent");
            if (!this.foundInsertTag) {
                return;
            }
            if (bl && !this.inParagraph && !this.inPre) {
                this.blockOpen(HTML.Tag.IMPLIED, new SimpleAttributeSet());
                this.inParagraph = true;
                this.impliedP = true;
            }
            this.emptyAnchor = false;
            HTMLIndexerKit.this.debug("Pre parseIntoTokens String=" + new String(cArray, n, n2) + " currentPos=" + this.currentPos);
            this.startTagType = false;
            this.currentPos = this.kit.parseIntoTokens(new String(cArray, n, n2), this.currentPos);
            HTMLIndexerKit.this.debug("Post parseIntoTokens currentPos=" + this.currentPos);
            if (n2 > 0) {
                this.lastWasNewline = cArray[n + n2 - 1] == '\n';
            }
        }

        protected void addSpecialElement(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
            if (tag != HTML.Tag.FRAME && !this.inParagraph && !this.inPre) {
                this.blockOpen(HTML.Tag.IMPLIED, new SimpleAttributeSet());
                this.inParagraph = true;
                this.impliedP = true;
            }
            if (!this.canInsertTag(tag, mutableAttributeSet, true)) {
                return;
            }
            this.emptyAnchor = false;
            ++this.currentPos;
            HTMLIndexerKit.this.debug("addingSpecialElement tag=" + tag + " currentPos=" + this.currentPos);
            this.startTagType = false;
            if (tag == HTML.Tag.FRAME) {
                this.lastWasNewline = true;
            }
        }

        private boolean canInsertTag(HTML.Tag tag, AttributeSet attributeSet, boolean bl) {
            if (!this.foundInsertTag) {
                this.foundInsertTag(bl);
                return false;
            }
            return true;
        }

        private boolean isInsertTag(HTML.Tag tag) {
            return false;
        }

        private void foundInsertTag(boolean bl) {
            this.foundInsertTag = true;
        }

        protected void addTag(HTML.Tag tag, String string) {
            LangElement langElement = new LangElement(tag, string);
            this.tagStack.push(langElement);
            if (this.lastLang.compareTo(string) != 0) {
                this.kit.setLocale(string);
                this.lastLang = string;
            }
        }

        protected void removeTag(HTML.Tag tag) {
            String string = tag.toString();
            String string2 = this.defaultLang;
            while (!this.tagStack.empty()) {
                LangElement langElement = (LangElement)this.tagStack.pop();
                if (langElement.getTag().toString().compareTo(string) != 0) continue;
                if (this.tagStack.empty()) {
                    string2 = this.defaultLang;
                    break;
                }
                langElement = (LangElement)this.tagStack.peek();
                string2 = langElement.getLang();
                break;
            }
            if (this.lastLang.compareTo(string2) != 0) {
                this.kit.setLocale(string2);
                this.lastLang = string2;
            }
        }

        public class FormAction
        extends SpecialAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                if (tag == HTML.Tag.TEXTAREA) {
                    HTMLParserCallback.this.inTextArea = true;
                }
                if (tag != HTML.Tag.OPTION) {
                    super.start(tag, mutableAttributeSet);
                }
            }

            public void end(HTML.Tag tag) {
                if (tag == HTML.Tag.TEXTAREA) {
                    HTMLParserCallback.this.inTextArea = false;
                }
                if (tag != HTML.Tag.OPTION) {
                    super.end(tag);
                }
            }
        }

        class ObjectAction
        extends SpecialAction {
            ObjectAction() {
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                if (tag != HTML.Tag.PARAM) {
                    super.start(tag, mutableAttributeSet);
                }
            }

            public void end(HTML.Tag tag) {
                if (tag != HTML.Tag.PARAM) {
                    super.end(tag);
                }
            }
        }

        class BaseAction
        extends TagAction {
            BaseAction() {
            }
        }

        class TitleAction
        extends HiddenAction {
            TitleAction() {
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLParserCallback.this.inTitle = true;
                super.start(tag, mutableAttributeSet);
            }

            public void end(HTML.Tag tag) {
                HTMLParserCallback.this.inTitle = false;
                super.end(tag);
            }
        }

        class AnchorAction
        extends CharacterAction {
            private boolean post4207472 = this.isPost4207472();

            AnchorAction() {
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLParserCallback.this.emptyAnchor = true;
                super.start(tag, mutableAttributeSet);
            }

            public void end(HTML.Tag tag) {
                if (HTMLParserCallback.this.emptyAnchor) {
                    char[] cArray = new char[]{this.post4207472 ? (char)'\n' : ' '};
                    HTMLIndexerKit.this.debug("emptyAnchor currentPos=" + HTMLParserCallback.this.currentPos);
                    HTMLParserCallback.this.addContent(cArray, 0, 1);
                }
                super.end(tag);
            }

            private boolean isPost4207472() {
                try {
                    String string = System.getProperty("java.version");
                    int n = Integer.parseInt(string.substring(2, 3));
                    int n2 = 0;
                    if (string.length() > 6) {
                        n2 = Integer.parseInt(string.substring(6, 8));
                    }
                    return n > 5 || n == 5 && n2 >= 4;
                }
                catch (Exception exception) {
                    HTMLIndexerKit.this.debug("Exception in isPost4207472 : " + exception);
                    return true;
                }
            }
        }

        class ConvertAction
        extends TagAction {
            ConvertAction() {
            }
        }

        public class CharacterAction
        extends TagAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                String string = (String)mutableAttributeSet.getAttribute(HTML.Attribute.LANG);
                if (string == null) {
                    string = HTMLParserCallback.this.lastLang;
                }
                HTMLParserCallback.this.addTag(tag, string);
            }

            public void end(HTML.Tag tag) {
                HTMLParserCallback.this.removeTag(tag);
            }
        }

        public class PreAction
        extends BlockAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLParserCallback.this.inPre = true;
                HTMLParserCallback.this.blockOpen(tag, mutableAttributeSet);
                mutableAttributeSet.addAttribute(CSS.Attribute.WHITE_SPACE, "pre");
                HTMLParserCallback.this.blockOpen(HTML.Tag.IMPLIED, mutableAttributeSet);
                String string = (String)mutableAttributeSet.getAttribute(HTML.Attribute.LANG);
                if (string == null) {
                    string = HTMLParserCallback.this.lastLang;
                }
                HTMLParserCallback.this.addTag(tag, string);
            }

            public void end(HTML.Tag tag) {
                HTMLParserCallback.this.blockClose(HTML.Tag.IMPLIED);
                HTMLParserCallback.this.inPre = false;
                HTMLParserCallback.this.blockClose(tag);
                HTMLParserCallback.this.removeTag(tag);
            }
        }

        class StyleAction
        extends TagAction {
            StyleAction() {
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                if (HTMLParserCallback.this.inHead) {
                    HTMLParserCallback.this.inStyle = true;
                }
                super.start(tag, mutableAttributeSet);
            }

            public void end(HTML.Tag tag) {
                HTMLParserCallback.this.inStyle = false;
                super.end(tag);
            }
        }

        class AreaAction
        extends TagAction {
            AreaAction() {
            }
        }

        class MapAction
        extends TagAction {
            MapAction() {
            }
        }

        class LinkAction
        extends HiddenAction {
            LinkAction() {
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                super.start(tag, mutableAttributeSet);
            }
        }

        class HeadAction
        extends BlockAction {
            HeadAction() {
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLParserCallback.this.inHead = true;
                super.start(tag, mutableAttributeSet);
            }

            public void end(HTML.Tag tag) {
                HTMLParserCallback.this.inHead = (HTMLParserCallback.this.inStyle = false);
                super.end(tag);
            }
        }

        class MetaAction
        extends HiddenAction {
            MetaAction() {
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                super.start(tag, mutableAttributeSet);
            }

            private boolean isEmpty(HTML.Tag tag) {
                return true;
            }
        }

        public class HiddenAction
        extends TagAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                String string = (String)mutableAttributeSet.getAttribute(HTML.Attribute.LANG);
                if (string == null) {
                    string = HTMLParserCallback.this.lastLang;
                }
                HTMLParserCallback.this.addTag(tag, string);
                HTMLParserCallback.this.addSpecialElement(tag, mutableAttributeSet);
            }

            public void end(HTML.Tag tag) {
                if (!this.isEmpty(tag)) {
                    SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                    simpleAttributeSet.addAttribute(HTML.Attribute.ENDTAG, "true");
                    HTMLParserCallback.this.addSpecialElement(tag, simpleAttributeSet);
                }
                HTMLParserCallback.this.removeTag(tag);
            }

            private boolean isEmpty(HTML.Tag tag) {
                return tag != HTML.Tag.APPLET && tag != HTML.Tag.TITLE && tag != HTML.Tag.SCRIPT;
            }
        }

        public class IsindexAction
        extends TagAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLParserCallback.this.blockOpen(HTML.Tag.IMPLIED, new SimpleAttributeSet());
                HTMLParserCallback.this.addSpecialElement(tag, mutableAttributeSet);
                HTMLParserCallback.this.blockClose(HTML.Tag.IMPLIED);
            }
        }

        public class SpecialAction
        extends TagAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                String string = (String)mutableAttributeSet.getAttribute(HTML.Attribute.LANG);
                if (string == null) {
                    string = HTMLParserCallback.this.lastLang;
                }
                HTMLParserCallback.this.addTag(tag, string);
                HTMLParserCallback.this.addSpecialElement(tag, mutableAttributeSet);
            }
        }

        public class ParagraphAction
        extends BlockAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                if (HTMLParserCallback.this.firstHeader && (tag == HTML.Tag.H1 || tag == HTML.Tag.H2 || tag == HTML.Tag.H3 || tag == HTML.Tag.H4 || tag == HTML.Tag.H5 || tag == HTML.Tag.H6)) {
                    HTMLParserCallback.this.inFirstHeader = true;
                }
                super.start(tag, mutableAttributeSet);
                HTMLParserCallback.this.inParagraph = true;
            }

            public void end(HTML.Tag tag) {
                if (HTMLParserCallback.this.firstHeader && (tag == HTML.Tag.H1 || tag == HTML.Tag.H2 || tag == HTML.Tag.H3 || tag == HTML.Tag.H4 || tag == HTML.Tag.H5 || tag == HTML.Tag.H6)) {
                    HTMLParserCallback.this.inFirstHeader = false;
                    HTMLParserCallback.this.firstHeader = false;
                }
                super.end(tag);
                HTMLParserCallback.this.inParagraph = false;
            }
        }

        private class FormTagAction
        extends BlockAction {
            private FormTagAction() {
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                super.start(tag, mutableAttributeSet);
            }

            public void end(HTML.Tag tag) {
                super.end(tag);
            }
        }

        public class BlockAction
        extends TagAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLParserCallback.this.blockOpen(tag, mutableAttributeSet);
                String string = (String)mutableAttributeSet.getAttribute(HTML.Attribute.LANG);
                if (string == null) {
                    string = HTMLParserCallback.this.lastLang;
                }
                HTMLParserCallback.this.addTag(tag, string);
            }

            public void end(HTML.Tag tag) {
                HTMLParserCallback.this.blockClose(tag);
                HTMLParserCallback.this.removeTag(tag);
            }
        }

        public class TagAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                String string = (String)mutableAttributeSet.getAttribute(HTML.Attribute.LANG);
                if (string == null) {
                    string = HTMLParserCallback.this.lastLang;
                }
                HTMLParserCallback.this.addTag(tag, string);
            }

            public void end(HTML.Tag tag) {
                HTMLParserCallback.this.removeTag(tag);
            }
        }

        private class LangElement {
            HTML.Tag tag;
            String lang;

            public LangElement(HTML.Tag tag, String string) {
                this.tag = tag;
                this.lang = string;
            }

            public HTML.Tag getTag() {
                return this.tag;
            }

            public String getLang() {
                return this.lang;
            }
        }
    }
}

