/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.problemsnavigator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.TableModel;
import org.enhydra.jawe.BarFactory;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEComponentView;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.Utils;
import org.enhydra.jawe.base.xpdlvalidator.ValidationError;
import org.enhydra.jawe.components.problemsnavigator.ProblemsNavigator;
import org.enhydra.jawe.components.problemsnavigator.ProblemsTablePanel;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLUtil;
import org.enhydra.jxpdl.elements.ActivitySet;
import org.enhydra.jxpdl.elements.Package;
import org.enhydra.jxpdl.elements.WorkflowProcess;

public class ProblemsNavigatorPanel
extends JPanel
implements JaWEComponentView {
    protected JToolBar toolbar;
    protected JLabel problemsInfo = new JLabel();
    protected JPanel innerPanel = new JPanel();
    protected JScrollPane scrollPane;
    protected ProblemsTablePanel table;
    protected ProblemsNavigator controller;
    protected List allProblems = new ArrayList();

    public ProblemsNavigatorPanel(ProblemsNavigator problemsNavigator) {
        this.controller = problemsNavigator;
    }

    public void configure() {
        this.init();
    }

    public void init() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        this.toolbar = BarFactory.createToolbar((String)"defaultToolbar", (JaWEComponent)this.controller);
        this.toolbar.setFloatable(false);
        if (this.toolbar.getComponentCount() > 0) {
            this.add((Component)this.toolbar, "North");
        }
        this.table = new ProblemsTablePanel(this.controller);
        this.innerPanel.setLayout(new BorderLayout());
        this.innerPanel.add((Component)this.problemsInfo, "North");
        this.innerPanel.add((Component)this.table, "Center");
        this.add((Component)this.innerPanel, "Center");
    }

    public TableModel getTableModel() {
        return this.table.getTable().getModel();
    }

    public JTable getTable() {
        return this.table.getTable();
    }

    public JaWEComponent getJaWEComponent() {
        return this.controller;
    }

    public JComponent getDisplay() {
        return this;
    }

    public void refreshProblemsPanel(XMLElement xMLElement, List list, boolean bl) {
        String string = this.table.getSelectedErrId();
        this.table.cleanup();
        this.problemsInfo.setText("");
        if (xMLElement != null) {
            Object object;
            if (list != null) {
                this.allProblems = new ArrayList(list);
                object = JaWEManager.getInstance().getJaWEController().getSelectionManager().getSelectedElement();
                this.refreshT((XMLElement)object, string);
            }
            if (bl && list != null && list.size() > 0 && this.getParent() instanceof JTabbedPane) {
                object = (JTabbedPane)this.getParent();
                Component component = ((JTabbedPane)object).getSelectedComponent();
                if (component != this) {
                    for (int i = 0; i < ((JTabbedPane)object).getTabCount(); ++i) {
                        component = ((JTabbedPane)object).getComponentAt(i);
                        if (component != this) continue;
                        ((JTabbedPane)object).setSelectedIndex(i);
                        break;
                    }
                }
                this.requestFocus();
            }
        }
    }

    public void refreshOnSelection(XMLElement xMLElement) {
        String string = this.table.getSelectedErrId();
        this.table.cleanup();
        this.problemsInfo.setText("");
        this.refreshT(xMLElement, string);
    }

    protected void refreshT(XMLElement xMLElement, String string) {
        ActivitySet activitySet = null;
        WorkflowProcess workflowProcess = null;
        Package package_ = null;
        ActivitySet activitySet2 = null;
        if (xMLElement != null) {
            activitySet = XMLUtil.getActivitySet((XMLElement)xMLElement);
            if (activitySet != null) {
                activitySet2 = activitySet;
            }
            workflowProcess = XMLUtil.getWorkflowProcess((XMLElement)xMLElement);
            if (activitySet2 == null && workflowProcess != null) {
                activitySet2 = workflowProcess;
            }
            package_ = XMLUtil.getPackage((XMLElement)xMLElement);
            if (activitySet2 == null && package_ != null) {
                activitySet2 = package_;
            }
        }
        ArrayList arrayList = new ArrayList(this.allProblems);
        if (activitySet != null || workflowProcess != null || package_ != null) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ValidationError validationError = (ValidationError)iterator.next();
                if (!(activitySet != null && XMLUtil.getActivitySet((XMLElement)validationError.getElement()) != activitySet || workflowProcess != null && XMLUtil.getWorkflowProcess((XMLElement)validationError.getElement()) != workflowProcess) && (package_ == null || XMLUtil.getPackage((XMLElement)validationError.getElement()) == package_)) continue;
                iterator.remove();
            }
        }
        int n = arrayList.size();
        int n2 = Utils.countErrors(arrayList);
        String string2 = " ";
        if (activitySet2 != null) {
            string2 = string2 + JaWEManager.getInstance().getLabelGenerator().getLabel((XMLElement)activitySet2) + " '" + JaWEManager.getInstance().getDisplayNameGenerator().getDisplayName((XMLElement)activitySet2) + "': ";
        }
        string2 = string2 + n2 + " " + this.controller.getSettings().getLanguageDependentString("ErrorsKey") + ", " + (n - n2) + " " + this.controller.getSettings().getLanguageDependentString("WarningsKey");
        this.problemsInfo.setText(string2);
        this.table.fillTableContent(arrayList);
        this.table.setSelectedElement(string);
    }

    protected boolean hasProblems() {
        return this.getTableModel().getRowCount() > 0;
    }

    public void cleanup() {
        this.table.cleanup();
        this.problemsInfo.setText("");
        this.allProblems.clear();
    }
}

