/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe;

import java.util.ArrayList;
import java.util.List;
import java.util.Observer;
import java.util.Stack;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.UndoHistoryManager;
import org.enhydra.jawe.XPDLElementChangeInfo;
import org.enhydra.jawe.base.controller.JaWEController;
import org.enhydra.jxpdl.XMLCollection;
import org.enhydra.jxpdl.XMLComplexChoice;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLElementChangeInfo;
import org.enhydra.jxpdl.elements.Package;

public class UndoHistoryMgr
implements UndoHistoryManager {
    protected Stack undoHistory = new Stack();
    protected Stack redoHistory = new Stack();
    protected int maxHistory = -1;
    protected JaWEController jc = JaWEManager.getInstance().getJaWEController();
    protected boolean undoOrRedoInProgress = false;

    public void init(int n) {
        this.maxHistory = n >= 0 ? n : Integer.MAX_VALUE;
    }

    public void registerEvents(List list, XPDLElementChangeInfo xPDLElementChangeInfo) {
        if (this.maxHistory <= 0) {
            return;
        }
        if (list == null || list.size() == 0) {
            return;
        }
        List list2 = this.convertList(list);
        list2.add(xPDLElementChangeInfo);
        if (this.undoHistory.size() >= this.maxHistory) {
            this.undoHistory.remove(0);
        }
        this.undoHistory.push(list2);
        this.redoHistory.clear();
    }

    public void undo() {
        if (!this.undoHistory.empty()) {
            XPDLElementChangeInfo xPDLElementChangeInfo;
            List list = (List)this.undoHistory.pop();
            XPDLElementChangeInfo xPDLElementChangeInfo2 = (XPDLElementChangeInfo)list.remove(list.size() - 1);
            XPDLElementChangeInfo xPDLElementChangeInfo3 = this.jc.getCurrentSelectionEvent();
            List list2 = this.convertList(list);
            list2.add(xPDLElementChangeInfo3);
            if (this.redoHistory.size() >= this.maxHistory) {
                this.redoHistory.remove(0);
            }
            this.redoHistory.push(list2);
            this.undoOrRedoInProgress = true;
            for (int i = 0; i < list.size(); ++i) {
                xPDLElementChangeInfo = (XPDLElementChangeInfo)list.get(i);
                this.changeModel(xPDLElementChangeInfo);
            }
            this.undoOrRedoInProgress = false;
            this.jc.setUpdateInProgress(true);
            Package package_ = this.jc.getMainPackage();
            xPDLElementChangeInfo = this.jc.createInfo((XMLElement)package_, 16);
            xPDLElementChangeInfo.setChangedSubElements(list);
            this.jc.sendEvent(xPDLElementChangeInfo);
            this.jc.setUpdateInProgress(false);
            JaWEManager.getInstance().getLoggingManager().debug("All events after UNDO:\n" + list);
            if (xPDLElementChangeInfo2.getChangedSubElements().size() > 0) {
                this.jc.getSelectionManager().setSelection(xPDLElementChangeInfo2.getChangedSubElements(), true);
            } else {
                this.jc.getSelectionManager().setSelection(xPDLElementChangeInfo2.getChangedElement(), true);
            }
        }
    }

    public void redo() {
        if (!this.redoHistory.empty()) {
            XPDLElementChangeInfo xPDLElementChangeInfo;
            List list = (List)this.redoHistory.pop();
            XPDLElementChangeInfo xPDLElementChangeInfo2 = (XPDLElementChangeInfo)list.remove(list.size() - 1);
            XPDLElementChangeInfo xPDLElementChangeInfo3 = this.jc.getCurrentSelectionEvent();
            List list2 = this.convertList(list);
            list2.add(xPDLElementChangeInfo3);
            if (this.undoHistory.size() >= this.maxHistory) {
                this.undoHistory.remove(0);
            }
            this.undoHistory.push(list2);
            this.undoOrRedoInProgress = true;
            for (int i = 0; i < list.size(); ++i) {
                xPDLElementChangeInfo = (XPDLElementChangeInfo)list.get(i);
                this.changeModel(xPDLElementChangeInfo);
            }
            this.undoOrRedoInProgress = false;
            this.jc.setUpdateInProgress(true);
            Package package_ = this.jc.getMainPackage();
            xPDLElementChangeInfo = this.jc.createInfo((XMLElement)package_, 17);
            xPDLElementChangeInfo.setChangedSubElements(list);
            this.jc.sendEvent(xPDLElementChangeInfo);
            this.jc.setUpdateInProgress(false);
            JaWEManager.getInstance().getLoggingManager().debug("All events after REDO:\n" + list);
            if (xPDLElementChangeInfo2.getChangedSubElements().size() > 0) {
                this.jc.getSelectionManager().setSelection(xPDLElementChangeInfo2.getChangedSubElements(), true);
            } else {
                this.jc.getSelectionManager().setSelection(xPDLElementChangeInfo2.getChangedElement(), true);
            }
        }
    }

    public boolean canUndo() {
        return !this.undoHistory.isEmpty();
    }

    public boolean canRedo() {
        return !this.redoHistory.isEmpty();
    }

    public boolean isUndoOrRedoInProgress() {
        return this.undoOrRedoInProgress;
    }

    public void cleanHistory() {
        this.undoHistory.clear();
        this.redoHistory.clear();
    }

    protected List convertList(List list) {
        ArrayList<XPDLElementChangeInfo> arrayList = new ArrayList<XPDLElementChangeInfo>();
        for (int i = list.size() - 1; i >= 0; --i) {
            XPDLElementChangeInfo xPDLElementChangeInfo = (XPDLElementChangeInfo)list.get(i);
            XPDLElementChangeInfo xPDLElementChangeInfo2 = new XPDLElementChangeInfo((Observer)this.jc, (XMLElementChangeInfo)xPDLElementChangeInfo);
            if (xPDLElementChangeInfo2.getAction() == 3) {
                xPDLElementChangeInfo2.setAction(5);
            } else if (xPDLElementChangeInfo2.getAction() == 5) {
                xPDLElementChangeInfo2.setAction(3);
            } else if (xPDLElementChangeInfo2.getAction() == 1 || xPDLElementChangeInfo2.getAction() == 7) {
                xPDLElementChangeInfo2.setNewValue(xPDLElementChangeInfo.getOldValue());
                xPDLElementChangeInfo2.setOldValue(xPDLElementChangeInfo.getNewValue());
            }
            arrayList.add(xPDLElementChangeInfo2);
        }
        return arrayList;
    }

    protected boolean changeModel(XPDLElementChangeInfo xPDLElementChangeInfo) {
        try {
            if (xPDLElementChangeInfo.getAction() == 3) {
                if (xPDLElementChangeInfo.getChangedElement() instanceof XMLCollection) {
                    XMLCollection xMLCollection = (XMLCollection)xPDLElementChangeInfo.getChangedElement();
                    List list = xPDLElementChangeInfo.getChangedSubElements();
                    for (int i = 0; i < list.size(); ++i) {
                        xMLCollection.add((XMLElement)list.get(i));
                    }
                }
            } else if (xPDLElementChangeInfo.getAction() == 5) {
                if (xPDLElementChangeInfo.getChangedElement() instanceof XMLCollection) {
                    XMLCollection xMLCollection = (XMLCollection)xPDLElementChangeInfo.getChangedElement();
                    List list = xPDLElementChangeInfo.getChangedSubElements();
                    for (int i = 0; i < list.size(); ++i) {
                        xMLCollection.remove((XMLElement)list.get(i));
                    }
                }
            } else if (xPDLElementChangeInfo.getAction() == 1) {
                XMLElement xMLElement = xPDLElementChangeInfo.getChangedElement();
                if (xMLElement instanceof XMLComplexChoice) {
                    ((XMLComplexChoice)xMLElement).setChoosen((XMLElement)xPDLElementChangeInfo.getNewValue());
                } else {
                    xMLElement.setValue(xPDLElementChangeInfo.getNewValue().toString());
                }
            } else if (xPDLElementChangeInfo.getAction() == 7) {
                XMLCollection xMLCollection = (XMLCollection)xPDLElementChangeInfo.getChangedElement();
                List list = xPDLElementChangeInfo.getChangedSubElements();
                List list2 = (List)xPDLElementChangeInfo.getNewValue();
                for (int i = 0; i < list.size(); ++i) {
                    xMLCollection.reposition((XMLElement)list.get(i), ((Integer)list2.get(i)).intValue());
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    protected void printGH(String string) {
        System.out.println(string + "- BACK:" + this.undoHistory);
        System.out.println(string + "- FORW:" + this.redoHistory);
    }
}

