/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jxpdl;

import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xerces.parsers.DOMParser;
import org.enhydra.jxpdl.GraphChecker;
import org.enhydra.jxpdl.ParsingErrors;
import org.enhydra.jxpdl.XMLAttribute;
import org.enhydra.jxpdl.XMLCollection;
import org.enhydra.jxpdl.XMLCollectionElement;
import org.enhydra.jxpdl.XMLComplexChoice;
import org.enhydra.jxpdl.XMLComplexElement;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLEmptyChoiceElement;
import org.enhydra.jxpdl.XMLInterface;
import org.enhydra.jxpdl.XMLSimpleElement;
import org.enhydra.jxpdl.XMLUtil;
import org.enhydra.jxpdl.XMLValidationError;
import org.enhydra.jxpdl.XMLValidator;
import org.enhydra.jxpdl.XPDLEntityResolver;
import org.enhydra.jxpdl.XPDLRepositoryHandler;
import org.enhydra.jxpdl.elements.Activities;
import org.enhydra.jxpdl.elements.Activity;
import org.enhydra.jxpdl.elements.ActivitySet;
import org.enhydra.jxpdl.elements.ActivitySets;
import org.enhydra.jxpdl.elements.ActualParameter;
import org.enhydra.jxpdl.elements.ActualParameters;
import org.enhydra.jxpdl.elements.Application;
import org.enhydra.jxpdl.elements.Artifact;
import org.enhydra.jxpdl.elements.Association;
import org.enhydra.jxpdl.elements.Associations;
import org.enhydra.jxpdl.elements.BasicType;
import org.enhydra.jxpdl.elements.BlockActivity;
import org.enhydra.jxpdl.elements.Condition;
import org.enhydra.jxpdl.elements.DataField;
import org.enhydra.jxpdl.elements.DataType;
import org.enhydra.jxpdl.elements.DataTypes;
import org.enhydra.jxpdl.elements.Deadline;
import org.enhydra.jxpdl.elements.DeadlineDuration;
import org.enhydra.jxpdl.elements.Deadlines;
import org.enhydra.jxpdl.elements.DeclaredType;
import org.enhydra.jxpdl.elements.EnumerationType;
import org.enhydra.jxpdl.elements.EnumerationValue;
import org.enhydra.jxpdl.elements.ExceptionName;
import org.enhydra.jxpdl.elements.ExpressionType;
import org.enhydra.jxpdl.elements.ExternalPackage;
import org.enhydra.jxpdl.elements.FormalParameter;
import org.enhydra.jxpdl.elements.FormalParameters;
import org.enhydra.jxpdl.elements.Join;
import org.enhydra.jxpdl.elements.Package;
import org.enhydra.jxpdl.elements.Participant;
import org.enhydra.jxpdl.elements.Performer;
import org.enhydra.jxpdl.elements.Priority;
import org.enhydra.jxpdl.elements.Responsible;
import org.enhydra.jxpdl.elements.Split;
import org.enhydra.jxpdl.elements.SubFlow;
import org.enhydra.jxpdl.elements.TaskApplication;
import org.enhydra.jxpdl.elements.Tool;
import org.enhydra.jxpdl.elements.Transition;
import org.enhydra.jxpdl.elements.TransitionRef;
import org.enhydra.jxpdl.elements.TransitionRefs;
import org.enhydra.jxpdl.elements.Transitions;
import org.enhydra.jxpdl.elements.TypeDeclaration;
import org.enhydra.jxpdl.elements.WorkflowProcess;
import org.enhydra.jxpdl.elements.WorkflowProcesses;
import org.enhydra.jxpdl.elements.XPDLVersion;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class StandardPackageValidator
implements XMLValidator {
    public static final String VALIDATE_SUBFLOW_REFERENCES = "ValidateSubFlowReferences";
    public static final String VALIDATE_PERFORMER_EXPRESSIONS = "ValidatePerformerExpressions";
    public static final String VALIDATE_ACTUAL_PARAMETER_EXPRESSIONS = "ValidateActualParameterExpressions";
    public static final String VALIDATE_DEADLINE_EXPRESSIONS = "ValidateDeadlineExpressions";
    public static final String VALIDATE_CONDITION_EXPRESSIONS = "ValidateConditionExpressions";
    public static final String VALIDATE_UNUSED_VARIABLES = "ValidateUnusedVariables";
    public static final String VALIDATE_CONDITION_BY_TYPE = "ValidateConditionByType";
    public static final String GET_EXISTING_SCHEMA_VALIDATION_ERRORS = "GetExistingSchemaValidationErrors";
    public static final String CHECK_EXTERNAL_PACKAGES = "CheckExternalPackages";
    public static final String ALLOW_UNDEFINED_START = "AllowUndefinedStart";
    public static final String ALLOW_UNDEFINED_END = "AllowUndefinedEnd";
    public static final String ENCODING = "Encoding";
    public static final String LOCALE = "Locale";
    protected static final String CURRENT_XPDL_VERSION = "2.1";
    protected Properties properties;
    protected XMLInterface xmlInterface;
    protected Map epsValidationErrors = new HashMap();
    protected Map schemaValidationErrors = new HashMap();
    protected Properties settings;

    public StandardPackageValidator() {
    }

    public StandardPackageValidator(Properties properties) {
        this.settings = properties;
    }

    public void init(XMLInterface xMLInterface, Package package_, boolean bl, String string, String string2) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.settings);
        properties.put(GET_EXISTING_SCHEMA_VALIDATION_ERRORS, String.valueOf(bl));
        properties.put(CHECK_EXTERNAL_PACKAGES, "true");
        properties.put(ENCODING, string);
        properties.put(LOCALE, string2);
        this.init(properties, xMLInterface);
    }

    public void clearCache(Package package_) {
        this.epsValidationErrors.remove(package_);
        this.schemaValidationErrors.remove(package_);
    }

    public void clearCache() {
        this.epsValidationErrors.clear();
        this.schemaValidationErrors.clear();
        this.xmlInterface = null;
    }

    public Map getExtPkgValidationErrors() {
        return this.epsValidationErrors;
    }

    @Override
    public void init(Properties properties) {
        this.properties = properties;
        if (properties == null) {
            this.clearCache();
        }
    }

    public void init(Properties properties, XMLInterface xMLInterface) {
        this.init(properties);
        this.xmlInterface = xMLInterface;
    }

    @Override
    public void validateElement(XMLElement xMLElement, List list, boolean bl) {
        if (!bl && list.size() > 0) {
            return;
        }
        if (xMLElement.isEmpty() && !(xMLElement instanceof XMLCollection) && !xMLElement.isRequired()) {
            return;
        }
        try {
            Method method;
            Class<Object> clazz;
            block11: {
                clazz = xMLElement.getClass();
                method = null;
                try {
                    method = this.getClass().getMethod("validateElement", clazz, List.class, Boolean.TYPE);
                }
                catch (Exception exception) {
                    if (clazz == XMLSimpleElement.class || clazz == XMLAttribute.class || clazz == XMLComplexChoice.class || clazz == XMLComplexElement.class || clazz == XMLCollectionElement.class || clazz == XMLCollection.class) break block11;
                    if (XMLComplexChoice.class.isAssignableFrom(clazz)) {
                        clazz = XMLComplexChoice.class;
                    }
                    if (XMLAttribute.class.isAssignableFrom(clazz)) {
                        clazz = XMLAttribute.class;
                    }
                    if (XMLSimpleElement.class.isAssignableFrom(clazz)) {
                        clazz = XMLSimpleElement.class;
                    }
                    if (ExpressionType.class.isAssignableFrom(clazz)) {
                        clazz = ExpressionType.class;
                    }
                    if (XMLComplexElement.class.isAssignableFrom(clazz)) {
                        clazz = XMLComplexElement.class;
                    }
                    if (!XMLCollection.class.isAssignableFrom(clazz)) break block11;
                    clazz = XMLCollection.class;
                }
            }
            method = this.getClass().getMethod("validateElement", clazz, List.class, Boolean.TYPE);
            method.invoke((Object)this, xMLElement, list, new Boolean(bl));
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.validateStandard(xMLElement, list, bl);
            return;
        }
    }

    public void validateElement(XMLAttribute xMLAttribute, List list, boolean bl) {
        Object object;
        XMLElement xMLElement = xMLAttribute.getParent();
        boolean bl2 = true;
        if (xMLAttribute.toName().equals("Id")) {
            if (xMLElement instanceof SubFlow) {
                this.checkSubFlowId(xMLAttribute, list, bl);
            } else if (xMLElement instanceof TaskApplication) {
                this.checkToolId(xMLAttribute, list, bl);
            } else if (xMLElement instanceof TransitionRef) {
                this.checkTransitionRefId(xMLAttribute, list, bl);
            } else if (xMLElement instanceof DeclaredType) {
                this.checkDeclaredTypeId(xMLAttribute, list);
            } else {
                if (!this.isIdValid(xMLAttribute.toValue())) {
                    bl2 = false;
                    object = new XMLValidationError("ERROR", "LOGIC", "ERROR_INVALID_ID", xMLAttribute.toValue(), xMLAttribute);
                    list.add(object);
                }
                if (xMLElement instanceof XMLCollectionElement && (bl || bl2) && !this.isIdUnique((XMLCollectionElement)xMLElement)) {
                    bl2 = false;
                    object = new XMLValidationError("ERROR", "LOGIC", "ERROR_NON_UNIQUE_ID", xMLAttribute.toValue(), xMLAttribute);
                    list.add(object);
                }
            }
        } else if (xMLAttribute.toName().equals("href")) {
            if (xMLElement instanceof ExternalPackage) {
                object = xMLAttribute.toValue();
                Package package_ = XMLUtil.getPackage(xMLAttribute);
                String string = package_.getExternalPackageId((String)object);
                if (string == null || string.equals("")) {
                    XMLValidationError xMLValidationError = new XMLValidationError("ERROR", "LOGIC", "ERROR_NON_EXISTING_EXTERNAL_PACKAGE_REFERENCE", (String)object, xMLAttribute);
                    list.add(xMLValidationError);
                }
            }
        } else if (xMLElement instanceof Transition) {
            if (xMLAttribute.toName().equals("From")) {
                this.checkTransitionFrom(xMLAttribute, list);
            } else if (xMLAttribute.toName().equals("To")) {
                this.checkTransitionTo(xMLAttribute, list);
            }
        } else if (xMLElement instanceof Association) {
            if (xMLAttribute.toName().equals("Source")) {
                this.checkAssociationSource(xMLAttribute, list);
            } else if (xMLAttribute.toName().equals("Target")) {
                this.checkAssociationTarget(xMLAttribute, list);
            }
        } else if (xMLElement instanceof BlockActivity) {
            this.checkBlockId(xMLAttribute, list);
        }
        if (!bl && list.size() > 0) {
            return;
        }
        if (!this.isElementLengthOK(xMLAttribute)) {
            object = new XMLValidationError("ERROR", "LOGIC", "ERROR_UNALLOWED_LENGTH", xMLAttribute.toName(), xMLAttribute);
            list.add(object);
        }
    }

    public void validateElement(XMLComplexChoice xMLComplexChoice, List list, boolean bl) {
        this.validateElement(xMLComplexChoice.getChoosen(), list, bl);
    }

    public void validateElement(XMLEmptyChoiceElement xMLEmptyChoiceElement, List list, boolean bl) {
    }

    public void validateElement(XMLCollection xMLCollection, List list, boolean bl) {
        for (XMLElement xMLElement : xMLCollection.toElements()) {
            this.validateElement(xMLElement, list, bl);
        }
    }

    public void validateElement(XMLCollectionElement xMLCollectionElement, List list, boolean bl) {
        this.validateElement((XMLComplexElement)xMLCollectionElement, list, bl);
    }

    public void validateElement(XMLComplexElement xMLComplexElement, List list, boolean bl) {
        for (XMLElement xMLElement : xMLComplexElement.toElements()) {
            this.validateElement(xMLElement, list, bl);
        }
    }

    public void validateElement(XMLSimpleElement xMLSimpleElement, List list, boolean bl) {
        if (!this.isElementLengthOK(xMLSimpleElement)) {
            XMLValidationError xMLValidationError = new XMLValidationError("ERROR", "LOGIC", "ERROR_UNALLOWED_LENGTH", xMLSimpleElement.toName(), xMLSimpleElement);
            list.add(xMLValidationError);
        }
    }

    protected void validateStandard(XMLElement xMLElement, List list, boolean bl) {
        if (xMLElement instanceof XMLAttribute) {
            this.validateElement((XMLAttribute)xMLElement, list, bl);
        } else if (xMLElement instanceof XMLSimpleElement) {
            this.validateElement((XMLSimpleElement)xMLElement, list, bl);
        } else if (xMLElement instanceof XMLCollectionElement) {
            this.validateElement((XMLCollectionElement)xMLElement, list, bl);
        } else if (xMLElement instanceof XMLComplexElement) {
            this.validateElement((XMLComplexElement)xMLElement, list, bl);
        } else if (xMLElement instanceof XMLComplexChoice) {
            this.validateElement((XMLComplexChoice)xMLElement, list, bl);
        } else if (xMLElement instanceof XMLCollection) {
            this.validateElement((XMLCollection)xMLElement, list, bl);
        }
    }

    public void validateElement(Activity activity, List list, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        boolean bl2;
        this.validateStandard(activity, list, bl);
        boolean bl3 = bl2 = list.size() == 0;
        if (!bl2 && !bl) {
            return;
        }
        Set set = XMLUtil.getExceptionalOutgoingTransitions(activity);
        if (activity.getDeadlines().size() > 0 && set.size() == 0) {
            object3 = new XMLValidationError("ERROR", "LOGIC", "ERROR_DEADLINES_NOT_PROPERLY_HANDLED_NO_EXCEPTIONAL_TRANSITIONS", "", activity);
            list.add(object3);
            bl2 = false;
        }
        if (!bl2 && !bl) {
            return;
        }
        object3 = XMLUtil.getOutgoingTransitions(activity);
        Set set2 = XMLUtil.getIncomingTransitions(activity);
        if (activity.getActivityType() == 6 || activity.getActivityType() == 7) {
            if (activity.getActivityType() == 6) {
                if (set2.size() > 0) {
                    object2 = new XMLValidationError("ERROR", "CONNECTION", "ERROR_CONNECTION_TO_START_EVENT_NOT_ALLOWED", "", activity);
                    list.add(object2);
                    bl2 = false;
                    if (!bl2 && !bl) {
                        return;
                    }
                }
                if (object3.size() == 0) {
                    object2 = new XMLValidationError("ERROR", "CONNECTION", "ERROR_START_EVENT_NOT_CONNECTED", "", activity);
                    list.add(object2);
                    bl2 = false;
                    if (!bl2 && !bl) {
                        return;
                    }
                }
            }
            if (activity.getActivityType() == 7) {
                if (object3.size() > 0) {
                    object2 = new XMLValidationError("ERROR", "CONNECTION", "ERROR_CONNECTION_FROM_END_EVENT_NOT_ALLOWED", "", activity);
                    list.add(object2);
                    bl2 = false;
                    if (!bl2 && !bl) {
                        return;
                    }
                }
                if (set2.size() == 0) {
                    object2 = new XMLValidationError("ERROR", "CONNECTION", "ERROR_END_EVENT_NOT_CONNECTED", "", activity);
                    list.add(object2);
                    bl2 = false;
                    if (!bl2 && !bl) {
                        return;
                    }
                }
            }
        } else {
            if (set2.size() == 0) {
                object2 = new XMLValidationError("WARNING", "CONNECTION", "WARNING_CONNECTION_FROM_START_EVENT_IS_MISSING", "", activity);
                list.add(object2);
                bl2 = false;
                if (!bl2 && !bl) {
                    return;
                }
            }
            if (object3.size() == 0) {
                object2 = new XMLValidationError("WARNING", "CONNECTION", "WARNING_CONNECTION_TO_END_EVENT_IS_MISSING", "", activity);
                list.add(object2);
                bl2 = false;
                if (!bl2 && !bl) {
                    return;
                }
            }
        }
        if (((object2 = XMLUtil.getSplit(activity)) == null || ((Split)object2).getType().length() == 0) && object3.size() - set.size() > 1) {
            bl2 = false;
            object = new XMLValidationError("ERROR", "LOGIC", "ERROR_MULTIPLE_OUTGOING_TRANSITIONS_WITHOUT_SPLIT_TYPE_DEFINED", "", activity);
            list.add(object);
        }
        if (!bl2 && !bl) {
            return;
        }
        object = XMLUtil.getJoin(activity);
        if ((object == null || ((Join)object).getType().length() == 0) && set2.size() > 1) {
            bl2 = false;
            XMLValidationError xMLValidationError = new XMLValidationError("ERROR", "LOGIC", "ERROR_MULTIPLE_INCOMING_TRANSITIONS_WITHOUT_JOIN_TYPE_DEFINED", "", activity);
            list.add(xMLValidationError);
        }
        if (!bl && !bl2) {
            return;
        }
        this.checkMultipleOtherwiseOrDefaultExceptionTransitions(activity, (Set)object3, list, bl);
    }

    public void validateElement(ActivitySet activitySet, List list, boolean bl) {
        this.validateStandard(activitySet, list, bl);
        boolean bl2 = true;
        if ((list.size() == 0 || bl) && activitySet.getActivities().toElements().size() == 0) {
            bl2 = false;
            XMLValidationError xMLValidationError = new XMLValidationError("ERROR", "LOGIC", "ERROR_ACTIVITY_SET_NOT_DEFINED", "", activitySet);
            list.add(xMLValidationError);
        }
        if (bl2 || bl) {
            boolean bl3 = bl2 = this.checkGraphConnectionsForWpOrAs(activitySet, list, bl) || bl;
        }
        if (bl2 || bl) {
            bl2 = this.checkGraphConformanceForWpOrAs(activitySet, list, bl) || bl;
        }
    }

    public void validateElement(Associations associations, List list, boolean bl) {
        this.validateStandard(associations, list, bl);
        if (bl || list.size() == 0) {
            String string;
            HashMap<String, Association> hashMap = new HashMap<String, Association>();
            HashSet<Object> hashSet = new HashSet<Object>();
            for (int i = 0; i < associations.size(); ++i) {
                Association association = (Association)associations.get(i);
                string = "[" + association.getSource() + "-" + association.getTarget() + "]";
                if (hashMap.containsKey(string)) {
                    hashSet.add(hashMap.get(string));
                    hashSet.add(association);
                    if (!bl) break;
                }
                hashMap.put(string, association);
            }
            if (hashSet.size() > 0) {
                for (Association association : hashSet) {
                    string = "[" + association.getSource() + "-" + association.getTarget() + "]";
                    XMLValidationError xMLValidationError = new XMLValidationError("ERROR", "LOGIC", "ERROR_MULTIPLE_CONNECTIONS", string, association);
                    list.add(xMLValidationError);
                }
            }
        }
    }

    public void validateElement(Condition condition, List list, boolean bl) {
        XMLValidationError xMLValidationError;
        this.validateStandard(condition, list, bl);
        String string = condition.getType();
        String string2 = condition.toValue();
        if (list.size() > 0 && !bl) {
            return;
        }
        boolean bl2 = this.properties.getProperty(VALIDATE_CONDITION_BY_TYPE, "false").equals("true");
        if (string.equals("DEFAULTEXCEPTION")) {
            if (bl2 && string2.length() > 0) {
                XMLValidationError xMLValidationError2 = new XMLValidationError("WARNING", "LOGIC", "WARNING_DEFAULT_EXCEPTION_TRANSITION_WITH_EXPRESSION", string2, condition);
                list.add(xMLValidationError2);
            }
            return;
        }
        if (string.equals("OTHERWISE")) {
            if (bl2 && string2.length() > 0) {
                XMLValidationError xMLValidationError3 = new XMLValidationError("WARNING", "LOGIC", "WARNING_OTHERWISE_TRANSITION_WITH_EXPRESSION", string2, condition);
                list.add(xMLValidationError3);
            }
            return;
        }
        if (string.equals("")) {
            if (bl2 && string2.length() > 0) {
                xMLValidationError = new XMLValidationError("WARNING", "LOGIC", "WARNING_UNCONDITIONAL_TRANSITION_WITH_EXPRESSION", string2, condition);
                list.add(xMLValidationError);
            }
        } else if (string.equals("CONDITION")) {
            if (bl2 && string2.length() <= 0) {
                xMLValidationError = new XMLValidationError("WARNING", "LOGIC", "WARNING_CONDITIONAL_TRANSITION_WITHOUT_EXPRESSION", "", condition);
                list.add(xMLValidationError);
            }
        } else if (string.equals("EXCEPTION")) {
            if (bl2 && string2.length() <= 0) {
                XMLValidationError xMLValidationError4 = new XMLValidationError("WARNING", "LOGIC", "WARNING_EXCEPTION_TRANSITION_WITHOUT_EXPRESSION", "", condition);
                list.add(xMLValidationError4);
            }
            return;
        }
        if ((list.size() == 0 || bl) && string2.length() > 0 && this.properties.getProperty(VALIDATE_CONDITION_EXPRESSIONS, "false").equals("true")) {
            boolean bl3 = false;
            if (string2.toLowerCase().indexOf("true") >= 0 || string2.toLowerCase().indexOf("false") >= 0 || string2.toLowerCase().indexOf("boolean") >= 0 || string2.toLowerCase().indexOf("equals") >= 0 || string2.toLowerCase().indexOf(">") >= 0 || string2.toLowerCase().indexOf(">=") >= 0 || string2.toLowerCase().indexOf("<") >= 0 || string2.toLowerCase().indexOf("<=") >= 0 || string2.toLowerCase().indexOf("==") >= 0) {
                bl3 = true;
            }
            Map map = this.getActualParameterOrConditionChoices(condition);
            bl3 = bl3 || this.canBeExpression(string2, map, false);
            String string3 = "WARNING";
            if (!bl3 || !(string3 = this.additionalExpressionCheck(condition, string2, map)).equals("")) {
                XMLValidationError xMLValidationError5 = new XMLValidationError(string3, "LOGIC", "WARNING_CONDITION_EXPRESSION_POSSIBLY_INVALID", string2, condition);
                list.add(xMLValidationError5);
            }
        }
    }

    public void validateElement(DataField dataField, List list, boolean bl) {
        this.validateStandard(dataField, list, bl);
        boolean bl2 = this.properties.getProperty(VALIDATE_UNUSED_VARIABLES, "false").equals("true");
        if (bl2 && (bl || list.size() == 0) && this.getNoOfReferences((XMLComplexElement)dataField.getParent().getParent(), dataField) == 0) {
            XMLValidationError xMLValidationError = new XMLValidationError("WARNING", "LOGIC", "WARNING_UNUSED_VARIABLE", dataField.getId(), dataField);
            list.add(xMLValidationError);
        }
    }

    public void validateElement(DeadlineDuration deadlineDuration, List list, boolean bl) {
        this.validateStandard(deadlineDuration, list, bl);
        String string = deadlineDuration.toValue();
        if ((list.size() == 0 || bl) && string.length() > 0 && this.properties.getProperty(VALIDATE_DEADLINE_EXPRESSIONS, "false").equals("true")) {
            boolean bl2 = false;
            if (string.toLowerCase().indexOf("date") >= 0 || string.toLowerCase().indexOf("calendar") >= 0) {
                bl2 = true;
            }
            Map map = this.getDeadlineConditionChoices(deadlineDuration);
            bl2 = bl2 || this.canBeExpression(string, map, false);
            String string2 = "WARNING";
            if (!bl2 || !(string2 = this.additionalExpressionCheck(deadlineDuration, string, map)).equals("")) {
                XMLValidationError xMLValidationError = new XMLValidationError(string2, "LOGIC", "WARNING_DEADLINE_EXPRESSION_POSSIBLY_INVALID", string, deadlineDuration);
                list.add(xMLValidationError);
            }
        }
    }

    public void validateElement(Deadlines deadlines, List list, boolean bl) {
        Object object;
        Iterator iterator = deadlines.toElements().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            object = (Deadline)iterator.next();
            if (!((Deadline)object).getExecution().equals("SYNCHR")) continue;
            ++n;
        }
        if (n > 1) {
            object = new XMLValidationError("ERROR", "LOGIC", "ERROR_MULTIPLE_SYNC_DEADLINES_DEFINED", "", deadlines);
            list.add(object);
        }
        if (bl || n > 1) {
            this.validateStandard(deadlines, list, bl);
        }
    }

    public void validateElement(ExceptionName exceptionName, List list, boolean bl) {
        Object object;
        Activity activity = XMLUtil.getActivity(exceptionName);
        Set set = XMLUtil.getExceptionalOutgoingTransitions(activity);
        boolean bl2 = true;
        if (set.size() == 0) {
            bl2 = false;
        } else {
            object = exceptionName.toValue();
            for (Transition transition : set) {
                String string = transition.getCondition().toValue();
                String string2 = transition.getCondition().getType();
                if (!string2.equals("DEFAULTEXCEPTION") && !string.equals(object) && string.length() != 0) continue;
                return;
            }
            bl2 = false;
        }
        if (!bl2) {
            object = new XMLValidationError("ERROR", "LOGIC", "ERROR_DEADLINE_EXCEPTION_NOT_PROPERLY_HANDLED_MISSING_SPECIFIED_EXCEPTION_TRANSITION_OR_DEFAULT_EXCEPTION_TRANSITION", "", exceptionName);
            list.add(object);
        }
    }

    public void validateElement(ExpressionType expressionType, List list, boolean bl) {
    }

    public void validateElement(FormalParameter formalParameter, List list, boolean bl) {
        this.validateStandard(formalParameter, list, bl);
        boolean bl2 = this.properties.getProperty(VALIDATE_UNUSED_VARIABLES, "false").equals("true");
        if (bl2 && formalParameter.getParent().getParent() instanceof WorkflowProcess && (bl || list.size() == 0) && this.getNoOfReferences((WorkflowProcess)formalParameter.getParent().getParent(), formalParameter) == 0) {
            XMLValidationError xMLValidationError = new XMLValidationError("WARNING", "LOGIC", "WARNING_UNUSED_VARIABLE", formalParameter.getId(), formalParameter);
            list.add(xMLValidationError);
        }
    }

    protected int getNoOfReferences(XMLComplexElement xMLComplexElement, XMLComplexElement xMLComplexElement2) {
        return XMLUtil.getReferences(xMLComplexElement, xMLComplexElement2, null).size();
    }

    public void validateElement(Package package_, List list, boolean bl) {
        this.validateAgainstXPDLSchema(package_, list, bl);
        if (list.size() == 0 || bl) {
            this.validateStandard(package_, list, bl);
        }
        if (list.size() == 0 || bl) {
            this.checkExternalPackages(package_, list, bl);
        }
        if (list.size() == 0 || bl) {
            this.checkGraphConnectionsForArtifacts(package_, list, bl);
        }
    }

    public void validateElement(Performer performer, List list, boolean bl) {
        Object object;
        String string = performer.toValue();
        Activity activity = XMLUtil.getActivity(performer);
        if (activity == null) {
            return;
        }
        int n = activity.getActivityType();
        boolean bl2 = true;
        if (n != 1 && n != 2) {
            bl2 = false;
        }
        if (!bl2 && string.length() > 0) {
            object = new XMLValidationError("WARNING", "LOGIC", "WARNING_ACTIVITY_CANNOT_HAVE_PERFORMER", "", performer);
            list.add(object);
        }
        if (bl2 && this.properties.getProperty(VALIDATE_PERFORMER_EXPRESSIONS, "false").equals("true") && (object = XMLUtil.findParticipant(this.xmlInterface, XMLUtil.getWorkflowProcess(activity), string)) == null && string.length() > 0) {
            Map map = this.getPerformerChoices(performer);
            boolean bl3 = this.canBeExpression(string, map, true);
            String string2 = "WARNING";
            if (!bl3 || !(string2 = this.additionalExpressionCheck(performer, string, map)).equals("")) {
                XMLValidationError xMLValidationError = new XMLValidationError(string2, "LOGIC", "WARNING_PERFORMER_EXPRESSION_POSSIBLY_INVALID", string, performer);
                list.add(xMLValidationError);
            }
        }
    }

    public void validateElement(Priority priority, List list, boolean bl) {
        boolean bl2 = false;
        try {
            if (priority.toValue().trim().length() > 0) {
                Integer.parseInt(priority.toValue());
            }
        }
        catch (Exception exception) {
            bl2 = true;
        }
        if (bl2) {
            XMLValidationError xMLValidationError = new XMLValidationError("ERROR", "LOGIC", "ERROR_PRIORITY_INVALID_VALUE", priority.toValue(), priority);
            list.add(xMLValidationError);
        }
    }

    public void validateElement(Responsible responsible, List list, boolean bl) {
        XMLComplexElement xMLComplexElement = XMLUtil.getWorkflowProcess(responsible);
        if (xMLComplexElement == null) {
            xMLComplexElement = XMLUtil.getPackage(responsible);
        }
        String string = responsible.toValue();
        Participant participant = xMLComplexElement instanceof Package ? XMLUtil.findParticipant(this.xmlInterface, (Package)xMLComplexElement, string) : XMLUtil.findParticipant(this.xmlInterface, xMLComplexElement, string);
        if (participant == null) {
            XMLValidationError xMLValidationError = new XMLValidationError("ERROR", "LOGIC", "ERROR_NON_EXISTING_PARTICIPANT_REFERENCE", string, responsible);
            list.add(xMLValidationError);
        }
    }

    public void validateElement(SubFlow subFlow, List list, boolean bl) {
        WorkflowProcess workflowProcess;
        this.validateStandard(subFlow, list, bl);
        if ((list.size() == 0 || bl) && (workflowProcess = XMLUtil.findWorkflowProcess(this.xmlInterface, XMLUtil.getPackage(subFlow), subFlow.getId())) != null) {
            ActualParameters actualParameters = subFlow.getActualParameters();
            this.checkParameterMatching(workflowProcess.getFormalParameters(), actualParameters, list, this.properties.getProperty(VALIDATE_ACTUAL_PARAMETER_EXPRESSIONS, "false").equals("true"), bl);
        }
    }

    public void validateElement(TaskApplication taskApplication, List list, boolean bl) {
        this.validateStandard(taskApplication, list, bl);
        if (list.size() == 0 || bl) {
            XMLElement xMLElement;
            String string = taskApplication.getId();
            WorkflowProcess workflowProcess = XMLUtil.getWorkflowProcess(taskApplication);
            Application application = XMLUtil.findApplication(this.xmlInterface, workflowProcess, string);
            if (application != null && (xMLElement = application.getApplicationTypes().getChoosen()) instanceof FormalParameters) {
                ActualParameters actualParameters = taskApplication.getActualParameters();
                this.checkParameterMatching((FormalParameters)xMLElement, actualParameters, list, this.properties.getProperty(VALIDATE_ACTUAL_PARAMETER_EXPRESSIONS, "false").equals("true"), bl);
            }
        }
    }

    public void validateElement(TransitionRefs transitionRefs, List list, boolean bl) {
        Set set = XMLUtil.getOutgoingTransitions(XMLUtil.getActivity(transitionRefs));
        Split split = (Split)XMLUtil.getParentElement(Split.class, transitionRefs);
        boolean bl2 = true;
        if (transitionRefs.size() != set.size() && set.size() > 1 && !split.getType().equals("Parallel")) {
            bl2 = false;
            XMLValidationError xMLValidationError = new XMLValidationError("ERROR", "LOGIC", "ERROR_TRANSITION_REFS_AND_OUTGOING_TRANSITION_NUMBER_MISSMATCH", "", transitionRefs);
            list.add(xMLValidationError);
        }
        if (!bl && !bl2) {
            return;
        }
        this.validateStandard(transitionRefs, list, bl);
    }

    public void validateElement(Transitions transitions, List list, boolean bl) {
        this.validateStandard(transitions, list, bl);
        if (bl || list.size() == 0) {
            String string;
            HashMap<String, Transition> hashMap = new HashMap<String, Transition>();
            HashSet<Object> hashSet = new HashSet<Object>();
            for (int i = 0; i < transitions.size(); ++i) {
                Transition transition = (Transition)transitions.get(i);
                string = "[" + transition.getFrom() + "-" + transition.getTo() + "]";
                if (hashMap.containsKey(string)) {
                    hashSet.add(hashMap.get(string));
                    hashSet.add(transition);
                    if (!bl) break;
                }
                hashMap.put(string, transition);
            }
            if (hashSet.size() > 0) {
                for (Transition transition : hashSet) {
                    string = "[" + transition.getFrom() + "-" + transition.getTo() + "]";
                    XMLValidationError xMLValidationError = new XMLValidationError("ERROR", "LOGIC", "ERROR_MULTIPLE_CONNECTIONS", string, transition);
                    list.add(xMLValidationError);
                }
            }
        }
    }

    public void validateElement(WorkflowProcess workflowProcess, List list, boolean bl) {
        boolean bl2 = true;
        if (workflowProcess.getActivities().toElements().size() == 0) {
            bl2 = false;
            XMLValidationError xMLValidationError = new XMLValidationError("ERROR", "LOGIC", "ERROR_WORKFLOW_PROCESS_NOT_DEFINED", "", workflowProcess);
            list.add(xMLValidationError);
        }
        if (bl || bl2) {
            this.validateStandard(workflowProcess, list, bl);
        }
        if (bl2 || bl) {
            this.checkGraphConnectionsForWpOrAs(workflowProcess, list, bl);
        }
        if (bl2 || bl) {
            this.checkGraphConformanceForWpOrAs(workflowProcess, list, bl);
        }
    }

    public void validateElement(XPDLVersion xPDLVersion, List list, boolean bl) {
        if (!xPDLVersion.toValue().equals(CURRENT_XPDL_VERSION)) {
            XMLValidationError xMLValidationError = new XMLValidationError("WARNING", "LOGIC", "WARNING_INVALID_XPDL_VERSION", xPDLVersion.toValue(), xPDLVersion);
            list.add(xMLValidationError);
        }
    }

    protected void validateAgainstXPDLSchema(Package package_, List list, boolean bl) {
        Object object;
        ArrayList<Object> arrayList = (ArrayList<Object>)this.schemaValidationErrors.get(package_);
        if (arrayList != null && this.properties.getProperty(GET_EXISTING_SCHEMA_VALIDATION_ERRORS, "false").equals("true")) {
            list.addAll(arrayList);
            return;
        }
        List<String> list2 = new ArrayList<String>();
        try {
            String string = this.properties.getProperty(ENCODING, "UTF-8");
            Object object2 = null;
            object = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XPDLRepositoryHandler xPDLRepositoryHandler = new XPDLRepositoryHandler();
            xPDLRepositoryHandler.toXML(document, package_);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("encoding", string);
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(byteArrayOutputStream);
            transformer.transform(dOMSource, streamResult);
            DOMParser dOMParser = new DOMParser();
            try {
                String string2 = this.properties.getProperty(LOCALE);
                Locale locale = new Locale("");
                if (string2 == null || string2.trim().length() == 0) {
                    locale = Locale.getDefault();
                } else if (!string2.equals("default")) {
                    locale = new Locale(string2);
                }
                dOMParser.setLocale(locale);
                dOMParser.setFeature("http://apache.org/xml/features/continue-after-fatal-error", true);
                ParsingErrors parsingErrors = new ParsingErrors();
                dOMParser.setErrorHandler((ErrorHandler)parsingErrors);
                dOMParser.setEntityResolver((EntityResolver)new XPDLEntityResolver());
                dOMParser.setFeature("http://xml.org/sax/features/validation", true);
                dOMParser.setFeature("http://apache.org/xml/features/validation/schema", true);
                dOMParser.parse(new InputSource(new StringReader(byteArrayOutputStream.toString(string))));
                list2 = parsingErrors.getErrorMessages();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                list2.add("Fatal error while parsing document:" + exception.getMessage());
            }
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            list2.add("Fatal error while validating schema for package " + package_.getId() + " :" + exception.getMessage());
        }
        arrayList = new ArrayList<Object>();
        if (list2.size() > 0) {
            for (String string : list2) {
                if (string.contains("SubFlowIdRef.Package") || string.contains("of attribute 'Id' on element 'SubFlow' is not valid with respect to its type, 'IdRef'") || string.contains("'http") && string.contains("is not a valid value for 'NMTOKEN'")) continue;
                object = new XMLValidationError("ERROR", "SCHEMA", "", string, package_);
                arrayList.add(object);
            }
        }
        list.addAll(arrayList);
        this.schemaValidationErrors.put(package_, arrayList);
    }

    protected void checkExternalPackages(Package package_, List list, boolean bl) {
        if (this.properties.getProperty(CHECK_EXTERNAL_PACKAGES, "true").equals("false")) {
            return;
        }
        Iterator iterator = XMLUtil.getAllExternalPackageIds(this.xmlInterface, package_, new HashSet()).iterator();
        while (iterator.hasNext()) {
            Package package_2 = this.xmlInterface.getPackageById((String)iterator.next());
            List list2 = (List)this.epsValidationErrors.get(package_2);
            if (list2 == null) {
                list2 = this.reCheckExternalPackage(package_2);
            }
            list.addAll(list2);
        }
    }

    public List reCheckExternalPackage(Package package_) {
        Object object;
        ArrayList arrayList = (ArrayList)this.epsValidationErrors.get(package_);
        if (arrayList != null) {
            arrayList.clear();
        } else {
            arrayList = new ArrayList();
        }
        Properties properties = new Properties();
        for (Map.Entry<Object, Object> object22 : this.properties.entrySet()) {
            object = (String)object22.getKey();
            String string = (String)object22.getValue();
            if (((String)object).equals(CHECK_EXTERNAL_PACKAGES)) {
                properties.setProperty(CHECK_EXTERNAL_PACKAGES, "false");
                continue;
            }
            if (((String)object).equals(GET_EXISTING_SCHEMA_VALIDATION_ERRORS)) {
                properties.setProperty(GET_EXISTING_SCHEMA_VALIDATION_ERRORS, "false");
                continue;
            }
            properties.setProperty((String)object, string);
        }
        StandardPackageValidator standardPackageValidator = this.createValidatorInstance();
        standardPackageValidator.init(properties, this.xmlInterface);
        object = new ArrayList();
        standardPackageValidator.validateElement(package_, (List)object, true);
        this.epsValidationErrors.put(package_, object);
        this.schemaValidationErrors.remove(package_);
        return object;
    }

    protected boolean checkToolId(XMLAttribute xMLAttribute, List list, boolean bl) {
        XMLValidationError xMLValidationError = null;
        String string = xMLAttribute.toValue();
        WorkflowProcess workflowProcess = XMLUtil.getWorkflowProcess(xMLAttribute);
        Application application = XMLUtil.findApplication(this.xmlInterface, workflowProcess, string);
        if (application == null) {
            xMLValidationError = new XMLValidationError("ERROR", "LOGIC", "ERROR_NON_EXISTING_APPLICATION_REFERENCE", string, xMLAttribute);
            list.add(xMLValidationError);
        }
        return xMLValidationError != null;
    }

    protected boolean checkSubFlowId(XMLAttribute xMLAttribute, List list, boolean bl) {
        XMLValidationError xMLValidationError = null;
        String string = xMLAttribute.toValue();
        if (string.trim().equals("")) {
            xMLValidationError = new XMLValidationError("ERROR", "LOGIC", "ERROR_NON_EXISTING_WORKFLOW_PROCESS_REFERENCE", string, xMLAttribute);
        }
        Package package_ = XMLUtil.getPackage(xMLAttribute);
        WorkflowProcess workflowProcess = null;
        if (xMLValidationError == null && (workflowProcess = XMLUtil.findWorkflowProcess(this.xmlInterface, package_, string)) == null && !this.isRemoteSubflowIdOK(string) && this.properties.getProperty(VALIDATE_SUBFLOW_REFERENCES, "true").equals("true")) {
            xMLValidationError = new XMLValidationError("ERROR", "LOGIC", "ERROR_NON_EXISTING_WORKFLOW_PROCESS_REFERENCE", string, xMLAttribute);
        }
        if (xMLValidationError != null) {
            list.add(xMLValidationError);
        }
        return xMLValidationError == null;
    }

    protected void checkTransitionRefId(XMLAttribute xMLAttribute, List list, boolean bl) {
        String string;
        Set set = XMLUtil.getOutgoingTransitions(XMLUtil.getActivity(xMLAttribute));
        if (!this.containsTransitionWithId(set, string = xMLAttribute.toValue())) {
            XMLValidationError xMLValidationError = new XMLValidationError("ERROR", "LOGIC", "ERROR_NON_EXISTING_TRANSITION_REFERENCE", string, xMLAttribute);
            list.add(xMLValidationError);
        }
    }

    protected boolean containsTransitionWithId(Set set, String string) {
        for (Transition transition : set) {
            if (!transition.getId().equals(string)) continue;
            return true;
        }
        return false;
    }

    protected boolean isRemoteSubflowIdOK(String string) {
        return false;
    }

    protected void checkMultipleOtherwiseOrDefaultExceptionTransitions(Activity activity, Set set, List list, boolean bl) {
        Object object2;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        for (Object object2 : set) {
            String string = ((Transition)object2).getCondition().getType();
            if (string.equals("OTHERWISE")) {
                if (bl2) {
                    bl3 = true;
                    if (!bl5 && bl) continue;
                    break;
                }
                bl2 = true;
                continue;
            }
            if (!string.equals("DEFAULTEXCEPTION")) continue;
            if (bl4) {
                bl5 = true;
                if (!bl3 && bl) continue;
                break;
            }
            bl4 = true;
        }
        if (bl3) {
            object2 = new XMLValidationError("ERROR", "LOGIC", "ERROR_MORE_THAN_ONE_OTHERWISE_TRANSITION", "", activity);
            list.add(object2);
        }
        if (bl5) {
            object2 = new XMLValidationError("ERROR", "LOGIC", "ERROR_MORE_THAN_ONE_DEFAULT_EXCEPTION_TRANSITION", "", activity);
            list.add(object2);
        }
    }

    protected void checkTransitionFrom(XMLAttribute xMLAttribute, List list) {
        if (XMLUtil.getFromActivity(XMLUtil.getTransition(xMLAttribute)) == null) {
            XMLValidationError xMLValidationError = new XMLValidationError("ERROR", "LOGIC", "ERROR_NON_EXISTING_ACTIVITY_REFERENCE", xMLAttribute.toValue(), xMLAttribute);
            list.add(xMLValidationError);
        }
    }

    protected void checkTransitionTo(XMLAttribute xMLAttribute, List list) {
        if (XMLUtil.getToActivity(XMLUtil.getTransition(xMLAttribute)) == null) {
            XMLValidationError xMLValidationError = new XMLValidationError("ERROR", "LOGIC", "ERROR_NON_EXISTING_ACTIVITY_REFERENCE", xMLAttribute.toValue(), xMLAttribute);
            list.add(xMLValidationError);
        }
    }

    protected void checkAssociationSource(XMLAttribute xMLAttribute, List list) {
        if (XMLUtil.getAssociationSource(XMLUtil.getAssociation(xMLAttribute)) == null) {
            XMLValidationError xMLValidationError = new XMLValidationError("ERROR", "LOGIC", "ERROR_NON_EXISTING_ACTIVITY_OR_ARTIFACT_REFERENCE", xMLAttribute.toValue(), xMLAttribute);
            list.add(xMLValidationError);
        }
    }

    protected void checkAssociationTarget(XMLAttribute xMLAttribute, List list) {
        if (XMLUtil.getAssociationTarget(XMLUtil.getAssociation(xMLAttribute)) == null) {
            XMLValidationError xMLValidationError = new XMLValidationError("ERROR", "LOGIC", "ERROR_NON_EXISTING_ACTIVITY_OR_ARTIFACT_REFERENCE", xMLAttribute.toValue(), xMLAttribute);
            list.add(xMLValidationError);
        }
    }

    protected void checkDeclaredTypeId(XMLAttribute xMLAttribute, List list) {
        String string = xMLAttribute.toValue();
        TypeDeclaration typeDeclaration = XMLUtil.getTypeDeclaration(this.xmlInterface, XMLUtil.getPackage(xMLAttribute), string);
        if (typeDeclaration == null) {
            XMLValidationError xMLValidationError = new XMLValidationError("ERROR", "LOGIC", "ERROR_NON_EXISTING_TYPE_DECLARATION_REFERENCE", string, xMLAttribute);
            list.add(xMLValidationError);
        }
    }

    protected void checkBlockId(XMLAttribute xMLAttribute, List list) {
        String string = xMLAttribute.toValue();
        ActivitySet activitySet = XMLUtil.getWorkflowProcess(xMLAttribute).getActivitySet(string);
        if (activitySet == null) {
            XMLValidationError xMLValidationError = new XMLValidationError("ERROR", "LOGIC", "ERROR_NON_EXISTING_ACTIVITY_SET_REFERENCE", string, xMLAttribute);
            list.add(xMLValidationError);
        }
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public boolean isElementLengthOK(XMLElement xMLElement) {
        return true;
    }

    protected boolean isIdValid(String string) {
        return XMLUtil.isIdValid(string);
    }

    protected boolean isIdUnique(XMLCollectionElement xMLCollectionElement) {
        XMLElement xMLElement = xMLCollectionElement.getParent();
        if (xMLCollectionElement instanceof Tool || xMLCollectionElement instanceof TransitionRef) {
            return true;
        }
        if (xMLCollectionElement instanceof Activity) {
            return this.checkActivityId((Activity)xMLCollectionElement);
        }
        if (xMLCollectionElement instanceof Transition) {
            return this.checkTransitionId((Transition)xMLCollectionElement);
        }
        if (xMLCollectionElement instanceof ActivitySet) {
            return this.checkActivitySetId((ActivitySet)xMLCollectionElement);
        }
        if (xMLElement instanceof XMLCollection) {
            return XMLUtil.cntIds((XMLCollection)xMLElement, xMLCollectionElement.getId()) <= 1;
        }
        return true;
    }

    protected boolean checkActivityId(Activity activity) {
        int n = 0;
        for (WorkflowProcess workflowProcess : XMLUtil.getPackage(activity).getWorkflowProcesses().toElements()) {
            String string = activity.getId();
            Activities activities = workflowProcess.getActivities();
            n += XMLUtil.cntIds(activities, string);
            ActivitySets activitySets = workflowProcess.getActivitySets();
            for (int i = 0; i < activitySets.size(); ++i) {
                ActivitySet activitySet = (ActivitySet)activitySets.get(i);
                activities = activitySet.getActivities();
                n += XMLUtil.cntIds(activities, string);
            }
        }
        return n <= 1;
    }

    protected boolean checkTransitionId(Transition transition) {
        int n = 0;
        WorkflowProcess workflowProcess = XMLUtil.getWorkflowProcess(transition);
        String string = transition.getId();
        Transitions transitions = workflowProcess.getTransitions();
        n += XMLUtil.cntIds(transitions, string);
        ActivitySets activitySets = workflowProcess.getActivitySets();
        for (int i = 0; i < activitySets.size(); ++i) {
            ActivitySet activitySet = (ActivitySet)activitySets.get(i);
            transitions = activitySet.getTransitions();
            n += XMLUtil.cntIds(transitions, string);
        }
        return n <= 1;
    }

    protected boolean checkActivitySetId(ActivitySet activitySet) {
        int n = 0;
        WorkflowProcesses workflowProcesses = XMLUtil.getPackage(activitySet).getWorkflowProcesses();
        n += XMLUtil.cntIds(workflowProcesses, activitySet.getId());
        for (WorkflowProcess workflowProcess : workflowProcesses.toElements()) {
            String string = activitySet.getId();
            ActivitySets activitySets = workflowProcess.getActivitySets();
            n += XMLUtil.cntIds(activitySets, string);
        }
        return n <= 1;
    }

    protected boolean checkGraphConformanceForWpOrAs(XMLCollectionElement xMLCollectionElement, List list, boolean bl) {
        XMLValidationError xMLValidationError;
        int n;
        Object object;
        Object object2;
        Package package_ = XMLUtil.getPackage(xMLCollectionElement);
        String string = package_.getConformanceClass().getGraphConformance();
        int n2 = XMLUtil.getConformanceClassNo(string);
        Activities activities = (Activities)xMLCollectionElement.get("Activities");
        ArrayList arrayList = activities.toElements();
        if (arrayList.size() == 0) {
            return true;
        }
        boolean bl2 = true;
        Set set = XMLUtil.getSplitOrJoinActivities(arrayList, 0);
        Set set2 = XMLUtil.getSplitOrJoinActivities(arrayList, 1);
        HashSet hashSet = new HashSet(arrayList);
        hashSet.removeAll(set);
        GraphChecker graphChecker = null;
        if (n2 > 0 && (bl2 || bl)) {
            object2 = this.createIncidenceMatrix(activities);
            if (object2 == null) {
                XMLValidationError xMLValidationError2 = new XMLValidationError("ERROR", "CONFORMANCE", "Unexpected error while checking graph conformance!", "", xMLCollectionElement);
                list.add(xMLValidationError2);
                return false;
            }
            graphChecker = new GraphChecker((boolean[][])object2);
            boolean bl3 = false;
            if (bl) {
                object = graphChecker.getCyclicNodes();
                if (object != null) {
                    bl2 = false;
                    bl3 = true;
                    for (n = 0; n < ((int[])object).length; ++n) {
                        Activity activity = (Activity)arrayList.get(object[n]);
                        xMLValidationError = new XMLValidationError("ERROR", "CONFORMANCE", "ERROR_LOOP_CONTAINED_ACTIVITY_IN_LOOP_BLOCKED_MODE", "", activity);
                        list.add(xMLValidationError);
                    }
                }
            } else {
                bl3 = graphChecker.isGraphCyclic();
                if (bl3) {
                    bl2 = false;
                    object = new XMLValidationError("ERROR", "CONFORMANCE", "ERROR_CYCLIC_GRAPH_IN_LOOP_BLOCKED_MODE", "", xMLCollectionElement);
                    list.add(object);
                }
            }
        }
        if (n2 == 2 && (bl2 || bl)) {
            if (XMLUtil.getStartingActivities(xMLCollectionElement).size() != 1) {
                bl2 = false;
                object2 = new XMLValidationError("ERROR", "CONFORMANCE", "ERROR_MULTIPLE_STARTING_ACTIVITIES_IN_FULL_BLOCKED_MODE", "", xMLCollectionElement);
                list.add(object2);
            }
            if ((bl2 || bl) && XMLUtil.getEndingActivities(xMLCollectionElement).size() != 1) {
                bl2 = false;
                object2 = new XMLValidationError("ERROR", "CONFORMANCE", "ERROR_MULTIPLE_ENDING_ACTIVITIES_IN_FULL_BLOCKED_MODE", "", xMLCollectionElement);
                list.add(object2);
            }
            boolean bl4 = false;
            if ((bl2 || bl) && set.size() != set2.size()) {
                XMLValidationError xMLValidationError3;
                if (set.size() > set2.size()) {
                    xMLValidationError3 = new XMLValidationError("ERROR", "CONFORMANCE", "ERROR_SPLIT_JOIN_MISSMATCH_IN_FULL_BLOCKED_MODE_MORE_SPLITS", "", xMLCollectionElement);
                    list.add(xMLValidationError3);
                } else {
                    xMLValidationError3 = new XMLValidationError("ERROR", "CONFORMANCE", "ERROR_SPLIT_JOIN_MISSMATCH_IN_FULL_BLOCKED_MODE_MORE_JOINS", "", xMLCollectionElement);
                    list.add(xMLValidationError3);
                }
                bl2 = false;
                bl4 = true;
            }
            if ((bl2 || bl) && !bl4 && this.getNoOfANDSplitsOrJoins(set, 0) != this.getNoOfANDSplitsOrJoins(set2, 1)) {
                XMLValidationError xMLValidationError4 = new XMLValidationError("ERROR", "CONFORMANCE", "ERROR_SPLIT_JOIN_MISSMATCH_IN_FULL_BLOCKED_MODE_DIFFERENT_TYPES", "", xMLCollectionElement);
                list.add(xMLValidationError4);
                bl2 = false;
            }
            if (bl2 || bl) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    object = (Activity)iterator.next();
                    if (XMLUtil.isANDTypeSplitOrJoin((Activity)object, 0)) {
                        if (this.checkANDSplit((Activity)object)) continue;
                        bl2 = false;
                        XMLValidationError xMLValidationError5 = new XMLValidationError("ERROR", "CONFORMANCE", "ERROR_CONDITIONAL_TRANSITION_FOR_AND_SPLIT_IN_FULL_BLOCKED_MODE", "", (XMLElement)object);
                        list.add(xMLValidationError5);
                        if (bl) continue;
                        break;
                    }
                    if (this.checkXORSplit((Activity)object)) continue;
                    bl2 = false;
                    XMLValidationError xMLValidationError6 = new XMLValidationError("ERROR", "CONFORMANCE", "ERROR_NO_OTHERWISE_TRANSITION_FOR_XOR_SPLIT_IN_FULL_BLOCKED_MODE", "", (XMLElement)object);
                    list.add(xMLValidationError6);
                    if (bl) continue;
                    break;
                }
                iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    object = (Activity)iterator.next();
                    if (this.checkXORSplit((Activity)object)) continue;
                    bl2 = false;
                    XMLValidationError xMLValidationError7 = new XMLValidationError("ERROR", "CONFORMANCE", "ERROR_NO_OTHERWISE_TRANSITION_FOR_XOR_SPLIT_IN_FULL_BLOCKED_MODE", "", (XMLElement)object);
                    list.add(xMLValidationError7);
                    if (bl) continue;
                    break;
                }
            }
            if (bl2 || bl) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    object = (Activity)iterator.next();
                    n = arrayList.indexOf(object);
                    if (n == -1) {
                        XMLValidationError xMLValidationError8 = new XMLValidationError("ERROR", "CONFORMANCE", "Unexpected error while searching for split/join matching for graph conformance!", "", xMLCollectionElement);
                        list.add(xMLValidationError8);
                        bl2 = false;
                        if (bl) continue;
                        break;
                    }
                    int n3 = graphChecker.getJoinIndex(n);
                    if (n3 < 0) {
                        bl2 = false;
                        xMLValidationError = new XMLValidationError("ERROR", "CONFORMANCE", "ERROR_NO_CORRESPONDING_JOIN_ACTIVITY_IN_FULL_BLOCKED_MODE", "", (XMLElement)object);
                        list.add(xMLValidationError);
                        if (bl) continue;
                        break;
                    }
                    if (XMLUtil.isANDTypeSplitOrJoin((Activity)object, 0) == XMLUtil.isANDTypeSplitOrJoin((Activity)arrayList.get(n3), 1)) continue;
                    bl2 = false;
                    if (XMLUtil.isANDTypeSplitOrJoin((Activity)object, n3)) {
                        xMLValidationError = new XMLValidationError("ERROR", "CONFORMANCE", "ERROR_NO_CORRESPONDING_JOIN_ACTIVITY_TYPE_IN_FULL_BLOCKED_MODE_AND_XOR", "", (XMLElement)object);
                        list.add(xMLValidationError);
                    } else {
                        xMLValidationError = new XMLValidationError("ERROR", "CONFORMANCE", "ERROR_NO_CORRESPONDING_JOIN_ACTIVITY_TYPE_IN_FULL_BLOCKED_MODE_XOR_AND", "", (XMLElement)object);
                        list.add(xMLValidationError);
                    }
                    if (bl) continue;
                    break;
                }
            }
        }
        return bl2;
    }

    protected boolean[][] createIncidenceMatrix(Activities activities) {
        int n = activities.size();
        boolean[][] blArray = new boolean[n][n];
        for (int i = 0; i < n; ++i) {
            Activity activity = (Activity)activities.get(i);
            for (Transition transition : XMLUtil.getOutgoingTransitions(activity)) {
                String string = transition.getTo();
                Activity activity2 = activities.getActivity(string);
                if (activity2 == null) {
                    return null;
                }
                int n2 = activities.indexOf(activity2);
                blArray[i][n2] = true;
            }
        }
        return blArray;
    }

    protected int getNoOfANDSplitsOrJoins(Set set, int n) {
        int n2 = 0;
        for (Activity activity : set) {
            if (n == 0 && XMLUtil.isANDTypeSplitOrJoin(activity, 0)) {
                ++n2;
                continue;
            }
            if (n != 1 || !XMLUtil.isANDTypeSplitOrJoin(activity, 0)) continue;
            ++n2;
        }
        return n2;
    }

    protected boolean checkANDSplit(Activity activity) {
        return !this.hasAnyPostcondition(activity);
    }

    protected boolean checkXORSplit(Activity activity) {
        if (this.hasAnyPostcondition(activity)) {
            Set set = XMLUtil.getOutgoingTransitions(activity);
            for (Transition transition : set) {
                if (!transition.getCondition().getType().equals("OTHERWISE")) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected boolean hasAnyPostcondition(Activity activity) {
        Set set = XMLUtil.getOutgoingTransitions(activity);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (((Transition)iterator.next()).getCondition().toValue().equals("")) continue;
            return true;
        }
        return false;
    }

    protected boolean checkGraphConnectionsForWpOrAs(XMLCollectionElement xMLCollectionElement, List list, boolean bl) {
        Object object2;
        boolean bl2;
        if (xMLCollectionElement == null) {
            return false;
        }
        boolean bl3 = true;
        ArrayList arrayList = ((Activities)xMLCollectionElement.get("Activities")).toElements();
        if (arrayList == null || arrayList.size() == 0) {
            return true;
        }
        Set set = null;
        Set set2 = null;
        if (bl || bl3) {
            set = XMLUtil.getStartingActivities(xMLCollectionElement);
            bl2 = this.properties.getProperty(ALLOW_UNDEFINED_START, "true").equals("true");
            if (set.size() == 0 && (!bl2 || xMLCollectionElement instanceof ActivitySet)) {
                bl3 = false;
                object2 = new XMLValidationError("ERROR", "LOGIC", "ERROR_NO_STARTING_ACTIVITY", "", xMLCollectionElement);
                list.add(object2);
            }
        }
        if (bl || bl3) {
            set2 = XMLUtil.getEndingActivities(xMLCollectionElement);
            bl2 = this.properties.getProperty(ALLOW_UNDEFINED_END, "true").equals("true");
            if (set2.size() == 0 && (!bl2 || xMLCollectionElement instanceof ActivitySet)) {
                bl3 = false;
                object2 = new XMLValidationError("ERROR", "LOGIC", "ERROR_NO_ENDING_ACTIVITY", "", xMLCollectionElement);
                list.add(object2);
            }
        }
        if (bl || bl3) {
            for (Object object2 : arrayList) {
                boolean bl4 = this.checkActivityConnection((Activity)object2, list, bl);
                if (bl4) continue;
                bl3 = false;
                if (bl) continue;
                break;
            }
        }
        return bl3;
    }

    protected boolean checkActivityConnection(Activity activity, List list, boolean bl) {
        return true;
    }

    protected boolean checkGraphConnectionsForArtifacts(Package package_, List list, boolean bl) {
        if (package_ == null) {
            return false;
        }
        boolean bl2 = true;
        ArrayList arrayList = package_.getArtifacts().toElements();
        if (arrayList == null || arrayList.size() == 0) {
            return true;
        }
        for (Artifact artifact : arrayList) {
            boolean bl3 = this.checkArtifactConnection(artifact, list, bl);
            if (bl3) continue;
            bl2 = false;
            if (bl) continue;
            break;
        }
        return bl2;
    }

    protected boolean checkArtifactConnection(Artifact artifact, List list, boolean bl) {
        if (XMLUtil.getOutgoingAssociations(artifact).size() == 0 && XMLUtil.getIncomingAssociations(artifact).size() == 0) {
            XMLValidationError xMLValidationError = new XMLValidationError("ERROR", "CONNECTION", "ERROR_IMPROPERLY_CONNECTED_ARTIFACT_NO_ASSOCIATION", "", artifact);
            list.add(xMLValidationError);
            return false;
        }
        return true;
    }

    protected void checkParameterMatching(FormalParameters formalParameters, ActualParameters actualParameters, List list, boolean bl, boolean bl2) {
        if (formalParameters.size() != actualParameters.size()) {
            XMLValidationError xMLValidationError = new XMLValidationError("ERROR", "LOGIC", "ERROR_FORMAL_AND_ACTUAL_PARAMETERS_NUMBER_MISSMATCH", "", actualParameters);
            list.add(xMLValidationError);
        }
        if (!bl2 && list.size() != 0) {
            return;
        }
        for (int i = 0; i < formalParameters.size(); ++i) {
            Object object;
            Object object2;
            Object object3;
            String string;
            FormalParameter formalParameter = (FormalParameter)formalParameters.get(i);
            if (actualParameters.size() - 1 < i) {
                return;
            }
            ActualParameter actualParameter = (ActualParameter)actualParameters.get(i);
            String string2 = formalParameter.getMode();
            if (string2.equals("IN") && !bl) continue;
            DataType dataType = formalParameter.getDataType();
            DataTypes dataTypes = dataType.getDataTypes();
            XMLElement xMLElement = dataTypes.getChoosen();
            Map map = this.getActualParameterOrConditionChoices(actualParameters);
            XMLCollectionElement xMLCollectionElement = (XMLCollectionElement)map.get(string = actualParameter.toValue());
            if (xMLCollectionElement == null) {
                String string3;
                boolean bl3;
                if (!string2.equals("IN")) {
                    object3 = new XMLValidationError("ERROR", "LOGIC", "ERROR_NON_EXISTING_VARIABLE_REFERENCE", string, actualParameter);
                    list.add(object3);
                    continue;
                }
                boolean bl4 = false;
                if (xMLElement instanceof BasicType && ((String)(object2 = ((BasicType)xMLElement).getType())).equals("STRING") && !formalParameter.getIsArray()) {
                    bl4 = true;
                }
                object2 = this.getActualParameterOrConditionChoices(actualParameters);
                boolean bl5 = bl3 = string.equalsIgnoreCase("null") || this.canBeExpression(string, (Map)object2, bl4);
                if (!bl3 && xMLElement instanceof BasicType && !formalParameter.getIsArray()) {
                    string3 = ((BasicType)xMLElement).getType();
                    if (string3.equals("INTEGER")) {
                        try {
                            new Integer(string);
                            bl3 = true;
                        }
                        catch (Exception exception) {
                            if (string.toLowerCase().indexOf("short") >= 0 || string.toLowerCase().indexOf("integer") >= 0 || string.toLowerCase().indexOf("long") >= 0) {
                                bl3 = true;
                            }
                        }
                    } else if (string3.equals("FLOAT")) {
                        try {
                            new Double(string);
                            bl3 = true;
                        }
                        catch (Exception exception) {
                            if (string.toLowerCase().indexOf("short") >= 0 || string.toLowerCase().indexOf("integer") >= 0 || string.toLowerCase().indexOf("long") >= 0 || string.toLowerCase().indexOf("float") >= 0 || string.toLowerCase().indexOf("double") >= 0) {
                                bl3 = true;
                            }
                        }
                    } else if (string3.equals("BOOLEAN") && (string.equals("false") || string.equals("true") || string.toLowerCase().indexOf("boolean") >= 0)) {
                        bl3 = true;
                    }
                }
                string3 = "WARNING";
                if (bl3 && (string3 = this.additionalExpressionCheck(actualParameter, string, (Map)object2)).equals("")) continue;
                XMLValidationError xMLValidationError = new XMLValidationError(string3, "LOGIC", "WARNING_ACTUAL_PARAMETER_EXPRESSION_POSSIBLY_INVALID", string, actualParameter);
                list.add(xMLValidationError);
                if (bl2) continue;
                return;
            }
            object3 = null;
            object2 = (DataType)xMLCollectionElement.get("DataType");
            DataTypes dataTypes2 = ((DataType)object2).getDataTypes();
            object3 = dataTypes2.getChoosen();
            boolean bl6 = false;
            boolean bl7 = new Boolean(xMLCollectionElement.get("IsArray").toValue());
            if (xMLElement.getClass().equals(object3.getClass()) && bl7 == formalParameter.getIsArray()) {
                Object object4;
                if (xMLElement instanceof BasicType) {
                    object = ((BasicType)xMLElement).getType();
                    if (!((String)object).equals(object4 = ((BasicType)object3).getType())) {
                        bl6 = true;
                    }
                } else if (xMLElement instanceof EnumerationType) {
                    if (((EnumerationType)xMLElement).size() != ((EnumerationType)object3).size()) {
                        bl6 = true;
                    } else {
                        for (int j = 0; j < ((EnumerationType)xMLElement).size(); ++j) {
                            object4 = (EnumerationValue)((EnumerationType)xMLElement).get(j);
                            EnumerationValue enumerationValue = (EnumerationValue)((EnumerationType)object3).get(j);
                            if (((EnumerationValue)object4).getName().equals(enumerationValue.getName())) continue;
                            bl6 = true;
                        }
                    }
                } else if (xMLElement instanceof DeclaredType && !((DeclaredType)xMLElement).getId().equals(((DeclaredType)object3).getId())) {
                    bl6 = true;
                }
            } else {
                bl6 = true;
            }
            if (!bl6) continue;
            object = new XMLValidationError("ERROR", "LOGIC", "ERROR_INVALID_ACTUAL_PARAMETER_VARIABLE_TYPE", "", actualParameter);
            list.add(object);
            if (bl2) continue;
            return;
        }
    }

    public String prepareMessageString(String string) {
        string = string != null ? string + "; " : "";
        return string;
    }

    public boolean hasErrors(List list) {
        for (int i = 0; i < list.size(); ++i) {
            XMLValidationError xMLValidationError = (XMLValidationError)list.get(i);
            if (!xMLValidationError.getType().equals("ERROR")) continue;
            return true;
        }
        return false;
    }

    public boolean canBeExpression(String string, Map map, boolean bl) {
        boolean bl2;
        boolean bl3;
        String string2 = new String(string);
        boolean bl4 = bl3 = string.indexOf(".") >= 0;
        if (bl && string.startsWith("\"") && string.endsWith("\"") || string.startsWith("'") && string.endsWith("'")) {
            bl3 = true;
        }
        if (!bl3 && (bl2 = XMLUtil.isIdValid(string2)) && map.containsKey(string2)) {
            bl3 = true;
        }
        if (!bl3) {
            for (String string3 : map.keySet()) {
                if (XMLUtil.getUsingPositions(string2, string3, map).size() <= 0) continue;
                bl3 = true;
                break;
            }
        }
        return bl3;
    }

    public String additionalExpressionCheck(XMLElement xMLElement, String string, Map map) {
        return "";
    }

    protected StandardPackageValidator createValidatorInstance() {
        return new StandardPackageValidator();
    }

    protected Map getActualParameterOrConditionChoices(XMLElement xMLElement) {
        return XMLUtil.getPossibleVariables(XMLUtil.getWorkflowProcess(xMLElement));
    }

    protected Map getDeadlineConditionChoices(XMLElement xMLElement) {
        return XMLUtil.getPossibleVariables(XMLUtil.getWorkflowProcess(xMLElement));
    }

    protected Map getPerformerChoices(XMLElement xMLElement) {
        return XMLUtil.getPossibleVariables(XMLUtil.getWorkflowProcess(xMLElement));
    }
}

