/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseListener;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;

public class TextEditorPane
extends JTextArea
implements Serializable {
    private boolean modified = false;
    private boolean alreadySaved;
    private Date saved;
    private int start = 0;
    private int end = 0;
    private String prevWord;
    private String panePath = String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + "Documenti";
    private String paneName;

    public TextEditorPane() {
        this.setText("");
        this.setEnabled(true);
        this.setBackground(Color.WHITE);
        this.setForeground(Color.BLACK);
        this.setWrapStyleWord(true);
        this.setLineWrap(true);
        this.setTabSize(3);
        this.setKeyListener();
    }

    public void setAlreadySaved(boolean arg) {
        this.alreadySaved = arg;
    }

    public void setKeyListener() {
        KeyTextListener listener = new KeyTextListener();
        this.addKeyListener(listener);
    }

    public void setMouseListener(MouseListener e) {
        this.addMouseListener(e);
    }

    public void findForward(String word) {
        if (this.prevWord == null) {
            this.prevWord = word;
        }
        if (!this.prevWord.equalsIgnoreCase(word)) {
            this.prevWord = word;
            this.start = 0;
            this.end = word.length();
        }
        if (this.start == 0 && this.end == 0) {
            this.start = 0;
            this.end = word.length();
        }
        if (this.end > this.getText().length()) {
            this.end = this.getText().length();
        }
        String temp = "";
        boolean flag = false;
        while (this.end < this.getText().length() && !flag) {
            temp = this.getText().substring(this.start, this.end);
            if (temp.equalsIgnoreCase(word)) {
                flag = true;
                continue;
            }
            ++this.start;
            ++this.end;
        }
        if (flag) {
            this.setSelectionStart(this.start);
            this.setSelectionEnd(this.end);
            ++this.start;
            ++this.end;
        } else if (this.getText().substring(this.start, this.end).equalsIgnoreCase(word)) {
            this.setSelectionStart(this.start);
            this.setSelectionEnd(this.end);
        } else {
            JOptionPane.showMessageDialog(this, String.valueOf(word) + " doesn't exist in this document", "Sorry", 1);
        }
    }

    public void paste(boolean arg) {
        String text = this.getText();
        this.paste();
        if (arg && !text.equalsIgnoreCase(this.getText())) {
            this.modified = true;
        }
    }

    public void cut(boolean arg) {
        this.cut();
        if (arg) {
            this.modified = true;
        }
    }

    public void findBack(String word) {
        if (this.prevWord == null) {
            this.prevWord = word;
        }
        if (!this.prevWord.equalsIgnoreCase(word)) {
            this.prevWord = word;
            this.start = this.getText().length() - word.length();
            this.end = this.getText().length();
        }
        if (this.start == 0 && this.end == 0) {
            this.start = this.getText().length() - word.length();
            this.end = this.getText().length();
        }
        String temp = "";
        boolean flag = false;
        while (this.start > 0 && !flag) {
            temp = this.getText().substring(this.start, this.end);
            if (temp.equalsIgnoreCase(word)) {
                flag = true;
                continue;
            }
            --this.start;
            --this.end;
        }
        if (flag) {
            this.setSelectionStart(this.start);
            this.setSelectionEnd(this.end);
            --this.start;
            --this.end;
        } else if (this.getText().substring(this.start, this.end).equalsIgnoreCase(word)) {
            this.setSelectionStart(this.start);
            this.setSelectionEnd(this.end);
        } else {
            JOptionPane.showMessageDialog(this, String.valueOf(word) + " doesn't exist in this document", "Sorry", 1);
        }
    }

    public void resetFind() {
        this.start = 0;
        this.end = 0;
        this.prevWord = null;
    }

    public void setPaneName(String name) {
        this.paneName = name;
    }

    public void setPanePath(String path) {
        this.panePath = new File(path).getParent();
        this.setPaneName(new File(path).getName());
    }

    public boolean saveToFile() {
        File outFile = new File(String.valueOf(this.panePath) + System.getProperty("file.separator") + this.paneName);
        if (this.paneName.toUpperCase().endsWith(".TXT") || !this.paneName.toUpperCase().endsWith(".FTF")) {
            ArrayList<String> lines = this.getLinesToSave(this.getText());
            try {
                FileWriter outFileWriter = new FileWriter(outFile);
                PrintWriter printWriter = new PrintWriter(outFileWriter);
                int i = 0;
                while (i < lines.size()) {
                    printWriter.println(lines.get(i));
                    ++i;
                }
                printWriter.close();
                this.alreadySaved = true;
                this.modified = false;
                this.updateLastSave();
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        if (this.paneName.toUpperCase().endsWith(".FTF")) {
            try {
                FileOutputStream outFileStream = new FileOutputStream(outFile);
                ObjectOutputStream outObjectStream = new ObjectOutputStream(outFileStream);
                this.alreadySaved = true;
                this.modified = false;
                this.updateLastSave();
                outObjectStream.writeObject(this);
                outObjectStream.close();
                return true;
            }
            catch (FileNotFoundException e) {
                return false;
            }
            catch (IOException e) {
                System.out.println("NOOOO");
                return false;
            }
        }
        return false;
    }

    public boolean isAlreadySaved() {
        return this.alreadySaved;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setFormat(Font font, Color color) {
        this.setFont(font);
        this.setForeground(color);
        this.modified = true;
    }

    public String getPaneName() {
        return this.paneName;
    }

    public String getPanePath() {
        return this.panePath;
    }

    public void updateLastSave() {
        this.saved = Calendar.getInstance().getTime();
    }

    public String getLastSave() {
        if (this.saved != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM HH:mm:ss");
            return sdf.format(this.saved);
        }
        return "none";
    }

    public void printPane() {
        JDialog option;
        block11: {
            option = new JDialog();
            option.setTitle("Print");
            option.add((Component)new JLabel("Printing...", 0), "Center");
            option.setSize(200, 100);
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int y = screenSize.height / 2 - option.getHeight() / 2;
            int x = screenSize.width / 2 - option.getWidth() / 2;
            option.setLocation(x, y);
            option.setResizable(false);
            option.setModal(false);
            option.setDefaultCloseOperation(0);
            option.setAlwaysOnTop(true);
            option.setVisible(true);
            PrinterJob pj = PrinterJob.getPrinterJob();
            pj.setJobName(this.getPaneName());
            Paper foglio = new Paper();
            PageFormat formato = pj.defaultPage();
            formato.setPaper(foglio);
            Book pages = new Book();
            ArrayList<String> lines = this.getLinesToPrint(this.getText());
            int n = (int)(pj.defaultPage().getImageableHeight() - pj.defaultPage().getImageableY()) / this.getFont().getSize();
            Vector<String> v = new Vector<String>();
            int i = 0;
            while (i < lines.size()) {
                v.add(lines.get(i));
                if (i % n == 0 && i != 0) {
                    pages.append(new Page(v, this), formato);
                    v = new Vector();
                }
                ++i;
            }
            pages.append(new Page(v, this), formato);
            pj.setPageable(pages);
            int copies = 1;
            try {
                if (!pj.printDialog()) break block11;
                copies = pj.getCopies();
                try {
                    if (copies == 1) {
                        pj.print();
                    } else {
                        int i2 = 1;
                        while (i2 <= pj.getCopies()) {
                            pj.setJobName(String.valueOf(this.getPaneName()) + String.valueOf(i2));
                            pj.print();
                            ++i2;
                        }
                    }
                }
                catch (PrinterException e) {
                    JOptionPane.showMessageDialog(null, "Error in the printing of the document", "Print Error", 0);
                }
            }
            catch (Exception e) {
                try {
                    pj.print();
                }
                catch (PrinterException e1) {
                    JOptionPane.showMessageDialog(null, "Error in the printing of the document", "Print Error", 0);
                }
            }
        }
        option.dispose();
    }

    private ArrayList<String> getLinesToSave(String atext) {
        String text = String.valueOf(atext) + "\n";
        char[] letters = text.toCharArray();
        ArrayList<String> lines = new ArrayList<String>();
        String temp = "";
        int i = 0;
        while (i < letters.length) {
            if (String.valueOf(letters[i]).hashCode() == 10) {
                lines.add(temp);
                temp = "";
            } else {
                temp = temp.concat(String.valueOf(letters[i]));
            }
            ++i;
        }
        return lines;
    }

    private ArrayList<String> getLinesToPrint(String atext) {
        String text = String.valueOf(atext) + "\n";
        char[] letters = text.toCharArray();
        ArrayList<String> lines = new ArrayList<String>();
        String temp = "";
        double width = PrinterJob.getPrinterJob().defaultPage().getImageableWidth();
        int i = 0;
        while (i < letters.length) {
            if ((double)(this.getFontMetrics(this.getFont()).charsWidth(temp.toCharArray(), 0, temp.toCharArray().length) + this.getFontMetrics(this.getFont()).charWidth(letters[i])) > width) {
                lines.add(temp);
                temp = "";
                temp = String.valueOf(temp) + letters[i];
            } else if (String.valueOf(letters[i]).hashCode() == 10) {
                lines.add(temp);
                temp = "";
            } else {
                temp = temp.concat(String.valueOf(letters[i]));
            }
            ++i;
        }
        return lines;
    }

    class KeyTextListener
    extends KeyAdapter {
        @Override
        public void keyPressed(KeyEvent e) {
            int code = e.getKeyCode();
            if (this.controlPress(code)) {
                TextEditorPane.this.modified = true;
            }
        }

        private boolean controlPress(int code) {
            return code != 18 && code != 65406 && code != 20 && code != 17 && code != 40 && code != 37 && code != 38 && code != 39 && code != 524 && code != 16 && code != 35 && code != 34 && code != 33 && code != 154 && code != 27 && code != 155 && code != 19 && code != 144 && code != 112 && code != 113 && code != 114 && code != 115 && code != 116 && code != 117 && code != 118 && code != 119 && code != 120 && code != 121 && code != 122 && code != 123 && code != 36 && code != 0 && code != 525;
        }
    }
}

